/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.XML;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineModelResolver {
    private OpenAPI openapi;
    private Map<String, Schema> addedModels = new HashMap<String, Schema>();
    private Map<String, String> generatedSignature = new HashMap<String, String>();
    static Logger LOGGER = LoggerFactory.getLogger(InlineModelResolver.class);

    void flatten(OpenAPI openapi) {
        this.openapi = openapi;
        if (openapi.getComponents() == null) {
            openapi.setComponents(new Components());
        }
        if (openapi.getComponents().getSchemas() == null) {
            openapi.getComponents().setSchemas(new HashMap());
        }
        Paths paths = openapi.getPaths();
        Map models = openapi.getComponents().getSchemas();
        if (paths != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get(pathname);
                for (Operation operation : path.readOperations()) {
                    ApiResponses responses;
                    String existing;
                    String modelName;
                    ObjectSchema op;
                    List parameters;
                    ArraySchema am;
                    RequestBody requestBody = operation.getRequestBody();
                    if (requestBody != null) {
                        ObjectSchema op2;
                        Schema inner;
                        Schema model = ModelUtils.getSchemaFromRequestBody(requestBody);
                        if (model instanceof ObjectSchema) {
                            Schema obj = model;
                            if ((obj.getType() == null || "object".equals(obj.getType())) && obj.getProperties() != null && obj.getProperties().size() > 0) {
                                Set consumes;
                                this.flattenProperties(obj.getProperties(), pathname);
                                String modelName2 = this.resolveModelName(obj.getTitle(), "inline_object");
                                this.addGenerated(modelName2, model);
                                openapi.getComponents().addSchemas(modelName2, model);
                                RequestBody rb = new RequestBody();
                                Content content = new Content();
                                MediaType mt = new MediaType();
                                Schema schema = new Schema();
                                schema.set$ref(modelName2);
                                mt.setSchema(schema);
                                if (requestBody == null || requestBody.getContent() == null || requestBody.getContent().isEmpty()) {
                                    consumes = new HashSet<String>();
                                    consumes.add("application/json");
                                    LOGGER.info("Default to application/json for inline body schema");
                                } else {
                                    consumes = requestBody.getContent().keySet();
                                }
                                for (String consume : consumes) {
                                    content.addMediaType(consume, mt);
                                }
                                rb.setContent(content);
                                if (openapi.getComponents().getRequestBodies() == null) {
                                    HashMap<String, RequestBody> requestBodies = new HashMap<String, RequestBody>();
                                    requestBodies.put(modelName2, rb);
                                    openapi.getComponents().setRequestBodies(requestBodies);
                                } else {
                                    openapi.getComponents().getRequestBodies().put(modelName2, rb);
                                }
                                requestBody.set$ref(modelName2);
                            }
                        } else if (model instanceof ArraySchema && (inner = (am = (ArraySchema)model).getItems()) instanceof ObjectSchema && (op2 = (ObjectSchema)inner).getProperties() != null && op2.getProperties().size() > 0) {
                            Schema schema;
                            this.flattenProperties(op2.getProperties(), pathname);
                            String modelName3 = this.resolveModelName(op2.getTitle(), null);
                            Schema innerModel = this.modelFromProperty(op2, modelName3);
                            String existing2 = this.matchGenerated(innerModel);
                            if (existing2 != null) {
                                schema = new Schema().$ref(existing2);
                                schema.setRequired(op2.getRequired());
                                am.setItems(schema);
                            } else {
                                schema = new Schema().$ref(modelName3);
                                schema.setRequired(op2.getRequired());
                                am.setItems(schema);
                                this.addGenerated(modelName3, innerModel);
                                openapi.getComponents().addSchemas(modelName3, innerModel);
                            }
                        }
                    }
                    if ((parameters = operation.getParameters()) != null) {
                        am = parameters.iterator();
                        while (am.hasNext()) {
                            Schema schema;
                            ArraySchema am2;
                            Schema inner;
                            Parameter parameter = (Parameter)am.next();
                            if (parameter.getSchema() == null) continue;
                            Schema model = parameter.getSchema();
                            if (model instanceof ObjectSchema) {
                                Schema obj = model;
                                if (obj.getType() != null && !"object".equals(obj.getType()) || obj.getProperties() == null || obj.getProperties().size() <= 0) continue;
                                this.flattenProperties(obj.getProperties(), pathname);
                                String modelName4 = this.resolveModelName(obj.getTitle(), parameter.getName());
                                parameter.$ref(modelName4);
                                this.addGenerated(modelName4, model);
                                openapi.getComponents().addSchemas(modelName4, model);
                                continue;
                            }
                            if (!(model instanceof ArraySchema) || !((inner = (am2 = (ArraySchema)model).getItems()) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                            this.flattenProperties(op.getProperties(), pathname);
                            modelName = this.resolveModelName(op.getTitle(), parameter.getName());
                            Schema innerModel = this.modelFromProperty(op, modelName);
                            existing = this.matchGenerated(innerModel);
                            if (existing != null) {
                                schema = new Schema().$ref(existing);
                                schema.setRequired(op.getRequired());
                                am2.setItems(schema);
                                continue;
                            }
                            schema = new Schema().$ref(modelName);
                            schema.setRequired(op.getRequired());
                            am2.setItems(schema);
                            this.addGenerated(modelName, innerModel);
                            openapi.getComponents().addSchemas(modelName, innerModel);
                        }
                    }
                    if ((responses = operation.getResponses()) == null) continue;
                    for (String key : responses.keySet()) {
                        MapSchema mp;
                        Schema innerProperty;
                        Schema schema;
                        String existing3;
                        Schema innerModel;
                        String modelName5;
                        ObjectSchema op3;
                        ApiResponse response = (ApiResponse)responses.get(key);
                        if (ModelUtils.getSchemaFromResponse(response) == null) continue;
                        Schema property = ModelUtils.getSchemaFromResponse(response);
                        if (property instanceof ObjectSchema) {
                            op = (ObjectSchema)property;
                            if (op.getProperties() == null || op.getProperties().size() <= 0) continue;
                            modelName = this.resolveModelName(op.getTitle(), "inline_response_" + key);
                            Schema model = this.modelFromProperty(op, modelName);
                            existing = this.matchGenerated(model);
                            Content content = response.getContent();
                            for (MediaType mediaType : content.values()) {
                                Schema schema2;
                                if (existing != null) {
                                    schema2 = this.makeSchema(existing, property);
                                    schema2.setRequired(op.getRequired());
                                    mediaType.setSchema(schema2);
                                    continue;
                                }
                                schema2 = this.makeSchema(modelName, property);
                                schema2.setRequired(op.getRequired());
                                mediaType.setSchema(schema2);
                                this.addGenerated(modelName, model);
                                openapi.getComponents().addSchemas(modelName, model);
                            }
                            continue;
                        }
                        if (property instanceof ArraySchema) {
                            ArraySchema ap = (ArraySchema)property;
                            Schema inner = ap.getItems();
                            if (!(inner instanceof ObjectSchema) || (op3 = (ObjectSchema)inner).getProperties() == null || op3.getProperties().size() <= 0) continue;
                            this.flattenProperties(op3.getProperties(), pathname);
                            modelName5 = this.resolveModelName(op3.getTitle(), "inline_response_" + key);
                            innerModel = this.modelFromProperty(op3, modelName5);
                            existing3 = this.matchGenerated(innerModel);
                            if (existing3 != null) {
                                schema = this.makeSchema(existing3, (Schema)op3);
                                schema.setRequired(op3.getRequired());
                                ap.setItems(schema);
                                continue;
                            }
                            schema = this.makeSchema(modelName5, (Schema)op3);
                            schema.setRequired(op3.getRequired());
                            ap.setItems(schema);
                            this.addGenerated(modelName5, innerModel);
                            openapi.getComponents().addSchemas(modelName5, innerModel);
                            continue;
                        }
                        if (!(property instanceof MapSchema) || !((innerProperty = ModelUtils.getAdditionalProperties((Schema)(mp = (MapSchema)property))) instanceof ObjectSchema) || (op3 = (ObjectSchema)innerProperty).getProperties() == null || op3.getProperties().size() <= 0) continue;
                        this.flattenProperties(op3.getProperties(), pathname);
                        modelName5 = this.resolveModelName(op3.getTitle(), "inline_response_" + key);
                        innerModel = this.modelFromProperty(op3, modelName5);
                        existing3 = this.matchGenerated(innerModel);
                        if (existing3 != null) {
                            schema = new Schema().$ref(existing3);
                            schema.setRequired(op3.getRequired());
                            mp.setAdditionalProperties((Object)schema);
                            continue;
                        }
                        schema = new Schema().$ref(modelName5);
                        schema.setRequired(op3.getRequired());
                        mp.setAdditionalProperties((Object)schema);
                        this.addGenerated(modelName5, innerModel);
                        openapi.getComponents().addSchemas(modelName5, innerModel);
                    }
                }
            }
        }
        if (models != null) {
            ArrayList modelNames = new ArrayList(models.keySet());
            for (String modelName : modelNames) {
                Object op;
                Schema m;
                Schema model = (Schema)models.get(modelName);
                if (model instanceof Schema) {
                    m = model;
                    Map properties = m.getProperties();
                    this.flattenProperties(properties, modelName);
                    this.fixStringModel(m);
                    continue;
                }
                if (ModelUtils.isArraySchema(model)) {
                    Schema schema;
                    m = (ArraySchema)model;
                    Schema inner = m.getItems();
                    if (!(inner instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
                    String innerModelName = this.resolveModelName(op.getTitle(), modelName + "_inner");
                    Schema innerModel = this.modelFromProperty((ObjectSchema)op, innerModelName);
                    String existing = this.matchGenerated(innerModel);
                    if (existing == null) {
                        openapi.getComponents().addSchemas(innerModelName, innerModel);
                        this.addGenerated(innerModelName, innerModel);
                        schema = new Schema().$ref(innerModelName);
                        schema.setRequired(op.getRequired());
                        m.setItems(schema);
                        continue;
                    }
                    schema = new Schema().$ref(existing);
                    schema.setRequired(op.getRequired());
                    m.setItems(schema);
                    continue;
                }
                if (!ModelUtils.isComposedSchema(model) || (m = (ComposedSchema)model).getAllOf() == null || m.getAllOf().isEmpty()) continue;
                Schema child = null;
                op = m.getAllOf().iterator();
                while (op.hasNext()) {
                    Schema component = (Schema)op.next();
                    if (component.get$ref() != null) continue;
                    child = component;
                }
                if (child == null) continue;
                Map properties = child.getProperties();
                this.flattenProperties(properties, modelName);
            }
        }
    }

    private void fixStringModel(Schema m) {
        String example;
        if (m.getType() != null && m.getType().equals("string") && m.getExample() != null && (example = m.getExample().toString()).substring(0, 1).equals("\"") && example.substring(example.length() - 1).equals("\"")) {
            m.setExample((Object)example.substring(1, example.length() - 1));
        }
    }

    private String resolveModelName(String title, String key) {
        if (title == null) {
            return this.uniqueName(key);
        }
        return this.uniqueName(title);
    }

    private String matchGenerated(Schema model) {
        String json = Json.pretty((Object)model);
        if (this.generatedSignature.containsKey(json)) {
            return this.generatedSignature.get(json);
        }
        return null;
    }

    private void addGenerated(String name, Schema model) {
        this.generatedSignature.put(Json.pretty((Object)model), name);
    }

    private String uniqueName(String key) {
        if (key == null) {
            key = "NULL_UNIQUE_NAME";
            LOGGER.warn("null key found. Default to NULL_UNIQUE_NAME");
        }
        int count = 0;
        boolean done = false;
        key = key.replaceAll("[^a-z_\\.A-Z0-9 ]", "");
        while (!done) {
            String name = key;
            if (count > 0) {
                name = key + "_" + count;
            }
            if (this.openapi.getComponents().getSchemas() == null) {
                return name;
            }
            if (!this.openapi.getComponents().getSchemas().containsKey(name)) {
                return name;
            }
            ++count;
        }
        return key;
    }

    private void flattenProperties(Map<String, Schema> properties, String path) {
        if (properties == null) {
            return;
        }
        HashMap<String, Schema> propsToUpdate = new HashMap<String, Schema>();
        HashMap<String, Schema> modelsToAdd = new HashMap<String, Schema>();
        for (String key : properties.keySet()) {
            Schema schema;
            ObjectSchema op;
            Schema inner;
            ObjectSchema op2;
            ArraySchema ap;
            Schema inner2;
            Schema property = properties.get(key);
            if (property instanceof ObjectSchema && ((ObjectSchema)property).getProperties() != null && ((ObjectSchema)property).getProperties().size() > 0) {
                Schema schema2;
                ObjectSchema op3 = (ObjectSchema)property;
                String modelName = this.resolveModelName(op3.getTitle(), path + "_" + key);
                Schema model = this.modelFromProperty(op3, modelName);
                String existing = this.matchGenerated(model);
                if (existing != null) {
                    schema2 = new Schema().$ref(existing);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                } else {
                    schema2 = new Schema().$ref(modelName);
                    schema2.setRequired(op3.getRequired());
                    propsToUpdate.put(key, schema2);
                    modelsToAdd.put(modelName, model);
                    this.addGenerated(modelName, model);
                    this.openapi.getComponents().addSchemas(modelName, model);
                }
            } else if (property instanceof ArraySchema && (inner2 = (ap = (ArraySchema)property).getItems()) instanceof ObjectSchema && (op2 = (ObjectSchema)inner2).getProperties() != null && op2.getProperties().size() > 0) {
                Schema schema3;
                this.flattenProperties(op2.getProperties(), path);
                String modelName = this.resolveModelName(op2.getTitle(), path + "_" + key);
                Schema innerModel = this.modelFromProperty(op2, modelName);
                String existing = this.matchGenerated(innerModel);
                if (existing != null) {
                    schema3 = new Schema().$ref(existing);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                } else {
                    schema3 = new Schema().$ref(modelName);
                    schema3.setRequired(op2.getRequired());
                    ap.setItems(schema3);
                    this.addGenerated(modelName, innerModel);
                    this.openapi.getComponents().addSchemas(modelName, innerModel);
                }
            }
            if (!ModelUtils.isMapSchema(property) || !((inner = ModelUtils.getAdditionalProperties(property)) instanceof ObjectSchema) || (op = (ObjectSchema)inner).getProperties() == null || op.getProperties().size() <= 0) continue;
            this.flattenProperties(op.getProperties(), path);
            String modelName = this.resolveModelName(op.getTitle(), path + "_" + key);
            Schema innerModel = this.modelFromProperty(op, modelName);
            String existing = this.matchGenerated(innerModel);
            if (existing != null) {
                schema = new Schema().$ref(existing);
                schema.setRequired(op.getRequired());
                property.setAdditionalProperties((Object)schema);
                continue;
            }
            schema = new Schema().$ref(modelName);
            schema.setRequired(op.getRequired());
            property.setAdditionalProperties((Object)schema);
            this.addGenerated(modelName, innerModel);
            this.openapi.getComponents().addSchemas(modelName, innerModel);
        }
        if (propsToUpdate.size() > 0) {
            for (String key : propsToUpdate.keySet()) {
                properties.put(key, (Schema)propsToUpdate.get(key));
            }
        }
        for (String key : modelsToAdd.keySet()) {
            this.openapi.getComponents().addSchemas(key, (Schema)modelsToAdd.get(key));
            this.addedModels.put(key, (Schema)modelsToAdd.get(key));
        }
    }

    private Schema modelFromProperty(ObjectSchema object, String path) {
        String description = object.getDescription();
        String example = null;
        Object obj = object.getExample();
        if (obj != null) {
            example = obj.toString();
        }
        XML xml = object.getXml();
        Map properties = object.getProperties();
        Schema model = new Schema();
        model.setDescription(description);
        model.setExample((Object)example);
        model.setName(object.getName());
        model.setXml(xml);
        model.setRequired(object.getRequired());
        if (properties != null) {
            this.flattenProperties(properties, path);
            model.setProperties(properties);
        }
        return model;
    }

    private Schema makeSchema(String ref, Schema property) {
        Schema newProperty = new Schema().$ref(ref);
        this.copyVendorExtensions(property, newProperty);
        return newProperty;
    }

    private void copyVendorExtensions(Schema source, Schema target) {
        Map vendorExtensions = source.getExtensions();
        if (vendorExtensions == null) {
            return;
        }
        for (String extName : vendorExtensions.keySet()) {
            target.addExtension(extName, vendorExtensions.get(extName));
        }
    }
}

