/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.examples.ExampleGenerator;
import org.openapitools.codegen.languages.PythonClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientExperimentalCodegen
extends PythonClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonClientExperimentalCodegen.class);

    public PythonClientExperimentalCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.instantiationTypes.put("map", "dict");
        this.languageSpecificPrimitives.add("file_type");
        this.languageSpecificPrimitives.add("none_type");
        this.apiTemplateFiles.remove("api.mustache");
        this.apiTemplateFiles.put("python-experimental/api.mustache", ".py");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiDocTemplateFiles.put("python-experimental/api_doc.mustache", ".md");
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.modelDocTemplateFiles.put("python-experimental/model_doc.mustache", ".md");
        this.modelTemplateFiles.remove("model.mustache");
        this.modelTemplateFiles.put("python-experimental/model.mustache", ".py");
        this.modelTestTemplateFiles.remove("model_test.mustache", ".py");
        this.modelTestTemplateFiles.put("python-experimental/model_test.mustache", ".py");
        this.cliOptions.remove(4);
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.remove(new SupportingFile("api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/model_utils.mustache", this.packagePath(), "model_utils.py"));
        this.supportingFiles.remove(new SupportingFile("__init__model.mustache", this.packagePath() + File.separatorChar + "models", "__init__.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/__init__model.mustache", this.packagePath() + File.separatorChar + "models", "__init__.py"));
        this.supportingFiles.remove(new SupportingFile("__init__package.mustache", this.packagePath(), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("python-experimental/__init__package.mustache", this.packagePath(), "__init__.py"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("python-experimental/signing.mustache", this.packagePath(), "signing.py"));
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        String readmePath = "README.md";
        String readmeTemplate = "README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packagePath() + "_" + readmePath;
            readmeTemplate = "README_onlypackage.mustache";
        }
        this.supportingFiles.remove(new SupportingFile(readmeTemplate, "", readmePath));
        readmeTemplate = "python-experimental/README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmeTemplate = "python-experimental/README_onlypackage.mustache";
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.remove(new SupportingFile("setup.mustache", "", "setup.py"));
            this.supportingFiles.add(new SupportingFile("python-experimental/setup.mustache", "", "setup.py"));
            this.supportingFiles.remove(new SupportingFile("requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("python-experimental/requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.remove(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("python-experimental/test-requirements.mustache", "", "test-requirements.txt"));
        }
        ModelUtils.setGenerateAliasAsModel(true);
        LOGGER.info("generateAliasAsModel is hard coded to true in this generator. Alias models will only be generated if they contain validations or enums");
    }

    @Override
    public String getName() {
        return "python-experimental";
    }

    public String dateToString(Schema p, Date date, DateFormat dateFormatter, DateFormat dateTimeFormatter) {
        if (!ModelUtils.isDateSchema(p) && !ModelUtils.isDateTimeSchema(p)) {
            throw new RuntimeException("passed schema must be of type Date or DateTime");
        }
        if (ModelUtils.isDateSchema(p)) {
            return "dateutil_parser('" + dateFormatter.format(date) + "').date()";
        }
        return "dateutil_parser('" + dateTimeFormatter.format(date) + "')";
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultObject = null;
        Boolean enumLengthOne = p.getEnum() != null && p.getEnum().size() == 1;
        if (p.getDefault() != null) {
            defaultObject = p.getDefault();
        } else if (enumLengthOne.booleanValue()) {
            defaultObject = p.getEnum().get(0);
        }
        SimpleDateFormat iso8601Date = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        SimpleDateFormat iso8601DateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
        TimeZone utc = TimeZone.getTimeZone("UTC");
        iso8601Date.setTimeZone(utc);
        iso8601DateTime.setTimeZone(utc);
        if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
            Object currentExample;
            List currentEnum = p.getEnum();
            ArrayList<String> fixedEnum = new ArrayList<String>();
            String fixedValue = null;
            Date date = null;
            if (currentEnum != null && !currentEnum.isEmpty()) {
                for (Object enumItem : currentEnum) {
                    date = (Date)enumItem;
                    fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                    fixedEnum.add(fixedValue);
                }
                p.setEnum(fixedEnum);
            }
            if ((currentExample = p.getExample()) != null) {
                date = (Date)currentExample;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                fixedEnum.add(fixedValue);
                p.setExample((Object)fixedValue);
            }
            if (defaultObject != null) {
                date = (Date)defaultObject;
                fixedValue = this.dateToString(p, date, iso8601Date, iso8601DateTime);
                p.setDefault((Object)fixedValue);
                defaultObject = fixedValue;
            }
        }
        if (defaultObject == null) {
            return null;
        }
        String defaultValue = null;
        if (ModelUtils.isStringSchema(p)) {
            defaultValue = defaultObject.toString();
            if (ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p)) {
                return defaultValue;
            }
            if (!(ModelUtils.isByteArraySchema(p) || ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || ModelUtils.isEmailSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isDateSchema(p))) {
                defaultValue = Pattern.compile("\r\n|\r|\n").matcher(defaultValue).find() ? "'''" + defaultValue + "'''" : "'" + defaultValue + "'";
            }
            return defaultValue;
        }
        if (ModelUtils.isIntegerSchema(p) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            defaultValue = String.valueOf(defaultObject);
            if (ModelUtils.isBooleanSchema(p)) {
                if (!Boolean.valueOf(defaultValue).booleanValue()) {
                    return "False";
                }
                return "True";
            }
            return defaultValue;
        }
        return defaultObject.toString();
    }

    @Override
    public String toModelImport(String name) {
        String moduleName = name.split("\\.")[0];
        return "from " + this.modelPackage() + " import " + moduleName;
    }

    private String robustImport(String name) {
        String moduleName = name.split("\\.")[0];
        String modelImport = "try:\n    from " + this.modelPackage() + " import " + moduleName + "\nexcept ImportError:\n    " + moduleName + " = sys.modules[\n        '" + this.modelPackage() + "." + moduleName + "']";
        return modelImport;
    }

    private String getPythonClassName(String name) {
        String[] pieces = name.split("\\.");
        if (pieces.length == 1) {
            return pieces[0];
        }
        return pieces[1];
    }

    private void fixOperationImports(Set<String> imports) {
        if (imports.size() == 0) {
            return;
        }
        String[] modelNames = imports.toArray(new String[0]);
        imports.clear();
        for (String modelName : modelNames) {
            if (modelName.indexOf(".") == -1) {
                modelName = this.toModelName(modelName);
            }
            imports.add(this.toModelImport(modelName));
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        HashMap val = (HashMap)objs.get("operations");
        ArrayList operations = (ArrayList)val.get("operation");
        ArrayList imports = (ArrayList)objs.get("imports");
        imports.clear();
        for (CodegenOperation operation : operations) {
            this.fixOperationImports(operation.imports);
            for (String thisImport : operation.imports) {
                HashMap<String, String> higherImport = new HashMap<String, String>();
                higherImport.put("import", thisImport);
                if (imports.contains(higherImport)) continue;
                imports.add(higherImport);
            }
        }
        return objs;
    }

    private void fixModelImports(Set<String> imports) {
        if (imports.size() == 0) {
            return;
        }
        String[] modelNames = imports.toArray(new String[0]);
        imports.clear();
        for (String modelName : modelNames) {
            imports.add(this.robustImport(modelName));
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, Schema> modelSchemasToRemove = new HashMap<String, Schema>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                CodegenDiscriminator discriminator = cm.discriminator;
                if (discriminator != null) {
                    Set<CodegenDiscriminator.MappedModel> mappedModels = discriminator.getMappedModels();
                    for (CodegenDiscriminator.MappedModel mappedModel : mappedModels) {
                        String otherModelName = mappedModel.getModelName();
                        cm.imports.add(otherModelName);
                    }
                }
                ArrayList<Set<String>> composedSchemaSets = new ArrayList<Set<String>>();
                composedSchemaSets.add(cm.allOf);
                composedSchemaSets.add(cm.anyOf);
                composedSchemaSets.add(cm.oneOf);
                for (Set set : composedSchemaSets) {
                    for (String otherModelName : set) {
                        cm.imports.add(otherModelName);
                    }
                }
                this.fixModelImports(cm.imports);
                Schema modelSchema = ModelUtils.getSchema(this.openAPI, cm.name);
                CodegenProperty codegenProperty = this.fromProperty("value", modelSchema);
                if (cm.isEnum || cm.isAlias) {
                    if (codegenProperty.isEnum || codegenProperty.hasValidation) continue;
                    modelSchemasToRemove.put(cm.name, modelSchema);
                    continue;
                }
                if (!cm.isArrayModel || codegenProperty.isEnum || codegenProperty.hasValidation) continue;
                modelSchemasToRemove.put(cm.name, modelSchema);
            }
        }
        for (String modelName : modelSchemasToRemove.keySet()) {
            objs.remove(modelName);
        }
        return objs;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty result = super.fromProperty(name, p);
        if (result.isEnum) {
            this.updateCodegenPropertyEnum(result);
        }
        return result;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Optional<Schema> referencedSchema = ModelUtils.getSchemas(this.openAPI).entrySet().stream().filter(entry -> Objects.equals(varDataType, this.toModelName((String)entry.getKey()))).map(Map.Entry::getValue).findFirst();
        String dataType = referencedSchema.isPresent() ? this.getTypeDeclaration(referencedSchema.get()) : varDataType;
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, dataType);
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema.isPresent()) {
            extensions = referencedSchema.get().getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions);
        allowableValues.put("enumVars", enumVars);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        Set keySet;
        Object[] keyArray;
        CodegenParameter result = super.fromRequestBody(body, imports, bodyParameterName);
        Content content = body.getContent();
        MediaType mediaType = (MediaType)content.get((keyArray = (keySet = content.keySet()).toArray())[0]);
        Schema schema = mediaType.getSchema();
        String ref = schema.get$ref();
        if (ref == null) {
            return result;
        }
        String modelName = ModelUtils.getSimpleRef(ref);
        Schema realSchema = ModelUtils.getSchema(this.openAPI, modelName);
        CodegenProperty modelProp = this.fromProperty("body", realSchema);
        if (modelProp.isPrimitiveType && (modelProp.hasValidation || modelProp.isEnum)) {
            String simpleDataType = result.dataType;
            result.dataType = this.toModelName(modelName);
            result.baseType = this.getPythonClassName(result.dataType);
            imports.remove(modelName);
            imports.add(result.dataType);
            if (modelProp.isEnum) {
                String value = modelProp._enum.get(0).toString();
                result.example = this.packageName + "." + result.baseType + "(" + this.toEnumValue(value, simpleDataType) + ")";
            } else {
                result.example = this.packageName + "." + result.baseType + "(" + result.example + ")";
            }
        } else if (!result.isPrimitiveType) {
            result.baseType = this.getPythonClassName(result.baseType);
        }
        return result;
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        Schema responseSchema = this.openAPI != null && this.openAPI.getComponents() != null ? ModelUtils.unaliasSchema(this.openAPI, ModelUtils.getSchemaFromResponse(response), this.importMapping) : ModelUtils.getSchemaFromResponse(response);
        String newBaseType = null;
        if (responseSchema != null) {
            CodegenProperty cp = this.fromProperty("response", responseSchema);
            if (cp.complexType != null) {
                String modelName = this.getPythonClassName(cp.complexType);
                Schema modelSchema = ModelUtils.getSchema(this.openAPI, modelName);
                if (modelSchema != null && !"object".equals(modelSchema.getType())) {
                    CodegenProperty modelProp = this.fromProperty("response", modelSchema);
                    if (modelProp.isEnum || modelProp.hasValidation) {
                        newBaseType = modelName;
                    }
                }
            } else if (cp.isEnum || cp.hasValidation) {
                Schema sc = ModelUtils.getSchemaFromResponse(response);
                newBaseType = ModelUtils.getSimpleRef(sc.get$ref());
            }
        }
        CodegenResponse result = super.fromResponse(responseCode, response);
        if (newBaseType != null) {
            result.dataType = this.toModelName(newBaseType);
            result.baseType = this.getPythonClassName(newBaseType);
        } else if (!result.primitiveType) {
            result.baseType = this.getPythonClassName(result.baseType);
        }
        return result;
    }

    @Override
    public void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse) {
        this.handleMethodResponse(operation, schemas, op, methodResponse, Collections.emptyMap());
    }

    @Override
    protected void handleMethodResponse(Operation operation, Map<String, Schema> schemas, CodegenOperation op, ApiResponse methodResponse, Map<String, String> importMappings) {
        CodegenResponse defaultResponse = this.fromResponse("defaultResponse", methodResponse);
        Schema responseSchema = ModelUtils.unaliasSchema(this.openAPI, ModelUtils.getSchemaFromResponse(methodResponse), importMappings);
        if (responseSchema != null) {
            op.returnBaseType = defaultResponse.baseType;
            String exampleStatusCode = "200";
            for (String key : operation.getResponses().keySet()) {
                if (operation.getResponses().get((Object)key) != methodResponse || key.equals("default")) continue;
                exampleStatusCode = key;
            }
            op.examples = new ExampleGenerator(schemas, this.openAPI).generateFromResponseSchema(exampleStatusCode, responseSchema, PythonClientExperimentalCodegen.getProducesInfo(this.openAPI, operation));
            op.defaultResponse = this.toDefaultValue(responseSchema);
            op.returnType = defaultResponse.dataType;
            op.hasReference = schemas.containsKey(op.returnBaseType);
            Schema schema = schemas.get(op.returnBaseType);
            if (schema != null) {
                CodegenModel cmod = this.fromModel(op.returnBaseType, schema);
                op.discriminator = cmod.discriminator;
            }
            if (defaultResponse.isListContainer) {
                op.isListContainer = true;
            } else if (defaultResponse.isMapContainer) {
                op.isMapContainer = true;
            } else {
                op.returnSimpleType = true;
            }
            if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                op.returnTypeIsPrimitive = true;
            }
        }
        this.addHeaders(methodResponse, op.responseHeaders);
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\s+", "_").toUpperCase(Locale.ROOT);
        return var;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.equals("int") || datatype.equals("float")) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty p) {
        this.postProcessPattern(p.pattern, p.vendorExtensions);
        if (p.complexType != null && !this.languageSpecificPrimitives.contains(p.complexType)) {
            p.complexType = this.getPythonClassName(p.complexType);
        } else if (p.isListContainer && p.mostInnerItems.complexType != null && !this.languageSpecificPrimitives.contains(p.mostInnerItems.complexType)) {
            p.complexType = this.getPythonClassName(p.mostInnerItems.complexType);
        }
        if (p.complexType != null && p.dataType.contains(model.classname)) {
            String classNameNoModule = this.getPythonClassName(model.classname);
            p.dataType = p.dataType.replace(model.classname, classNameNoModule);
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter p) {
        this.postProcessPattern(p.pattern, p.vendorExtensions);
        if (p.baseType != null && this.languageSpecificPrimitives.contains(p.baseType)) {
            p.baseType = null;
        } else if (p.isListContainer && p.mostInnerItems.complexType != null && !this.languageSpecificPrimitives.contains(p.mostInnerItems.complexType)) {
            p.baseType = this.getPythonClassName(p.mostInnerItems.complexType);
        }
    }

    private void addNullDefaultToOneOfAnyOfReqProps(Schema schema, CodegenModel result) {
        List anyOf;
        ComposedSchema cs = (ComposedSchema)schema;
        LinkedHashMap<String, Schema> selfProperties = new LinkedHashMap<String, Schema>();
        ArrayList<String> selfRequired = new ArrayList<String>();
        LinkedHashMap<String, Schema> otherProperties = new LinkedHashMap<String, Schema>();
        ArrayList<String> otherRequired = new ArrayList<String>();
        ArrayList oneOfanyOfSchemas = new ArrayList();
        List oneOf = cs.getOneOf();
        if (oneOf != null) {
            oneOfanyOfSchemas.addAll(oneOf);
        }
        if ((anyOf = cs.getAnyOf()) != null) {
            oneOfanyOfSchemas.addAll(anyOf);
        }
        for (Schema sc : oneOfanyOfSchemas) {
            Schema refSchema = ModelUtils.getReferencedSchema(this.openAPI, sc);
            this.addProperties(otherProperties, otherRequired, refSchema);
        }
        HashSet otherRequiredSet = new HashSet(otherRequired);
        List allOf = cs.getAllOf();
        if (schema.getProperties() != null && !schema.getProperties().isEmpty() || allOf != null) {
            this.addProperties(selfProperties, selfRequired, schema);
        }
        if (result.discriminator != null) {
            selfRequired.add(result.discriminator.getPropertyBaseName());
        }
        HashSet<String> selfRequiredSet = new HashSet<String>(selfRequired);
        List<CodegenProperty> reqVars = result.getRequiredVars();
        if (reqVars != null) {
            for (CodegenProperty cp : reqVars) {
                String propName = cp.baseName;
                if (!otherRequiredSet.contains(propName) || selfRequiredSet.contains(propName)) continue;
                cp.setDefaultValue("nulltype.Null");
            }
        }
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema) {
        HashMap<String, String> propertyToModelName = new HashMap<String, String>();
        Map propertiesMap = schema.getProperties();
        if (propertiesMap != null) {
            for (Map.Entry entry : propertiesMap.entrySet()) {
                Schema refSchema;
                String refType;
                String schemaPropertyName = (String)entry.getKey();
                String string = this.toVarName(schemaPropertyName);
                Schema propertySchema = (Schema)entry.getValue();
                String ref = propertySchema.get$ref();
                if (ref == null || (refType = (refSchema = ModelUtils.getReferencedSchema(this.openAPI, propertySchema)).getType()) == null || refType.equals("object")) continue;
                CodegenProperty modelProperty = this.fromProperty("_fake_name", refSchema);
                if (!modelProperty.isEnum && !modelProperty.hasValidation) continue;
                String modelName = ModelUtils.getSimpleRef(ref);
                propertyToModelName.put(string, this.toModelName(modelName));
            }
        }
        CodegenModel result = super.fromModel(name, schema);
        result.unescapedDescription = this.simpleModelName(name);
        if (result.isAlias || result.isEnum) {
            Schema modelSchema = ModelUtils.getSchema(this.openAPI, result.name);
            CodegenProperty modelProperty = this.fromProperty("value", modelSchema);
            if (modelProperty.isEnum || modelProperty.hasValidation) {
                result.isAlias = true;
                modelProperty.required = true;
                List<CodegenProperty> list = Arrays.asList(modelProperty);
                result.setAllVars(list);
                result.setVars(list);
                result.setRequiredVars(list);
                if (result.vars != null) {
                    for (CodegenProperty prop : result.vars) {
                        this.postProcessModelProperty(result, prop);
                    }
                }
            }
        }
        ArrayList<List<CodegenProperty>> listOfLists = new ArrayList<List<CodegenProperty>>();
        listOfLists.add(result.vars);
        listOfLists.add(result.allVars);
        listOfLists.add(result.requiredVars);
        listOfLists.add(result.optionalVars);
        listOfLists.add(result.readOnlyVars);
        listOfLists.add(result.readWriteVars);
        for (List list : listOfLists) {
            for (CodegenProperty cp : list) {
                this.postProcessModelProperty(result, cp);
                if (!propertyToModelName.containsKey(cp.name)) continue;
                cp.isPrimitiveType = false;
                String modelName = (String)propertyToModelName.get(cp.name);
                cp.complexType = this.getPythonClassName(modelName);
                cp.dataType = modelName;
                cp.isEnum = false;
                cp.hasValidation = false;
                result.imports.add(modelName);
            }
        }
        if (result.imports.contains(result.classname)) {
            result.imports.remove(result.classname);
        }
        if (result.requiredVars.size() > 0 && (result.oneOf.size() > 0 || result.anyOf.size() > 0)) {
            this.addNullDefaultToOneOfAnyOfReqProps(schema, result);
        }
        return result;
    }

    public String getSimpleTypeDeclaration(Schema schema) {
        String oasType = this.getSchemaType(schema);
        if (this.typeMapping.containsKey(oasType)) {
            return (String)this.typeMapping.get(oasType);
        }
        return oasType;
    }

    public String getTypeString(Schema p, String prefix, String suffix) {
        String fullSuffix = suffix;
        if (")".equals(suffix)) {
            fullSuffix = "," + suffix;
        }
        if (ModelUtils.isNullable(ModelUtils.getReferencedSchema(this.openAPI, p))) {
            fullSuffix = ", none_type" + suffix;
        }
        if (ModelUtils.isFreeFormObject(p) && ModelUtils.getAdditionalProperties(p) == null) {
            return prefix + "bool, date, datetime, dict, float, int, list, str" + fullSuffix;
        }
        if ((ModelUtils.isMapSchema(p) || "object".equals(p.getType())) && ModelUtils.getAdditionalProperties(p) != null) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return prefix + "{str: " + this.getTypeString(inner, "(", ")") + "}" + fullSuffix;
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return prefix + "[" + this.getTypeString(inner, "", "") + "]" + fullSuffix;
        }
        if (ModelUtils.isFileSchema(p)) {
            return prefix + "file_type" + fullSuffix;
        }
        String baseType = this.getSimpleTypeDeclaration(p);
        return prefix + baseType + fullSuffix;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        return this.getTypeString(p, "", "");
    }

    @Override
    public String toInstantiationType(Schema property) {
        if (ModelUtils.isArraySchema(property) || ModelUtils.isMapSchema(property) || property.getAdditionalProperties() != null) {
            return this.getSchemaType(property);
        }
        return super.toInstantiationType(property);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema addProps = ModelUtils.getAdditionalProperties(schema);
        if (addProps != null && addProps.get$ref() == null) {
            String typeString;
            codegenModel.additionalPropertiesType = typeString = this.getTypeDeclaration(addProps);
        } else {
            this.addParentContainer(codegenModel, codegenModel.name, schema);
        }
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        String example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type) || "str".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("file".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "open('" + example + "', 'rb')";
        } else if ("Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if ("DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "'" + this.escapeText(example) + "'";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.packageName + "." + this.getPythonClassName(type) + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "None";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key': " + example + "}";
        }
        p.example = example;
    }

    private String simpleModelName(String name) {
        String modelName = this.sanitizeName(name);
        if (this.isReservedWord(modelName = modelName.replaceAll("$", ""))) {
            LOGGER.warn(modelName + " (reserved word) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + modelName));
            modelName = "model_" + modelName;
        }
        if (modelName.matches("^\\d.*")) {
            LOGGER.warn(modelName + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + modelName));
            modelName = "model_" + modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            modelName = this.modelNamePrefix + "_" + modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            modelName = modelName + "_" + this.modelNameSuffix;
        }
        return StringUtils.camelize(modelName);
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(PythonClientExperimentalCodegen.dropDots(this.simpleModelName(name)));
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name) + "." + this.simpleModelName(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.simpleModelName(name);
    }
}

