/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.DartClientCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartJaguarClientCodegen
extends DartClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(DartJaguarClientCodegen.class);
    private static final String NULLABLE_FIELDS = "nullableFields";
    private static final String SERIALIZATION_FORMAT = "serialization";
    private static final String IS_FORMAT_JSON = "jsonFormat";
    private static final String IS_FORMAT_PROTO = "protoFormat";
    private static final String CLIENT_NAME = "clientName";
    private static Set<String> modelToIgnore = new HashSet<String>();
    private HashMap<String, String> protoTypeMapping = new HashMap();
    private static final String SERIALIZATION_JSON = "json";
    private static final String SERIALIZATION_PROTO = "proto";
    private boolean nullableFields = true;
    private String serialization = "json";

    public DartJaguarClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Implicit, SecurityFeature.BasicAuth, SecurityFeature.ApiKey)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.browserClient = false;
        this.outputFolder = "generated-code/dart-jaguar";
        this.templateDir = "dart-jaguar";
        this.embeddedTemplateDir = "dart-jaguar";
        this.cliOptions.add(new CliOption(NULLABLE_FIELDS, "Is the null fields should be in the JSON payload"));
        this.cliOptions.add(new CliOption(SERIALIZATION_FORMAT, "Choose serialization format JSON or PROTO is supported"));
        this.typeMapping.put("file", "List<int>");
        this.typeMapping.put("binary", "List<int>");
        this.protoTypeMapping.put("Array", "repeated");
        this.protoTypeMapping.put("array", "repeated");
        this.protoTypeMapping.put("List", "repeated");
        this.protoTypeMapping.put("boolean", "bool");
        this.protoTypeMapping.put("string", "string");
        this.protoTypeMapping.put("char", "string");
        this.protoTypeMapping.put("int", "int32");
        this.protoTypeMapping.put("long", "int64");
        this.protoTypeMapping.put("short", "int32");
        this.protoTypeMapping.put("number", "double");
        this.protoTypeMapping.put("float", "float");
        this.protoTypeMapping.put("double", "double");
        this.protoTypeMapping.put("object", "google.protobuf.Any");
        this.protoTypeMapping.put("integer", "int32");
        this.protoTypeMapping.put("Date", "google.protobuf.Timestamp");
        this.protoTypeMapping.put("date", "google.protobuf.Timestamp");
        this.protoTypeMapping.put("File", "bytes");
        this.protoTypeMapping.put("file", "bytes");
        this.protoTypeMapping.put("binary", "bytes");
        this.protoTypeMapping.put("UUID", "string");
        this.protoTypeMapping.put("URI", "string");
        this.protoTypeMapping.put("ByteArray", "bytes");
    }

    @Override
    public String getName() {
        return "dart-jaguar";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Jaguar client library.";
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            return "const {}";
        }
        if (ModelUtils.isArraySchema(p)) {
            return "const []";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public void processOpts() {
        this.defaultProcessOpts();
        if (this.additionalProperties.containsKey(NULLABLE_FIELDS)) {
            this.nullableFields = this.convertPropertyToBooleanAndWriteBack(NULLABLE_FIELDS);
        } else {
            this.additionalProperties.put(NULLABLE_FIELDS, this.nullableFields);
        }
        if (this.additionalProperties.containsKey(SERIALIZATION_FORMAT)) {
            this.serialization = (String)this.additionalProperties.get(SERIALIZATION_FORMAT);
            boolean isProto = this.serialization.equalsIgnoreCase(SERIALIZATION_PROTO);
            this.additionalProperties.put(IS_FORMAT_JSON, this.serialization.equalsIgnoreCase(SERIALIZATION_JSON));
            this.additionalProperties.put(IS_FORMAT_PROTO, isProto);
            this.modelTemplateFiles.put("model.mustache", isProto ? ".proto" : ".dart");
        } else {
            this.additionalProperties.put(IS_FORMAT_JSON, true);
            this.additionalProperties.put(IS_FORMAT_PROTO, false);
        }
        if (this.additionalProperties.containsKey("pubName")) {
            this.setPubName((String)this.additionalProperties.get("pubName"));
        } else {
            this.additionalProperties.put("pubName", this.pubName);
        }
        this.additionalProperties.put(CLIENT_NAME, StringUtils.camelize(this.pubName));
        if (this.additionalProperties.containsKey("pubVersion")) {
            this.setPubVersion((String)this.additionalProperties.get("pubVersion"));
        } else {
            this.additionalProperties.put("pubVersion", this.pubVersion);
        }
        if (this.additionalProperties.containsKey("pubDescription")) {
            this.setPubDescription((String)this.additionalProperties.get("pubDescription"));
        } else {
            this.additionalProperties.put("pubDescription", this.pubDescription);
        }
        if (this.additionalProperties.containsKey("useEnumExtension")) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack("useEnumExtension"));
        } else {
            this.additionalProperties.put("useEnumExtension", this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/basic_auth.mustache", authFolder, "basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/auth.mustache", authFolder, "auth.dart"));
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models, 1);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            HashSet<String> modelImports = new HashSet<String>();
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (String modelImport : cm.imports) {
                if (modelToIgnore.contains(modelImport.toLowerCase(Locale.ROOT))) continue;
                modelImports.add(StringUtils.underscore(modelImport));
            }
            for (CodegenProperty p : cm.vars) {
                String protoType = this.protoTypeMapping.get(p.openApiType);
                if (p.isListContainer) {
                    String innerType = this.protoTypeMapping.get(p.mostInnerItems.openApiType);
                    protoType = protoType + " " + (innerType == null ? p.mostInnerItems.openApiType : innerType);
                }
                p.vendorExtensions.put("x-proto-type", protoType == null ? p.openApiType : protoType);
            }
            cm.imports = modelImports;
            boolean hasVars = cm.vars.size() > 0;
            cm.vendorExtensions.put("x-has-vars", hasVars);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        HashSet<String> modelImports = new HashSet<String>();
        HashSet fullImports = new HashSet();
        for (CodegenOperation op : operationList) {
            op.httpMethod = org.apache.commons.lang3.StringUtils.capitalize((String)op.httpMethod.toLowerCase(Locale.ROOT));
            boolean isJson = true;
            boolean isForm = false;
            boolean isProto = false;
            boolean isMultipart = false;
            if (op.consumes != null) {
                for (Map map : op.consumes) {
                    if (!map.containsKey("mediaType")) continue;
                    String type = (String)map.get("mediaType");
                    isJson = type.equalsIgnoreCase("application/json");
                    isProto = type.equalsIgnoreCase("application/octet-stream");
                    isForm = type.equalsIgnoreCase("application/x-www-form-urlencoded");
                    isMultipart = type.equalsIgnoreCase("multipart/form-data");
                    break;
                }
            }
            for (CodegenParameter codegenParameter : op.allParams) {
                if (codegenParameter.baseType == null || !codegenParameter.baseType.equalsIgnoreCase("List<int>") || !isMultipart) continue;
                codegenParameter.baseType = "MultipartFile";
                codegenParameter.dataType = "MultipartFile";
            }
            for (CodegenParameter codegenParameter : op.formParams) {
                if (codegenParameter.baseType == null || !codegenParameter.baseType.equalsIgnoreCase("List<int>") || !isMultipart) continue;
                codegenParameter.baseType = "MultipartFile";
                codegenParameter.dataType = "MultipartFile";
            }
            for (CodegenParameter codegenParameter : op.bodyParams) {
                if (codegenParameter.baseType == null || !codegenParameter.baseType.equalsIgnoreCase("List<int>") || !isMultipart) continue;
                codegenParameter.baseType = "MultipartFile";
                codegenParameter.dataType = "MultipartFile";
            }
            op.vendorExtensions.put("x-is-form", isForm);
            op.vendorExtensions.put("x-is-json", isJson);
            op.vendorExtensions.put("x-is-proto", isProto);
            op.vendorExtensions.put("x-is-multipart", isMultipart);
            HashSet<String> imports = new HashSet<String>();
            for (String item : op.imports) {
                if (modelToIgnore.contains(item.toLowerCase(Locale.ROOT))) continue;
                imports.add(StringUtils.underscore(item));
            }
            modelImports.addAll(imports);
            op.imports = imports;
            String[] stringArray = op.path.split("/", -1);
            String jaguarPath = "";
            for (int i = 0; i < stringArray.length; ++i) {
                jaguarPath = stringArray[i].matches("^\\{(.*)\\}$") ? jaguarPath + ":" + stringArray[i].replace("{", "").replace("}", "") : jaguarPath + stringArray[i];
                if (i == stringArray.length - 1) continue;
                jaguarPath = jaguarPath + "/";
            }
            op.path = jaguarPath;
        }
        objs.put("modelImports", modelImports);
        objs.put("fullImports", fullImports);
        return objs;
    }

    static {
        modelToIgnore.add("datetime");
        modelToIgnore.add("map");
        modelToIgnore.add("object");
        modelToIgnore.add("list");
        modelToIgnore.add("file");
        modelToIgnore.add("list<int>");
    }
}

