/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.config.GlobalSettings;

public class StringUtils {
    public static final String NAME_CACHE_SIZE_PROPERTY = "org.openapitools.codegen.utils.namecache.cachesize";
    public static final String NAME_CACHE_EXPIRY_PROPERTY = "org.openapitools.codegen.utils.namecache.expireafter.seconds";
    private static Cache<Pair<String, Boolean>, String> camelizedWordsCache;
    private static Cache<String, String> underscoreWords;
    private static Pattern camelizeSlashPattern;
    private static Pattern camelizeUppercasePattern;
    private static Pattern camelizeUnderscorePattern;
    private static Pattern camelizeHyphenPattern;

    public static String underscore(String word) {
        return (String)underscoreWords.get((Object)word, wordToUnderscore -> {
            String firstPattern = "([A-Z]+)([A-Z][a-z])";
            String secondPattern = "([a-z\\d])([A-Z])";
            String replacementPattern = "$1_$2";
            String result = wordToUnderscore.replaceAll("\\.", "/");
            result = result.replaceAll("\\$", "__");
            result = result.replaceAll(firstPattern, replacementPattern);
            result = result.replaceAll(secondPattern, replacementPattern);
            result = result.replace('-', '_');
            result = result.replace(' ', '_');
            result = result.toLowerCase(Locale.ROOT);
            return result;
        });
    }

    public static String dashize(String word) {
        return StringUtils.underscore(word).replaceAll("[_ ]+", "-");
    }

    public static String camelize(String word) {
        return StringUtils.camelize(word, false);
    }

    public static String camelize(String inputWord, boolean lowercaseFirstLetter) {
        ImmutablePair key = new ImmutablePair((Object)inputWord, (Object)lowercaseFirstLetter);
        return (String)camelizedWordsCache.get((Object)key, pair -> {
            String word = (String)pair.getKey();
            Boolean lowerFirstLetter = (Boolean)pair.getValue();
            Matcher m = camelizeSlashPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst("." + m.group(1));
                m = camelizeSlashPattern.matcher(word);
            }
            String[] parts = word.split("\\.");
            StringBuilder f = new StringBuilder();
            for (String z : parts) {
                if (z.length() <= 0) continue;
                f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
            }
            word = f.toString();
            m = camelizeSlashPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
                m = camelizeSlashPattern.matcher(word);
            }
            m = camelizeUppercasePattern.matcher(word);
            if (m.find()) {
                String rep = m.group(1) + m.group(2).toUpperCase(Locale.ROOT) + m.group(3);
                rep = rep.replaceAll("\\$", "\\\\\\$");
                word = m.replaceAll(rep);
            }
            m = camelizeUnderscorePattern.matcher(word);
            while (m.find()) {
                String upperCase;
                String original = m.group(2);
                word = original.equals(upperCase = original.toUpperCase(Locale.ROOT)) ? word.replaceFirst("_", "") : m.replaceFirst(upperCase);
                m = camelizeUnderscorePattern.matcher(word);
            }
            m = camelizeHyphenPattern.matcher(word);
            while (m.find()) {
                word = m.replaceFirst(m.group(2).toUpperCase(Locale.ROOT));
                m = camelizeHyphenPattern.matcher(word);
            }
            if (lowerFirstLetter.booleanValue() && word.length() > 0) {
                int i = 0;
                char charAt = word.charAt(i);
                while (!(i + 1 >= word.length() || charAt >= 'a' && charAt <= 'z' || charAt >= 'A' && charAt <= 'Z')) {
                    charAt = word.charAt(++i);
                }
                word = word.substring(0, ++i).toLowerCase(Locale.ROOT) + word.substring(i);
            }
            word = word.replaceAll("_", "");
            return word;
        });
    }

    public static String escape(String name, Map<String, String> replacementMap, List<String> charactersToAllow, String appendToReplacement) {
        String result = name.chars().mapToObj(c -> {
            String character = "" + (char)c;
            if (charactersToAllow != null && charactersToAllow.contains(character)) {
                return character;
            }
            if (replacementMap.containsKey(character)) {
                return (String)replacementMap.get(character) + (appendToReplacement != null ? appendToReplacement : "");
            }
            return character;
        }).reduce((c1, c2) -> "" + c1 + c2).orElse(null);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Word '" + name + "' could not be escaped.");
    }

    static {
        int cacheSize = Integer.parseInt(GlobalSettings.getProperty(NAME_CACHE_SIZE_PROPERTY, "200"));
        int cacheExpiry = Integer.parseInt(GlobalSettings.getProperty(NAME_CACHE_EXPIRY_PROPERTY, "5"));
        camelizedWordsCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        underscoreWords = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpiry, TimeUnit.SECONDS).ticker(Ticker.systemTicker()).build();
        camelizeSlashPattern = Pattern.compile("\\/(.?)");
        camelizeUppercasePattern = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        camelizeUnderscorePattern = Pattern.compile("(_)(.)");
        camelizeHyphenPattern = Pattern.compile("(-)(.)");
    }
}

