/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConfigLoader;
import org.openapitools.codegen.SpecValidationException;
import org.openapitools.codegen.TemplatingEngineLoader;
import org.openapitools.codegen.api.TemplateDefinition;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.auth.AuthParser;
import org.openapitools.codegen.config.Context;
import org.openapitools.codegen.config.DynamicSettings;
import org.openapitools.codegen.config.GeneratorSettings;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.config.WorkflowSettings;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenConfigurator {
    public static final Logger LOGGER = LoggerFactory.getLogger(CodegenConfigurator.class);
    private GeneratorSettings.Builder generatorSettingsBuilder = GeneratorSettings.newBuilder();
    private WorkflowSettings.Builder workflowSettingsBuilder = WorkflowSettings.newBuilder();
    private String generatorName;
    private String inputSpec;
    private String templatingEngineName;
    private Map<String, String> globalProperties = new HashMap<String, String>();
    private Map<String, String> instantiationTypes = new HashMap<String, String>();
    private Map<String, String> typeMappings = new HashMap<String, String>();
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private Map<String, String> importMappings = new HashMap<String, String>();
    private Set<String> languageSpecificPrimitives = new HashSet<String>();
    private Map<String, String> reservedWordMappings = new HashMap<String, String>();
    private Map<String, String> serverVariables = new HashMap<String, String>();
    private String auth;
    private List<TemplateDefinition> userDefinedTemplates = new ArrayList<TemplateDefinition>();

    public static CodegenConfigurator fromFile(String configFile, Module ... modules) {
        if (StringUtils.isNotEmpty((CharSequence)configFile)) {
            DynamicSettings settings = CodegenConfigurator.readDynamicSettings(configFile, modules);
            CodegenConfigurator configurator = new CodegenConfigurator();
            GeneratorSettings generatorSettings = settings.getGeneratorSettings();
            WorkflowSettings workflowSettings = settings.getWorkflowSettings();
            List<TemplateDefinition> userDefinedTemplateSettings = settings.getFiles();
            configurator.generatorName = generatorSettings.getGeneratorName();
            configurator.inputSpec = workflowSettings.getInputSpec();
            configurator.templatingEngineName = workflowSettings.getTemplatingEngineName();
            if (workflowSettings.getGlobalProperties() != null) {
                configurator.globalProperties.putAll(workflowSettings.getGlobalProperties());
            }
            if (generatorSettings.getInstantiationTypes() != null) {
                configurator.instantiationTypes.putAll(generatorSettings.getInstantiationTypes());
            }
            if (generatorSettings.getTypeMappings() != null) {
                configurator.typeMappings.putAll(generatorSettings.getTypeMappings());
            }
            if (generatorSettings.getAdditionalProperties() != null) {
                configurator.additionalProperties.putAll(generatorSettings.getAdditionalProperties());
            }
            if (generatorSettings.getImportMappings() != null) {
                configurator.importMappings.putAll(generatorSettings.getImportMappings());
            }
            if (generatorSettings.getLanguageSpecificPrimitives() != null) {
                configurator.languageSpecificPrimitives.addAll(generatorSettings.getLanguageSpecificPrimitives());
            }
            if (generatorSettings.getReservedWordMappings() != null) {
                configurator.reservedWordMappings.putAll(generatorSettings.getReservedWordMappings());
            }
            if (generatorSettings.getServerVariables() != null) {
                configurator.serverVariables.putAll(generatorSettings.getServerVariables());
            }
            configurator.generatorSettingsBuilder = GeneratorSettings.newBuilder((GeneratorSettings)generatorSettings);
            configurator.workflowSettingsBuilder = WorkflowSettings.newBuilder((WorkflowSettings)workflowSettings);
            if (userDefinedTemplateSettings != null) {
                configurator.userDefinedTemplates.addAll(userDefinedTemplateSettings);
            }
            return configurator;
        }
        return null;
    }

    private static DynamicSettings readDynamicSettings(String configFile, Module ... modules) {
        ObjectMapper mapper = FilenameUtils.isExtension((String)configFile.toLowerCase(Locale.ROOT), (String[])new String[]{"yml", "yaml"}) ? Yaml.mapper().copy() : Json.mapper().copy();
        if (modules != null && modules.length > 0) {
            mapper.registerModules(modules);
        }
        mapper.registerModule((Module)new GuavaModule());
        try {
            return (DynamicSettings)mapper.readValue(new File(configFile), DynamicSettings.class);
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage());
            throw new RuntimeException("Unable to deserialize config file: " + configFile);
        }
    }

    public CodegenConfigurator addServerVariable(String key, String value) {
        this.serverVariables.put(key, value);
        this.generatorSettingsBuilder.withServerVariable(key, value);
        return this;
    }

    public CodegenConfigurator addAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
        this.generatorSettingsBuilder.withAdditionalProperty(key, value);
        return this;
    }

    public CodegenConfigurator addAdditionalReservedWordMapping(String key, String value) {
        this.reservedWordMappings.put(key, value);
        this.generatorSettingsBuilder.withReservedWordMapping(key, value);
        return this;
    }

    public CodegenConfigurator addImportMapping(String key, String value) {
        this.importMappings.put(key, value);
        this.generatorSettingsBuilder.withImportMapping(key, value);
        return this;
    }

    public CodegenConfigurator addInstantiationType(String key, String value) {
        this.instantiationTypes.put(key, value);
        this.generatorSettingsBuilder.withInstantiationType(key, value);
        return this;
    }

    public CodegenConfigurator addLanguageSpecificPrimitive(String value) {
        this.languageSpecificPrimitives.add(value);
        this.generatorSettingsBuilder.withLanguageSpecificPrimitive(value);
        return this;
    }

    public CodegenConfigurator addGlobalProperty(String key, String value) {
        this.globalProperties.put(key, value);
        this.workflowSettingsBuilder.withGlobalProperty(key, value);
        return this;
    }

    public CodegenConfigurator addTypeMapping(String key, String value) {
        this.typeMappings.put(key, value);
        this.generatorSettingsBuilder.withTypeMappings(this.typeMappings);
        return this;
    }

    public CodegenConfigurator setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.generatorSettingsBuilder.withAdditionalProperties(additionalProperties);
        return this;
    }

    public CodegenConfigurator setServerVariables(Map<String, String> serverVariables) {
        this.serverVariables = serverVariables;
        this.generatorSettingsBuilder.withServerVariables(serverVariables);
        return this;
    }

    public CodegenConfigurator setReservedWordsMappings(Map<String, String> reservedWordMappings) {
        this.reservedWordMappings = reservedWordMappings;
        this.generatorSettingsBuilder.withReservedWordMappings(reservedWordMappings);
        return this;
    }

    public CodegenConfigurator setApiPackage(String apiPackage) {
        if (StringUtils.isNotEmpty((CharSequence)apiPackage)) {
            this.addAdditionalProperty("apiPackage", apiPackage);
        }
        this.generatorSettingsBuilder.withApiPackage(apiPackage);
        return this;
    }

    public CodegenConfigurator setArtifactId(String artifactId) {
        if (StringUtils.isNotEmpty((CharSequence)artifactId)) {
            this.addAdditionalProperty("artifactId", artifactId);
        }
        this.generatorSettingsBuilder.withArtifactId(artifactId);
        return this;
    }

    public CodegenConfigurator setArtifactVersion(String artifactVersion) {
        if (StringUtils.isNotEmpty((CharSequence)artifactVersion)) {
            this.addAdditionalProperty("artifactVersion", artifactVersion);
        }
        this.generatorSettingsBuilder.withArtifactVersion(artifactVersion);
        return this;
    }

    public CodegenConfigurator setAuth(String auth) {
        this.auth = auth;
        return this;
    }

    public CodegenConfigurator setEnableMinimalUpdate(boolean enableMinimalUpdate) {
        this.workflowSettingsBuilder.withEnableMinimalUpdate(Boolean.valueOf(enableMinimalUpdate));
        return this;
    }

    public CodegenConfigurator setEnablePostProcessFile(boolean enablePostProcessFile) {
        this.workflowSettingsBuilder.withEnablePostProcessFile(Boolean.valueOf(enablePostProcessFile));
        return this;
    }

    public CodegenConfigurator setGenerateAliasAsModel(boolean generateAliasAsModel) {
        this.workflowSettingsBuilder.withGenerateAliasAsModel(Boolean.valueOf(generateAliasAsModel));
        ModelUtils.setGenerateAliasAsModel(generateAliasAsModel);
        return this;
    }

    public CodegenConfigurator setGeneratorName(String generatorName) {
        this.generatorName = generatorName;
        this.generatorSettingsBuilder.withGeneratorName(generatorName);
        return this;
    }

    public CodegenConfigurator setGitRepoId(String gitRepoId) {
        if (StringUtils.isNotEmpty((CharSequence)gitRepoId)) {
            this.addAdditionalProperty("gitRepoId", gitRepoId);
        }
        this.generatorSettingsBuilder.withGitRepoId(gitRepoId);
        return this;
    }

    public CodegenConfigurator setGitHost(String gitHost) {
        if (StringUtils.isNotEmpty((CharSequence)gitHost)) {
            this.addAdditionalProperty("gitHost", gitHost);
        }
        this.generatorSettingsBuilder.withGitHost(gitHost);
        return this;
    }

    public CodegenConfigurator setGitUserId(String gitUserId) {
        if (StringUtils.isNotEmpty((CharSequence)gitUserId)) {
            this.addAdditionalProperty("gitHost", gitUserId);
        }
        this.generatorSettingsBuilder.withGitUserId(gitUserId);
        return this;
    }

    public CodegenConfigurator setGroupId(String groupId) {
        if (StringUtils.isNotEmpty((CharSequence)groupId)) {
            this.addAdditionalProperty("groupId", groupId);
        }
        this.generatorSettingsBuilder.withGroupId(groupId);
        return this;
    }

    public CodegenConfigurator setHttpUserAgent(String httpUserAgent) {
        if (StringUtils.isNotEmpty((CharSequence)httpUserAgent)) {
            this.addAdditionalProperty("httpUserAgent", httpUserAgent);
        }
        this.generatorSettingsBuilder.withHttpUserAgent(httpUserAgent);
        return this;
    }

    public CodegenConfigurator setIgnoreFileOverride(String ignoreFileOverride) {
        this.workflowSettingsBuilder.withIgnoreFileOverride(ignoreFileOverride);
        return this;
    }

    public CodegenConfigurator setImportMappings(Map<String, String> importMappings) {
        this.importMappings = importMappings;
        this.generatorSettingsBuilder.withImportMappings(importMappings);
        return this;
    }

    public CodegenConfigurator setInputSpec(String inputSpec) {
        this.inputSpec = inputSpec;
        this.workflowSettingsBuilder.withInputSpec(inputSpec);
        return this;
    }

    public CodegenConfigurator setInstantiationTypes(Map<String, String> instantiationTypes) {
        this.instantiationTypes = instantiationTypes;
        this.generatorSettingsBuilder.withInstantiationTypes(instantiationTypes);
        return this;
    }

    public CodegenConfigurator setInvokerPackage(String invokerPackage) {
        if (StringUtils.isNotEmpty((CharSequence)invokerPackage)) {
            this.addAdditionalProperty("invokerPackage", invokerPackage);
        }
        this.generatorSettingsBuilder.withInvokerPackage(invokerPackage);
        return this;
    }

    public CodegenConfigurator setLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
        this.languageSpecificPrimitives = languageSpecificPrimitives;
        this.generatorSettingsBuilder.withLanguageSpecificPrimitives(languageSpecificPrimitives);
        return this;
    }

    public CodegenConfigurator setLibrary(String library) {
        this.generatorSettingsBuilder.withLibrary(library);
        return this;
    }

    public CodegenConfigurator setLogToStderr(boolean logToStderr) {
        this.workflowSettingsBuilder.withLogToStderr(Boolean.valueOf(logToStderr));
        return this;
    }

    public CodegenConfigurator setApiNameSuffix(String suffix) {
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            this.addAdditionalProperty("apiNameSuffix", suffix);
        }
        this.generatorSettingsBuilder.withApiNameSuffix(suffix);
        return this;
    }

    public CodegenConfigurator setModelNamePrefix(String prefix) {
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            this.addAdditionalProperty("modelNamePrefix", prefix);
        }
        this.generatorSettingsBuilder.withModelNamePrefix(prefix);
        return this;
    }

    public CodegenConfigurator setModelNameSuffix(String suffix) {
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            this.addAdditionalProperty("modelNameSuffix", suffix);
        }
        this.generatorSettingsBuilder.withModelNameSuffix(suffix);
        return this;
    }

    public CodegenConfigurator setModelPackage(String modelPackage) {
        if (StringUtils.isNotEmpty((CharSequence)modelPackage)) {
            this.addAdditionalProperty("modelPackage", modelPackage);
        }
        this.generatorSettingsBuilder.withModelPackage(modelPackage);
        return this;
    }

    public CodegenConfigurator setOutputDir(String outputDir) {
        this.workflowSettingsBuilder.withOutputDir(outputDir);
        return this;
    }

    public CodegenConfigurator setPackageName(String packageName) {
        if (StringUtils.isNotEmpty((CharSequence)packageName)) {
            this.addAdditionalProperty("packageName", packageName);
        }
        this.generatorSettingsBuilder.withPackageName(packageName);
        return this;
    }

    public CodegenConfigurator setReleaseNote(String releaseNote) {
        if (StringUtils.isNotEmpty((CharSequence)releaseNote)) {
            this.addAdditionalProperty("releaseNote", releaseNote);
        }
        this.generatorSettingsBuilder.withReleaseNote(releaseNote);
        return this;
    }

    public CodegenConfigurator setRemoveOperationIdPrefix(boolean removeOperationIdPrefix) {
        this.workflowSettingsBuilder.withRemoveOperationIdPrefix(Boolean.valueOf(removeOperationIdPrefix));
        return this;
    }

    public CodegenConfigurator setSkipOperationExample(boolean skipOperationExample) {
        this.workflowSettingsBuilder.withSkipOperationExample(Boolean.valueOf(skipOperationExample));
        return this;
    }

    public CodegenConfigurator setSkipOverwrite(boolean skipOverwrite) {
        this.workflowSettingsBuilder.withSkipOverwrite(Boolean.valueOf(skipOverwrite));
        return this;
    }

    public CodegenConfigurator setStrictSpecBehavior(boolean strictSpecBehavior) {
        this.workflowSettingsBuilder.withStrictSpecBehavior(Boolean.valueOf(strictSpecBehavior));
        return this;
    }

    public CodegenConfigurator setGlobalProperties(Map<String, String> globalProperties) {
        this.globalProperties = globalProperties;
        this.workflowSettingsBuilder.withGlobalProperties(globalProperties);
        return this;
    }

    public CodegenConfigurator setTemplateDir(String templateDir) {
        this.workflowSettingsBuilder.withTemplateDir(templateDir);
        return this;
    }

    public CodegenConfigurator setTemplatingEngineName(String templatingEngineName) {
        this.templatingEngineName = templatingEngineName;
        this.workflowSettingsBuilder.withTemplatingEngineName(templatingEngineName);
        return this;
    }

    public CodegenConfigurator setTypeMappings(Map<String, String> typeMappings) {
        this.typeMappings = typeMappings;
        this.generatorSettingsBuilder.withTypeMappings(typeMappings);
        return this;
    }

    public CodegenConfigurator setValidateSpec(boolean validateSpec) {
        this.workflowSettingsBuilder.withValidateSpec(Boolean.valueOf(validateSpec));
        return this;
    }

    public CodegenConfigurator setVerbose(boolean verbose) {
        this.workflowSettingsBuilder.withVerbose(Boolean.valueOf(verbose));
        return this;
    }

    public Context<?> toContext() {
        Validate.notEmpty((CharSequence)this.generatorName, (String)"generator name must be specified", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)this.inputSpec, (String)"input spec must be specified", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)this.templatingEngineName)) {
            this.workflowSettingsBuilder.withTemplatingEngineName("mustache");
        } else {
            this.workflowSettingsBuilder.withTemplatingEngineName(this.templatingEngineName);
        }
        GeneratorSettings generatorSettings = this.generatorSettingsBuilder.build();
        WorkflowSettings workflowSettings = this.workflowSettingsBuilder.build();
        if (workflowSettings.isVerbose()) {
            LOGGER.info("\nVERBOSE MODE: ON. Additional debug options are injected\n - [debugOpenAPI] prints the OpenAPI specification as interpreted by the codegen\n - [debugModels] prints models passed to the template engine\n - [debugOperations] prints operations passed to the template engine\n - [debugSupportingFiles] prints additional data passed to the template engine");
            GlobalSettings.setProperty("debugOpenAPI", "");
            GlobalSettings.setProperty("debugModels", "");
            GlobalSettings.setProperty("debugOperations", "");
            GlobalSettings.setProperty("debugSupportingFiles", "");
            GlobalSettings.setProperty("verbose", "true");
        } else {
            GlobalSettings.setProperty("verbose", "false");
        }
        for (Map.Entry entry : workflowSettings.getGlobalProperties().entrySet()) {
            GlobalSettings.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        ModelUtils.setGenerateAliasAsModel(workflowSettings.isGenerateAliasAsModel());
        List<AuthorizationValue> authorizationValues = AuthParser.parse(this.auth);
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        SwaggerParseResult result = new OpenAPIParser().readLocation(this.inputSpec, authorizationValues, options);
        HashSet<String> validationMessages = new HashSet<String>(null != result.getMessages() ? result.getMessages() : new ArrayList());
        OpenAPI specification = result.getOpenAPI();
        if (validationMessages.size() > 0) {
            CharSequence sb;
            List<String> unusedModels;
            HashSet<String> warnings = new HashSet<String>();
            if (specification != null && (unusedModels = ModelUtils.getUnusedSchemas(specification)) != null) {
                unusedModels.forEach(name -> warnings.add("Unused model: " + name));
            }
            if (workflowSettings.isValidateSpec()) {
                sb = "There were issues with the specification. The option can be disabled via validateSpec (Maven/Gradle) or --skip-validate-spec (CLI)." + System.lineSeparator();
                SpecValidationException ex = new SpecValidationException((String)sb);
                ex.setErrors(validationMessages);
                ex.setWarnings(warnings);
                throw ex;
            }
            sb = new StringBuilder();
            ((StringBuilder)sb).append("There were issues with the specification, but validation has been explicitly disabled.");
            ((StringBuilder)sb).append(System.lineSeparator());
            ((StringBuilder)sb).append("Errors: ").append(System.lineSeparator());
            validationMessages.forEach(arg_0 -> CodegenConfigurator.lambda$toContext$1((StringBuilder)sb, arg_0));
            if (!warnings.isEmpty()) {
                ((StringBuilder)sb).append("Warnings: ").append(System.lineSeparator());
                warnings.forEach(arg_0 -> CodegenConfigurator.lambda$toContext$2((StringBuilder)sb, arg_0));
            }
            LOGGER.warn(((StringBuilder)sb).toString());
        }
        return new Context((Object)specification, generatorSettings, workflowSettings);
    }

    public ClientOptInput toClientOptInput() {
        String templateDir;
        Context<?> context = this.toContext();
        WorkflowSettings workflowSettings = context.getWorkflowSettings();
        GeneratorSettings generatorSettings = context.getGeneratorSettings();
        CodegenConfig config = CodegenConfigLoader.forName(generatorSettings.getGeneratorName());
        if (StringUtils.isNotEmpty((CharSequence)generatorSettings.getLibrary())) {
            config.setLibrary(generatorSettings.getLibrary());
        }
        config.setInputSpec(workflowSettings.getInputSpec());
        config.setOutputDir(workflowSettings.getOutputDir());
        config.setSkipOverwrite(workflowSettings.isSkipOverwrite());
        config.setIgnoreFilePathOverride(workflowSettings.getIgnoreFileOverride());
        config.setRemoveOperationIdPrefix(workflowSettings.isRemoveOperationIdPrefix());
        config.setSkipOperationExample(workflowSettings.isSkipOperationExample());
        config.setEnablePostProcessFile(workflowSettings.isEnablePostProcessFile());
        config.setEnableMinimalUpdate(workflowSettings.isEnableMinimalUpdate());
        config.setStrictSpecBehavior(workflowSettings.isStrictSpecBehavior());
        TemplatingEngineAdapter templatingEngine = TemplatingEngineLoader.byIdentifier(workflowSettings.getTemplatingEngineName());
        config.setTemplatingEngine(templatingEngine);
        config.instantiationTypes().putAll(generatorSettings.getInstantiationTypes());
        config.typeMapping().putAll(generatorSettings.getTypeMappings());
        config.importMapping().putAll(generatorSettings.getImportMappings());
        config.languageSpecificPrimitives().addAll(generatorSettings.getLanguageSpecificPrimitives());
        config.reservedWordsMappings().putAll(generatorSettings.getReservedWordMappings());
        config.additionalProperties().putAll(generatorSettings.getAdditionalProperties());
        Map serverVariables = generatorSettings.getServerVariables();
        if (!serverVariables.isEmpty()) {
            LOGGER.warn("user-defined server variable support is experimental.");
            config.serverVariableOverrides().putAll(serverVariables);
        }
        if ((templateDir = workflowSettings.getTemplateDir()) != null) {
            config.additionalProperties().put("templateDir", workflowSettings.getTemplateDir());
        }
        ClientOptInput input = new ClientOptInput().config(config).userDefinedTemplates(this.userDefinedTemplates);
        return input.openAPI((OpenAPI)context.getSpecDocument());
    }

    private static /* synthetic */ void lambda$toContext$2(StringBuilder sb, String msg) {
        sb.append("\t-").append(msg).append(System.lineSeparator());
    }

    private static /* synthetic */ void lambda$toContext$1(StringBuilder sb, String msg) {
        sb.append("\t-").append(msg).append(System.lineSeparator());
    }
}

