/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonClientCodegen
extends AbstractPythonCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonClientCodegen.class);
    public static final String PACKAGE_URL = "packageUrl";
    public static final String DEFAULT_LIBRARY = "urllib3";
    public static final String RECURSION_LIMIT = "recursionLimit";
    public static final String DATETIME_FORMAT = "datetimeFormat";
    public static final String DATE_FORMAT = "dateFormat";
    protected String packageUrl;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean useOneOfDiscriminatorLookup = false;
    protected String datetimeFormat = "%Y-%m-%dT%H:%M:%S.%f%z";
    protected String dateFormat = "%Y-%m-%d";
    private String testFolder;

    public PythonClientCodegen() {
        this.sortParamsByRequiredFlag = true;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.SignatureAuth}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism, SchemaSupportFeature.allOf, SchemaSupportFeature.oneOf, SchemaSupportFeature.anyOf}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.importMapping.clear();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "List");
        this.typeMapping.put("map", "Dict");
        this.typeMapping.put("decimal", "decimal.Decimal");
        this.typeMapping.put("file", "bytearray");
        this.typeMapping.put("binary", "bytearray");
        this.typeMapping.put("ByteArray", "bytearray");
        this.languageSpecificPrimitives.remove("file");
        this.languageSpecificPrimitives.add("decimal.Decimal");
        this.languageSpecificPrimitives.add("bytearray");
        this.languageSpecificPrimitives.add("none_type");
        this.supportsInheritance = true;
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.modelTestTemplateFiles.put("model_test.mustache", ".py");
        this.apiTestTemplateFiles.put("api_test.mustache", ".py");
        this.templateDir = "python";
        this.embeddedTemplateDir = "python";
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.testFolder = "test";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("schema", "base64", "json", "date", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await"));
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("projectName", "python project name in setup.py (e.g. petstore-api)."));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(PACKAGE_URL, "python package URL."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("generateSourceCodeOnly", "Specifies that only a library source code is to be generated.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(RECURSION_LIMIT, "Set the recursion limit. If not set, use the system default value."));
        this.cliOptions.add(new CliOption("mapNumberTo", "Map number to Union[StrictFloat, StrictInt], StrictStr or float.").defaultValue("Union[StrictFloat, StrictInt]"));
        this.cliOptions.add(new CliOption(DATETIME_FORMAT, "datetime format for query parameters").defaultValue("%Y-%m-%dT%H:%M:%S%z"));
        this.cliOptions.add(new CliOption(DATE_FORMAT, "date format for query parameters").defaultValue("%Y-%m-%d"));
        this.cliOptions.add(new CliOption("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped.").defaultValue("false"));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "urllib3-based client");
        this.supportedLibraries.put("asyncio", "asyncio-based client");
        this.supportedLibraries.put("tornado", "tornado-based client (deprecated)");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use: asyncio, tornado (deprecated), urllib3");
        libraryOption.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(DEFAULT_LIBRARY);
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        this.specialCharReplacements.put(".", "Dot");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.setProjectName(this.packageName.replaceAll("_", "-"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("projectName", this.projectName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = Boolean.valueOf(this.additionalProperties.get("excludeTests").toString());
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        if (generateSourceCodeOnly.booleanValue()) {
            this.testFolder = this.packagePath() + File.separatorChar + this.testFolder;
            this.apiDocPath = this.packagePath() + "/" + this.apiDocPath;
            this.modelDocPath = this.packagePath() + "/" + this.modelDocPath;
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.additionalProperties.containsKey(PACKAGE_URL)) {
            this.setPackageUrl((String)this.additionalProperties.get(PACKAGE_URL));
        }
        if (this.additionalProperties.containsKey(RECURSION_LIMIT)) {
            try {
                Integer.parseInt((String)this.additionalProperties.get(RECURSION_LIMIT));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new IllegalArgumentException("recursionLimit must be an integer, e.g. 2000.");
            }
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
        if (this.additionalProperties.containsKey("mapNumberTo")) {
            this.setMapNumberTo(String.valueOf(this.additionalProperties.get("mapNumberTo")));
        }
        if (this.additionalProperties.containsKey(DATETIME_FORMAT)) {
            this.setDatetimeFormat((String)this.additionalProperties.get(DATETIME_FORMAT));
        } else {
            this.additionalProperties.put(DATETIME_FORMAT, this.datetimeFormat);
        }
        if (this.additionalProperties.containsKey(DATE_FORMAT)) {
            this.setDateFormat((String)this.additionalProperties.get(DATE_FORMAT));
        } else {
            this.additionalProperties.put(DATE_FORMAT, this.dateFormat);
        }
        String modelPath = this.packagePath() + File.separatorChar + this.modelPackage.replace('.', File.separatorChar);
        String apiPath = this.packagePath() + File.separatorChar + this.apiPackage.replace('.', File.separatorChar);
        Object readmePath = "README.md";
        String readmeTemplate = "README.mustache";
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packagePath() + "_" + (String)readmePath;
            readmeTemplate = "README_onlypackage.mustache";
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", (String)readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tox.mustache", "", "tox.ini"));
            this.supportingFiles.add(new SupportingFile("test-requirements.mustache", "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("requirements.mustache", "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("setup_cfg.mustache", "", "setup.cfg"));
            this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
            this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
            this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
            this.supportingFiles.add(new SupportingFile("github-workflow.mustache", ".github/workflows", "python.yml"));
            this.supportingFiles.add(new SupportingFile("gitlab-ci.mustache", "", ".gitlab-ci.yml"));
            this.supportingFiles.add(new SupportingFile("setup.mustache", "", "setup.py"));
            this.supportingFiles.add(new SupportingFile("pyproject.mustache", "", "pyproject.toml"));
            this.supportingFiles.add(new SupportingFile("py.typed.mustache", this.packagePath(), "py.typed"));
        }
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.packagePath(), "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", this.packagePath(), "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", modelPath, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", apiPath, "__init__.py"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing.mustache", this.packagePath(), "signing.py"));
        }
        String[] packageNameSplits = this.packageName.split("\\.");
        Object currentPackagePath = "";
        for (int i = 0; i < packageNameSplits.length - 1; ++i) {
            if (i > 0) {
                currentPackagePath = (String)currentPackagePath + File.separatorChar;
            }
            currentPackagePath = (String)currentPackagePath + packageNameSplits[i];
            this.supportingFiles.add(new SupportingFile("__init__.mustache", (String)currentPackagePath, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("exceptions.mustache", this.packagePath(), "exceptions.py"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("__init__.mustache", this.testFolder, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.packagePath(), "api_client.py"));
        this.supportingFiles.add(new SupportingFile("api_response.mustache", this.packagePath(), "api_response.py"));
        if ("asyncio".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("asyncio/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("asyncio", "true");
        } else if ("tornado".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("tornado/rest.mustache", this.packagePath(), "rest.py"));
            this.additionalProperties.put("tornado", "true");
        } else {
            this.supportingFiles.add(new SupportingFile("rest.mustache", this.packagePath(), "rest.py"));
        }
        this.modelPackage = this.packageName + "." + this.modelPackage;
        this.apiPackage = this.packageName + "." + this.apiPackage;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    @Override
    public String toModelImport(String name) {
        Object modelImport;
        if (org.apache.commons.lang3.StringUtils.startsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"import", "from"})) {
            modelImport = name;
        } else {
            modelImport = "from ";
            if (!"".equals(this.modelPackage())) {
                modelImport = (String)modelImport + this.modelPackage() + ".";
            }
            modelImport = (String)modelImport + this.toModelFilename(name) + " import " + name;
        }
        return modelImport;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + File.separator + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + File.separator + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String packagePath() {
        return this.packageName.replace('.', File.separatorChar);
    }

    public String generatePackageName(String packageName) {
        return StringUtils.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String generatorLanguageVersion() {
        return "3.7+";
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema additionalProperties = ModelUtils.getAdditionalProperties(schema);
        if (additionalProperties != null) {
            codegenModel.additionalPropertiesType = this.getSchemaType(additionalProperties);
        }
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "str".equals(dataType);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "var_" + name;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }
}

