/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import com.google.common.collect.Sets;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.File;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptClientCodegen
extends AbstractTypeScriptClientCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(TypeScriptClientCodegen.class);
    private static final String FRAMEWORK_SWITCH = "framework";
    private static final String FRAMEWORK_SWITCH_DESC = "Specify the framework which should be used in the client code.";
    private static final String[] FRAMEWORKS = new String[]{"fetch-api", "jquery"};
    private static final String PLATFORM_SWITCH = "platform";
    private static final String PLATFORM_SWITCH_DESC = "Specifies the platform the code should run on. The default is 'node' for the 'request' framework and 'browser' otherwise.";
    private static final String[] PLATFORMS = new String[]{"browser", "node", "deno"};
    private static final String IMPORT_FILE_EXTENSION_SWITCH = "importFileExtension";
    private static final String IMPORT_FILE_EXTENSION_SWITCH_DESC = "File extension to use with relative imports. Set it to '.js' or '.mjs' when using [ESM](https://nodejs.org/api/esm.html). Defaults to '.ts' when 'platform' is set to 'deno'.";
    private static final String FILE_CONTENT_DATA_TYPE = "fileContentDataType";
    private static final String FILE_CONTENT_DATA_TYPE_DESC = "Specifies the type to use for the content of a file - i.e. Blob (Browser, Deno) / Buffer (node)";
    private static final String USE_RXJS_SWITCH = "useRxJS";
    private static final String USE_RXJS_SWITCH_DESC = "Enable this to internally use rxjs observables. If disabled, a stub is used instead. This is required for the 'angular' framework.";
    private static final String USE_INVERSIFY_SWITCH = "useInversify";
    private static final String USE_INVERSIFY_SWITCH_DESC = "Enable this to generate decorators and service identifiers for the InversifyJS inversion of control container. If you set 'deno' as 'platform', the generator will process this value as 'disable'.";
    private static final String USE_OBJECT_PARAMS_SWITCH = "useObjectParameters";
    private static final String USE_OBJECT_PARAMS_DESC = "Use aggregate parameter objects as function arguments for api operations instead of passing each parameter as a separate function argument.";
    private final Map<String, String> frameworkToHttpLibMap;
    private static final String NPM_REPOSITORY = "npmRepository";
    protected String npmRepository = null;
    protected String snapshot = null;
    protected CodegenConstants.ENUM_PROPERTY_NAMING_TYPE enumPropertyNaming = CodegenConstants.ENUM_PROPERTY_NAMING_TYPE.PascalCase;
    private final DateTimeFormatter iso8601Date = DateTimeFormatter.ISO_DATE;
    private final DateTimeFormatter iso8601DateTime = DateTimeFormatter.ISO_DATE_TIME;

    public TypeScriptClientCodegen() {
        this.modifyFeatureSet(features -> features.includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}));
        this.frameworkToHttpLibMap = new HashMap<String, String>();
        this.frameworkToHttpLibMap.put("fetch-api", "isomorphic-fetch");
        this.frameworkToHttpLibMap.put("jquery", "jquery");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.outputFolder = "generated-code" + File.separator + "typescript";
        this.templateDir = "typescript";
        this.embeddedTemplateDir = "typescript";
        this.reservedWords.addAll(Arrays.asList("from", "constructor"));
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("object", "any");
        this.typeMapping.put("DateTime", "Date");
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(FILE_CONTENT_DATA_TYPE, FILE_CONTENT_DATA_TYPE_DESC).defaultValue("Buffer"));
        this.cliOptions.add(new CliOption(USE_RXJS_SWITCH, USE_RXJS_SWITCH_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_OBJECT_PARAMS_SWITCH, USE_OBJECT_PARAMS_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_INVERSIFY_SWITCH, USE_INVERSIFY_SWITCH_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(IMPORT_FILE_EXTENSION_SWITCH, IMPORT_FILE_EXTENSION_SWITCH_DESC));
        CliOption frameworkOption = new CliOption(FRAMEWORK_SWITCH, FRAMEWORK_SWITCH_DESC);
        for (String option : FRAMEWORKS) {
            frameworkOption.addEnum(option, option);
        }
        frameworkOption.defaultValue(FRAMEWORKS[0]);
        this.cliOptions.add(frameworkOption);
        CliOption platformOption = new CliOption(PLATFORM_SWITCH, PLATFORM_SWITCH_DESC);
        for (String option : PLATFORMS) {
            platformOption.addEnum(option, option);
        }
        platformOption.defaultValue(PLATFORMS[0]);
        this.cliOptions.add(platformOption);
        this.supportModelPropertyNaming(CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.camelCase);
        this.supportingFiles.add(new SupportingFile(".gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("util.mustache", "", "util.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "exception.mustache", "apis", "exception.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "http.mustache", "http", "http.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "servers.mustache", "servers.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("auth" + File.separator + "auth.mustache", "auth", "auth.ts"));
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "models_all.mustache", "models", "all.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "PromiseAPI.mustache", "types", "PromiseAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObservableAPI.mustache", "types", "ObservableAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObjectParamAPI.mustache", "types", "ObjectParamAPI.ts"));
        this.setModelPackage("models");
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "ObjectSerializer.mustache", "models", "ObjectSerializer.ts"));
        this.modelTemplateFiles.put("model" + File.separator + "model.mustache", ".ts");
        this.setApiPackage("");
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "middleware.mustache", "", "middleware.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "baseapi.mustache", "apis", "baseapi.ts"));
        this.apiTemplateFiles.put("api" + File.separator + "api.mustache", ".ts");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
    }

    @Override
    public String getNpmName() {
        return this.npmName;
    }

    @Override
    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    @Override
    public String getNpmVersion() {
        return this.npmVersion;
    }

    @Override
    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Object propFramework = this.additionalProperties.get(FRAMEWORK_SWITCH);
        HashMap<String, Boolean> frameworks = new HashMap<String, Boolean>();
        for (String framework : FRAMEWORKS) {
            frameworks.put(framework, framework.equals(propFramework));
        }
        objs.put(FRAMEWORK_SWITCH, propFramework);
        objs.put("frameworks", frameworks);
        objs.put(FILE_CONTENT_DATA_TYPE, this.additionalProperties.get(FILE_CONTENT_DATA_TYPE));
        return objs;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> models) {
        List<Map<String, String>> imports = operations.getImports();
        for (Map<String, String> im : imports) {
            im.put("filename", im.get("import"));
        }
        OperationMap operationsMap = operations.getOperations();
        List<CodegenOperation> operationList = operationsMap.getOperation();
        for (CodegenOperation operation : operationList) {
            List<CodegenResponse> responses = operation.responses;
            operation.returnType = this.getReturnType(responses);
        }
        return operations;
    }

    private String getReturnType(List<CodegenResponse> responses) {
        HashSet<String> returnTypes = new HashSet<String>();
        for (CodegenResponse response : responses) {
            if (!response.is2xx) continue;
            if (response.dataType != null) {
                returnTypes.add(response.dataType);
                continue;
            }
            returnTypes.add("void");
        }
        if (returnTypes.size() == 0) {
            return null;
        }
        return String.join((CharSequence)" | ", returnTypes);
    }

    @Override
    public String toParamName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        return super.toParamName(name);
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        return super.toVarName(name);
    }

    @Override
    public String toModelImport(String name) {
        return "../" + this.modelPackage() + "/" + this.toModelName(name);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return this.getNameWithEnumPropertyNaming("empty");
        }
        if (this.getSymbolName(name) != null) {
            return this.getNameWithEnumPropertyNaming(this.getSymbolName(name));
        }
        if ("number".equals(datatype)) {
            Object varName = "NUMBER_" + name;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = this.getNameWithEnumPropertyNaming(enumName)).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    private String getNameWithEnumPropertyNaming(String name) {
        switch (this.getEnumPropertyNaming()) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(StringUtils.underscore(name), CamelizeOption.LOWERCASE_FIRST_LETTER);
            }
            case PascalCase: {
                return StringUtils.camelize(StringUtils.underscore(name));
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
            case UPPERCASE: {
                return StringUtils.underscore(name).toUpperCase(Locale.ROOT);
            }
        }
        throw new IllegalArgumentException("Unsupported enum property naming: '" + name);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        CodegenModel cm;
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        for (ModelMap mo : models) {
            cm = mo.getModel();
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (ModelMap mo : models) {
            cm = mo.getModel();
            mo.put("tsImports", this.toTsImports(cm, cm.imports));
        }
        return objs;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.importMapping.getOrDefault(im, this.toModelImport(im)));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public String getName() {
        return "typescript";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    @Override
    public void processOpts() {
        boolean useInversify;
        boolean useRxJS;
        Object fileExtension;
        super.processOpts();
        this.apiPackage = this.apiPackage + ".apis";
        this.testPackage = this.testPackage + ".tests";
        this.additionalProperties.putIfAbsent(FRAMEWORK_SWITCH, FRAMEWORKS[0]);
        this.supportingFiles.add(new SupportingFile("index.mustache", "index.ts"));
        String httpLibName = this.getHttpLibForFramework(this.additionalProperties.get(FRAMEWORK_SWITCH).toString());
        this.supportingFiles.add(new SupportingFile("http" + File.separator + httpLibName + ".mustache", "http", httpLibName + ".ts"));
        Object propPlatform = this.additionalProperties.get(PLATFORM_SWITCH);
        if (propPlatform == null) {
            propPlatform = "browser";
            this.additionalProperties.put(PLATFORM_SWITCH, propPlatform);
        }
        HashMap<String, Boolean> platforms = new HashMap<String, Boolean>();
        for (String platform : PLATFORMS) {
            platforms.put(platform, platform.equals(propPlatform));
        }
        this.additionalProperties.put("platforms", platforms);
        this.additionalProperties.putIfAbsent(FILE_CONTENT_DATA_TYPE, "node".equals(propPlatform) ? "Buffer" : "Blob");
        if (!"deno".equals(propPlatform)) {
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
            this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        }
        if ((fileExtension = this.additionalProperties.get(IMPORT_FILE_EXTENSION_SWITCH)) == null && "deno".equals(propPlatform)) {
            this.additionalProperties.put(IMPORT_FILE_EXTENSION_SWITCH, ".ts");
        }
        if (!(useRxJS = this.convertPropertyToBooleanAndWriteBack(USE_RXJS_SWITCH))) {
            this.supportingFiles.add(new SupportingFile("rxjsStub.mustache", "rxjsStub.ts"));
        }
        if (useInversify = this.convertPropertyToBooleanAndWriteBack(USE_INVERSIFY_SWITCH)) {
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "index.mustache", "services", "index.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "configuration.mustache", "services", "configuration.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "PromiseAPI.mustache", "services", "PromiseAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObservableAPI.mustache", "services", "ObservableAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObjectParamAPI.mustache", "services", "ObjectParamAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "http.mustache", "services", "http.ts"));
            this.apiTemplateFiles.put("services" + File.separator + "api.mustache", ".service.ts");
        }
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
    }

    private String getHttpLibForFramework(String object) {
        return this.frameworkToHttpLibMap.get(object);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(this.unaliasSchema(inner)) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema<?> inner = this.getSchemaAdditionalProperties(p);
            String postfix = "";
            if (Boolean.TRUE.equals(inner.getNullable())) {
                postfix = " | null";
            }
            return "{ [key: string]: " + this.getTypeDeclaration(this.unaliasSchema(inner)) + postfix + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "HttpFile";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)schema.getAdditionalProperties());
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    public String typescriptDate(Object dateValue) {
        String strValue = null;
        if (dateValue instanceof OffsetDateTime) {
            OffsetDateTime date = null;
            try {
                date = (OffsetDateTime)dateValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date` format for value {}", dateValue);
                date = ((Date)dateValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = date.format(this.iso8601Date);
        } else {
            strValue = dateValue.toString();
        }
        return "new Date('" + strValue + "').toISOString().split('T')[0];";
    }

    public String typescriptDateTime(Object dateTimeValue) {
        String strValue = null;
        if (dateTimeValue instanceof OffsetDateTime) {
            OffsetDateTime dateTime = null;
            try {
                dateTime = (OffsetDateTime)dateTimeValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date-time` format for value {}", dateTimeValue);
                dateTime = ((Date)dateTimeValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = dateTime.format(this.iso8601DateTime);
        } else {
            strValue = dateTimeValue.toString();
        }
        return "new Date('" + strValue + "')";
    }

    public String getModelName(Schema sc) {
        Schema unaliasedSchema;
        if (sc.get$ref() != null && (unaliasedSchema = this.unaliasSchema(sc)).get$ref() != null) {
            return this.toModelName(ModelUtils.getSimpleRef(sc.get$ref()));
        }
        return null;
    }

    protected Object getObjectExample(Schema sc) {
        Boolean objectModel;
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((objectModel = Boolean.valueOf(ModelUtils.isObjectSchema(schema) || ModelUtils.isMapSchema(schema) || ModelUtils.isComposedSchema(schema))).booleanValue()) {
            return null;
        }
        if (schema.getExample() != null) {
            return schema.getExample();
        }
        if (schema.getDefault() != null) {
            return schema.getDefault();
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return schema.getEnum().get(0);
        }
        return null;
    }

    private String ensureQuotes(String in) {
        Pattern pattern = Pattern.compile("\r\n|\r|\n");
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return "`" + in + "`";
        }
        String strPattern = "^['\"].*?['\"]$";
        if (in.matches(strPattern)) {
            return in;
        }
        return "\"" + in + "\"";
    }

    @Override
    public String toExampleValue(Schema schema) {
        Object objExample = this.getObjectExample(schema);
        return this.toExampleValue(schema, objExample);
    }

    public String toExampleValue(Schema schema, Object objExample) {
        String modelName = this.getModelName(schema);
        return this.toExampleValueRecursive(modelName, schema, objExample, 1, "", 0, Sets.newHashSet());
    }

    private Boolean simpleStringSchema(Schema schema) {
        Schema sc = schema;
        String ref = schema.get$ref();
        if (ref != null) {
            sc = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        return ModelUtils.isStringSchema(sc) && !ModelUtils.isDateSchema(sc) && !ModelUtils.isDateTimeSchema(sc) && !"Number".equalsIgnoreCase(sc.getFormat()) && !ModelUtils.isByteArraySchema(sc) && !ModelUtils.isBinarySchema(sc) && schema.getPattern() == null;
    }

    private CodegenDiscriminator.MappedModel getDiscriminatorMappedModel(CodegenDiscriminator disc) {
        for (CodegenDiscriminator.MappedModel mm : disc.getMappedModels()) {
            String modelName = mm.getModelName();
            Schema modelSchema = this.getModelNameToSchemaCache().get(modelName);
            if (!ModelUtils.isObjectSchema(modelSchema)) continue;
            return mm;
        }
        return null;
    }

    private String toExampleValueRecursive(String modelName, Schema schema, Object objExample, int indentationLevel, String prefix, Integer exampleLine, Set<Schema> seenSchemas) {
        String indentionConst = "  ";
        Object currentIndentation = "";
        Object closingIndentation = "";
        for (int i = 0; i < indentationLevel; ++i) {
            currentIndentation = (String)currentIndentation + "  ";
        }
        if (exampleLine.equals(0)) {
            closingIndentation = currentIndentation;
            currentIndentation = "";
        } else {
            closingIndentation = currentIndentation;
        }
        String openChars = "";
        String closeChars = "";
        String fullPrefix = (String)currentIndentation + prefix + openChars;
        Object example = null;
        if (objExample != null) {
            example = objExample.toString();
        }
        if (seenSchemas.contains(schema)) {
            if (modelName != null) {
                return fullPrefix + closeChars;
            }
            if (ModelUtils.isNullable(schema)) {
                return fullPrefix + "null" + closeChars;
            }
            if (ModelUtils.isArraySchema(schema)) {
                return fullPrefix + "[]" + closeChars;
            }
            return fullPrefix + "{}" + closeChars;
        }
        if (null != schema.get$ref()) {
            String ref;
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            Schema refSchema = allDefinitions.get(ref = ModelUtils.getSimpleRef(schema.get$ref()));
            if (null == refSchema) {
                this.LOGGER.warn("Unable to find referenced schema " + schema.get$ref() + "\n");
                return fullPrefix + "null" + closeChars;
            }
            String refModelName = this.getModelName(schema);
            return this.toExampleValueRecursive(refModelName, refSchema, objExample, indentationLevel, prefix, exampleLine, seenSchemas);
        }
        if (ModelUtils.isNullType(schema) || ModelUtils.isAnyType(schema)) {
            return fullPrefix + "null" + closeChars;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            example = objExample == null ? "true" : ("false".equalsIgnoreCase(objExample.toString()) ? "false" : "true");
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = objExample == null ? this.typescriptDate("1970-01-01") : this.typescriptDate(objExample);
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = objExample == null ? this.typescriptDateTime("1970-01-01T00:00:00.00Z") : this.typescriptDateTime(objExample);
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            if (objExample == null) {
                example = "/path/to/file";
            }
            example = "{ data: Buffer.from(fs.readFileSync('" + (String)example + "', 'utf-8')), name: '" + (String)example + "' }";
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            if (objExample == null) {
                example = "'YQ=='";
            }
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (objExample == null) {
                if ("Number".equalsIgnoreCase(schema.getFormat())) {
                    example = "2";
                    return fullPrefix + (String)example + closeChars;
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                    String pattern = schema.getPattern();
                    RgxGen rgxGen = new RgxGen((CharSequence)pattern);
                    Random random = new Random(18L);
                    example = rgxGen.generate(random);
                } else if (schema.getMinLength() != null) {
                    example = "";
                    int len = schema.getMinLength();
                    for (int i = 0; i < len; ++i) {
                        example = (String)example + "a";
                    }
                } else {
                    example = ModelUtils.isUUIDSchema(schema) ? "046b6c7f-0b8a-43b9-b35d-6489e6daee91" : "string_example";
                }
            }
            return fullPrefix + this.ensureQuotes((String)example) + closeChars;
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1";
            }
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "3.14";
            }
            return fullPrefix + (String)example + closeChars;
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arrayschema = (ArraySchema)schema;
            Schema itemSchema = arrayschema.getItems();
            String itemModelName = this.getModelName(itemSchema);
            if (objExample instanceof Iterable && itemModelName == null) {
                return fullPrefix + objExample + closeChars;
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            example = fullPrefix + "[\n" + this.toExampleValueRecursive(itemModelName, itemSchema, objExample, indentationLevel + 1, "", exampleLine + 1, newSeenSchemas) + ",\n" + (String)closingIndentation + "]" + closeChars;
            return example;
        }
        if (ModelUtils.isMapSchema(schema)) {
            Object addPropsObj;
            if (modelName == null) {
                fullPrefix = fullPrefix + "{";
                closeChars = "}";
            }
            if ((addPropsObj = schema.getAdditionalProperties()) instanceof Schema) {
                Schema addPropsSchema = (Schema)addPropsObj;
                String key = "key";
                Object addPropsExample = this.getObjectExample(addPropsSchema);
                if (addPropsSchema.getEnum() != null && !addPropsSchema.getEnum().isEmpty()) {
                    key = addPropsSchema.getEnum().get(0).toString();
                }
                addPropsExample = this.exampleFromStringOrArraySchema(addPropsSchema, addPropsExample, key);
                String addPropPrefix = key + ": ";
                if (modelName == null) {
                    addPropPrefix = this.ensureQuotes(key) + ": ";
                }
                String addPropsModelName = "\"" + this.getModelName(addPropsSchema) + "\"";
                HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
                newSeenSchemas.add(schema);
                example = fullPrefix + "\n" + this.toExampleValueRecursive(addPropsModelName, addPropsSchema, addPropsExample, indentationLevel + 1, addPropPrefix, exampleLine + 1, newSeenSchemas) + ",\n" + (String)closingIndentation + closeChars;
            } else {
                example = fullPrefix + closeChars;
            }
            return example;
        }
        if (ModelUtils.isComposedSchema(schema)) {
            ComposedSchema cm = (ComposedSchema)schema;
            List ls = cm.getOneOf();
            if (ls != null && !ls.isEmpty()) {
                return fullPrefix + this.toExampleValue((Schema)ls.get(0)) + closeChars;
            }
            return fullPrefix + closeChars;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            fullPrefix = fullPrefix + "{";
            closeChars = "}";
            CodegenDiscriminator disc = this.createDiscriminator(modelName, schema);
            if (disc != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm != null) {
                    String discPropNameValue = mm.getMappingName();
                    String string = mm.getModelName();
                } else {
                    return fullPrefix + closeChars;
                }
            }
            HashSet<Schema> newSeenSchemas = new HashSet<Schema>(seenSchemas);
            newSeenSchemas.add(schema);
            String exampleForObjectModel = this.exampleForObjectModel(schema, fullPrefix, closeChars, null, indentationLevel, exampleLine, (String)closingIndentation, newSeenSchemas);
            return exampleForObjectModel;
        }
        this.LOGGER.warn("Type " + schema.getType() + " not handled properly in toExampleValue");
        return example;
    }

    private String exampleForObjectModel(Schema schema, String fullPrefix, String closeChars, CodegenProperty discProp, int indentationLevel, int exampleLine, String closingIndentation, Set<Schema> seenSchemas) {
        Map requiredAndOptionalProps = schema.getProperties();
        if (requiredAndOptionalProps == null || requiredAndOptionalProps.isEmpty()) {
            return fullPrefix + closeChars;
        }
        String example = fullPrefix + "\n";
        for (Map.Entry entry : requiredAndOptionalProps.entrySet()) {
            String propName = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            boolean readOnly = false;
            if (propSchema.getReadOnly() != null) {
                readOnly = propSchema.getReadOnly();
            }
            if (readOnly) continue;
            String ref = propSchema.get$ref();
            if (ref != null) {
                Schema refSchema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
                if (refSchema.getReadOnly() != null) {
                    readOnly = refSchema.getReadOnly();
                }
                if (readOnly) continue;
            }
            propName = this.toVarName(propName);
            String propModelName = null;
            Object propExample = null;
            if (discProp != null && propName.equals(discProp.name)) {
                propModelName = null;
                propExample = discProp.example;
            } else {
                propModelName = this.getModelName(propSchema);
                propExample = this.exampleFromStringOrArraySchema(propSchema, null, propName);
            }
            example = example + this.toExampleValueRecursive(propModelName, propSchema, propExample, indentationLevel + 1, propName + ": ", exampleLine + 1, seenSchemas) + ",\n";
        }
        example = example + closingIndentation + closeChars;
        return example;
    }

    private Object exampleFromStringOrArraySchema(Schema sc, Object currentExample, String propName) {
        Object example;
        if (currentExample != null) {
            return currentExample;
        }
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((example = this.getObjectExample(schema)) != null) {
            return example;
        }
        if (this.simpleStringSchema(schema).booleanValue()) {
            return propName + "_example";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema itemSchema = arraySchema.getItems();
            example = this.getObjectExample(itemSchema);
            if (example != null) {
                return example;
            }
            if (this.simpleStringSchema(itemSchema).booleanValue()) {
                return propName + "_example";
            }
        }
        return null;
    }

    protected String setPropertyExampleValue(CodegenProperty p) {
        if (p == null) {
            return "null";
        }
        Object example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if (Boolean.TRUE.equals(p.isInteger)) {
            if (example == null) {
                example = "56";
            }
        } else if (Boolean.TRUE.equals(p.isLong)) {
            if (example == null) {
                example = "789";
            }
        } else if (Boolean.TRUE.equals(p.isDouble) || Boolean.TRUE.equals(p.isFloat) || Boolean.TRUE.equals(p.isNumber)) {
            if (example == null) {
                example = "3.4";
            }
        } else if (Boolean.TRUE.equals(p.isBoolean)) {
            if (example == null) {
                example = "true";
            }
        } else if (Boolean.TRUE.equals(p.isFile) || Boolean.TRUE.equals(p.isBinary)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if (Boolean.TRUE.equals(p.isDate)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new Date(\"" + this.escapeText((String)example) + "\")";
        } else if (Boolean.TRUE.equals(p.isDateTime)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new Date(\"" + this.escapeText((String)example) + "\")";
        } else if (Boolean.TRUE.equals(p.isString)) {
            if (example == null) {
                example = p.name + "_example";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new {{moduleName}}." + type + "()";
        }
        return example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        String finalExample;
        Schema schema = parameter.getSchema();
        if (schema == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because parameter lacks a schema");
            return;
        }
        Object example = null;
        example = codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example") ? codegenParameter.vendorExtensions.get("x-example") : (parameter.getExample() != null ? parameter.getExample() : (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && ((Example)parameter.getExamples().values().iterator().next()).getValue() != null ? ((Example)parameter.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema)));
        example = this.exampleFromStringOrArraySchema(schema, example, parameter.getName());
        codegenParameter.example = finalExample = this.toExampleValue(schema, example);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        MediaType mediaType;
        Schema schema;
        Content content;
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        }
        if ((content = requestBody.getContent()).size() > 1) {
            OnceLogger.once(this.LOGGER).debug("Multiple MediaTypes found, using only the first one");
        }
        if ((schema = (mediaType = (MediaType)content.values().iterator().next()).getSchema()) == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because requestBody content lacks a schema");
            return;
        }
        Object example = null;
        example = mediaType.getExample() != null ? mediaType.getExample() : (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && ((Example)mediaType.getExamples().values().iterator().next()).getValue() != null ? ((Example)mediaType.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema));
        example = this.exampleFromStringOrArraySchema(schema, example, codegenParameter.paramName);
        codegenParameter.example = this.toExampleValue(schema, example);
    }

    @Override
    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter cp = super.fromFormProperty(name, propertySchema, imports);
        Parameter p = new Parameter();
        p.setSchema(propertySchema);
        p.setName(cp.paramName);
        this.setParameterExampleValue(cp, p);
        return cp;
    }

    @Override
    protected void addImport(Set<String> importsToBeAddedTo, String type) {
        String[] parts;
        if (type == null) {
            return;
        }
        for (String s : parts = this.splitComposedTypes(type)) {
            super.addImport(importsToBeAddedTo, s);
        }
    }

    protected String[] splitComposedTypes(String type) {
        return type.replace(" ", "").split("[|&<>]");
    }
}

