/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsManyToOneMap;
import org.opencms.util.CmsUUID;

public class CmsDetailNameCache
implements I_CmsGlobalConfigurationCache {
    public static final int DELAY_MILLIS = 10000;
    private static final Log LOG = CmsLog.getLog(CmsDetailNameCache.class);
    private CmsObject m_cms;
    private CmsManyToOneMap<String, CmsUUID> m_detailIdCache = new CmsManyToOneMap();
    private Set<CmsUUID> m_updateSet = Sets.newHashSet();

    public CmsDetailNameCache(CmsObject cms) {
        this.m_cms = cms;
    }

    @Override
    public void clear() {
        this.markForUpdate(CmsUUID.getNullUUID());
    }

    public CmsUUID getDetailId(String name) {
        return this.m_detailIdCache.get(name);
    }

    public void initialize() {
        OpenCms.getExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CmsDetailNameCache.this.checkForUpdates();
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        this.reload();
    }

    @Override
    public void remove(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void remove(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void update(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    synchronized void checkForUpdates() {
        if (!this.m_updateSet.isEmpty()) {
            HashSet copiedIds = Sets.newHashSet(this.m_updateSet);
            this.m_updateSet.clear();
            if (copiedIds.contains(CmsUUID.getNullUUID())) {
                LOG.info((Object)"Updating detail name cache: reloading...");
                this.reload();
            } else {
                LOG.info((Object)("Updating detail name cache. Number of changed files: " + copiedIds.size()));
                CmsManyToOneMap<String, CmsUUID> cacheCopy = new CmsManyToOneMap<String, CmsUUID>(this.m_detailIdCache);
                for (CmsUUID id : copiedIds) {
                    Set<String> urlNames = this.getUrlNames(id);
                    cacheCopy.removeValue(id);
                    for (String urlName : urlNames) {
                        cacheCopy.put(urlName, id);
                    }
                }
                this.m_detailIdCache = cacheCopy;
            }
        }
    }

    private void checkIfUpdateIsNeeded(CmsUUID structureId, String rootPath, int typeId) {
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(typeId);
            if (resType instanceof CmsResourceTypeXmlContent && !OpenCms.getResourceManager().matchResourceType("containerpage", typeId)) {
                this.markForUpdate(structureId);
            }
        }
        catch (CmsLoaderException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private Set<String> getUrlNames(CmsUUID id) {
        try {
            return new HashSet<String>(this.m_cms.readUrlNamesForAllLocales(id));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private synchronized void markForUpdate(CmsUUID id) {
        this.m_updateSet.add(id);
    }

    private void reload() {
        CmsManyToOneMap<String, CmsUUID> newMap = new CmsManyToOneMap<String, CmsUUID>();
        try {
            List<CmsUrlNameMappingEntry> mappings = this.m_cms.readUrlNameMappings(CmsUrlNameMappingFilter.ALL);
            LOG.info((Object)("Initializing detail name cache with " + mappings.size() + " entries"));
            for (CmsUrlNameMappingEntry entry : mappings) {
                newMap.put(entry.getName(), entry.getStructureId());
            }
            this.m_detailIdCache = newMap;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

