/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsFormatterChangeSet {
    public static final String PREFIX_TYPE = "type_";
    private Pattern m_pathPattern;
    private Map<String, Boolean> m_typeUpdateSet = new HashMap<String, Boolean>();
    private Map<CmsUUID, Boolean> m_updateSet = new HashMap<CmsUUID, Boolean>();
    private boolean m_removeAllNonExplicitlyAdded;

    public CmsFormatterChangeSet() {
    }

    public CmsFormatterChangeSet(Collection<String> toRemove, Collection<String> toAdd, String siteRoot, boolean removeAllNonExplicitlyAdded) {
        this();
        this.initialize(toRemove, toAdd, siteRoot, removeAllNonExplicitlyAdded);
    }

    public static String keyForType(String typeName) {
        return PREFIX_TYPE + typeName;
    }

    public void applyToFormatters(Map<CmsUUID, I_CmsFormatterBean> formatters, CmsFormatterConfigurationCacheState externalFormatters) {
        if (this.m_removeAllNonExplicitlyAdded) {
            formatters.clear();
        }
        for (Map.Entry<CmsUUID, Boolean> updateEntry : this.m_updateSet.entrySet()) {
            CmsUUID key = updateEntry.getKey();
            Boolean value = updateEntry.getValue();
            if (value.booleanValue()) {
                I_CmsFormatterBean addedFormatter = externalFormatters.getFormatters().get(key);
                if (addedFormatter == null) continue;
                formatters.put(key, addedFormatter);
                continue;
            }
            formatters.remove(key);
        }
        if (this.m_pathPattern != null) {
            Iterator<Map.Entry<CmsUUID, I_CmsFormatterBean>> formattersIt = formatters.entrySet().iterator();
            while (formattersIt.hasNext()) {
                Map.Entry<CmsUUID, I_CmsFormatterBean> entry = formattersIt.next();
                if (entry.getValue().getLocation() == null || this.m_pathPattern.matcher(entry.getValue().getLocation()).matches()) continue;
                formattersIt.remove();
            }
        }
    }

    public void applyToTypes(Set<String> types) {
        if (this.m_removeAllNonExplicitlyAdded) {
            types.clear();
        }
        for (Map.Entry<String, Boolean> typeUpdateEntry : this.m_typeUpdateSet.entrySet()) {
            String typeName = typeUpdateEntry.getKey();
            Boolean add = typeUpdateEntry.getValue();
            if (add.booleanValue()) {
                types.add(typeName);
                continue;
            }
            types.remove(typeName);
        }
    }

    private void initialize(Collection<String> toRemove, Collection<String> toAdd, String siteRoot, boolean removeAllNonExplicitlyAdded) {
        this.m_removeAllNonExplicitlyAdded = removeAllNonExplicitlyAdded;
        for (String removeKey : toRemove) {
            if (CmsUUID.isValidUUID(removeKey)) {
                this.m_updateSet.put(new CmsUUID(removeKey), Boolean.FALSE);
                continue;
            }
            if (!removeKey.startsWith(PREFIX_TYPE)) continue;
            this.m_typeUpdateSet.put(this.removePrefix(removeKey), Boolean.FALSE);
        }
        for (String addKey : toAdd) {
            if (CmsUUID.isValidUUID(addKey)) {
                this.m_updateSet.put(new CmsUUID(addKey), Boolean.TRUE);
                continue;
            }
            if (!addKey.startsWith(PREFIX_TYPE)) continue;
            this.m_typeUpdateSet.put(this.removePrefix(addKey), Boolean.TRUE);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(siteRoot)) {
            if (!siteRoot.endsWith("/")) {
                siteRoot = siteRoot + "/";
            }
            String regex = "^(/system/|" + OpenCms.getSiteManager().getSharedFolder() + "|" + siteRoot + ").*";
            this.m_pathPattern = Pattern.compile(regex);
        }
    }

    private String removePrefix(String key) {
        if (key.startsWith(PREFIX_TYPE)) {
            return key.substring(PREFIX_TYPE.length());
        }
        return key;
    }
}

