/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.configuration.formatters.CmsFormatterBeanParser;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;

public class CmsFormatterConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final CmsUUID RELOAD_MARKER = CmsUUID.getNullUUID();
    public static final String TYPE_FLEX_FORMATTER = "flex_formatter";
    public static final String TYPE_FORMATTER_CONFIG = "formatter_config";
    public static final String TYPE_MACRO_FORMATTER = "macro_formatter";
    public static final String TYPE_SETTINGS_CONFIG = "settings_config";
    protected static int UPDATE_DELAY_MILLIS = 500;
    private static final Log LOG = CmsLog.getLog(CmsFormatterConfigurationCache.class);
    private volatile ScheduledFuture<?> m_taskFuture;
    private LinkedBlockingQueue<Object> m_workQueue = new LinkedBlockingQueue();
    private CmsObject m_cms;
    private String m_name;
    private volatile Map<CmsUUID, List<CmsXmlContentProperty>> m_settingConfigs;
    private volatile CmsFormatterConfigurationCacheState m_state = new CmsFormatterConfigurationCacheState(Collections.emptyMap());

    public CmsFormatterConfigurationCache(CmsObject cms, String name) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        Map<CmsUUID, I_CmsFormatterBean> noFormatters = Collections.emptyMap();
        this.m_state = new CmsFormatterConfigurationCacheState(noFormatters);
        this.m_name = name;
    }

    public void addWaitHandle(CmsWaitHandle handle) {
        this.m_workQueue.add(handle);
    }

    @Override
    public void clear() {
        this.markForUpdate(RELOAD_MARKER);
    }

    public String getName() {
        return this.m_name;
    }

    public CmsFormatterConfigurationCacheState getState() {
        return this.m_state;
    }

    public void initialize() {
        if (this.m_taskFuture != null) {
            this.m_taskFuture.cancel(false);
            this.m_taskFuture = null;
        }
        this.reload();
        this.m_taskFuture = OpenCms.getExecutor().scheduleWithFixedDelay(this::performUpdate, UPDATE_DELAY_MILLIS, UPDATE_DELAY_MILLIS, TimeUnit.MILLISECONDS);
    }

    public void performUpdate() {
        try {
            ArrayList work = new ArrayList();
            this.m_workQueue.drainTo(work);
            HashSet<CmsUUID> copiedIds = new HashSet<CmsUUID>();
            ArrayList<CmsWaitHandle> waitHandles = new ArrayList<CmsWaitHandle>();
            for (Object o : work) {
                if (o instanceof CmsUUID) {
                    copiedIds.add((CmsUUID)o);
                    continue;
                }
                if (!(o instanceof CmsWaitHandle)) continue;
                waitHandles.add((CmsWaitHandle)o);
            }
            if (copiedIds.contains(RELOAD_MARKER)) {
                this.reload();
            } else {
                HashMap formattersToUpdate = Maps.newHashMap();
                for (CmsUUID structureId : copiedIds) {
                    I_CmsFormatterBean formatterBean = this.readFormatter(structureId);
                    formattersToUpdate.put(structureId, formatterBean);
                }
                this.m_state = this.m_state.createUpdatedCopy(formattersToUpdate);
            }
            for (CmsWaitHandle handle : waitHandles) {
                handle.release();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void reload() {
        CmsResourceFilter filter;
        I_CmsResourceType type;
        ArrayList<CmsResource> settingConfigResources = new ArrayList<CmsResource>();
        try {
            I_CmsResourceType type2 = OpenCms.getResourceManager().getResourceType(TYPE_SETTINGS_CONFIG);
            CmsResourceFilter filter2 = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(type2);
            settingConfigResources.addAll(this.m_cms.readResources("/", filter2));
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        HashMap<CmsUUID, List<CmsXmlContentProperty>> settingConfigs = new HashMap<CmsUUID, List<CmsXmlContentProperty>>();
        for (CmsResource resource : settingConfigResources) {
            this.parseSettingsConfig(resource, settingConfigs);
        }
        this.m_settingConfigs = settingConfigs;
        ArrayList<CmsResource> formatterResources = new ArrayList<CmsResource>();
        try {
            type = OpenCms.getResourceManager().getResourceType(TYPE_FORMATTER_CONFIG);
            filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(type);
            formatterResources.addAll(this.m_cms.readResources("/", filter));
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            type = OpenCms.getResourceManager().getResourceType(TYPE_MACRO_FORMATTER);
            filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(type);
            formatterResources.addAll(this.m_cms.readResources("/", filter));
            I_CmsResourceType typeFlex = OpenCms.getResourceManager().getResourceType(TYPE_FLEX_FORMATTER);
            CmsResourceFilter filterFlex = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(typeFlex);
            formatterResources.addAll(this.m_cms.readResources("/", filterFlex));
            I_CmsResourceType typeFunction = OpenCms.getResourceManager().getResourceType("function_config");
            CmsResourceFilter filterFunction = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(typeFunction);
            formatterResources.addAll(this.m_cms.readResources("/", filterFunction));
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        HashMap newFormatters = Maps.newHashMap();
        for (CmsResource formatterResource : formatterResources) {
            I_CmsFormatterBean formatterBean = this.readFormatter(formatterResource.getStructureId());
            if (formatterBean == null) continue;
            newFormatters.put(formatterResource.getStructureId(), formatterBean);
        }
        this.m_state = new CmsFormatterConfigurationCacheState(newFormatters);
    }

    @Override
    public void remove(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void remove(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void update(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    public void waitForUpdate() {
        CmsWaitHandle handle = new CmsWaitHandle(true);
        this.addWaitHandle(handle);
        handle.enter(Long.MAX_VALUE);
    }

    protected I_CmsFormatterBean readFormatter(CmsUUID structureId) {
        I_CmsFormatterBean formatterBean = null;
        CmsResource formatterRes = null;
        try {
            formatterRes = this.m_cms.readResource(structureId);
            CmsFile formatterFile = this.m_cms.readFile(formatterRes);
            CmsFormatterBeanParser parser = new CmsFormatterBeanParser(this.m_cms, this.m_settingConfigs);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, formatterFile);
            formatterBean = parser.parse(content, formatterRes.getRootPath(), "" + formatterRes.getStructureId());
        }
        catch (Exception e) {
            if (formatterRes == null) {
                LOG.info((Object)("Could not read formatter with id " + structureId));
            }
            LOG.error((Object)("Error while trying to read formatter configuration " + formatterRes.getRootPath() + ":    " + e.getLocalizedMessage()), (Throwable)e);
        }
        return formatterBean;
    }

    private void checkIfUpdateIsNeeded(CmsUUID structureId, String path, int resourceType) {
        if (CmsResource.isTemporaryFileName(path)) {
            return;
        }
        CmsResourceManager manager = OpenCms.getResourceManager();
        if (manager.matchResourceType(TYPE_SETTINGS_CONFIG, resourceType)) {
            this.markForUpdate(RELOAD_MARKER);
            return;
        }
        if (manager.matchResourceType(TYPE_FORMATTER_CONFIG, resourceType) || manager.matchResourceType(TYPE_MACRO_FORMATTER, resourceType) || manager.matchResourceType(TYPE_FLEX_FORMATTER, resourceType) || manager.matchResourceType("function_config", resourceType)) {
            this.markForUpdate(structureId);
        }
    }

    private void markForUpdate(CmsUUID structureId) {
        this.m_workQueue.add(structureId);
    }

    private void parseSettingsConfig(CmsResource resource, Map<CmsUUID, List<CmsXmlContentProperty>> settingConfigs) {
        ArrayList<CmsXmlContentProperty> settingConfig = new ArrayList<CmsXmlContentProperty>();
        try {
            CmsFile settingFile = this.m_cms.readFile(resource);
            CmsXmlContent settingContent = CmsXmlContentFactory.unmarshal(this.m_cms, settingFile);
            CmsXmlContentRootLocation location = new CmsXmlContentRootLocation(settingContent, Locale.ENGLISH);
            for (I_CmsXmlContentValueLocation settingLoc : location.getSubValues("Setting")) {
                CmsXmlContentProperty setting = CmsConfigurationReader.parseProperty(this.m_cms, settingLoc).getPropertyData();
                settingConfig.add(setting);
            }
            settingConfigs.put(resource.getStructureId(), settingConfig);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

