/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import org.opencms.acacia.shared.CmsSerialDateUtil;
import org.opencms.acacia.shared.rpc.I_CmsSerialDateService;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.gwt.CmsGwtService;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsPair;
import org.opencms.widgets.serialdate.CmsSerialDateBeanFactory;
import org.opencms.widgets.serialdate.CmsSerialDateValue;
import org.opencms.widgets.serialdate.I_CmsSerialDateBean;

public class CmsSerialDateService
extends CmsGwtService
implements I_CmsSerialDateService {
    private static final long serialVersionUID = -5078405766510438917L;
    private DateFormat m_dateFormat;

    @Override
    public Collection<CmsPair<Date, Boolean>> getDates(String config) {
        I_CmsSerialDateBean bean = CmsSerialDateBeanFactory.createSerialDateBean(config);
        if (null != bean) {
            SortedSet<Date> dates = bean.getDates();
            SortedSet<Date> exceptions = bean.getExceptions();
            ArrayList<CmsPair<Date, Boolean>> result = new ArrayList<CmsPair<Date, Boolean>>(dates.size() + exceptions.size());
            for (Date d : dates) {
                result.add(new CmsPair<Date, Boolean>(d, Boolean.TRUE));
            }
            for (Date d : exceptions) {
                result.add(new CmsPair<Date, Boolean>(d, Boolean.FALSE));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public CmsPair<Boolean, String> getStatus(String config) {
        CmsSerialDateValue value = new CmsSerialDateValue(config);
        Locale l = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        CmsMessages messages = Messages.get().getBundle(l);
        if (value.isValid()) {
            I_CmsSerialDateBean bean = CmsSerialDateBeanFactory.createSerialDateBean(value);
            if (bean.hasTooManyDates()) {
                return new CmsPair<Boolean, String>(Boolean.FALSE, messages.key("GUI_SERIALDATE_STATUS_TOO_MANY_DATES_2", CmsSerialDateUtil.getMaxEvents(), this.formatDate(bean.getDates().last())));
            }
            SortedSet<Date> dates = bean.getDates();
            String message = dates.isEmpty() ? messages.key("GUI_SERIALDATE_EMPTY_EVENT_SERIES_0") : (dates.size() == 1 ? messages.key("GUI_SERIALDATE_SINGLE_EVENT_1", this.formatDate(dates.first())) : messages.key("GUI_SERIALDATE_MULTIPLE_EVENTS_3", dates.size(), this.formatDate(dates.first()), this.formatDate(dates.last())));
            return new CmsPair<Boolean, String>(Boolean.TRUE, message);
        }
        return new CmsPair<Boolean, String>(Boolean.FALSE, messages.key("GUI_SERIALDATE_INVALID_SERIES_SPECIFICATION_0"));
    }

    private String formatDate(Date date) {
        if (null == this.m_dateFormat) {
            this.m_dateFormat = DateFormat.getDateInstance(0, OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()));
        }
        return this.m_dateFormat.format(date);
    }
}

