/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.galleries.A_CmsTreeTabDataPreloader;
import org.opencms.ade.galleries.CmsGalleryFilteredNavTreeBuilder;
import org.opencms.ade.galleries.CmsSiteSelectorOptionBuilder;
import org.opencms.ade.galleries.CmsTreeOpenState;
import org.opencms.ade.galleries.Messages;
import org.opencms.ade.galleries.preview.I_CmsPreviewProvider;
import org.opencms.ade.galleries.shared.CmsGalleryConfiguration;
import org.opencms.ade.galleries.shared.CmsGalleryDataBean;
import org.opencms.ade.galleries.shared.CmsGalleryFolderBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchBean;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.ade.galleries.shared.CmsGalleryTabConfiguration;
import org.opencms.ade.galleries.shared.CmsResourceTypeBean;
import org.opencms.ade.galleries.shared.CmsResultItemBean;
import org.opencms.ade.galleries.shared.CmsSitemapEntryBean;
import org.opencms.ade.galleries.shared.CmsVfsEntryBean;
import org.opencms.ade.galleries.shared.I_CmsGalleryProviderConstants;
import org.opencms.ade.galleries.shared.rpc.I_CmsGalleryService;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsCoreService;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsResourceManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsStaticResourceHandler;
import org.opencms.main.OpenCms;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.ui.components.CmsResourceIcon;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsUriSplitter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsADESessionCache;

public class CmsGalleryService
extends CmsGwtService
implements I_CmsGalleryService {
    public static final String FOLDER_FILTER_ADD_INFO_KEY = "gallery_folder_filter";
    public static final int INITIAL_SEARCH_MAX_RESULTS = 200;
    public static final String KEY_LAST_USED_GALLERY_ADEVIEW = "__adeView";
    public static final String PREF_GALLERY_SHOW_INVALID_DEFAULT = "galleryShowInvalidDefault";
    public static final String RESULT_VIEW_TYPE_ADD_INFO_KEY = "gallery_result_view_type";
    private static final Log LOG = CmsLog.getLog(CmsGalleryService.class);
    private static final long serialVersionUID = 1673026761080584889L;
    private static final Comparator<CmsVfsEntryBean> VFS_COMPARATOR = new Comparator<CmsVfsEntryBean>(){

        @Override
        public int compare(CmsVfsEntryBean o1, CmsVfsEntryBean o2) {
            String o1Path = o1.getRootPath();
            String o2Path = o2.getRootPath();
            if (o1Path.endsWith("/")) {
                o1Path = o1Path.substring(0, o1Path.length() - 1);
            }
            if (o2Path.endsWith("/")) {
                o2Path = o2Path.substring(0, o2Path.length() - 1);
            }
            return o1Path.compareTo(o2Path);
        }
    };
    private static final Set<String> FUNCTION_TYPES = new HashSet<String>(Arrays.asList("function", "function_config"));
    CmsResourceManager m_resourceManager;
    private CmsWorkplaceSettings m_workplaceSettings;
    private Locale m_wpLocale;

    public static CmsVfsEntryBean generateVfsPreloadData(CmsObject cms, CmsTreeOpenState vfsState, Set<String> folders) {
        CmsVfsEntryBean vfsPreloadData = null;
        A_CmsTreeTabDataPreloader<CmsVfsEntryBean> vfsloader = new A_CmsTreeTabDataPreloader<CmsVfsEntryBean>(){

            @Override
            protected CmsVfsEntryBean createEntry(CmsObject innerCms, CmsResource resource) throws CmsException {
                String title = innerCms.readPropertyObject(resource, "Title", false).getValue();
                boolean isEditable = false;
                try {
                    isEditable = innerCms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                return CmsGalleryService.internalCreateVfsEntryBean(innerCms, resource, title, true, isEditable, null, false);
            }
        };
        HashSet treeOpenResources = Sets.newHashSet();
        if (vfsState != null) {
            for (CmsUUID structureId : vfsState.getOpenItems()) {
                try {
                    treeOpenResources.add(cms.readResource(structureId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        CmsObject rootCms = null;
        HashSet folderSetResources = Sets.newHashSet();
        try {
            rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            if (folders != null && !folders.isEmpty()) {
                for (String folder : folders) {
                    try {
                        folderSetResources.add(rootCms.readResource(folder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED));
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (CmsException e1) {
            LOG.error((Object)e1.getLocalizedMessage(), (Throwable)e1);
        }
        try {
            vfsPreloadData = (CmsVfsEntryBean)vfsloader.preloadData(cms, treeOpenResources, folderSetResources);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return vfsPreloadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsGalleryDataBean getInitialSettings(HttpServletRequest request, CmsGalleryConfiguration config) throws CmsRpcException {
        CmsGalleryService srv = new CmsGalleryService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsGalleryDataBean result = null;
        try {
            result = srv.getInitialSettings(config);
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsGallerySearchBean getSearch(HttpServletRequest request, CmsGalleryDataBean config) {
        CmsGalleryService srv = new CmsGalleryService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsGallerySearchBean result = null;
        try {
            result = srv.getSearch(config);
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    public static String getTreeOpenStateAttributeName(String treeName, String treeToken) {
        return "tree_" + treeName + "_" + treeToken;
    }

    public static CmsTreeOpenState getVfsTreeState(HttpServletRequest request, String treeToken) {
        return (CmsTreeOpenState)request.getSession().getAttribute(CmsGalleryService.getTreeOpenStateAttributeName("vfs", treeToken));
    }

    public static CmsVfsEntryBean internalCreateVfsEntryBean(CmsObject cms, CmsResource resource, String title, boolean isRoot, boolean isEditable, List<CmsVfsEntryBean> children, boolean isMatch) throws CmsException {
        String tempSiteRoot;
        String rootPath = resource.getRootPath();
        CmsUUID structureId = resource.getStructureId();
        CmsVfsEntryBean result = new CmsVfsEntryBean(rootPath, structureId, title, CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(cms, resource), resource.getName(), true), isRoot, isEditable, children, isMatch);
        String siteRoot = null;
        if (resource.isFolder()) {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setSiteRoot("");
            List<CmsResource> realChildren = cms.getResourcesInFolder(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            ArrayList<CmsResource> effectiveChildren = new ArrayList<CmsResource>();
            for (CmsResource realChild : realChildren) {
                if (!realChild.isFolder()) continue;
                effectiveChildren.add(realChild);
            }
            if (effectiveChildren.isEmpty()) {
                result.setChildren(new ArrayList<CmsVfsEntryBean>());
            }
        }
        siteRoot = OpenCms.getSiteManager().startsWithShared(rootPath) ? OpenCms.getSiteManager().getSharedFolder() : ((tempSiteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath)) != null ? tempSiteRoot : "");
        result.setSiteRoot(siteRoot);
        return result;
    }

    public List<CmsResourceTypeBean> buildTypesList(List<I_CmsResourceType> resourceTypes, Set<String> creatableTypes, Set<String> deactivatedTypes, final List<String> typesForTypeTab) {
        List<CmsResourceTypeBean> result = this.buildTypesList(resourceTypes, creatableTypes);
        for (CmsResourceTypeBean typeBean : result) {
            if (typesForTypeTab != null && typesForTypeTab.size() > 0 && !typesForTypeTab.contains(typeBean.getType()) && typeBean.getVisibility() != CmsResourceTypeBean.TypeVisibility.hidden) {
                typeBean.setVisibility(CmsResourceTypeBean.TypeVisibility.showOptional);
            }
            typeBean.setDeactivated(deactivatedTypes.contains(typeBean.getType()));
        }
        if (typesForTypeTab != null && typesForTypeTab.size() > 0) {
            Collections.sort(result, new Comparator<CmsResourceTypeBean>(){

                @Override
                public int compare(CmsResourceTypeBean first, CmsResourceTypeBean second) {
                    return ComparisonChain.start().compare(this.searchTypeRank(first), this.searchTypeRank(second)).compare((Object)first.getTitle(), (Object)second.getTitle(), (Comparator)Collator.getInstance(CmsGalleryService.this.getWorkplaceLocale())).compare((Comparable)((Object)first.getType()), (Comparable)((Object)second.getType())).result();
                }

                int searchTypeRank(CmsResourceTypeBean type) {
                    int index = typesForTypeTab.indexOf(type.getType());
                    if (index == -1) {
                        return Integer.MAX_VALUE;
                    }
                    return index;
                }
            });
        }
        return result;
    }

    @Override
    public void deleteResource(String resourcePath) throws CmsRpcException {
        try {
            this.ensureLock(resourcePath);
            this.getCmsObject().deleteResource(resourcePath, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public CmsGalleryConfiguration getAdeViewModeConfiguration() {
        CmsGalleryConfiguration result = new CmsGalleryConfiguration();
        ArrayList<String> typeNames = new ArrayList<String>();
        for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
            Class<?> typeClass = type.getClass();
            if (CmsResourceTypeXmlContent.class.isAssignableFrom(typeClass) || CmsResourceTypeXmlPage.class.isAssignableFrom(typeClass) || type.getGalleryTypes().size() <= 0) continue;
            typeNames.add(type.getTypeName());
        }
        result.setSearchTypes(typeNames);
        result.setResourceTypes(typeNames);
        result.setGalleryMode(I_CmsGalleryProviderConstants.GalleryMode.adeView);
        result.setGalleryStoragePrefix("" + (Object)((Object)I_CmsGalleryProviderConstants.GalleryMode.adeView));
        result.setTabConfiguration(CmsGalleryTabConfiguration.resolve("selectDoc"));
        return result;
    }

    @Override
    public List<CmsGalleryFolderBean> getGalleries(List<String> resourceTypes) {
        return this.buildGalleriesList(this.readGalleryInfosByTypeNames(resourceTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsResultItemBean getInfoForResource(String linkPath, String locale) throws CmsRpcException {
        CmsResultItemBean result;
        block32: {
            result = null;
            CmsObject cms = this.getCmsObject();
            CmsMessages messageBundle = Messages.get().getBundle(this.getWorkplaceLocale());
            try {
                boolean isInTimeRange;
                boolean notFound;
                block34: {
                    if (new CmsUriSplitter(linkPath).getProtocol() != null) {
                        result = new CmsResultItemBean();
                        result.setTitle(messageBundle.key("GUI_EXTERNAL_LINK_0"));
                        result.setSubTitle("");
                        result.setType(CmsResourceTypePointer.getStaticTypeName());
                        result.setBigIconClasses(CmsIconUtil.getIconClasses(CmsResourceTypePointer.getStaticTypeName(), null, false));
                        break block32;
                    }
                    if (CmsStaticResourceHandler.isStaticResourceUri(linkPath)) {
                        result = new CmsResultItemBean();
                        result.setTitle(messageBundle.key("GUI_STATIC_RESOURCE_0"));
                        result.setSubTitle(CmsStaticResourceHandler.removeStaticResourcePrefix(linkPath));
                        result.setType(CmsResourceTypeBinary.getStaticTypeName());
                        result.setBigIconClasses(CmsIconUtil.getIconClasses(CmsResourceTypeBinary.getStaticTypeName(), null, false));
                        break block32;
                    }
                    notFound = false;
                    String path = linkPath;
                    String siteRoot = OpenCms.getSiteManager().getSiteRoot(linkPath);
                    String oldSite = cms.getRequestContext().getSiteRoot();
                    try {
                        if (siteRoot != null) {
                            cms.getRequestContext().setSiteRoot(siteRoot);
                            path = cms.getRequestContext().removeSiteRoot(linkPath);
                        }
                        int pos = path.indexOf("?");
                        int anchorPos = path.indexOf(35);
                        if (pos == -1 || anchorPos > -1 && pos > anchorPos) {
                            pos = anchorPos;
                        }
                        if (pos > -1) {
                            path = path.substring(0, pos);
                        }
                        path = OpenCms.getLinkManager().getRootPath(cms, path);
                    }
                    catch (Exception e) {
                        notFound = true;
                    }
                    finally {
                        if (siteRoot != null) {
                            cms.getRequestContext().setSiteRoot(oldSite);
                        }
                    }
                    notFound = notFound || path == null;
                    isInTimeRange = true;
                    if (!notFound) {
                        CmsObject rootCms = OpenCms.initCmsObject(cms);
                        rootCms.getRequestContext().setSiteRoot("");
                        try {
                            CmsResource selectedResource = rootCms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
                            long currentTime = System.currentTimeMillis();
                            isInTimeRange = selectedResource.isReleasedAndNotExpired(currentTime);
                            if (selectedResource.isFolder()) {
                                String title;
                                result = new CmsResultItemBean();
                                CmsJspNavElement folderNav = new CmsJspNavBuilder(rootCms).getNavigationForResource(selectedResource.getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
                                CmsResource defaultFileResource = null;
                                if (folderNav.isInNavigation() && !folderNav.isNavigationLevel()) {
                                    try {
                                        defaultFileResource = rootCms.readDefaultFile(selectedResource, CmsResourceFilter.ONLY_VISIBLE);
                                    }
                                    catch (Exception e) {
                                        this.log(e.getMessage(), e);
                                    }
                                }
                                result.setBigIconClasses(CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(rootCms, selectedResource), path, false));
                                CmsResource resourceForType = defaultFileResource != null ? defaultFileResource : selectedResource;
                                result.setType(OpenCms.getResourceManager().getResourceType(resourceForType).getTypeName());
                                if (defaultFileResource != null) {
                                    result.setSmallIconClasses(CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(rootCms, defaultFileResource), defaultFileResource.getName(), true));
                                }
                                if (CmsStringUtil.isEmptyOrWhitespaceOnly(title = folderNav.getProperty("NavText"))) {
                                    title = folderNav.getTitle();
                                } else if (CmsStringUtil.isEmptyOrWhitespaceOnly(title) && (title = CmsResource.getName(path)).contains("/")) {
                                    title = title.substring(0, title.indexOf("/"));
                                }
                                result.setTitle(title);
                                try {
                                    String userName = cms.readUser(selectedResource.getUserLastModified()).getFullName();
                                    result.setUserLastModified(userName);
                                }
                                catch (CmsException e) {
                                    this.log(e.getMessage(), e);
                                }
                                Date date = new Date(selectedResource.getDateLastModified());
                                String formattedDate = CmsDateUtil.getDateTime(date, 2, this.getWorkplaceLocale());
                                result.setDateLastModified(formattedDate);
                                break block34;
                            }
                            CmsGallerySearchResult resultItem = null;
                            try {
                                resultItem = CmsGallerySearch.searchByPath(cms, path, CmsLocaleManager.getLocale(locale));
                            }
                            catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                                // empty catch block
                            }
                            boolean bl = notFound = resultItem == null;
                            if (!notFound) {
                                result = this.buildSingleSearchResultItem(this.getCmsObject(), resultItem, null);
                            }
                        }
                        catch (CmsException ex) {
                            notFound = true;
                        }
                    }
                }
                if (notFound) {
                    result = new CmsResultItemBean();
                    result.setTitle(messageBundle.key("GUI_RESOURCE_NOT_FOUND_0"));
                    result.setSubTitle("");
                    result.setType("cms_resource_not_found");
                    result.setBigIconClasses(CmsIconUtil.getIconClasses("cms_resource_not_found", null, false));
                } else if (!isInTimeRange && result != null) {
                    result.setType("cms_resource_not_found");
                    result.setTitle(messageBundle.key("GUI_RESOURCE_OUT_OF_TIME_RANGE_1", result.getTitle()));
                    result.setBigIconClasses(CmsIconUtil.getIconClasses("cms_resource_not_found", null, false));
                }
            }
            catch (Throwable t) {
                this.error(t);
            }
        }
        return result;
    }

    @Override
    public CmsGalleryDataBean getInitialSettings(CmsGalleryConfiguration conf) throws CmsRpcException {
        try {
            return this.getInitialSettingsInternal(conf);
        }
        catch (Throwable t) {
            this.error(t);
            return null;
        }
    }

    public CmsGalleryDataBean getInitialSettingsForContainerPage(List<CmsResourceTypeBean> types, String uri, String locale) {
        CmsGalleryDataBean data = null;
        try {
            data = new CmsGalleryDataBean();
            boolean galleryShowInvalidDefault = Boolean.parseBoolean(this.getWorkplaceSettings().getUserSettings().getAdditionalPreference(PREF_GALLERY_SHOW_INVALID_DEFAULT, true));
            data.setIncludeExpiredDefault(galleryShowInvalidDefault);
            data.setResultViewType(this.readResultViewType());
            data.setMode(I_CmsGalleryProviderConstants.GalleryMode.ade);
            data.setGalleryStoragePrefix("");
            data.setLocales(this.buildLocalesMap());
            data.setLocale(locale);
            data.setVfsRootFolders(this.getRootEntries());
            data.setScope(this.getWorkplaceSettings().getLastSearchScope());
            data.setSortOrder(this.getWorkplaceSettings().getLastGalleryResultOrder());
            data.setTabIds(I_CmsGalleryProviderConstants.GalleryMode.ade.getTabs());
            data.setReferenceSitePath(uri);
            data.setTypes(types);
            Map<String, CmsGalleryTypeInfo> adeGalleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
            data.setGalleries(this.buildGalleriesList(adeGalleryTypeInfos));
            data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_types);
            Set<String> folderFilter = this.readFolderFilters();
            data.setStartFolderFilter(folderFilter);
            if (folderFilter != null && !folderFilter.isEmpty()) {
                try {
                    data.setVfsPreloadData(CmsGalleryService.generateVfsPreloadData(this.getCmsObject(), null, folderFilter));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            CmsSiteSelectorOptionBuilder optionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
            optionBuilder.addNormalSites(true, this.getWorkplaceSettings().getUserSettings().getStartFolder());
            optionBuilder.addSharedSite();
            data.setVfsSiteSelectorOptions(optionBuilder.getOptions());
            CmsSiteSelectorOptionBuilder sitemapOptionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
            sitemapOptionBuilder.addNormalSites(false, null);
            if (data.getReferenceSitePath() != null) {
                sitemapOptionBuilder.addCurrentSubsite(this.getCmsObject().addSiteRoot(data.getReferenceSitePath()));
            }
            data.setSitemapSiteSelectorOptions(sitemapOptionBuilder.getOptions());
            data.setDefaultScope(OpenCms.getWorkplaceManager().getGalleryDefaultScope());
            CmsCoreService service = new CmsCoreService();
            service.setCms(this.getCmsObject());
            data.setCategories(service.getCategoriesForSitePath(data.getReferenceSitePath()));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return data;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGalleryDataBean data) {
        CmsGallerySearchBean result = null;
        List<String> types = this.getTypeNames(data);
        switch (data.getMode()) {
            case editor: 
            case view: 
            case adeView: 
            case widget: {
                String currentelement = data.getCurrentElement();
                try {
                    CmsSitemapEntryBean sitemapPreloadData = null;
                    CmsVfsEntryBean vfsPreloadData = null;
                    boolean disablePreview = false;
                    I_CmsGalleryProviderConstants.GalleryTabId startTab = null;
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(currentelement)) {
                        this.log("looking up:" + currentelement);
                        currentelement = CmsLinkManager.removeOpenCmsContext(currentelement);
                        result = this.findResourceInGallery(currentelement, data);
                        if (result != null) {
                            sitemapPreloadData = result.getSitemapPreloadData();
                            vfsPreloadData = result.getVfsPreloadData();
                        }
                        if (sitemapPreloadData != null && data.getTabConfiguration().getTabs().contains((Object)I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_sitemap)) {
                            startTab = I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_sitemap;
                            disablePreview = true;
                        }
                    } else {
                        CmsTreeOpenState sitemapState = this.getSitemapTreeState(data.getTreeToken());
                        if (sitemapState != null) {
                            A_CmsTreeTabDataPreloader<CmsSitemapEntryBean> sitemaploader = new A_CmsTreeTabDataPreloader<CmsSitemapEntryBean>(){

                                @Override
                                protected CmsSitemapEntryBean createEntry(CmsObject cms, CmsResource resource) throws CmsException {
                                    return CmsGalleryService.this.internalCreateSitemapEntryBean(cms, resource);
                                }

                                @Override
                                protected List<CmsResource> getChildren(CmsResource resource) throws CmsException {
                                    return CmsGalleryService.this.getSitemapSubEntryResources(resource.getRootPath());
                                }
                            };
                            sitemapPreloadData = (CmsSitemapEntryBean)sitemaploader.preloadData(this.getCmsObject(), Sets.newHashSet(this.readAll(sitemapState.getOpenItems(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)), null);
                        }
                    }
                    if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                        result = new CmsGallerySearchBean();
                        result.setOriginalGalleryData(data);
                        result.setGalleryMode(data.getMode());
                        result.setGalleryStoragePrefix(data.getGalleryStoragePrefix());
                        result.setIgnoreSearchExclude(true);
                        String gallery = data.getStartGallery();
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(gallery)) {
                            ArrayList<String> galleries = new ArrayList<String>();
                            galleries.add(gallery);
                            result.setGalleries(galleries);
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(data.getStartFolder())) {
                            HashSet<String> folders = new HashSet<String>();
                            folders.add(data.getStartFolder());
                            result.setFolders(folders);
                        } else if (data.getStartFolderFilter() != null) {
                            result.setFolders(data.getStartFolderFilter());
                        }
                        result.setTypes(types);
                        result.setLocale(data.getLocale());
                        CmsGallerySearchScope scope = data.getScope();
                        if (scope == null) {
                            scope = OpenCms.getWorkplaceManager().getGalleryDefaultScope();
                        }
                        result.setSortOrder(data.getSortOrder().name());
                        result.setScope(scope);
                        result.setIncludeExpired(data.getIncludeExpiredDefault());
                        result = this.search(result);
                    }
                    result.setSitemapPreloadData(sitemapPreloadData);
                    result.setVfsPreloadData(vfsPreloadData);
                    result.setInitialTabId(startTab);
                    result.setDisablePreview(disablePreview);
                    if (types.size() <= 1) break;
                    result.setTypes(null);
                }
                catch (CmsException e) {
                    this.logError(e);
                    result = null;
                }
                break;
            }
        }
        return result;
    }

    @Override
    public CmsGallerySearchBean getSearch(CmsGallerySearchBean searchObj) throws CmsRpcException {
        CmsGallerySearchBean gSearchObj = null;
        try {
            gSearchObj = this.search(searchObj);
            this.getWorkplaceSettings().setLastSearchScope(searchObj.getScope());
            this.getWorkplaceSettings().setLastGalleryResultOrder(I_CmsGalleryProviderConstants.SortParams.valueOf(searchObj.getSortOrder()));
            this.setLastOpenedGallery(searchObj);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return gSearchObj;
    }

    @Override
    public List<CmsSitemapEntryBean> getSubEntries(String rootPath, boolean isRoot, String filter) throws CmsRpcException {
        try {
            return this.getSubEntriesInternal(rootPath, isRoot, filter);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getSubFolders(String rootPath) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
            if (cms.existsResource(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                CmsResource resource = cms.readResource(rootPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                List<CmsResource> resources = cms.getSubFolders(resource.getRootPath(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                for (CmsResource res : resources) {
                    String title = cms.readPropertyObject(res, "Title", false).getValue();
                    result.add(CmsGalleryService.internalCreateVfsEntryBean(this.getCmsObject(), res, title, false, this.isEditable(cms, res), null, false));
                }
            }
            Collections.sort(result, VFS_COMPARATOR);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsVfsEntryBean loadVfsEntryBean(String path, String filter) throws CmsRpcException {
        try {
            String startFolder;
            if (CmsStringUtil.isEmpty(filter)) {
                CmsResource optionRes;
                String title;
                String startFolder2;
                CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                if (!cms.existsResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) && cms.existsResource(startFolder2 = CmsStringUtil.joinPaths(path, this.getWorkplaceSettings().getUserSettings().getStartFolder()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                    path = startFolder2;
                }
                if (CmsStringUtil.isEmpty(title = cms.readPropertyObject(optionRes = cms.readResource(path), "Title", false).getValue())) {
                    title = path;
                }
                CmsVfsEntryBean entryBean = CmsGalleryService.internalCreateVfsEntryBean(this.getCmsObject(), optionRes, title, true, this.isEditable(cms, optionRes), null, false);
                return entryBean;
            }
            filter = filter.toLowerCase();
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            if (!cms.existsResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) && cms.existsResource(startFolder = CmsStringUtil.joinPaths(path, this.getWorkplaceSettings().getUserSettings().getStartFolder()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                path = startFolder;
            }
            CmsResource optionRes = cms.readResource(path);
            List<CmsResource> folders = cms.readResources(optionRes.getRootPath(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireFolder());
            folders.add(optionRes);
            HashSet folderSet = Sets.newHashSet(folders);
            List<CmsResource> titleResources = cms.readResourcesWithProperty(path, "Title");
            titleResources.retainAll(folderSet);
            HashSet filterMatches = Sets.newHashSet();
            for (CmsResource cmsResource : folderSet) {
                if (!cmsResource.getName().toLowerCase().contains(filter)) continue;
                filterMatches.add(cmsResource);
                titleResources.remove(cmsResource);
            }
            for (CmsResource cmsResource : titleResources) {
                CmsProperty prop = cms.readPropertyObject(cmsResource, "Title", false);
                String title = prop.getValue();
                if (title == null || !title.toLowerCase().contains(filter)) continue;
                filterMatches.add(cmsResource);
            }
            HashSet filterMatchAncestorPaths = Sets.newHashSet();
            if (filterMatches.size() > 0) {
                for (CmsResource filterMatch : filterMatches) {
                    Object currentPath = filterMatch.getRootPath();
                    while (currentPath != null) {
                        filterMatchAncestorPaths.add(currentPath);
                        currentPath = CmsResource.getParentFolder((String)currentPath);
                    }
                }
                HashSet hashSet = Sets.newHashSet();
                HashSet parentPaths = Sets.newHashSet();
                for (Object folder : folderSet) {
                    hashSet.add(((CmsResource)folder).getRootPath());
                    String parent = CmsResource.getParentFolder(((CmsResource)folder).getRootPath());
                    if (parent == null) continue;
                    parentPaths.add(parent);
                }
                parentPaths.retainAll(hashSet);
                HashSet filterMatchAncestors = Sets.newHashSet();
                for (Object folderRes : folderSet) {
                    if (!filterMatchAncestorPaths.contains(((CmsResource)folderRes).getRootPath())) continue;
                    filterMatchAncestors.add(folderRes);
                }
                HashMap resourcesByPath = Maps.newHashMap();
                for (CmsResource treeRes : filterMatchAncestors) {
                    resourcesByPath.put(treeRes.getRootPath(), treeRes);
                }
                ArrayListMultimap childMap = ArrayListMultimap.create();
                for (CmsResource res : filterMatchAncestors) {
                    CmsResource parent = (CmsResource)resourcesByPath.get(CmsResource.getParentFolder(res.getRootPath()));
                    if (parent == null) continue;
                    childMap.put((Object)parent, (Object)res);
                }
                return this.buildVfsEntryBeanForQuickSearch(optionRes, (Multimap<CmsResource, CmsResource>)childMap, filterMatches, parentPaths, true);
            }
            return null;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void saveResultViewType(String resultViewType) {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        user.setAdditionalInfo(RESULT_VIEW_TYPE_ADD_INFO_KEY, resultViewType);
        try {
            this.getCmsObject().writeUser(user);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void saveTreeOpenState(String treeName, String treeToken, String siteRoot, Set<CmsUUID> openItems) throws CmsRpcException {
        try {
            HttpServletRequest request = this.getRequest();
            HttpSession session = request.getSession();
            String attributeName = CmsGalleryService.getTreeOpenStateAttributeName(treeName, treeToken);
            if (openItems.isEmpty()) {
                CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
                cms.getRequestContext().setSiteRoot("");
                CmsResource resource = cms.readResource(siteRoot);
                openItems = Sets.newHashSet((Object[])new CmsUUID[]{resource.getStructureId()});
            }
            CmsTreeOpenState treeState = new CmsTreeOpenState(treeName, siteRoot, openItems);
            session.setAttribute(attributeName, (Object)treeState);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void updateIndex() throws CmsRpcException {
        try {
            OpenCms.getSearchManager().updateOfflineIndexes();
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    protected CmsObject getSearchCms(CmsGallerySearchBean searchObj) throws CmsException {
        CmsObject searchCms = this.getCmsObject();
        if (searchObj.isIncludeExpired()) {
            searchCms = OpenCms.initCmsObject(this.getCmsObject());
            searchCms.getRequestContext().setRequestTime(Long.MIN_VALUE);
        }
        return searchCms;
    }

    protected List<CmsResource> getSitemapSubEntryResources(String rootPath) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(this.getCmsObject());
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        rootCms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(rootCms);
        for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
            if (navElement == null || !navElement.isInNavigation()) continue;
            result.add(navElement.getResource());
        }
        return result;
    }

    protected List<CmsSitemapEntryBean> getSubEntriesInternal(String rootPath, boolean isRoot, String filter) throws CmsException {
        CmsObject rootCms = OpenCms.initCmsObject(this.getCmsObject());
        rootCms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(rootCms);
        if (isRoot) {
            if (CmsStringUtil.isEmpty(filter)) {
                ArrayList<CmsSitemapEntryBean> result = new ArrayList<CmsSitemapEntryBean>();
                for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
                    if (navElement == null || !navElement.isInNavigation()) continue;
                    CmsSitemapEntryBean nextEntry = this.prepareSitemapEntry(rootCms, navElement, false, true);
                    result.add(nextEntry);
                }
                CmsJspNavElement navElement = navBuilder.getNavigationForResource(rootPath, CmsResourceFilter.ONLY_VISIBLE);
                if (navElement == null) {
                    return result;
                }
                CmsSitemapEntryBean root = this.prepareSitemapEntry(rootCms, navElement, isRoot, true);
                root.setChildren(result);
                return Collections.singletonList(root);
            }
            CmsGalleryFilteredNavTreeBuilder navTreeBuilder = new CmsGalleryFilteredNavTreeBuilder(rootCms, rootPath);
            navTreeBuilder.initTree(filter);
            if (navTreeBuilder.hasMatches()) {
                return Lists.newArrayList((Object[])new CmsSitemapEntryBean[]{this.convertNavigationTreeToBean(rootCms, navTreeBuilder.getRoot(), true)});
            }
            return Lists.newArrayList();
        }
        ArrayList<CmsSitemapEntryBean> result = new ArrayList<CmsSitemapEntryBean>();
        for (CmsJspNavElement navElement : navBuilder.getNavigationForFolder(rootPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE)) {
            if (navElement == null || !navElement.isInNavigation()) continue;
            CmsSitemapEntryBean nextEntry = this.prepareSitemapEntry(rootCms, navElement, false, true);
            result.add(nextEntry);
        }
        return result;
    }

    protected List<String> getTypeNames(CmsGalleryDataBean data) {
        ArrayList<String> types = new ArrayList<String>();
        for (CmsResourceTypeBean info : data.getTypes()) {
            types.add(info.getType());
        }
        return types;
    }

    protected boolean isSitemapEntry(CmsObject cms, CmsResource resource) throws CmsException {
        CmsResource parent;
        CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED;
        ArrayList<CmsResource> ancestors = new ArrayList<CmsResource>();
        CmsResource currentResource = resource;
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource.getRootPath());
        if (CmsStringUtil.isEmpty(siteRoot)) {
            return false;
        }
        while ((parent = cms.readParentFolder(currentResource.getStructureId())) != null && cms.existsResource(parent.getStructureId(), filter)) {
            ancestors.add(parent);
            if (CmsStringUtil.comparePaths(siteRoot, parent.getRootPath())) break;
            currentResource = parent;
        }
        Collections.reverse(ancestors);
        boolean first = true;
        for (CmsResource ancestor : ancestors) {
            if (first ? null == OpenCms.getSiteManager().getSiteRoot(ancestor.getRootPath()) : !this.hasNavigationProperty(cms, ancestor)) {
                return false;
            }
            first = false;
        }
        if (resource.isFile()) {
            if (ancestors.isEmpty()) {
                return false;
            }
            CmsResource defaultFile = cms.readDefaultFile((CmsResource)ancestors.get(ancestors.size() - 1), filter);
            if (!resource.equals(defaultFile)) {
                return false;
            }
        } else if (!this.hasNavigationProperty(cms, resource)) {
            return false;
        }
        return true;
    }

    protected List<CmsResource> readAll(Collection<CmsUUID> structureIds, CmsResourceFilter filter) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsUUID id : structureIds) {
            try {
                result.add(this.getCmsObject().readResource(id, filter));
            }
            catch (CmsException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    CmsTreeOpenState getSitemapTreeState(String treeToken) {
        return (CmsTreeOpenState)this.getRequest().getSession().getAttribute(CmsGalleryService.getTreeOpenStateAttributeName("sitemap", treeToken));
    }

    CmsTreeOpenState getVfsTreeState(String treeToken) {
        return (CmsTreeOpenState)this.getRequest().getSession().getAttribute(CmsGalleryService.getTreeOpenStateAttributeName("vfs", treeToken));
    }

    Locale getWorkplaceLocale() {
        if (this.m_wpLocale == null) {
            this.m_wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        }
        return this.m_wpLocale;
    }

    CmsSitemapEntryBean internalCreateSitemapEntryBean(CmsObject cms, CmsResource resource) throws CmsException {
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setSiteRoot("");
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
        CmsJspNavElement entry = navBuilder.getNavigationForResource(resource.getRootPath());
        if (entry == null) {
            return null;
        }
        return this.prepareSitemapEntry(cms, entry, false, true);
    }

    boolean isEditable(CmsObject cms, CmsResource resource) {
        try {
            return cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            return false;
        }
    }

    private void addGalleriesForType(Map<String, CmsGalleryTypeInfo> galleryTypeInfos, String typeName) throws CmsLoaderException {
        I_CmsResourceType contentType = this.getResourceManager().getResourceType(typeName);
        for (I_CmsResourceType galleryType : contentType.getGalleryTypes()) {
            CmsGalleryTypeInfo typeInfo;
            if (galleryTypeInfos.containsKey(galleryType.getTypeName())) {
                typeInfo = galleryTypeInfos.get(galleryType.getTypeName());
                typeInfo.addContentType(contentType);
                continue;
            }
            typeInfo = new CmsGalleryTypeInfo(galleryType, contentType, this.getGalleriesByType(galleryType.getTypeId()));
            galleryTypeInfos.put(galleryType.getTypeName(), typeInfo);
        }
    }

    private List<CmsGalleryFolderBean> buildGalleriesList(Map<String, CmsGalleryTypeInfo> galleryTypes) {
        ArrayList<CmsGalleryFolderBean> list = new ArrayList<CmsGalleryFolderBean>();
        if (galleryTypes == null) {
            return list;
        }
        for (Map.Entry<String, CmsGalleryTypeInfo> ent : galleryTypes.entrySet()) {
            CmsGalleryTypeInfo tInfo = ent.getValue();
            ArrayList<String> contentTypes = new ArrayList<String>();
            Iterator<I_CmsResourceType> it = tInfo.getContentTypes().iterator();
            while (it.hasNext()) {
                contentTypes.add(String.valueOf(it.next().getTypeName()));
            }
            for (CmsResource res : tInfo.getGalleries()) {
                CmsGalleryFolderBean bean = new CmsGalleryFolderBean();
                String sitePath = this.getCmsObject().getSitePath(res);
                String title = "";
                try {
                    title = this.getCmsObject().readPropertyObject(sitePath, "Title", false).getValue("");
                }
                catch (CmsException e) {
                    this.logError(e);
                }
                bean.setPath(sitePath);
                bean.setContentTypes(contentTypes);
                bean.setTitle(title);
                bean.setResourceType(tInfo.getResourceType().getTypeName());
                bean.setEditable(this.isEditable(this.getCmsObject(), res));
                bean.setBigIconClasses(CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(this.getCmsObject(), res), sitePath, false));
                list.add(bean);
            }
        }
        return list;
    }

    private Map<String, String> buildLocalesMap() {
        TreeMap<String, String> localesMap = new TreeMap<String, String>();
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            localesMap.put(locale.toString(), locale.getDisplayName(this.getWorkplaceLocale()));
        }
        return localesMap;
    }

    private List<CmsResultItemBean> buildSearchResultList(List<CmsGallerySearchResult> searchResult, CmsGallerySearchResult presetResult) {
        ArrayList<CmsResultItemBean> list = new ArrayList<CmsResultItemBean>();
        if (searchResult == null || searchResult.size() == 0) {
            return list;
        }
        CmsObject cms = this.getCmsObject();
        for (CmsGallerySearchResult sResult : searchResult) {
            try {
                CmsResultItemBean bean = this.buildSingleSearchResultItem(cms, sResult, presetResult);
                list.add(bean);
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
        return list;
    }

    private CmsResultItemBean buildSingleSearchResultItem(CmsObject cms, CmsGallerySearchResult sResult, CmsGallerySearchResult presetResult) throws CmsException, ParseException {
        CmsProperty elementModelProperty;
        Locale wpLocale = this.getWorkplaceLocale();
        CmsResultItemBean bean = new CmsResultItemBean();
        if (sResult == presetResult) {
            bean.setPreset(true);
        }
        bean.setReleasedAndNotExpired(sResult.isReleaseAndNotExpired(cms));
        String path = sResult.getPath();
        path = cms.getRequestContext().removeSiteRoot(path);
        bean.setPath(path);
        String rawTitle = CmsStringUtil.isEmptyOrWhitespaceOnly(sResult.getTitle()) ? CmsResource.getName(sResult.getPath()) : sResult.getTitle();
        bean.setTitle(rawTitle);
        bean.setRawTitle(rawTitle);
        bean.setType(sResult.getResourceType());
        CmsResource resultResource = cms.readResource(new CmsUUID(sResult.getStructureId()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        bean.setBigIconClasses(CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(cms, resultResource), path, false));
        String detailType = CmsResourceIcon.getDefaultFileOrDetailType(cms, resultResource);
        if (detailType != null) {
            bean.setSmallIconClasses(CmsIconUtil.getIconClasses(detailType, null, true));
        }
        bean.setClientId(sResult.getStructureId());
        CmsVfsService.addLockInfo(cms, resultResource, bean);
        String permalinkId = sResult.getStructureId().toString();
        String permalink = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getOpenCmsContext(), "/permalink/", permalinkId);
        bean.setViewLink(permalink);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(sResult.getResourceType());
        String resourceTypeDisplayName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName());
        String description = sResult.getDescription();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
            bean.setDescription(description);
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DESCRIPTION_0"), description);
            if (sResult.getResourceType().equals("function_config")) {
                bean.setSubTitle(description);
            }
        } else {
            bean.setDescription(resourceTypeDisplayName);
        }
        bean.setUserLastModified(sResult.getUserLastModified());
        Date lastModDate = sResult.getDateLastModified();
        String formattedDate = lastModDate != null ? CmsDateUtil.getDateTime(lastModDate, 2, wpLocale) : "";
        bean.setDateLastModified(formattedDate);
        if (!type.getTypeName().equals(CmsResourceTypeImage.getStaticTypeName())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_RESOURCE_TYPE_0"), resourceTypeDisplayName);
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sResult.getExcerpt())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_EXCERPT_0"), sResult.getExcerpt(), "multiLineLabel");
        }
        if (type instanceof CmsResourceTypeImage) {
            CmsProperty imageDimensionProp;
            CmsProperty copyrightProp = cms.readPropertyObject(resultResource, "Copyright", false);
            if (!copyrightProp.isNullProperty()) {
                bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_COPYRIGHT_0"), copyrightProp.getValue());
            }
            if (!(imageDimensionProp = cms.readPropertyObject(resultResource, "image.size", false)).isNullProperty()) {
                String dimensions = imageDimensionProp.getValue();
                dimensions = dimensions.substring(2).replace(",h:", " x ");
                bean.setDimension(dimensions);
                bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DIMENSION_0"), dimensions);
            }
        }
        if (type instanceof CmsResourceTypeXmlContent && !(elementModelProperty = cms.readPropertyObject(resultResource, "element.model", true)).isNullProperty() && Boolean.valueOf(elementModelProperty.getValue()).booleanValue()) {
            bean.setIsCopyModel(true);
        }
        bean.setResourceState(resultResource.getState());
        bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_SIZE_0"), sResult.getLength() / 1000 + " kb");
        if (lastModDate != null) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_CHANGED_0"), CmsDateUtil.getDate(lastModDate, 3, this.getWorkplaceLocale()));
        }
        if (sResult.getDateExpired().getTime() != Long.MAX_VALUE && !sResult.getDateExpired().equals(CmsSearchFieldMapping.getDefaultDateExpired())) {
            bean.addAdditionalInfo(Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_RESULT_LABEL_DATE_EXPIRED_0"), CmsDateUtil.getDate(sResult.getDateExpired(), 3, this.getWorkplaceLocale()));
        }
        bean.setNoEditReson(new CmsResourceUtil(cms, resultResource).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)));
        bean.setMarkChangedState(true);
        return bean;
    }

    private List<CmsResourceTypeBean> buildTypesList(List<I_CmsResourceType> types, Set<String> creatableTypes) {
        ArrayList<CmsResourceTypeBean> list = new ArrayList<CmsResourceTypeBean>();
        if (types == null) {
            return list;
        }
        Map<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = this.getPreviewProviderForTypes(types);
        for (I_CmsResourceType type : types) {
            try {
                CmsResourceTypeBean bean = this.createTypeBean(type, typeProviderMapping.get(type), creatableTypes.contains(type.getTypeName()));
                list.add(bean);
            }
            catch (Exception e) {
                if (type == null) continue;
                this.log(Messages.get().getBundle(this.getWorkplaceLocale()).key("ERR_BUILD_TYPE_LIST_1", type.getTypeName()), e);
            }
        }
        return list;
    }

    private CmsVfsEntryBean buildVfsEntryBeanForQuickSearch(CmsResource resource, Multimap<CmsResource, CmsResource> childMap, Set<CmsResource> filterMatches, Set<String> parentPaths, boolean isRoot) throws CmsException {
        String tempSiteRoot;
        CmsObject cms = this.getCmsObject();
        String title = cms.readPropertyObject(resource, "Title", false).getValue();
        boolean isMatch = filterMatches.contains(resource);
        ArrayList childBeans = Lists.newArrayList();
        Collection children = childMap.get((Object)resource);
        if (!children.isEmpty()) {
            for (CmsResource child : children) {
                CmsVfsEntryBean childBean = this.buildVfsEntryBeanForQuickSearch(child, childMap, filterMatches, parentPaths, false);
                childBeans.add(childBean);
            }
        } else if (filterMatches.contains(resource) && parentPaths.contains(resource.getRootPath())) {
            childBeans = null;
        }
        String rootPath = resource.getRootPath();
        CmsVfsEntryBean result = new CmsVfsEntryBean(rootPath, resource.getStructureId(), title, CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(cms, resource), resource.getName(), true), isRoot, this.isEditable(cms, resource), childBeans, isMatch);
        String siteRoot = null;
        siteRoot = OpenCms.getSiteManager().startsWithShared(rootPath) ? OpenCms.getSiteManager().getSharedFolder() : ((tempSiteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath)) != null ? tempSiteRoot : "");
        result.setSiteRoot(siteRoot);
        return result;
    }

    private CmsSitemapEntryBean convertNavigationTreeToBean(CmsObject cms, CmsGalleryFilteredNavTreeBuilder.NavigationNode node, boolean isRoot) {
        CmsSitemapEntryBean bean = null;
        try {
            bean = this.prepareSitemapEntry(cms, node.getNavElement(), isRoot, false);
            bean.setSearchMatch(node.isMatch());
            List<CmsGalleryFilteredNavTreeBuilder.NavigationNode> children = node.getChildren();
            ArrayList childBeans = Lists.newArrayList();
            if (children.size() > 0) {
                for (CmsGalleryFilteredNavTreeBuilder.NavigationNode child : children) {
                    childBeans.add(this.convertNavigationTreeToBean(cms, child, false));
                }
            } else {
                childBeans = node.isLeaf() ? Lists.newArrayList() : null;
            }
            bean.setChildren(childBeans);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return bean;
    }

    private List<I_CmsResourceType> convertTypeNamesToTypes(List<String> resourceTypes) {
        ArrayList<I_CmsResourceType> result = new ArrayList<I_CmsResourceType>();
        if (resourceTypes != null) {
            for (String type : resourceTypes) {
                try {
                    result.add(this.getResourceManager().getResourceType(type.trim()));
                }
                catch (Exception e) {
                    this.logError(e);
                }
            }
        }
        return result;
    }

    private CmsResourceTypeBean createTypeBean(I_CmsResourceType type, I_CmsPreviewProvider preview, boolean creatable) {
        CmsResourceTypeBean result = new CmsResourceTypeBean();
        result.setResourceType(type.getTypeName());
        result.setTypeId(type.getTypeId());
        Locale wpLocale = this.getWorkplaceLocale();
        result.setTitle(CmsWorkplaceMessages.getResourceTypeName(wpLocale, type.getTypeName()));
        result.setSubTitle(CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, type.getTypeName()));
        result.setBigIconClasses(CmsIconUtil.getIconClasses(type.getTypeName(), null, false));
        ArrayList<String> galleryNames = new ArrayList<String>();
        for (I_CmsResourceType galleryType : type.getGalleryTypes()) {
            galleryNames.add(galleryType.getTypeName());
        }
        result.setGalleryTypeNames(galleryNames);
        if (preview != null) {
            result.setPreviewProviderName(preview.getPreviewName());
        }
        if (type.isFolder()) {
            result.setVisibility(CmsResourceTypeBean.TypeVisibility.hidden);
        }
        result.setCreatableType(creatable);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsGallerySearchBean findResourceInGallery(String resourceName, CmsGalleryDataBean data) throws CmsException {
        String resNameWithoutServer;
        CmsResource resource = null;
        int pos = resourceName.indexOf("?");
        String resName = resourceName;
        String query = "";
        if (pos > -1) {
            query = resourceName.substring(pos);
            resName = resourceName.substring(0, pos);
        }
        if ((resNameWithoutServer = OpenCms.getLinkManager().getRootPath(this.getCmsObject(), resName)) != null) {
            resName = resNameWithoutServer;
        }
        CmsObject cms = this.getCmsObject();
        try {
            this.log("reading resource: " + resName);
            resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        catch (CmsException e) {
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("");
                resource = cms.readResource(resName, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            catch (CmsException e2) {
                this.logError(e);
                CmsGallerySearchBean cmsGallerySearchBean = null;
                return cmsGallerySearchBean;
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }
        boolean typeOk = true;
        if (data.getTypes() != null && !data.getTypes().isEmpty()) {
            typeOk = false;
            for (CmsResourceTypeBean type : data.getTypes()) {
                if (!OpenCms.getResourceManager().matchResourceType(type.getType(), resource.getTypeId())) continue;
                typeOk = true;
            }
        }
        if (!typeOk) {
            LOG.debug((Object)("Selected resource " + resource.getRootPath() + " has invalid type for configured gallery widget."));
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        String resType = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        types.add(resType);
        Set<String> folders = null;
        if (data.getStartFolderFilter() != null) {
            for (String folder : data.getStartFolderFilter()) {
                if (!resource.getRootPath().startsWith(folder)) continue;
                folders = data.getStartFolderFilter();
                break;
            }
        }
        CmsGallerySearchBean initialSearchObj = new CmsGallerySearchBean();
        initialSearchObj.setGalleryMode(data.getMode());
        initialSearchObj.setGalleryStoragePrefix(data.getGalleryStoragePrefix());
        initialSearchObj.setIncludeExpired(data.getIncludeExpiredDefault());
        initialSearchObj.setIgnoreSearchExclude(true);
        initialSearchObj.setTypes(types);
        if (folders != null) {
            initialSearchObj.setFolders(folders);
        }
        ArrayList<String> galleries = new ArrayList<String>();
        for (CmsGalleryFolderBean gallery : data.getGalleries()) {
            String galleryPath = gallery.getPath();
            String galleryRootPath = cms.addSiteRoot(galleryPath);
            String folderPath = CmsResource.getFolderPath(resName);
            if (!galleryPath.equals(folderPath) && !galleryRootPath.equals(folderPath)) continue;
            galleries.add(gallery.getPath());
            initialSearchObj.setGalleries(galleries);
            break;
        }
        if (galleries.isEmpty()) {
            ArrayList<String> vfsFolders = new ArrayList<String>();
            vfsFolders.add(CmsResource.getFolderPath(resource.getRootPath()));
            initialSearchObj.setFolders(new HashSet<String>(vfsFolders));
        }
        initialSearchObj.setLocale(data.getLocale());
        CmsGallerySearchBean searchObj = new CmsGallerySearchBean(initialSearchObj);
        searchObj.setSortOrder(CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT.toString());
        int currentPage = 1;
        boolean found = false;
        searchObj.setPage(currentPage);
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsObject searchCms = this.getSearchCms(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        searchBean.init(searchCms);
        searchBean.setIndexForProject(searchCms);
        CmsGallerySearchResultList searchResults = null;
        CmsGallerySearchResultList totalResults = new CmsGallerySearchResultList();
        CmsGallerySearchResult foundItem = null;
        while (!found) {
            params.setResultPage(currentPage);
            searchResults = searchBean.getResult(params);
            totalResults.append(searchResults);
            ListIterator resultsIt = searchResults.listIterator();
            while (resultsIt.hasNext()) {
                CmsGallerySearchResult searchResult = (CmsGallerySearchResult)resultsIt.next();
                if (!searchResult.getPath().equals(resource.getRootPath())) continue;
                found = true;
                foundItem = searchResult;
                break;
            }
            if (found || searchResults.getHitCount() / (currentPage * params.getMatchesPerPage()) < 1) break;
            ++currentPage;
            if (searchResults.getHitCount() <= 200) continue;
            break;
        }
        boolean hasResults = searchResults != null;
        searchResults = totalResults;
        if (hasResults) {
            initialSearchObj.setSortOrder(params.getSortOrder().name());
            initialSearchObj.setResultCount(searchResults.getHitCount());
            initialSearchObj.setPage(params.getResultPage());
            initialSearchObj.setResults(this.buildSearchResultList(searchResults, foundItem));
            initialSearchObj.setPage(1);
            initialSearchObj.setLastPage(currentPage);
            initialSearchObj.setTabId(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results.name());
            initialSearchObj.setResourcePath(resName + query);
            initialSearchObj.setResourceType(resType);
            this.updateNoUploadReason(searchCms, searchObj);
        } else {
            this.log("could not find selected resource");
        }
        if (resource != null) {
            A_CmsTreeTabDataPreloader loader;
            if (this.isSitemapEntry(cms, resource)) {
                loader = new A_CmsTreeTabDataPreloader<CmsSitemapEntryBean>(){

                    @Override
                    protected CmsSitemapEntryBean createEntry(CmsObject innerCms, CmsResource innerResource) throws CmsException {
                        return CmsGalleryService.this.internalCreateSitemapEntryBean(innerCms, innerResource);
                    }

                    @Override
                    protected List<CmsResource> getChildren(CmsResource parent) throws CmsException {
                        return CmsGalleryService.this.getSitemapSubEntryResources(parent.getRootPath());
                    }
                };
                CmsSitemapEntryBean entryBean = (CmsSitemapEntryBean)loader.preloadData(cms, Sets.newHashSet(Collections.singletonList(resource)), null);
                initialSearchObj.setSitemapPreloadData(entryBean);
            } else if (resource.isFolder()) {
                loader = new A_CmsTreeTabDataPreloader<CmsVfsEntryBean>(){

                    @Override
                    protected CmsVfsEntryBean createEntry(CmsObject innerCms, CmsResource innerResource) throws CmsException {
                        String title = innerCms.readPropertyObject(innerResource, "Title", false).getValue();
                        return CmsGalleryService.internalCreateVfsEntryBean(CmsGalleryService.this.getCmsObject(), innerResource, title, true, CmsGalleryService.this.isEditable(innerCms, innerResource), null, false);
                    }
                };
                CmsVfsEntryBean entryBean = (CmsVfsEntryBean)loader.preloadData(cms, Sets.newHashSet(Collections.singletonList(resource)), null);
                initialSearchObj.setVfsPreloadData(entryBean);
            }
        }
        return initialSearchObj;
    }

    private List<I_CmsResourceType> getDefaultTypesForGallery() {
        return OpenCms.getResourceManager().getResourceTypes();
    }

    private List<CmsResource> getGalleriesByType(int galleryTypeId) {
        ArrayList<CmsResource> galleries = new ArrayList<CmsResource>();
        try {
            galleries.addAll(this.getCmsObject().readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId)));
        }
        catch (Exception e) {
            LOG.error((Object)("Could not read site galleries: " + e.getLocalizedMessage()), (Throwable)e);
        }
        String siteRoot = this.getCmsObject().getRequestContext().getSiteRoot();
        try {
            if (!siteRoot.equals("")) {
                List<CmsResource> systemGalleries = null;
                systemGalleries = this.getCmsObject().readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
                if (systemGalleries != null) {
                    galleries.addAll(systemGalleries);
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Could not read system galleries: " + e.getLocalizedMessage()), (Throwable)e);
        }
        try {
            if (!OpenCms.getSiteManager().isSharedFolder(siteRoot)) {
                String shared = OpenCms.getSiteManager().getSharedFolder();
                List<CmsResource> sharedGalleries = this.getCmsObject().readResources(shared, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
                if (sharedGalleries != null) {
                    galleries.addAll(sharedGalleries);
                }
            }
        }
        catch (Exception e) {
            LOG.info((Object)("Could not read shared galleries: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return galleries;
    }

    private CmsGalleryDataBean getInitialSettingsInternal(CmsGalleryConfiguration conf) throws CmsRpcException {
        CmsGalleryDataBean data = new CmsGalleryDataBean();
        data.setMode(conf.getGalleryMode());
        data.setResultViewType(this.readResultViewType());
        boolean galleryShowInvalidDefault = Boolean.parseBoolean(this.getWorkplaceSettings().getUserSettings().getAdditionalPreference(PREF_GALLERY_SHOW_INVALID_DEFAULT, true));
        data.setIncludeExpiredDefault(galleryShowInvalidDefault);
        data.setGalleryStoragePrefix(conf.getGalleryStoragePrefix());
        data.setLocales(this.buildLocalesMap());
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getLocale())) {
            data.setLocale(conf.getLocale());
        } else {
            data.setLocale(this.getCmsObject().getRequestContext().getLocale().toString());
        }
        data.setVfsRootFolders(this.getRootEntries());
        data.setScope(this.getWorkplaceSettings().getLastSearchScope());
        data.setSortOrder(this.getWorkplaceSettings().getLastGalleryResultOrder());
        List<CmsResourceTypeBean> types = null;
        data.setTabIds(conf.getGalleryMode().getTabs());
        switch (conf.getGalleryMode()) {
            case editor: 
            case view: 
            case adeView: 
            case widget: {
                if (conf.getTabIds() != null) {
                    data.setTabIds(conf.getTabIds());
                }
                data.setCurrentElement(conf.getCurrentElement());
                String referencePath = conf.getReferencePath();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(referencePath)) {
                    referencePath = conf.getGalleryPath();
                }
                data.setReferenceSitePath(referencePath);
                types = this.getResourceTypeBeans(conf.getGalleryMode(), data.getReferenceSitePath(), conf.getResourceTypes(), conf.getSearchTypes());
                data.setTypes(types);
                Map<String, CmsGalleryTypeInfo> galleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
                if (conf.getGalleryTypes() != null) {
                    HashMap<String, CmsGalleryTypeInfo> infos = new HashMap<String, CmsGalleryTypeInfo>();
                    for (int i = 0; i < conf.getGalleryTypes().length; ++i) {
                        CmsGalleryTypeInfo typeInfo = galleryTypeInfos.get(conf.getGalleryTypes()[i]);
                        if (typeInfo == null) continue;
                        infos.put(conf.getGalleryTypes()[i], typeInfo);
                    }
                    galleryTypeInfos = infos;
                }
                data.setGalleries(this.buildGalleriesList(galleryTypeInfos));
                String startGallery = conf.getGalleryPath();
                boolean galleryAvailable = false;
                for (CmsGalleryFolderBean folderBean : data.getGalleries()) {
                    if (!folderBean.getPath().equals(startGallery)) continue;
                    galleryAvailable = true;
                    break;
                }
                data.setStartGallery(galleryAvailable ? startGallery : null);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getStartFolder())) {
                    try {
                        CmsObject cloneCms = OpenCms.initCmsObject(this.getCmsObject());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(conf.getStartSite())) {
                            cloneCms.getRequestContext().setSiteRoot(conf.getStartSite());
                        }
                        if (cloneCms.existsResource(conf.getStartFolder(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                            data.setStartFolder(cloneCms.getRequestContext().addSiteRoot(conf.getStartFolder()));
                        }
                    }
                    catch (CmsException e) {
                        this.log(e.getMessage(), e);
                    }
                }
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) && !data.getGalleries().isEmpty()) {
                    String key = "";
                    if (!types.isEmpty() && !CmsStringUtil.isEmptyOrWhitespaceOnly(conf.getReferencePath())) {
                        key = types.get(0).getType();
                        try {
                            CmsResource refResource = this.getCmsObject().readResource(conf.getReferencePath());
                            String referenceType = OpenCms.getResourceManager().getResourceType(refResource).getTypeName();
                            key = CmsGallerySearchBean.getGalleryStorageKey(data.getGalleryStoragePrefix(), referenceType);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Could not read reference resource: " + conf.getReferencePath()));
                        }
                    }
                    if (!data.getGalleries().isEmpty() && CmsStringUtil.isEmptyOrWhitespaceOnly(startGallery = this.getWorkplaceSettings().getLastUsedGallery(key))) {
                        String galleryTypeName = data.getGalleries().get(0).getType();
                        startGallery = this.getWorkplaceSettings().getUserSettings().getStartGallery(galleryTypeName, this.getCmsObject());
                        if ("default".equals(startGallery)) {
                            startGallery = OpenCms.getWorkplaceManager().getDefaultUserSettings().getStartGallery(galleryTypeName);
                        }
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(startGallery)) {
                            startGallery = this.getCmsObject().getRequestContext().removeSiteRoot(startGallery);
                        }
                    }
                    if (!conf.isResultsSelectable()) {
                        data.setStartGallery(null);
                    } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(startGallery)) {
                        boolean galleryExists = this.getCmsObject().existsResource(startGallery);
                        if (galleryExists) {
                            data.setStartGallery(startGallery);
                        } else {
                            LOG.error((Object)("Could not read start gallery: " + startGallery));
                            data.setStartGallery(null);
                        }
                    } else {
                        data.setStartGallery(null);
                    }
                }
                I_CmsGalleryProviderConstants.GalleryTabId defaultTab = conf.getTabConfiguration().getDefaultTab();
                data.setTabConfiguration(conf.getTabConfiguration());
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery()) && CmsStringUtil.isEmptyOrWhitespaceOnly(data.getCurrentElement()) && CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartFolder())) {
                    data.setStartTab(defaultTab);
                    break;
                }
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_results);
                break;
            }
            case ade: {
                data.setReferenceSitePath(this.getCmsObject().getRequestContext().getUri());
                types = this.getResourceTypeBeans(conf.getGalleryMode(), data.getReferenceSitePath(), conf.getResourceTypes(), conf.getSearchTypes());
                data.setTypes(types);
                Map<String, CmsGalleryTypeInfo> adeGalleryTypeInfos = this.readGalleryInfosByTypeBeans(types);
                data.setGalleries(this.buildGalleriesList(adeGalleryTypeInfos));
                data.setStartTab(I_CmsGalleryProviderConstants.GalleryTabId.cms_tab_types);
                break;
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(data.getStartGallery())) {
            Set<String> folderFilter = this.readFolderFilters();
            data.setStartFolderFilter(folderFilter);
            if (folderFilter != null && !folderFilter.isEmpty()) {
                try {
                    data.setVfsPreloadData(CmsGalleryService.generateVfsPreloadData(this.getCmsObject(), CmsGalleryService.getVfsTreeState(this.getRequest(), conf.getTreeToken()), folderFilter));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        CmsSiteSelectorOptionBuilder optionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        optionBuilder.addNormalSites(true, this.getWorkplaceSettings().getUserSettings().getStartFolder());
        optionBuilder.addSharedSite();
        data.setVfsSiteSelectorOptions(optionBuilder.getOptions());
        CmsSiteSelectorOptionBuilder sitemapOptionBuilder = new CmsSiteSelectorOptionBuilder(this.getCmsObject());
        sitemapOptionBuilder.addNormalSites(false, null);
        if (data.getReferenceSitePath() != null) {
            sitemapOptionBuilder.addCurrentSubsite(this.getCmsObject().addSiteRoot(data.getReferenceSitePath()));
        }
        data.setSitemapSiteSelectorOptions(sitemapOptionBuilder.getOptions());
        data.setDefaultScope(OpenCms.getWorkplaceManager().getGalleryDefaultScope());
        return data;
    }

    private Map<I_CmsResourceType, I_CmsPreviewProvider> getPreviewProviderForTypes(List<I_CmsResourceType> types) {
        HashMap<String, I_CmsPreviewProvider> previewProviderMap = new HashMap<String, I_CmsPreviewProvider>();
        HashMap<I_CmsResourceType, I_CmsPreviewProvider> typeProviderMapping = new HashMap<I_CmsResourceType, I_CmsPreviewProvider>();
        for (I_CmsResourceType type : types) {
            String providerClass = type.getGalleryPreviewProvider();
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(providerClass)) continue;
            providerClass = providerClass.trim();
            try {
                if (previewProviderMap.containsKey(providerClass)) {
                    typeProviderMapping.put(type, (I_CmsPreviewProvider)previewProviderMap.get(providerClass));
                    continue;
                }
                I_CmsPreviewProvider previewProvider = (I_CmsPreviewProvider)Class.forName(providerClass).newInstance();
                previewProviderMap.put(providerClass, previewProvider);
                typeProviderMapping.put(type, previewProvider);
            }
            catch (Exception e) {
                this.logError(new CmsException(Messages.get().container("ERR_INSTANCING_PREVIEW_PROVIDER_2", providerClass, type.getTypeName()), (Throwable)e));
            }
        }
        return typeProviderMapping;
    }

    private CmsResourceManager getResourceManager() {
        if (this.m_resourceManager == null) {
            this.m_resourceManager = OpenCms.getResourceManager();
        }
        return this.m_resourceManager;
    }

    private List<CmsResourceTypeBean> getResourceTypeBeans(I_CmsGalleryProviderConstants.GalleryMode galleryMode, String referenceSitePath, List<String> resourceTypesList, List<String> typesForTypeTab) {
        List<Object> resourceTypes = null;
        Set<String> creatableTypes = null;
        switch (galleryMode) {
            case editor: 
            case view: 
            case adeView: 
            case widget: {
                resourceTypes = this.convertTypeNamesToTypes(resourceTypesList);
                if (resourceTypes.size() == 0) {
                    resourceTypes = Lists.newArrayList(this.getDefaultTypesForGallery());
                }
                creatableTypes = Collections.emptySet();
                break;
            }
            case ade: {
                throw new IllegalStateException("This code should never be called");
            }
            default: {
                resourceTypes = Collections.emptyList();
                creatableTypes = Collections.emptySet();
            }
        }
        return this.buildTypesList(resourceTypes, creatableTypes, Collections.emptySet(), typesForTypeTab);
    }

    private List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        ArrayList<CmsVfsEntryBean> rootFolders = new ArrayList<CmsVfsEntryBean>();
        CmsObject cms = this.getCmsObject();
        try {
            String path = "/";
            if (!cms.existsResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                String startFolder = this.getWorkplaceSettings().getUserSettings().getStartFolder();
                path = cms.existsResource(startFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED) ? startFolder : null;
            }
            if (path != null) {
                CmsResource rootFolderResource = this.getCmsObject().readResource(path, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                String title = cms.readPropertyObject(path, "Title", false).getValue();
                rootFolders.add(CmsGalleryService.internalCreateVfsEntryBean(this.getCmsObject(), rootFolderResource, title, true, this.isEditable(this.getCmsObject(), rootFolderResource), null, false));
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return rootFolders;
    }

    private CmsWorkplaceSettings getWorkplaceSettings() {
        if (this.m_workplaceSettings == null) {
            this.m_workplaceSettings = CmsWorkplace.getWorkplaceSettings(this.getCmsObject(), this.getRequest());
        }
        return this.m_workplaceSettings;
    }

    private boolean hasNavigationProperty(CmsObject cms, CmsResource resource) throws CmsException {
        List<CmsProperty> props = cms.readPropertyObjects(resource, false);
        Map<String, String> propMap = CmsProperty.toMap(props);
        return propMap.containsKey("NavPos") || propMap.containsKey("NavText");
    }

    private CmsGallerySearchParameters prepareSearchParams(CmsGallerySearchBean searchData) {
        CmsGallerySearchParameters.CmsGallerySortParam sortOrder;
        CmsGallerySearchParameters params = new CmsGallerySearchParameters();
        CmsObject cms = this.getCmsObject();
        if (searchData.getServerSearchTypes() != null) {
            params.setResourceTypes(searchData.getServerSearchTypes());
        }
        if (searchData.getGalleries() != null) {
            ArrayList<String> paramGalleries = new ArrayList<String>();
            for (String gallerySitePath : searchData.getGalleries()) {
                paramGalleries.add(cms.getRequestContext().addSiteRoot(gallerySitePath));
            }
            params.setGalleries(paramGalleries);
        }
        String temp = searchData.getSortOrder();
        try {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.valueOf(temp);
        }
        catch (Exception e) {
            sortOrder = CmsGallerySearchParameters.CmsGallerySortParam.DEFAULT;
        }
        params.setSortOrder(sortOrder);
        if (searchData.getScope() == null) {
            params.setScope(OpenCms.getWorkplaceManager().getGalleryDefaultScope());
        } else {
            params.setScope(searchData.getScope());
        }
        params.setReferencePath(searchData.getReferencePath());
        params.setFolders(new ArrayList<String>(searchData.getFolders()));
        if (searchData.getCategories() != null) {
            params.setCategories(searchData.getCategories());
        }
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(searchData.getQuery())) {
            params.setSearchWords(searchData.getQuery());
        }
        int page = searchData.getPage();
        params.setResultPage(page);
        String locale = searchData.getLocale();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(locale)) {
            locale = this.getCmsObject().getRequestContext().getLocale().toString();
        }
        params.setSearchLocale(locale);
        params.setMatchesPerPage(searchData.getMatchesPerPage());
        long dateCreatedStart = searchData.getDateCreatedStart();
        long dateCreatedEnd = searchData.getDateCreatedEnd();
        long dateModifiedStart = searchData.getDateModifiedStart();
        long dateModifiedEnd = searchData.getDateModifiedEnd();
        if (dateCreatedStart != -1L && dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, dateCreatedEnd);
        } else if (dateCreatedStart != -1L) {
            params.setDateCreatedTimeRange(dateCreatedStart, Long.MAX_VALUE);
        } else if (dateCreatedEnd != -1L) {
            params.setDateCreatedTimeRange(Long.MIN_VALUE, dateCreatedEnd);
        }
        if (dateModifiedStart != -1L && dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, dateModifiedEnd);
        } else if (dateModifiedStart != -1L) {
            params.setDateLastModifiedTimeRange(dateModifiedStart, Long.MAX_VALUE);
        } else if (dateModifiedEnd != -1L) {
            params.setDateLastModifiedTimeRange(Long.MIN_VALUE, dateModifiedEnd);
        }
        params.setIgnoreSearchExclude(searchData.isIgnoreSearchExclude());
        if (I_CmsGalleryProviderConstants.GalleryMode.ade.equals((Object)searchData.getGalleryMode()) && (searchData.getTypes().isEmpty() || !Collections.disjoint(FUNCTION_TYPES, searchData.getTypes()))) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(searchData.getReferencePath()));
            params.setAllowedFunctions(config.getDynamicFunctions());
        }
        return params;
    }

    private CmsSitemapEntryBean prepareSitemapEntry(CmsObject cms, CmsJspNavElement navElement, boolean isRoot, boolean checkHasChildren) throws CmsException {
        CmsResource ownResource = navElement.getResource();
        CmsResource defaultFileResource = null;
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
        if (ownResource.isFolder() && !navElement.isNavigationLevel()) {
            try {
                defaultFileResource = cms.readDefaultFile(ownResource, CmsResourceFilter.ONLY_VISIBLE);
            }
            catch (CmsPermissionViolationException cmsPermissionViolationException) {
                // empty catch block
            }
        }
        String type = defaultFileResource != null ? OpenCms.getResourceManager().getResourceType(defaultFileResource.getTypeId()).getTypeName() : OpenCms.getResourceManager().getResourceType(ownResource.getTypeId()).getTypeName();
        String title = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(navElement.getProperty("NavText"))) {
            title = navElement.getProperty("NavText");
        } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(navElement.getProperty("Title"))) {
            title = navElement.getProperty("Title");
        } else {
            title = navElement.getFileName();
            if (title.contains("/")) {
                title = title.substring(0, title.indexOf("/"));
            }
        }
        String childPath = navElement.getResource().getRootPath();
        boolean noChildren = true;
        if (checkHasChildren) {
            List<CmsJspNavElement> childNav = navBuilder.getNavigationForFolder(childPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE);
            for (CmsJspNavElement childNavEntry : childNav) {
                if (!childNavEntry.isInNavigation()) continue;
                noChildren = false;
                break;
            }
        }
        CmsSitemapEntryBean result = new CmsSitemapEntryBean(navElement.getResource().getRootPath(), navElement.getResourceName(), ownResource.getStructureId(), title, type, ownResource.isFolder(), isRoot, navElement.isHiddenNavigationEntry());
        result.setSiteRoot(OpenCms.getSiteManager().getSiteRoot(ownResource.getRootPath()));
        String displayType = CmsIconUtil.getDisplayType(cms, defaultFileResource != null ? defaultFileResource : ownResource);
        result.setBigIconClasses(CmsIconUtil.getIconClasses(displayType, defaultFileResource != null ? defaultFileResource.getName() : ownResource.getName(), false));
        result.setSmallIconClasses(CmsIconUtil.getIconClasses(displayType, defaultFileResource != null ? defaultFileResource.getName() : ownResource.getName(), true));
        if (checkHasChildren && noChildren) {
            result.setChildren(new ArrayList<CmsSitemapEntryBean>());
        }
        return result;
    }

    private Set<String> readFolderFilters() {
        JSONObject storedFilters = this.readUserFolderFilters();
        HashSet<String> result = null;
        if (storedFilters.has(this.getCmsObject().getRequestContext().getSiteRoot())) {
            try {
                JSONArray folders = storedFilters.getJSONArray(this.getCmsObject().getRequestContext().getSiteRoot());
                result = new HashSet<String>();
                for (int i = 0; i < folders.length(); ++i) {
                    result.add(folders.getString(i));
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeBeans(List<CmsResourceTypeBean> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (CmsResourceTypeBean typeBean : resourceTypes) {
            try {
                if (typeBean.isDeactivated()) continue;
                this.addGalleriesForType(galleryTypeInfos, typeBean.getType());
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private Map<String, CmsGalleryTypeInfo> readGalleryInfosByTypeNames(List<String> resourceTypes) {
        HashMap<String, CmsGalleryTypeInfo> galleryTypeInfos = new HashMap<String, CmsGalleryTypeInfo>();
        for (String typeName : resourceTypes) {
            try {
                this.addGalleriesForType(galleryTypeInfos, typeName);
            }
            catch (CmsLoaderException e1) {
                this.logError(e1);
            }
        }
        return galleryTypeInfos;
    }

    private String readResultViewType() {
        return (String)this.getCmsObject().getRequestContext().getCurrentUser().getAdditionalInfo(RESULT_VIEW_TYPE_ADD_INFO_KEY);
    }

    private JSONObject readUserFolderFilters() {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        String addInfo = (String)user.getAdditionalInfo(FOLDER_FILTER_ADD_INFO_KEY);
        JSONObject result = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(addInfo)) {
            try {
                result = new JSONObject(addInfo);
            }
            catch (JSONException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (result == null) {
            result = new JSONObject();
        }
        return result;
    }

    private CmsGallerySearchBean search(CmsGallerySearchBean searchObj) throws CmsException {
        CmsGallerySearchBean searchObjBean = new CmsGallerySearchBean(searchObj);
        if (searchObj == null) {
            return searchObjBean;
        }
        this.storeFolderFilter(searchObj.getFolders());
        CmsGallerySearchParameters params = this.prepareSearchParams(searchObj);
        CmsGallerySearch searchBean = new CmsGallerySearch();
        CmsObject searchCms = this.getSearchCms(searchObj);
        searchBean.init(searchCms);
        CmsGallerySearchResultList searchResults = OpenCms.getSearchManager().getIndexSolr("Solr Offline").gallerySearch(searchCms, params);
        searchResults.calculatePages(params.getResultPage(), params.getMatchesPerPage());
        searchObjBean.setSortOrder(params.getSortOrder().name());
        searchObjBean.setScope(params.getScope());
        searchObjBean.setResultCount(searchResults.getHitCount());
        searchObjBean.setPage(params.getResultPage());
        searchObjBean.setLastPage(params.getResultPage());
        searchObjBean.setResults(this.buildSearchResultList(searchResults, null));
        if (searchObj.getGalleryMode().equals((Object)I_CmsGalleryProviderConstants.GalleryMode.ade) && searchObjBean.getResultCount() > 0) {
            CmsADESessionCache cache = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject());
            cache.setLastPageEditorGallerySearch(searchObj);
        }
        this.updateNoUploadReason(searchCms, searchObjBean);
        return searchObjBean;
    }

    private void setLastOpenedGallery(CmsGallerySearchBean searchObject) {
        if (searchObject.getGalleries() != null && searchObject.getGalleries().size() <= 1 && searchObject.haveGalleriesChanged()) {
            String galleryPath = searchObject.getGalleries().isEmpty() ? null : searchObject.getGalleries().get(0);
            CmsWorkplaceSettings settings = this.getWorkplaceSettings();
            if (searchObject.getGalleryMode() == I_CmsGalleryProviderConstants.GalleryMode.adeView) {
                settings.setLastUsedGallery("" + (Object)((Object)I_CmsGalleryProviderConstants.GalleryMode.adeView), galleryPath);
            } else {
                String referencePath = searchObject.getReferencePath();
                String referenceTypeName = "";
                try {
                    CmsObject cms = this.getCmsObject();
                    CmsResource referenceResource = cms.readResource(referencePath);
                    I_CmsResourceType referenceType = OpenCms.getResourceManager().getResourceType(referenceResource);
                    referenceTypeName = referenceType.getTypeName();
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                settings.setLastUsedGallery(CmsGallerySearchBean.getGalleryStorageKey(searchObject.getGalleryStoragePrefix(), referenceTypeName), galleryPath);
            }
        }
    }

    private void storeFolderFilter(Set<String> folders) {
        JSONObject storedFilters = this.readUserFolderFilters();
        try {
            storedFilters.put(this.getCmsObject().getRequestContext().getSiteRoot(), folders);
            CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
            user.setAdditionalInfo(FOLDER_FILTER_ADD_INFO_KEY, storedFilters.toString());
            this.getCmsObject().writeUser(user);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void updateNoUploadReason(CmsObject searchCms, CmsGallerySearchBean searchObj) {
        if (searchObj.getGalleries().size() + searchObj.getFolders().size() == 1) {
            String target = !searchObj.getGalleries().isEmpty() ? searchObj.getGalleries().get(0) : searchObj.getFolders().iterator().next();
            try {
                CmsResource targetRes;
                if (searchCms.existsResource(target, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
                    targetRes = searchCms.readResource(target, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                } else {
                    CmsObject rootCms = OpenCms.initCmsObject(searchCms);
                    rootCms.getRequestContext().setSiteRoot("");
                    targetRes = rootCms.readResource(target, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                }
                searchObj.setNoUploadReason(new CmsResourceUtil(searchCms, targetRes).getNoEditReason(this.getWorkplaceLocale(), true));
            }
            catch (CmsException e) {
                searchObj.setNoUploadReason(e.getLocalizedMessage(this.getWorkplaceLocale()));
            }
        } else {
            searchObj.setNoUploadReason(null);
        }
    }

    class TypeWithVisibility {
        private boolean m_onlyShowInFullList;
        private I_CmsResourceType m_type;

        public TypeWithVisibility(I_CmsResourceType type, boolean onlyShowInFullList) {
            this.m_type = type;
            this.m_onlyShowInFullList = onlyShowInFullList;
        }

        public I_CmsResourceType getType() {
            return this.m_type;
        }

        public boolean isOnlyShowInFullList() {
            return this.m_onlyShowInFullList;
        }
    }

    protected class CmsGalleryTypeInfo {
        private List<I_CmsResourceType> m_contentTypes;
        private List<CmsResource> m_galleries;
        private I_CmsResourceType m_resourceType;

        protected CmsGalleryTypeInfo(I_CmsResourceType resourceType, I_CmsResourceType contentType, List<CmsResource> galleries) {
            this.m_resourceType = resourceType;
            this.m_contentTypes = new ArrayList<I_CmsResourceType>();
            this.m_contentTypes.add(contentType);
            this.m_galleries = galleries;
        }

        protected void addContentType(I_CmsResourceType type) {
            this.m_contentTypes.add(type);
        }

        protected List<I_CmsResourceType> getContentTypes() {
            return this.m_contentTypes;
        }

        protected List<CmsResource> getGalleries() {
            return this.m_galleries;
        }

        protected I_CmsResourceType getResourceType() {
            return this.m_resourceType;
        }

        protected void setContentTypes(List<I_CmsResourceType> contentTypes) {
            this.m_contentTypes = contentTypes;
        }

        protected void setGalleries(List<CmsResource> galleries) {
            this.m_galleries = galleries;
        }

        protected void setResourceType(I_CmsResourceType resourceType) {
            this.m_resourceType = resourceType;
        }
    }
}

