/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.galleries.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.opencms.ade.galleries.shared.I_CmsGalleryTreeEntry;
import org.opencms.gwt.shared.I_CmsHasIconClasses;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsVfsEntryBean
implements IsSerializable,
I_CmsGalleryTreeEntry<CmsVfsEntryBean>,
I_CmsHasIconClasses {
    private boolean m_editable;
    private String m_iconClasses;
    private boolean m_isRoot;
    private boolean m_isSearchMatch;
    private List<CmsVfsEntryBean> m_preloadedChildren;
    private String m_rootPath;
    private String m_siteRoot;
    private CmsUUID m_structureId;
    private String m_title;

    public CmsVfsEntryBean(String rootPath, CmsUUID structureId, String title, String iconClasses, boolean isRoot, boolean editable, List<CmsVfsEntryBean> preloadedChildren, boolean isMatch) {
        this.m_rootPath = rootPath;
        this.m_structureId = structureId;
        this.m_isRoot = isRoot;
        this.m_editable = editable;
        this.m_title = title;
        this.m_iconClasses = iconClasses;
        this.m_isSearchMatch = isMatch;
        this.m_preloadedChildren = preloadedChildren;
    }

    protected CmsVfsEntryBean() {
    }

    @Override
    public void addChild(CmsVfsEntryBean child) {
        if (this.m_preloadedChildren == null) {
            this.m_preloadedChildren = new ArrayList<CmsVfsEntryBean>();
        }
        this.m_preloadedChildren.add(child);
    }

    @Override
    public String getBigIconClasses() {
        return null;
    }

    @Override
    public List<CmsVfsEntryBean> getChildren() {
        return this.m_preloadedChildren;
    }

    public String getDisplayName() {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_title)) {
            return this.m_title;
        }
        if (this.m_isRoot) {
            return this.getRootPath();
        }
        String fixedPath = this.getRootPath().replaceFirst("/$", "");
        int lastSlash = fixedPath.lastIndexOf(47);
        if (lastSlash == -1) {
            return fixedPath;
        }
        return fixedPath.substring(lastSlash + 1);
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    @Override
    public String getSmallIconClasses() {
        return this.m_iconClasses;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public boolean isRoot() {
        return this.m_isRoot;
    }

    public boolean isSearchMatch() {
        return this.m_isSearchMatch;
    }

    public void setChildren(List<CmsVfsEntryBean> children) {
        this.m_preloadedChildren = children;
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public void setSiteRoot(String siteRoot) {
        this.m_siteRoot = siteRoot;
    }
}

