/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.postupload;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.postupload.Messages;
import org.opencms.ade.postupload.shared.CmsPostUploadDialogBean;
import org.opencms.ade.postupload.shared.CmsPostUploadDialogPanelBean;
import org.opencms.ade.postupload.shared.rpc.I_CmsPostUploadDialogService;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsPropertyEditorHelper;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsPostUploadDialogService
extends CmsGwtService
implements I_CmsPostUploadDialogService {
    private static final long serialVersionUID = 1L;

    public static CmsPostUploadDialogBean prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsPostUploadDialogService srv = new CmsPostUploadDialogService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsPostUploadDialogBean result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public CmsPostUploadDialogPanelBean load(CmsUUID id, boolean useConfiguration, boolean addBasicProperties) throws CmsRpcException {
        try {
            String description;
            CmsResource res = this.getCmsObject().readResource(id);
            List<CmsProperty> properties = this.getCmsObject().readPropertyObjects(res, false);
            String title = CmsProperty.get("Title", properties).getValue();
            if (title == null) {
                title = res.getName();
            }
            if ((description = CmsProperty.get("Description", properties).getValue()) == null) {
                description = this.getCmsObject().getSitePath(res);
            }
            CmsListInfoBean listInfo = CmsVfsService.getPageInfo(this.getCmsObject(), res);
            CmsPostUploadDialogPanelBean result = new CmsPostUploadDialogPanelBean(id, listInfo);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            String typeName = type.getTypeName();
            listInfo.setResourceType(typeName);
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
            List<String> defaultProperties = settings.getProperties();
            while (properties.isEmpty() && !CmsStringUtil.isEmptyOrWhitespaceOnly(settings.getReference())) {
                settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(settings.getReference());
                defaultProperties = settings.getProperties();
            }
            Map<String, CmsXmlContentProperty> propertyDefinitions = new LinkedHashMap<String, CmsXmlContentProperty>();
            LinkedHashMap<String, CmsClientProperty> clientProperties = new LinkedHashMap<String, CmsClientProperty>();
            CmsXmlContentProperty fileNamePropDef = new CmsXmlContentProperty("~~~file_name_property~~~", "string", "string", "", "", "", "", Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject())).key("GUI_UPLOAD_FILE_NAME_0"), "", "", "false");
            propertyDefinitions.put("~~~file_name_property~~~", fileNamePropDef);
            clientProperties.put("~~~file_name_property~~~", new CmsClientProperty("~~~file_name_property~~~", res.getName(), res.getName()));
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), res.getRootPath());
            Map<String, CmsXmlContentProperty> propertyConfiguration = configData.getPropertyConfigurationAsMap();
            HashSet<String> propertiesToShow = new HashSet<String>();
            propertiesToShow.addAll(defaultProperties);
            if (addBasicProperties) {
                propertiesToShow.addAll(propertyConfiguration.keySet());
            }
            for (String propertyName : propertiesToShow) {
                CmsXmlContentProperty propDef = null;
                if (useConfiguration) {
                    propDef = propertyConfiguration.get(propertyName);
                }
                if (propDef == null) {
                    propDef = new CmsXmlContentProperty(propertyName, "string", "string", "", "", "", "", null, "", "", "false");
                }
                propertyDefinitions.put(propertyName, propDef);
                CmsProperty property = CmsProperty.get(propertyName, properties);
                if (property == null) continue;
                CmsClientProperty clientProperty = new CmsClientProperty(propertyName, property.getStructureValue(), property.getResourceValue());
                clientProperties.put(clientProperty.getName(), clientProperty);
            }
            propertyDefinitions = CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertyDefinitions, CmsMacroResolver.newWorkplaceLocaleResolver(this.getCmsObject()));
            CmsPropertyEditorHelper.updateWysiwygConfig(propertyDefinitions, this.getCmsObject(), res);
            result.setPropertyDefinitions(propertyDefinitions);
            result.setProperties(clientProperties);
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPostUploadDialogBean prefetch() throws CmsRpcException {
        try {
            String resourceParam;
            LinkedHashMap<CmsUUID, String> uuids = new LinkedHashMap<CmsUUID, String>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getRequest().getParameter("resources"))) {
                String resourcesParam = this.getRequest().getParameter("resources");
                List<String> resourceUUIDs = CmsStringUtil.splitAsList(resourcesParam, ",");
                for (String uuidAsString : resourceUUIDs) {
                    CmsUUID uuid = new CmsUUID(uuidAsString);
                    CmsResource res = this.getCmsObject().readResource(uuid);
                    String resPath = this.getCmsObject().getRequestContext().removeSiteRoot(res.getRootPath());
                    uuids.put(uuid, resPath);
                }
            } else if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getRequest().getParameter("resource")) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(resourceParam = this.getRequest().getParameter("resource"))) {
                CmsResource res = this.getCmsObject().readResource(resourceParam);
                String resPath = this.getCmsObject().getRequestContext().removeSiteRoot(res.getRootPath());
                uuids.put(res.getStructureId(), resPath);
            }
            return new CmsPostUploadDialogBean(uuids);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }
}

