/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.Messages;
import org.opencms.main.CmsLog;

public abstract class A_CmsPublishGroupHelper<RESOURCE, GROUP> {
    protected static final int GROUP_SESSIONS_GAP = 28800000;
    private static final Log LOG = CmsLog.getLog(A_CmsPublishGroupHelper.class);
    private Locale m_locale;

    public A_CmsPublishGroupHelper(Locale locale) {
        this.m_locale = locale;
    }

    public Map<Long, Integer> computeDays(List<Long> sortedDates) {
        if (sortedDates.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Integer> days = new HashMap<Long, Integer>();
        long lastDate = System.currentTimeMillis();
        int dayCounter = 0;
        for (Long dateObj : sortedDates) {
            long date = dateObj;
            long dayDifference = this.getDayDifference(lastDate, date);
            dayCounter = (int)((long)dayCounter + dayDifference);
            lastDate = date;
            days.put(dateObj, new Integer(dayCounter));
        }
        return days;
    }

    public Map<Long, Integer> computeDaysForResources(List<RESOURCE> resources) {
        Map<Long, Integer> result = this.computeDays(this.getModificationDates(resources));
        if (LOG.isDebugEnabled()) {
            for (RESOURCE res : resources) {
                LOG.debug((Object)("Resource " + this.getRootPath(res) + " is " + result.get(new Long(this.getDateLastModified(res))) + " days old."));
            }
        }
        return result;
    }

    public int getDayDifference(long first, long second) {
        Calendar firstDay = this.getStartOfDay(first);
        Calendar secondDay = this.getStartOfDay(second);
        int result = 0;
        if (first >= second) {
            while (firstDay.after(secondDay)) {
                firstDay.add(5, -1);
                ++result;
            }
        } else {
            while (secondDay.after(firstDay)) {
                secondDay.add(5, -1);
                --result;
            }
        }
        return result;
    }

    public List<GROUP> getGroups(List<RESOURCE> resources) {
        String name;
        ArrayList<RESOURCE> sortedResources = new ArrayList<RESOURCE>(resources);
        Collections.sort(sortedResources, new SortingComparator());
        Map<Long, Integer> daysMap = this.computeDaysForResources(sortedResources);
        Map<GroupAge, List<RESOURCE>> resourcesByAge = this.partitionPublishResourcesByAge(sortedResources, daysMap);
        List<List<RESOURCE>> youngGroups = this.partitionYoungResources(resourcesByAge.get((Object)GroupAge.young));
        List<List<RESOURCE>> mediumGroups = this.partitionMediumResources(resourcesByAge.get((Object)GroupAge.medium), daysMap);
        List<RESOURCE> oldGroup = resourcesByAge.get((Object)GroupAge.old);
        ArrayList<GROUP> resultGroups = new ArrayList<GROUP>();
        for (List<RESOURCE> groupRes : youngGroups) {
            name = this.getPublishGroupName(groupRes, GroupAge.young);
            resultGroups.add(this.createGroup(name, groupRes));
        }
        for (List<RESOURCE> groupRes : mediumGroups) {
            name = this.getPublishGroupName(groupRes, GroupAge.medium);
            resultGroups.add(this.createGroup(name, groupRes));
        }
        if (!oldGroup.isEmpty()) {
            String oldName = this.getPublishGroupName(oldGroup, GroupAge.old);
            resultGroups.add(this.createGroup(oldName, oldGroup));
        }
        return resultGroups;
    }

    public List<Long> getModificationDates(List<RESOURCE> resources) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (RESOURCE res : resources) {
            result.add(new Long(this.getDateLastModified(res)));
        }
        return result;
    }

    public String getPublishGroupName(List<RESOURCE> resources, GroupAge age) {
        String groupName;
        long groupDate = this.getDateLastModified(resources.get(0));
        switch (age) {
            case young: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_SESSION_1", new Date(groupDate));
                break;
            }
            case medium: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_DAY_1", new Date(groupDate));
                break;
            }
            default: {
                groupName = Messages.get().getBundle(this.m_locale).key("GUI_GROUPNAME_EVERYTHING_ELSE_0");
            }
        }
        return groupName;
    }

    public Calendar getStartOfDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        Calendar result = Calendar.getInstance();
        result.set(1, year);
        result.set(2, month);
        result.set(5, day);
        return result;
    }

    public List<List<RESOURCE>> partitionMediumResources(List<RESOURCE> resources, Map<Long, Integer> days) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        RESOURCE firstRes = resources.get(0);
        int lastDay = days.get(new Long(this.getDateLastModified(firstRes)));
        ArrayList<List<RESOURCE>> result = new ArrayList<List<RESOURCE>>();
        ArrayList<RESOURCE> currentGroup = new ArrayList<RESOURCE>();
        result.add(currentGroup);
        for (RESOURCE res : resources) {
            LOG.debug((Object)("Processing medium-aged resource " + this.getRootPath(res)));
            int day = days.get(new Long(this.getDateLastModified(res)));
            if (day != lastDay) {
                LOG.debug((Object)"=== new group ===");
                currentGroup = new ArrayList();
                result.add(currentGroup);
            }
            lastDay = day;
            currentGroup.add(res);
        }
        return result;
    }

    public Map<GroupAge, List<RESOURCE>> partitionPublishResourcesByAge(List<RESOURCE> resources, Map<Long, Integer> days) {
        ArrayList<RESOURCE> youngRes = new ArrayList<RESOURCE>();
        ArrayList mediumRes = new ArrayList();
        ArrayList oldRes = new ArrayList();
        for (RESOURCE res : resources) {
            int day = days.get(new Long(this.getDateLastModified(res)));
            ArrayList<RESOURCE> listToAddTo = null;
            if (day < 7) {
                listToAddTo = youngRes;
                LOG.debug((Object)("Classifying publish resource " + this.getRootPath(res) + " as young"));
            } else if (day < 28) {
                listToAddTo = mediumRes;
                LOG.debug((Object)("Classifying publish resource " + this.getRootPath(res) + " as medium-aged"));
            } else {
                listToAddTo = oldRes;
                LOG.debug((Object)("Classifying publish resource " + this.getRootPath(res) + " as old"));
            }
            listToAddTo.add(res);
        }
        HashMap<GroupAge, List<RESOURCE>> result = new HashMap<GroupAge, List<RESOURCE>>();
        result.put(GroupAge.young, youngRes);
        result.put(GroupAge.medium, mediumRes);
        result.put(GroupAge.old, oldRes);
        return result;
    }

    public List<List<RESOURCE>> partitionYoungResources(List<RESOURCE> resources) {
        if (resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<RESOURCE>> result = new ArrayList<List<RESOURCE>>();
        ArrayList<RESOURCE> currentGroup = new ArrayList<RESOURCE>();
        result.add(currentGroup);
        long lastDate = this.getDateLastModified(resources.get(0));
        for (RESOURCE res : resources) {
            LOG.debug((Object)("Processing young resource " + this.getRootPath(res)));
            long resDate = this.getDateLastModified(res);
            if (lastDate - resDate > 28800000L) {
                LOG.debug((Object)"=== new group ===");
                currentGroup = new ArrayList();
                result.add(currentGroup);
            }
            lastDate = resDate;
            currentGroup.add(res);
        }
        return result;
    }

    protected abstract GROUP createGroup(String var1, List<RESOURCE> var2);

    protected abstract long getDateLastModified(RESOURCE var1);

    protected abstract String getRootPath(RESOURCE var1);

    public class SortingComparator
    implements Comparator<RESOURCE> {
        @Override
        public int compare(RESOURCE r1, RESOURCE r2) {
            long date2;
            if (r1 == r2) {
                return 0;
            }
            long date1 = A_CmsPublishGroupHelper.this.getDateLastModified(r1);
            return date1 > (date2 = A_CmsPublishGroupHelper.this.getDateLastModified(r2)) ? -1 : (date1 < date2 ? 1 : 0);
        }
    }

    public static enum GroupAge {
        medium,
        old,
        young;

    }
}

