/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.CmsPublishListHelper;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.gwt.shared.I_CmsContentLoadCollectorInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsCollectorPublishListHelper {
    private CmsObject m_cms;
    private I_CmsContentLoadCollectorInfo m_info;
    public static final boolean OFFLINE = false;
    public static final boolean ONLINE = true;
    private static final Log LOG = CmsLog.getLog(CmsCollectorPublishListHelper.class);
    private int m_collectorLimit;

    public CmsCollectorPublishListHelper(CmsObject cms, I_CmsContentLoadCollectorInfo collectorInfo, int collectorLimit) {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            throw new IllegalArgumentException("CmsObject must not be set to the Online project!");
        }
        this.m_cms = cms;
        this.m_info = collectorInfo;
        this.m_collectorLimit = collectorLimit;
    }

    public CmsObject getCmsObject(boolean online) throws CmsException {
        return CmsPublishListHelper.adjustCmsObject(this.m_cms, online);
    }

    public I_CmsResourceCollector getCollector() {
        return OpenCms.getResourceManager().getContentCollector(this.m_info.getCollectorName());
    }

    public Set<CmsResource> getPublishListFiles() throws CmsException {
        String context = "[" + RandomStringUtils.randomAlphabetic((int)8) + "] ";
        List<CmsResource> offlineResults = this.computeCollectorResults(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(context + "Offline collector results for " + this.m_info + ": " + this.resourcesToString(offlineResults)));
        }
        List<CmsResource> onlineResults = this.computeCollectorResults(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(context + "Online collector results for " + this.m_info + ": " + this.resourcesToString(onlineResults)));
        }
        HashSet result = Sets.newHashSet();
        for (CmsResource offlineRes : offlineResults) {
            if (offlineRes.getState().isUnchanged()) continue;
            result.add(offlineRes);
        }
        HashSet onlineAndNotOffline = Sets.newHashSet(onlineResults);
        onlineAndNotOffline.removeAll(offlineResults);
        for (CmsResource res : onlineAndNotOffline) {
            try {
                res = this.getCmsObject(false).readResource(res.getStructureId(), CmsResourceFilter.ALL);
                result.add(res);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        result.addAll(onlineAndNotOffline);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(context + "Publish list contributions for " + this.m_info + ": " + this.resourcesToString(result)));
        }
        return result;
    }

    protected List<CmsResource> computeCollectorResults(boolean online) throws CmsException {
        CmsObject cms = this.getCmsObject(online);
        I_CmsResourceCollector collector = this.getCollector();
        List<CmsResource> collectorResult = collector.getResults(cms, this.m_info.getCollectorName(), this.m_info.getCollectorParams(), this.m_collectorLimit);
        return collectorResult;
    }

    private String resourcesToString(Iterable<CmsResource> resources) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        buffer.append("[");
        for (CmsResource res : resources) {
            if (!first) {
                buffer.append(", ");
            }
            first = false;
            buffer.append(res.getRootPath());
            buffer.append("!");
            buffer.append(res.getState().getAbbreviation());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

