/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;

public class CmsAliasEditorLockTable {
    public static final long TIMEOUT_INTERVAL = 60000L;
    private Cache<String, CmsUser> m_map;

    public CmsAliasEditorLockTable() {
        CacheBuilder mm = CacheBuilder.newBuilder().expireAfterWrite(60000L, TimeUnit.MILLISECONDS);
        this.m_map = mm.build();
    }

    public void clear(CmsObject cms, String siteRoot) {
        CmsUser originalUser = (CmsUser)this.m_map.getIfPresent((Object)siteRoot);
        if (originalUser == null || !originalUser.equals(cms.getRequestContext().getCurrentUser())) {
            return;
        }
        this.m_map.invalidate((Object)siteRoot);
    }

    public CmsUser update(CmsObject cms, String siteRoot) {
        CmsUser originalUser = (CmsUser)this.m_map.getIfPresent((Object)siteRoot);
        if (originalUser == null || originalUser.equals(cms.getRequestContext().getCurrentUser())) {
            this.m_map.put((Object)siteRoot, (Object)cms.getRequestContext().getCurrentUser());
            return null;
        }
        return originalUser;
    }
}

