/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.upload;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.opencms.ade.upload.CmsUploadException;
import org.opencms.ade.upload.CmsUploadListener;
import org.opencms.ade.upload.Messages;
import org.opencms.main.CmsLog;

public class CmsUploadTimeoutWatcher
extends Thread
implements Serializable {
    private static final Log LOG = CmsLog.getLog(CmsUploadTimeoutWatcher.class);
    private static final long serialVersionUID = -649803529271569237L;
    private static final int WATCHER_INTERVAL = 5000;
    private long m_lastBytesRead;
    private long m_lastData = new Date().getTime();
    private CmsUploadListener m_listener;

    public CmsUploadTimeoutWatcher(CmsUploadListener listener) {
        this.m_listener = listener;
    }

    public void cancel() {
        this.m_listener = null;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)Messages.get().container("ERR_UPLOAD_INTERRUPT_WATCH_DOG_1", this.m_listener.toString()), (Throwable)e);
        }
        if (this.m_listener != null) {
            if (this.m_listener.getBytesRead() > 0L && this.m_listener.getPercent() >= 100L || this.m_listener.isCanceled()) {
                LOG.debug((Object)Messages.get().container("LOG_UPLOAD_FINISHED_WATCHER_1", this.m_listener.toString()));
                this.m_listener = null;
            } else if (this.isFrozen()) {
                this.m_listener.cancelUpload(new CmsUploadException(Messages.get().getBundle().key("ERR_UPLOAD_FROZEN_1", new Integer(20))));
            } else {
                this.run();
            }
        }
    }

    private boolean isFrozen() {
        long now = new Date().getTime();
        if (this.m_listener.getBytesRead() > this.m_lastBytesRead) {
            this.m_lastData = now;
            this.m_lastBytesRead = this.m_listener.getBytesRead();
        } else if (now - this.m_lastData > 20000L) {
            return true;
        }
        return false;
    }
}

