/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import org.apache.commons.logging.Log;
import org.opencms.cache.I_CmsLruCacheObject;
import org.opencms.cache.Messages;
import org.opencms.main.CmsLog;

public class CmsLruCache {
    private static final Log LOG = CmsLog.getLog(CmsLruCache.class);
    private long m_avgCacheCosts;
    private I_CmsLruCacheObject m_listHead;
    private I_CmsLruCacheObject m_listTail;
    private long m_maxCacheCosts;
    private int m_maxObjectCosts;
    private int m_objectCosts;
    private int m_objectCount;

    public CmsLruCache(long theMaxCacheCosts, long theAvgCacheCosts, int theMaxObjectCosts) {
        this.m_maxCacheCosts = theMaxCacheCosts;
        this.m_avgCacheCosts = theAvgCacheCosts;
        this.m_maxObjectCosts = theMaxObjectCosts;
    }

    public synchronized boolean add(I_CmsLruCacheObject theCacheObject) {
        if (theCacheObject == null) {
            return false;
        }
        if (this.m_maxObjectCosts != -1 && theCacheObject.getLruCacheCosts() > this.m_maxObjectCosts) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_CACHE_COSTS_TOO_HIGH_2", new Integer(theCacheObject.getLruCacheCosts()), new Integer(this.m_maxObjectCosts)));
            }
            return false;
        }
        if (!this.isCached(theCacheObject)) {
            this.addHead(theCacheObject);
        } else {
            this.touch(theCacheObject);
        }
        if ((long)this.m_objectCosts > this.m_maxCacheCosts) {
            this.gc();
        }
        return true;
    }

    public synchronized void clear() {
        for (I_CmsLruCacheObject currentObject = this.m_listTail; currentObject != null; currentObject = currentObject.getNextLruObject()) {
            this.removeTail();
        }
        this.m_objectCosts = 0;
        this.m_objectCount = 0;
        this.m_listHead = null;
        this.m_listTail = null;
    }

    public long getAvgCacheCosts() {
        return this.m_avgCacheCosts;
    }

    public long getMaxCacheCosts() {
        return this.m_maxCacheCosts;
    }

    public int getMaxObjectCosts() {
        return this.m_maxObjectCosts;
    }

    public int getObjectCosts() {
        return this.m_objectCosts;
    }

    public synchronized I_CmsLruCacheObject remove(I_CmsLruCacheObject theCacheObject) {
        boolean prevNull;
        if (!this.isCached(theCacheObject)) {
            return null;
        }
        boolean nextNull = theCacheObject.getNextLruObject() == null;
        boolean bl = prevNull = theCacheObject.getPreviousLruObject() == null;
        if (prevNull && nextNull) {
            this.m_listHead = null;
            this.m_listTail = null;
        } else if (nextNull) {
            I_CmsLruCacheObject newHead = theCacheObject.getPreviousLruObject();
            newHead.setNextLruObject(null);
            this.m_listHead = newHead;
        } else if (prevNull) {
            I_CmsLruCacheObject newTail = theCacheObject.getNextLruObject();
            newTail.setPreviousLruObject(null);
            this.m_listTail = newTail;
        } else {
            theCacheObject.getPreviousLruObject().setNextLruObject(theCacheObject.getNextLruObject());
            theCacheObject.getNextLruObject().setPreviousLruObject(theCacheObject.getPreviousLruObject());
        }
        this.decreaseCache(theCacheObject);
        return theCacheObject;
    }

    public int size() {
        return this.m_objectCount;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("max. costs: " + this.m_maxCacheCosts).append(", ");
        buf.append("avg. costs: " + this.m_avgCacheCosts).append(", ");
        buf.append("max. costs/object: " + this.m_maxObjectCosts).append(", ");
        buf.append("costs: " + this.m_objectCosts).append(", ");
        buf.append("count: " + this.m_objectCount);
        return buf.toString();
    }

    public synchronized boolean touch(I_CmsLruCacheObject theCacheObject) {
        if (!this.isCached(theCacheObject)) {
            return false;
        }
        if (this.m_maxObjectCosts != -1 && theCacheObject.getLruCacheCosts() > this.m_maxObjectCosts) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_CACHE_COSTS_TOO_HIGH_2", new Integer(theCacheObject.getLruCacheCosts()), new Integer(this.m_maxObjectCosts)));
            }
            this.remove(theCacheObject);
            return false;
        }
        I_CmsLruCacheObject nextObj = theCacheObject.getNextLruObject();
        if (nextObj == null) {
            return true;
        }
        I_CmsLruCacheObject prevObj = theCacheObject.getPreviousLruObject();
        if (prevObj == null) {
            I_CmsLruCacheObject newTail = nextObj;
            newTail.setPreviousLruObject(null);
            this.m_listTail = newTail;
        } else {
            prevObj.setNextLruObject(nextObj);
            nextObj.setPreviousLruObject(prevObj);
        }
        I_CmsLruCacheObject oldHead = this.m_listHead;
        if (oldHead != null) {
            oldHead.setNextLruObject(theCacheObject);
            theCacheObject.setNextLruObject(null);
            theCacheObject.setPreviousLruObject(oldHead);
        }
        this.m_listHead = theCacheObject;
        return true;
    }

    private void addHead(I_CmsLruCacheObject theCacheObject) {
        if (this.m_objectCount > 0) {
            I_CmsLruCacheObject oldHead = this.m_listHead;
            oldHead.setNextLruObject(theCacheObject);
            theCacheObject.setPreviousLruObject(oldHead);
            this.m_listHead = theCacheObject;
        } else {
            this.m_listTail = theCacheObject;
            this.m_listHead = theCacheObject;
            theCacheObject.setPreviousLruObject(null);
        }
        theCacheObject.setNextLruObject(null);
        this.increaseCache(theCacheObject);
    }

    private void decreaseCache(I_CmsLruCacheObject theCacheObject) {
        theCacheObject.removeFromLruCache();
        theCacheObject.setNextLruObject(null);
        theCacheObject.setPreviousLruObject(null);
        this.m_objectCosts -= theCacheObject.getLruCacheCosts();
        --this.m_objectCount;
    }

    private void gc() {
        for (I_CmsLruCacheObject currentObject = this.m_listTail; currentObject != null && (long)this.m_objectCosts >= this.m_avgCacheCosts; currentObject = currentObject.getNextLruObject()) {
            this.removeTail();
        }
    }

    private void increaseCache(I_CmsLruCacheObject theCacheObject) {
        theCacheObject.addToLruCache();
        this.m_objectCosts += theCacheObject.getLruCacheCosts();
        ++this.m_objectCount;
    }

    private boolean isCached(I_CmsLruCacheObject theCacheObject) {
        if (theCacheObject == null || this.m_objectCount == 0) {
            return false;
        }
        I_CmsLruCacheObject nextObj = theCacheObject.getNextLruObject();
        I_CmsLruCacheObject prevObj = theCacheObject.getPreviousLruObject();
        if (nextObj != null || prevObj != null) {
            return true;
        }
        return this.m_objectCount == 1 && this.m_listHead != null && this.m_listTail != null && this.m_listHead.equals(theCacheObject) && this.m_listTail.equals(theCacheObject);
    }

    private synchronized void removeTail() {
        I_CmsLruCacheObject oldTail = this.m_listTail;
        if (oldTail != null) {
            I_CmsLruCacheObject newTail = oldTail.getNextLruObject();
            if (newTail != null) {
                newTail.setPreviousLruObject(null);
                this.m_listTail = newTail;
            } else {
                this.m_listTail = null;
                this.m_listHead = null;
            }
            this.decreaseCache(oldTail);
        }
    }
}

