/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AclCapabilities;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityContentStreamUpdates;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CapabilityRenditions;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.SupportedPermissions;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AclCapabilitiesDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionDefinitionDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PermissionMappingDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RepositoryInfoImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.logging.Log;
import org.opencms.cmis.A_CmsCmisRepository;
import org.opencms.cmis.CmsCmisCallContext;
import org.opencms.cmis.CmsCmisRelationHelper;
import org.opencms.cmis.CmsCmisRenditionFilter;
import org.opencms.cmis.CmsCmisResourceHelper;
import org.opencms.cmis.CmsCmisTypeManager;
import org.opencms.cmis.CmsCmisUtil;
import org.opencms.cmis.CmsObjectListLimiter;
import org.opencms.cmis.I_CmsCmisObjectHelper;
import org.opencms.cmis.I_CmsCmisRenditionProvider;
import org.opencms.cmis.I_CmsPropertyProvider;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.repository.CmsRepositoryFilter;
import org.opencms.search.CmsSearchException;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.search.solr.CmsSolrResultList;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsCmisRepository
extends A_CmsCmisRepository {
    public static final String PARAM_DESCRIPTION = "description";
    public static final String PARAM_PROJECT = "project";
    public static final String PARAM_PROPERTY = "property";
    public static final String PARAM_RENDITION = "rendition";
    protected static final Log LOG = CmsLog.getLog(CmsCmisRepository.class);
    private static final String PARAM_INDEX = "index";
    private CmsObject m_adminCms;
    private String m_description;
    private CmsRepositoryFilter m_filter;
    private String m_id;
    private String m_indexName;
    private boolean m_isReadOnly;
    private CmsParameterConfiguration m_parameterConfiguration = new CmsParameterConfiguration();
    private CmsProject m_project;
    private List<I_CmsPropertyProvider> m_propertyProviders = new ArrayList<I_CmsPropertyProvider>();
    private CmsCmisRelationHelper m_relationHelper = new CmsCmisRelationHelper(this);
    private Map<String, I_CmsCmisRenditionProvider> m_renditionProviders = new HashMap<String, I_CmsCmisRenditionProvider>();
    private CmsCmisResourceHelper m_resourceHelper = new CmsCmisResourceHelper(this);
    private CmsResource m_root;

    private static PermissionDefinition createPermission(String permission, String description) {
        PermissionDefinitionDataImpl pd = new PermissionDefinitionDataImpl();
        pd.setId(permission);
        pd.setDescription(description);
        return pd;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_parameterConfiguration.add(paramName, paramValue);
    }

    @Override
    public synchronized String createDocument(CmsCmisCallContext context, Properties propertiesObj, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces) {
        this.checkWriteAccess();
        if (addAces != null || removeAces != null) {
            throw new CmisConstraintException("createDocument: ACEs not allowed");
        }
        if (contentStream == null) {
            throw new CmisConstraintException("createDocument: no content stream given");
        }
        try {
            CmsObject cms = this.getCmsObject(context);
            Map properties = propertiesObj.getProperties();
            String newDocName = (String)((PropertyData)properties.get("cmis:name")).getFirstValue();
            String defaultType = OpenCms.getResourceManager().getDefaultTypeForName(newDocName).getTypeName();
            String resTypeName = this.getResourceTypeFromProperties(properties, defaultType);
            I_CmsResourceType cmsResourceType = OpenCms.getResourceManager().getResourceType(resTypeName);
            if (cmsResourceType.isFolder()) {
                throw new CmisConstraintException("Not a document type: " + resTypeName);
            }
            List<CmsProperty> cmsProperties = this.getOpenCmsProperties(properties);
            CmsCmisUtil.checkResourceName(newDocName);
            InputStream stream = contentStream.getStream();
            byte[] content = CmsFileUtil.readFully(stream);
            CmsUUID parentFolderId = new CmsUUID(folderId);
            CmsResource parentFolder = cms.readResource(parentFolderId);
            String newFolderPath = CmsStringUtil.joinPaths(parentFolder.getRootPath(), newDocName);
            try {
                CmsResource newDocument = cms.createResource(newFolderPath, cmsResourceType.getTypeId(), content, cmsProperties);
                cms.unlockResource(newDocument.getRootPath());
                return newDocument.getStructureId().toString();
            }
            catch (CmsVfsResourceAlreadyExistsException e) {
                throw new CmisNameConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized String createDocumentFromSource(CmsCmisCallContext context, String sourceId, Properties propertiesObj, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces) {
        this.checkWriteAccess();
        if (addAces != null || removeAces != null) {
            throw new CmisConstraintException("createDocument: ACEs not allowed");
        }
        try {
            String newDocName;
            CmsObject cms = this.getCmsObject(context);
            Map<String, Object> properties = new HashMap();
            if (propertiesObj != null) {
                properties = propertiesObj.getProperties();
            }
            List<CmsProperty> cmsProperties = this.getOpenCmsProperties(properties);
            CmsUUID parentFolderId = new CmsUUID(folderId);
            CmsResource parentFolder = cms.readResource(parentFolderId);
            CmsUUID sourceUuid = new CmsUUID(sourceId);
            CmsResource source = cms.readResource(sourceUuid);
            String sourcePath = source.getRootPath();
            PropertyData nameProp = (PropertyData)properties.get("cmis:name");
            if (nameProp != null) {
                newDocName = (String)nameProp.getFirstValue();
                CmsCmisUtil.checkResourceName(newDocName);
            } else {
                newDocName = CmsResource.getName(source.getRootPath());
            }
            String targetPath = CmsStringUtil.joinPaths(parentFolder.getRootPath(), newDocName);
            try {
                cms.copyResource(sourcePath, targetPath);
            }
            catch (CmsVfsResourceAlreadyExistsException e) {
                throw new CmisNameConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
            }
            CmsResource targetResource = cms.readResource(targetPath);
            cms.setDateLastModified(targetResource.getRootPath(), targetResource.getDateCreated(), false);
            cms.unlockResource(targetResource);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, targetResource);
            cms.writePropertyObjects(targetResource, cmsProperties);
            for (String key : properties.keySet()) {
                if (!key.startsWith("opencms-dynamic:")) continue;
                I_CmsPropertyProvider provider = this.getTypeManager().getPropertyProvider(key);
                try {
                    String value = (String)((PropertyData)properties.get(key)).getFirstValue();
                    provider.setPropertyValue(cms, targetResource, value);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (wasLocked) {
                cms.unlockResource(targetResource);
            }
            return targetResource.getStructureId().toString();
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized String createFolder(CmsCmisCallContext context, Properties propertiesObj, String folderId, List<String> policies, Acl addAces, Acl removeAces) {
        this.checkWriteAccess();
        if (addAces != null || removeAces != null) {
            throw new CmisConstraintException("createFolder: ACEs not allowed");
        }
        try {
            CmsObject cms = this.getCmsObject(context);
            Map properties = propertiesObj.getProperties();
            String resTypeName = this.getResourceTypeFromProperties(properties, CmsResourceTypeFolder.getStaticTypeName());
            I_CmsResourceType cmsResourceType = OpenCms.getResourceManager().getResourceType(resTypeName);
            if (!cmsResourceType.isFolder()) {
                throw new CmisConstraintException("Invalid folder type: " + resTypeName);
            }
            List<CmsProperty> cmsProperties = this.getOpenCmsProperties(properties);
            String newFolderName = (String)((PropertyData)properties.get("cmis:name")).getFirstValue();
            CmsCmisUtil.checkResourceName(newFolderName);
            CmsUUID parentFolderId = new CmsUUID(folderId);
            CmsResource parentFolder = cms.readResource(parentFolderId);
            String newFolderPath = CmsStringUtil.joinPaths(parentFolder.getRootPath(), newFolderName);
            try {
                CmsResource newFolder = cms.createResource(newFolderPath, cmsResourceType.getTypeId(), null, cmsProperties);
                cms.unlockResource(newFolder);
                return newFolder.getStructureId().toString();
            }
            catch (CmsVfsResourceAlreadyExistsException e) {
                throw new CmisNameConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String createRelationship(CmsCmisCallContext context, Properties properties, List<String> policies, Acl addAces, Acl removeAces) {
        String string;
        block7: {
            CmsObject cms = this.getCmsObject(context);
            Map propertyMap = properties.getProperties();
            String sourceProp = (String)((PropertyData)propertyMap.get("cmis:sourceId")).getFirstValue();
            String targetProp = (String)((PropertyData)propertyMap.get("cmis:targetId")).getFirstValue();
            String typeId = (String)((PropertyData)propertyMap.get("cmis:objectTypeId")).getFirstValue();
            if (!typeId.startsWith("opencms:")) {
                throw new CmisConstraintException("Can't create this relationship type.");
            }
            String cmsTypeName = typeId.substring("opencms:".length());
            CmsUUID sourceId = new CmsUUID(sourceProp);
            CmsUUID targetId = new CmsUUID(targetProp);
            CmsResource sourceRes = cms.readResource(sourceId);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, sourceRes);
            try {
                CmsResource targetRes = cms.readResource(targetId);
                cms.addRelationToResource(sourceRes.getRootPath(), targetRes.getRootPath(), cmsTypeName);
                string = "REL_" + sourceRes.getStructureId() + "_" + targetRes.getStructureId() + "_" + cmsTypeName;
                if (!wasLocked) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (wasLocked) {
                        cms.unlockResource(sourceRes);
                    }
                    throw throwable;
                }
                catch (CmsException e) {
                    CmsCmisUtil.handleCmsException(e);
                    return null;
                }
            }
            cms.unlockResource(sourceRes);
        }
        return string;
    }

    @Override
    public synchronized void deleteContentStream(CmsCmisCallContext context, Holder<String> objectId, Holder<String> changeToken) {
        throw new CmisConstraintException("Content streams may not be deleted.");
    }

    @Override
    public synchronized void deleteObject(CmsCmisCallContext context, String objectId, boolean allVersions) {
        this.checkWriteAccess();
        this.getHelper(objectId).deleteObject(context, objectId, allVersions);
    }

    @Override
    public synchronized FailedToDeleteData deleteTree(CmsCmisCallContext context, String folderId, boolean allVersions, UnfileObject unfileObjects, boolean continueOnFailure) {
        this.checkWriteAccess();
        try {
            FailedToDeleteDataImpl result = new FailedToDeleteDataImpl();
            result.setIds(new ArrayList());
            CmsObject cms = this.getCmsObject(context);
            CmsUUID structureId = new CmsUUID(folderId);
            CmsResource folder = cms.readResource(structureId);
            if (!folder.isFolder()) {
                throw new CmisConstraintException("deleteTree can only be used on folders.");
            }
            CmsCmisUtil.ensureLock(cms, folder);
            cms.deleteResource(folder.getRootPath(), CmsResource.DELETE_PRESERVE_SIBLINGS);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized Acl getAcl(CmsCmisCallContext context, String objectId, boolean onlyBasicPermissions) {
        return this.getHelper(objectId).getAcl(context, objectId, onlyBasicPermissions);
    }

    @Override
    public synchronized AllowableActions getAllowableActions(CmsCmisCallContext context, String objectId) {
        return this.getHelper(objectId).getAllowableActions(context, objectId);
    }

    @Override
    public synchronized ObjectList getCheckedOutDocs(CmsCmisCallContext context, String folderId, String filter, String orderBy, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        ObjectListImpl result = new ObjectListImpl();
        result.setObjects(new ArrayList());
        return result;
    }

    @Override
    public synchronized ObjectInFolderList getChildren(CmsCmisCallContext context, String folderId, String filter, String orderBy, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePathSegment, BigInteger maxItems, BigInteger skipCount) {
        try {
            CmsUUID structureId;
            CmsObject cms;
            CmsResource folder;
            int max;
            int skip;
            CmsCmisResourceHelper helper = this.getResourceHelper();
            Set<String> filterCollection = CmsCmisUtil.splitFilter(filter);
            int n = skip = skipCount == null ? 0 : skipCount.intValue();
            if (skip < 0) {
                skip = 0;
            }
            int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
            if (max < 0) {
                max = Integer.MAX_VALUE;
            }
            if (!(folder = (cms = this.getCmsObject(context)).readResource(structureId = new CmsUUID(folderId))).isFolder()) {
                throw new CmisObjectNotFoundException("Not a folder!");
            }
            if (context.isObjectInfoRequired()) {
                helper.collectObjectData(context, cms, folder, null, renditionFilter, false, false, includeRelationships);
            }
            ObjectInFolderListImpl result = new ObjectInFolderListImpl();
            String folderSitePath = cms.getRequestContext().getSitePath(folder);
            List<CmsResource> children = cms.getResourcesInFolder(folderSitePath, CmsResourceFilter.DEFAULT);
            CmsObjectListLimiter<CmsResource> limiter = new CmsObjectListLimiter<CmsResource>(children, maxItems, skipCount);
            ArrayList<ObjectInFolderDataImpl> resultObjects = new ArrayList<ObjectInFolderDataImpl>();
            for (CmsResource child : limiter) {
                ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
                objectInFolder.setObject(helper.collectObjectData(context, cms, child, filterCollection, renditionFilter, includeAllowableActions, false, includeRelationships));
                if (includePathSegment) {
                    objectInFolder.setPathSegment(child.getName());
                }
                resultObjects.add(objectInFolder);
            }
            result.setObjects(resultObjects);
            result.setNumItems(BigInteger.valueOf(children.size()));
            result.setHasMoreItems(Boolean.valueOf(limiter.hasMore()));
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_parameterConfiguration;
    }

    @Override
    public synchronized ContentStream getContentStream(CmsCmisCallContext context, String objectId, String streamId, BigInteger offset, BigInteger length) {
        try {
            CmsObject cms = this.getCmsObject(context);
            CmsResource resource = cms.readResource(new CmsUUID(objectId));
            byte[] contents = null;
            if (streamId != null) {
                I_CmsCmisRenditionProvider renditionProvider = this.m_renditionProviders.get(streamId);
                if (renditionProvider == null) {
                    throw new CmisRuntimeException("Invalid stream id " + streamId);
                }
                contents = renditionProvider.getContent(cms, resource);
            } else {
                if (resource.isFolder()) {
                    throw new CmisStreamNotSupportedException("Not a file!");
                }
                CmsFile file = cms.readFile(resource);
                contents = file.getContents();
            }
            contents = this.extractRange(contents, offset, length);
            ByteArrayInputStream stream = new ByteArrayInputStream(contents);
            ContentStreamImpl result = new ContentStreamImpl();
            result.setFileName(resource.getName());
            result.setLength(BigInteger.valueOf(contents.length));
            result.setMimeType(OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "text/plain"));
            result.setStream((InputStream)stream);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized List<ObjectInFolderContainer> getDescendants(CmsCmisCallContext context, String folderId, BigInteger depth, String filter, boolean includeAllowableActions, boolean includePathSegment, boolean foldersOnly) {
        try {
            CmsUUID folderStructureId;
            int d;
            CmsCmisResourceHelper helper = this.getResourceHelper();
            int n = d = depth == null ? 2 : depth.intValue();
            if (d == 0) {
                throw new CmisInvalidArgumentException("Depth must not be 0!");
            }
            if (d < -1) {
                d = -1;
            }
            Set<String> filterCollection = CmsCmisUtil.splitFilter(filter);
            CmsObject cms = this.getCmsObject(context);
            CmsResource folder = cms.readResource(folderStructureId = new CmsUUID(folderId));
            if (!folder.isFolder()) {
                throw new CmisObjectNotFoundException("Not a folder!");
            }
            if (context.isObjectInfoRequired()) {
                helper.collectObjectData(context, cms, folder, null, "cmis:none", false, false, IncludeRelationships.NONE);
            }
            ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
            this.gatherDescendants(context, cms, folder, result, foldersOnly, d, filterCollection, includeAllowableActions, includePathSegment);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        if (this.m_project != null) {
            return this.m_project.getDescription();
        }
        return this.m_id;
    }

    @Override
    public CmsRepositoryFilter getFilter() {
        return this.m_filter;
    }

    @Override
    public synchronized ObjectData getFolderParent(CmsCmisCallContext context, String folderId, String filter) {
        List<ObjectParentData> parents = this.getObjectParents(context, folderId, filter, false, false);
        if (parents.size() == 0) {
            throw new CmisInvalidArgumentException("The root folder has no parent!");
        }
        return parents.get(0).getObject();
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getName() {
        return this.m_id;
    }

    @Override
    public synchronized ObjectData getObject(CmsCmisCallContext context, String objectId, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        return this.getHelper(objectId).getObject(context, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl);
    }

    @Override
    public synchronized ObjectData getObjectByPath(CmsCmisCallContext context, String path, String filter, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, boolean includePolicyIds, boolean includeAcl) {
        try {
            CmsCmisResourceHelper helper = this.getResourceHelper();
            Set<String> filterCollection = CmsCmisUtil.splitFilter(filter);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) {
                throw new CmisInvalidArgumentException("Invalid folder path!");
            }
            CmsObject cms = this.getCmsObject(context);
            CmsResource file = cms.readResource(path);
            return helper.collectObjectData(context, cms, file, filterCollection, renditionFilter, includeAllowableActions, includeAcl, IncludeRelationships.NONE);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized List<ObjectParentData> getObjectParents(CmsCmisCallContext context, String objectId, String filter, boolean includeAllowableActions, boolean includeRelativePathSegment) {
        try {
            CmsCmisResourceHelper helper = this.getResourceHelper();
            Set<String> filterCollection = CmsCmisUtil.splitFilter(filter);
            CmsObject cms = this.getCmsObject(context);
            CmsUUID structureId = new CmsUUID(objectId);
            CmsResource file = cms.readResource(structureId);
            if (this.m_root.equals(file)) {
                return Collections.emptyList();
            }
            if (context.isObjectInfoRequired()) {
                helper.collectObjectData(context, cms, file, null, "cmis:none", false, false, IncludeRelationships.NONE);
            }
            CmsResource parent = cms.readParentFolder(file.getStructureId());
            ObjectData object = helper.collectObjectData(context, cms, parent, filterCollection, "cmis:none", includeAllowableActions, false, IncludeRelationships.NONE);
            ObjectParentDataImpl result = new ObjectParentDataImpl();
            result.setObject(object);
            if (includeRelativePathSegment) {
                result.setRelativePathSegment(file.getName());
            }
            return Collections.singletonList(result);
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized ObjectList getObjectRelationships(CmsCmisCallContext context, String objectId, boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount) {
        try {
            CmsObject cms = this.getCmsObject(context);
            ObjectListImpl result = new ObjectListImpl();
            CmsUUID structureId = new CmsUUID(objectId);
            CmsResource resource = cms.readResource(structureId);
            List<ObjectData> resultObjects = this.getRelationshipObjectData(context, cms, resource, relationshipDirection, CmsCmisUtil.splitFilter(filter), includeAllowableActions);
            CmsObjectListLimiter<ObjectData> limiter = new CmsObjectListLimiter<ObjectData>(resultObjects, maxItems, skipCount);
            ArrayList<ObjectData> limitedResults = new ArrayList<ObjectData>();
            for (ObjectData objectData : limiter) {
                limitedResults.add(objectData);
            }
            result.setNumItems(BigInteger.valueOf(resultObjects.size()));
            result.setHasMoreItems(Boolean.valueOf(limiter.hasMore()));
            result.setObjects(limitedResults);
            return result;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized Properties getProperties(CmsCmisCallContext context, String objectId, String filter) {
        ObjectData object = this.getObject(context, objectId, null, false, null, null, false, false);
        return object.getProperties();
    }

    @Override
    public synchronized List<RenditionData> getRenditions(CmsCmisCallContext context, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        try {
            CmsObject cms = this.getCmsObject(context);
            CmsResource resource = cms.readResource(new CmsUUID(objectId));
            return this.getResourceHelper().collectObjectData(context, cms, resource, null, renditionFilter, false, false, IncludeRelationships.NONE).getRenditions();
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized RepositoryInfo getRepositoryInfo() {
        RepositoryInfoImpl repositoryInfo = new RepositoryInfoImpl();
        repositoryInfo.setId(this.m_id);
        repositoryInfo.setName(this.getName());
        repositoryInfo.setDescription(this.getDescription());
        repositoryInfo.setCmisVersionSupported("1.0");
        repositoryInfo.setProductName("OpenCms");
        repositoryInfo.setProductVersion(OpenCms.getSystemInfo().getVersion());
        repositoryInfo.setVendorName("Alkacon Software GmbH & Co. KG");
        repositoryInfo.setRootFolder(this.m_root.getStructureId().toString());
        repositoryInfo.setThinClientUri("");
        repositoryInfo.setPrincipalAnonymous(OpenCms.getDefaultUsers().getUserGuest());
        repositoryInfo.setChangesIncomplete(Boolean.TRUE);
        RepositoryCapabilitiesImpl capabilities = new RepositoryCapabilitiesImpl();
        capabilities.setCapabilityAcl(CapabilityAcl.DISCOVER);
        capabilities.setAllVersionsSearchable(Boolean.FALSE);
        capabilities.setCapabilityJoin(CapabilityJoin.NONE);
        capabilities.setSupportsMultifiling(Boolean.FALSE);
        capabilities.setSupportsUnfiling(Boolean.FALSE);
        capabilities.setSupportsVersionSpecificFiling(Boolean.FALSE);
        capabilities.setIsPwcSearchable(Boolean.FALSE);
        capabilities.setIsPwcUpdatable(Boolean.FALSE);
        capabilities.setCapabilityQuery(this.getIndex() != null ? CapabilityQuery.FULLTEXTONLY : CapabilityQuery.NONE);
        capabilities.setCapabilityChanges(CapabilityChanges.NONE);
        capabilities.setCapabilityContentStreamUpdates(CapabilityContentStreamUpdates.ANYTIME);
        capabilities.setSupportsGetDescendants(Boolean.TRUE);
        capabilities.setSupportsGetFolderTree(Boolean.TRUE);
        capabilities.setCapabilityRendition(CapabilityRenditions.READ);
        repositoryInfo.setCapabilities((RepositoryCapabilities)capabilities);
        AclCapabilitiesDataImpl aclCapability = new AclCapabilitiesDataImpl();
        aclCapability.setSupportedPermissions(SupportedPermissions.BOTH);
        aclCapability.setAclPropagation(AclPropagation.REPOSITORYDETERMINED);
        ArrayList<PermissionDefinition> permissions = new ArrayList<PermissionDefinition>();
        permissions.add(CmsCmisRepository.createPermission("cmis:read", "Read"));
        permissions.add(CmsCmisRepository.createPermission("cmis:write", "Write"));
        permissions.add(CmsCmisRepository.createPermission("cmis:all", "All"));
        aclCapability.setPermissionDefinitionData(permissions);
        PermissionMappings m = new PermissionMappings();
        m.add("canCreateDocument.Folder", "cmis:write");
        m.add("canCreateFolder.Folder", "cmis:write");
        m.add("canDeleteContent.Document", "cmis:write");
        m.add("canDelete.Object", "cmis:write");
        m.add("canDeleteTree.Folder", "cmis:write");
        m.add("canGetACL.Object", "cmis:read");
        m.add("canGetAllVersions.VersionSeries", "cmis:read");
        m.add("canGetChildren.Folder", "cmis:read");
        m.add("canGetDescendents.Folder", "cmis:read");
        m.add("canGetFolderParent.Object", "cmis:read");
        m.add("canGetParents.Folder", "cmis:read");
        m.add("canGetProperties.Object", "cmis:read");
        m.add("canMove.Object", "cmis:write");
        m.add("canMove.Source", "cmis:write");
        m.add("canMove.Target", "cmis:write");
        m.add("canSetContent.Document", "cmis:write");
        m.add("canUpdateProperties.Object", "cmis:write");
        m.add("canViewContent.Object", "cmis:read");
        aclCapability.setPermissionMappingData((Map)m);
        repositoryInfo.setAclCapabilities((AclCapabilities)aclCapability);
        return repositoryInfo;
    }

    @Override
    public synchronized TypeDefinitionList getTypeChildren(CmsCmisCallContext context, String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        return this.m_typeManager.getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
    }

    @Override
    public synchronized TypeDefinition getTypeDefinition(CmsCmisCallContext context, String typeId) {
        return this.m_typeManager.getTypeDefinition(typeId);
    }

    @Override
    public synchronized List<TypeDefinitionContainer> getTypeDescendants(CmsCmisCallContext context, String typeId, BigInteger depth, boolean includePropertyDefinitions) {
        return this.m_typeManager.getTypeDescendants(typeId, depth, includePropertyDefinitions);
    }

    @Override
    public void initConfiguration() throws CmsConfigurationException {
        if (this.m_filter != null) {
            this.m_filter.initConfiguration();
        }
        this.m_description = this.m_parameterConfiguration.getString(PARAM_DESCRIPTION, null);
        List<String> renditionProviderClasses = this.m_parameterConfiguration.getList(PARAM_RENDITION, Collections.emptyList());
        for (String className : renditionProviderClasses) {
            try {
                I_CmsCmisRenditionProvider provider = (I_CmsCmisRenditionProvider)Class.forName(className).newInstance();
                String id = provider.getId();
                this.m_renditionProviders.put(id, provider);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
        List<String> propertyProviderClasses = this.m_parameterConfiguration.getList(PARAM_PROPERTY, Collections.emptyList());
        for (String className : propertyProviderClasses) {
            try {
                I_CmsPropertyProvider provider = (I_CmsPropertyProvider)Class.forName(className).newInstance();
                this.m_propertyProviders.add(provider);
            }
            catch (Throwable e) {
                LOG.error((Object)e.getLocalizedMessage(), e);
            }
        }
        this.m_indexName = this.m_parameterConfiguration.getString(PARAM_INDEX, null);
    }

    @Override
    public void initializeCms(CmsObject cms) throws CmsException {
        CmsProject project;
        this.m_adminCms = cms;
        this.m_typeManager = new CmsCmisTypeManager(cms, this.m_propertyProviders);
        String projectName = this.m_parameterConfiguration.getString(PARAM_PROJECT, "Online");
        CmsResource root = this.m_adminCms.readResource("/");
        CmsObject offlineCms = OpenCms.initCmsObject(this.m_adminCms);
        this.m_project = project = this.m_adminCms.readProject(projectName);
        offlineCms.getRequestContext().setCurrentProject(project);
        this.m_adminCms = offlineCms;
        this.m_root = root;
        this.m_isReadOnly = project.isOnlineProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void moveObject(CmsCmisCallContext context, Holder<String> objectId, String targetFolderId, String sourceFolderId) {
        this.checkWriteAccess();
        try {
            CmsObject cms = this.getCmsObject(context);
            CmsUUID structureId = new CmsUUID((String)objectId.getValue());
            CmsUUID targetStructureId = new CmsUUID(targetFolderId);
            CmsResource targetFolder = cms.readResource(targetStructureId);
            CmsResource resourceToMove = cms.readResource(structureId);
            String name = CmsResource.getName(resourceToMove.getRootPath());
            String newPath = CmsStringUtil.joinPaths(targetFolder.getRootPath(), name);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, resourceToMove);
            try {
                cms.moveResource(resourceToMove.getRootPath(), newPath);
            }
            finally {
                if (wasLocked) {
                    CmsResource movedResource = cms.readResource(resourceToMove.getStructureId());
                    cms.unlockResource(movedResource);
                }
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
    }

    @Override
    public synchronized ObjectList query(CmsCmisCallContext context, String statement, boolean searchAllVersions, boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount) {
        try {
            int max;
            int skip;
            CmsObject cms = this.getCmsObject(context);
            CmsSolrIndex index = this.getIndex();
            CmsCmisResourceHelper helper = this.getResourceHelper();
            Set<String> filterCollection = null;
            int n = skip = skipCount == null ? 0 : skipCount.intValue();
            if (skip < 0) {
                skip = 0;
            }
            int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
            if (max < 0) {
                max = Integer.MAX_VALUE;
            }
            CmsSolrResultList results = this.solrSearch(cms, index, statement, skip, max);
            ObjectListImpl resultObjectList = new ObjectListImpl();
            ArrayList<ObjectData> objectDataList = new ArrayList<ObjectData>();
            resultObjectList.setObjects(objectDataList);
            for (CmsResource resource : results) {
                objectDataList.add(helper.collectObjectData(context, cms, resource, filterCollection, renditionFilter, includeAllowableActions, false, includeRelationships));
            }
            resultObjectList.setHasMoreItems(Boolean.valueOf(!results.isEmpty()));
            resultObjectList.setNumItems(BigInteger.valueOf(results.getVisibleHitCount()));
            return resultObjectList;
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
            return null;
        }
    }

    @Override
    public synchronized void setContentStream(CmsCmisCallContext context, Holder<String> objectId, boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream) {
        this.checkWriteAccess();
        try {
            CmsObject cms = this.getCmsObject(context);
            CmsUUID structureId = new CmsUUID((String)objectId.getValue());
            if (!overwriteFlag) {
                throw new CmisContentAlreadyExistsException();
            }
            CmsResource resource = cms.readResource(structureId);
            if (resource.isFolder()) {
                throw new CmisStreamNotSupportedException("Folders may not have content streams.");
            }
            CmsFile file = cms.readFile(resource);
            InputStream contentInput = contentStream.getStream();
            byte[] newContent = CmsFileUtil.readFully(contentInput);
            file.setContents(newContent);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, resource);
            CmsFile newFile = cms.writeFile(file);
            if (wasLocked) {
                cms.unlockResource(newFile);
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void setFilter(CmsRepositoryFilter filter) {
        this.m_filter = filter;
        LOG.warn((Object)"Filters not supported by CMIS repositories, ignoring configuration...");
    }

    @Override
    public void setName(String name) {
        this.m_id = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateProperties(CmsCmisCallContext context, Holder<String> objectId, Holder<String> changeToken, Properties properties) {
        this.checkWriteAccess();
        try {
            CmsObject cms = this.getCmsObject(context);
            CmsUUID structureId = new CmsUUID((String)objectId.getValue());
            CmsResource resource = cms.readResource(structureId);
            Map propertyMap = properties.getProperties();
            List<CmsProperty> cmsProperties = this.getOpenCmsProperties(propertyMap);
            boolean wasLocked = CmsCmisUtil.ensureLock(cms, resource);
            try {
                cms.writePropertyObjects(resource, cmsProperties);
                PropertyData nameProperty = (PropertyData)propertyMap.get("cmis:name");
                if (nameProperty != null) {
                    String newName = (String)nameProperty.getFirstValue();
                    CmsCmisUtil.checkResourceName(newName);
                    String parentFolder = CmsResource.getParentFolder(resource.getRootPath());
                    String newPath = CmsStringUtil.joinPaths(parentFolder, newName);
                    cms.moveResource(resource.getRootPath(), newPath);
                    resource = cms.readResource(resource.getStructureId());
                }
                for (String key : properties.getProperties().keySet()) {
                    if (!key.startsWith("opencms-dynamic:")) continue;
                    I_CmsPropertyProvider provider = this.getTypeManager().getPropertyProvider(key);
                    try {
                        String value = (String)((PropertyData)properties.getProperties().get(key)).getFirstValue();
                        provider.setPropertyValue(cms, resource, value);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                if (wasLocked) {
                    cms.unlockResource(resource);
                }
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
    }

    protected void checkWriteAccess() {
        if (this.m_isReadOnly) {
            throw new CmisNotSupportedException("Readonly repository '" + this.m_id + "' does not allow write operations.");
        }
    }

    protected CmsObject getCmsObject(CmsCmisCallContext context) {
        try {
            if (context.getUsername() == null) {
                CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                cms.getRequestContext().setCurrentProject(this.m_adminCms.getRequestContext().getCurrentProject());
                return cms;
            }
            CmsObject cms = OpenCms.initCmsObject(this.m_adminCms);
            CmsProject projectBeforeLogin = cms.getRequestContext().getCurrentProject();
            cms.loginUser(context.getUsername(), context.getPassword());
            cms.getRequestContext().setCurrentProject(projectBeforeLogin);
            return cms;
        }
        catch (CmsException e) {
            throw new CmisPermissionDeniedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected List<ObjectData> getRelationshipObjectData(CmsCmisCallContext context, CmsObject cms, CmsResource resource, RelationshipDirection relationshipDirection, Set<String> filterSet, boolean includeAllowableActions) throws CmsException {
        ArrayList<ObjectData> resultObjects = new ArrayList<ObjectData>();
        CmsRelationFilter relationFilter = relationshipDirection == RelationshipDirection.SOURCE ? CmsRelationFilter.TARGETS : (relationshipDirection == RelationshipDirection.TARGET ? CmsRelationFilter.SOURCES : CmsRelationFilter.ALL);
        List<CmsRelation> unfilteredRelations = cms.getRelationsForResource(resource.getRootPath(), relationFilter);
        ArrayList<CmsRelation> relations = new ArrayList<CmsRelation>();
        for (CmsRelation relation : unfilteredRelations) {
            if (relation.getTargetId().isNullUUID() || relation.getSourceId().isNullUUID()) continue;
            relations.add(relation);
        }
        CmsCmisRelationHelper helper = this.getRelationHelper();
        for (CmsRelation relation : relations) {
            ObjectData objData = helper.collectObjectData(context, cms, resource, relation, filterSet, includeAllowableActions, false);
            resultObjects.add(objData);
        }
        return resultObjects;
    }

    protected List<I_CmsCmisRenditionProvider> getRenditionProviders(CmsCmisRenditionFilter filter) {
        ArrayList<I_CmsCmisRenditionProvider> result = new ArrayList<I_CmsCmisRenditionProvider>();
        for (I_CmsCmisRenditionProvider provider : this.m_renditionProviders.values()) {
            String mimetype = provider.getMimeType();
            String kind = provider.getKind();
            if (!filter.accept(kind, mimetype)) continue;
            result.add(provider);
        }
        return result;
    }

    protected String getResourceTypeFromProperties(Map<String, PropertyData<?>> properties, String defaultValue) {
        PropertyData<?> typeProp = properties.get("opencms-special:resource-type");
        String resTypeName = defaultValue;
        if (typeProp != null) {
            resTypeName = (String)typeProp.getFirstValue();
        }
        return resTypeName;
    }

    protected CmsCmisTypeManager getTypeManager() {
        return this.m_typeManager;
    }

    I_CmsCmisObjectHelper getHelper(String objectId) {
        if (CmsUUID.isValidUUID(objectId)) {
            return this.getResourceHelper();
        }
        if (CmsCmisRelationHelper.RELATION_PATTERN.matcher(objectId).matches()) {
            return this.getRelationHelper();
        }
        return null;
    }

    CmsSolrResultList solrSearch(CmsObject cms, CmsSolrIndex index, String query, int start, int rows) throws CmsSearchException {
        CmsSolrQuery q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(query));
        q.setStart(new Integer(start));
        q.setRows(new Integer(rows));
        CmsSolrResultList resultPage = index.search(cms, q, true);
        return resultPage;
    }

    private void gatherDescendants(CmsCmisCallContext context, CmsObject cms, CmsResource folder, List<ObjectInFolderContainer> list, boolean foldersOnly, int depth, Set<String> filter, boolean includeAllowableActions, boolean includePathSegments) {
        try {
            CmsCmisResourceHelper helper = this.getResourceHelper();
            List<CmsResource> children = cms.getResourcesInFolder(cms.getSitePath(folder), CmsResourceFilter.DEFAULT);
            Collections.sort(children, new Comparator<CmsResource>(){

                @Override
                public int compare(CmsResource a, CmsResource b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            for (CmsResource child : children) {
                if (foldersOnly && !child.isFolder()) continue;
                ObjectInFolderDataImpl objectInFolder = new ObjectInFolderDataImpl();
                objectInFolder.setObject(helper.collectObjectData(context, cms, child, filter, "cmis:none", includeAllowableActions, false, IncludeRelationships.NONE));
                if (includePathSegments) {
                    objectInFolder.setPathSegment(child.getName());
                }
                ObjectInFolderContainerImpl container = new ObjectInFolderContainerImpl();
                container.setObject((ObjectInFolderData)objectInFolder);
                list.add((ObjectInFolderContainer)container);
                if (depth == 1 || !child.isFolder()) continue;
                container.setChildren(new ArrayList());
                this.gatherDescendants(context, cms, child, container.getChildren(), foldersOnly, depth - 1, filter, includeAllowableActions, includePathSegments);
            }
        }
        catch (CmsException e) {
            CmsCmisUtil.handleCmsException(e);
        }
    }

    private CmsSolrIndex getIndex() {
        String indexName = this.m_indexName;
        if (indexName == null) {
            return null;
        }
        return OpenCms.getSearchManager().getIndexSolr(indexName);
    }

    private CmsCmisRelationHelper getRelationHelper() {
        return this.m_relationHelper;
    }

    private CmsCmisResourceHelper getResourceHelper() {
        return this.m_resourceHelper;
    }

    private static class PermissionMappings
    extends HashMap<String, PermissionMapping> {
        private static PermissionMapping createMapping(String key, String permission) {
            PermissionMappingDataImpl pm = new PermissionMappingDataImpl();
            pm.setKey(key);
            pm.setPermissions(Collections.singletonList(permission));
            return pm;
        }

        public PermissionMappings add(String key, String permission) {
            this.put(key, PermissionMappings.createMapping(key, permission));
            return this;
        }
    }
}

