/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.digester3.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.i18n.CmsLocaleComparator;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchAnalyzer;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.I_CmsSearchIndex;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsLuceneFieldConfiguration;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldConfiguration;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrConfiguration;
import org.opencms.util.CmsStringUtil;

public class CmsSearchConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_ANALYZER = "analyzer";
    public static final String A_BOOST = "boost";
    public static final String A_DISPLAY = "display";
    public static final String A_EXCERPT = "excerpt";
    public static final String A_INDEX = "index";
    public static final String A_SERVER_URL = "serverUrl";
    public static final String A_STORE = "store";
    public static final String CONFIGURATION_DTD_NAME = "opencms-search.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-search.xml";
    public static final String N_ANALYZER = "analyzer";
    public static final String N_ANALYZERS = "analyzers";
    public static final String N_CLASS = "class";
    public static final String N_COMMIT_MS = "commitWithinMs";
    public static final String N_CONFIG_FILE = "configfile";
    public static final String N_CONFIGURATION = "configuration";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DIRECTORY = "directory";
    public static final String N_DOCUMENTTYPE = "documenttype";
    public static final String N_DOCUMENTTYPES = "documenttypes";
    public static final String N_DOCUMENTTYPES_INDEXED = "documenttypes-indexed";
    public static final String N_EXCERPT = "excerpt";
    public static final String N_EXTRACTION_CACHE_MAX_AGE = "extractionCacheMaxAge";
    public static final String N_FIELD = "field";
    public static final String N_FIELDCONFIGURATION = "fieldconfiguration";
    public static final String N_FIELDCONFIGURATIONS = "fieldconfigurations";
    public static final String N_FIELDS = "fields";
    public static final String N_FORCEUNLOCK = "forceunlock";
    public static final String N_HIGHLIGHTER = "highlighter";
    public static final String N_HOME = "home";
    public static final String N_INDEX = "index";
    public static final String N_INDEXER = "indexer";
    public static final String N_INDEXES = "indexes";
    public static final String N_INDEXSOURCE = "indexsource";
    public static final String N_INDEXSOURCES = "indexsources";
    public static final String N_LOCALE = "locale";
    public static final String N_MAPPING = "mapping";
    public static final String N_MAX_MODIFICATIONS_BEFORE_COMMIT = "maxModificationsBeforeCommit";
    public static final String N_MIMETYPE = "mimetype";
    public static final String N_MIMETYPES = "mimetypes";
    public static final String N_OFFLINE_UPDATE_FREQUENCY = "offlineUpdateFrequency";
    public static final String N_MAX_INDEX_WAIT_TIME = "maxIndexWaitTime";
    public static final String N_PROJECT = "project";
    public static final String N_REBUILD = "rebuild";
    public static final String N_RESOURCES = "resources";
    public static final String N_RESOURCETYPE = "resourcetype";
    public static final String N_RESOURCETYPES = "resourcetypes";
    public static final String N_SEARCH = "search";
    public static final String N_SOLR = "solr";
    public static final String N_SOURCE = "source";
    public static final String N_SOURCES = "sources";
    public static final String N_STEMMER = "stemmer";
    public static final String N_TIMEOUT = "timeout";
    private static final String XPATH_SEARCH = "*/search";
    private static final String N_MAX_PROCESSED_RESULTS = "maxProcessedResults";
    private CmsSearchManager m_searchManager;

    @Override
    public void addXmlDigesterRules(Digester digester) {
        String xPath = null;
        digester.addCallMethod(XPATH_SEARCH, "initializeFinished");
        digester.addObjectCreate(XPATH_SEARCH, CmsSearchManager.class.getName(), N_CLASS);
        digester.addSetNext(XPATH_SEARCH, "setSearchManager");
        digester.addCallMethod("*/search/directory", "setDirectory", 0);
        digester.addCallMethod("*/search/timeout", "setTimeout", 0);
        digester.addCallMethod("*/search/offlineUpdateFrequency", "setOfflineUpdateFrequency", 0);
        digester.addCallMethod("*/search/maxIndexWaitTime", "setMaxIndexWaitTime", 0);
        digester.addCallMethod("*/search/forceunlock", "setForceunlock", 0);
        digester.addCallMethod("*/search/excerpt", "setMaxExcerptLength", 0);
        digester.addCallMethod("*/search/extractionCacheMaxAge", "setExtractionCacheMaxAge", 0);
        digester.addCallMethod("*/search/maxModificationsBeforeCommit", "setMaxModificationsBeforeCommit", 0);
        digester.addCallMethod("*/search/highlighter", "setHighlighter", 0);
        xPath = "*/search/solr";
        digester.addObjectCreate(xPath, CmsSolrConfiguration.class);
        digester.addCallMethod(xPath, "setEnabled", 1);
        digester.addCallParam(xPath, 0, "enabled");
        digester.addCallMethod(xPath, "setServerUrl", 1);
        digester.addCallParam(xPath, 0, A_SERVER_URL);
        digester.addCallMethod(xPath + "/" + N_HOME, "setHomeFolderPath", 0);
        digester.addCallMethod(xPath + "/" + N_CONFIG_FILE, "setSolrFileName", 0);
        digester.addCallMethod(xPath + "/" + N_COMMIT_MS, "setSolrCommitMs", 0);
        digester.addCallMethod(xPath + "/" + N_MAX_PROCESSED_RESULTS, "setMaxProcessedResults", 0);
        digester.addSetNext(xPath, "setSolrServerConfiguration");
        xPath = "*/search/documenttypes/documenttype";
        digester.addObjectCreate(xPath, CmsSearchDocumentType.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_CLASS, "setClassName", 0);
        digester.addCallMethod(xPath + "/" + N_MIMETYPES + "/" + N_MIMETYPE, "addMimeType", 0);
        digester.addCallMethod(xPath + "/" + N_RESOURCETYPES + "/" + N_RESOURCETYPE, "addResourceType", 0);
        digester.addSetNext(xPath, "addDocumentTypeConfig");
        xPath = "*/search/analyzers/analyzer";
        digester.addObjectCreate(xPath, CmsSearchAnalyzer.class);
        digester.addCallMethod(xPath + "/" + N_CLASS, "setClassName", 0);
        digester.addCallMethod(xPath + "/" + N_STEMMER, "setStemmerAlgorithm", 0);
        digester.addCallMethod(xPath + "/" + N_LOCALE, "setLocaleString", 0);
        digester.addSetNext(xPath, "addAnalyzer");
        xPath = "*/search/indexes/index";
        digester.addObjectCreate(xPath, CmsSearchIndex.class.getName(), N_CLASS);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_REBUILD, "setRebuildMode", 0);
        digester.addCallMethod(xPath + "/" + N_PROJECT, "setProject", 0);
        digester.addCallMethod(xPath + "/" + N_LOCALE, "setLocaleString", 0);
        digester.addCallMethod(xPath + "/" + N_CONFIGURATION, "setFieldConfigurationName", 0);
        digester.addCallMethod(xPath + "/" + N_SOURCES + "/" + N_SOURCE, "addSourceName", 0);
        digester.addSetNext(xPath, "addSearchIndex");
        xPath = "*/search/indexsources/indexsource";
        digester.addObjectCreate(xPath, CmsSearchIndexSource.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_INDEXER, "setIndexerClassName", 1);
        digester.addCallParam(xPath + "/" + N_INDEXER, 0, N_CLASS);
        digester.addCallMethod(xPath + "/" + N_RESOURCES + "/" + "resource", "addResourceName", 0);
        digester.addCallMethod(xPath + "/" + N_DOCUMENTTYPES_INDEXED + "/" + "name", "addDocumentType", 0);
        digester.addSetNext(xPath, "addSearchIndexSource");
        xPath = "*/search/fieldconfigurations/fieldconfiguration";
        digester.addObjectCreate(xPath, CmsLuceneFieldConfiguration.class.getName(), N_CLASS);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_DESCRIPTION, "setDescription", 0);
        digester.addSetNext(xPath, "addFieldConfiguration");
        xPath = xPath + "/" + N_FIELDS + "/" + N_FIELD;
        digester.addObjectCreate(xPath, CmsLuceneField.class);
        digester.addSetNext(xPath, "addField");
        digester.addCallMethod(xPath, "setName", 1);
        digester.addCallParam(xPath, 0, "name");
        digester.addCallMethod(xPath, "setDisplayNameForConfiguration", 1);
        digester.addCallParam(xPath, 0, A_DISPLAY);
        digester.addCallMethod(xPath, "setStored", 1);
        digester.addCallParam(xPath, 0, A_STORE);
        digester.addCallMethod(xPath, "setIndexed", 1);
        digester.addCallParam(xPath, 0, "index");
        digester.addCallMethod(xPath, "setInExcerpt", 1);
        digester.addCallParam(xPath, 0, "excerpt");
        digester.addCallMethod(xPath, "setAnalyzer", 1);
        digester.addCallParam(xPath, 0, "analyzer");
        digester.addCallMethod(xPath, "setBoost", 1);
        digester.addCallParam(xPath, 0, A_BOOST);
        digester.addCallMethod(xPath, "setDefaultValue", 1);
        digester.addCallParam(xPath, 0, "default");
        digester.addCallMethod(xPath, "setType", 1);
        digester.addCallParam(xPath, 0, "type");
        xPath = xPath + "/" + N_MAPPING;
        digester.addObjectCreate(xPath, CmsSearchFieldMapping.class.getName(), N_CLASS);
        digester.addCallMethod(xPath, "setDefaultValue", 1);
        digester.addCallParam(xPath, 0, "default");
        digester.addCallMethod(xPath, "setType", 1);
        digester.addCallParam(xPath, 0, "type");
        digester.addCallMethod(xPath, "setParam", 0);
        digester.addSetNext(xPath, "addMapping");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
    }

    @Override
    public Element generateXml(Element parent) {
        Element searchElement = parent.addElement(N_SEARCH);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_searchManager = OpenCms.getSearchManager();
        }
        if (!this.m_searchManager.getClass().equals(CmsSearchManager.class)) {
            searchElement.addAttribute(N_CLASS, this.m_searchManager.getClass().getName());
        }
        if (this.m_searchManager.getSolrServerConfiguration() != null) {
            Element solr = searchElement.addElement(N_SOLR);
            CmsSolrConfiguration conf = this.m_searchManager.getSolrServerConfiguration();
            solr.addAttribute("enabled", new Boolean(conf.isEnabled()).toString());
            if (conf.getServerUrl() != null) {
                solr.addAttribute(A_SERVER_URL, conf.getServerUrl().toString());
            }
            if (conf.getHomeFolderPath() != null) {
                solr.addElement(N_HOME).addText(conf.getHomeFolderPath());
            }
            if (conf.getSolrFileName() != null) {
                solr.addElement(N_CONFIG_FILE).addText(conf.getSolrFileName());
            }
            solr.addElement(N_COMMIT_MS).addText(String.valueOf(conf.getSolrCommitMs()));
        }
        searchElement.addElement(N_DIRECTORY).addText(this.m_searchManager.getDirectory());
        searchElement.addElement(N_TIMEOUT).addText(String.valueOf(this.m_searchManager.getTimeout()));
        searchElement.addElement(N_OFFLINE_UPDATE_FREQUENCY).addText(String.valueOf(this.m_searchManager.getOfflineUpdateFrequency()));
        searchElement.addElement(N_MAX_INDEX_WAIT_TIME).addText(String.valueOf(this.m_searchManager.getMaxIndexWaitTime()));
        if (this.m_searchManager.getForceunlock() != null) {
            searchElement.addElement(N_FORCEUNLOCK).addText(this.m_searchManager.getForceunlock().toString());
        }
        searchElement.addElement("excerpt").addText(String.valueOf(this.m_searchManager.getMaxExcerptLength()));
        searchElement.addElement(N_EXTRACTION_CACHE_MAX_AGE).addText(String.valueOf(this.m_searchManager.getExtractionCacheMaxAge()));
        searchElement.addElement(N_MAX_MODIFICATIONS_BEFORE_COMMIT).addText(String.valueOf(this.m_searchManager.getMaxModificationsBeforeCommit()));
        searchElement.addElement(N_HIGHLIGHTER).addText(this.m_searchManager.getHighlighter().getClass().getName());
        Element documenttypesElement = searchElement.addElement(N_DOCUMENTTYPES);
        for (CmsSearchDocumentType currSearchDocType : this.m_searchManager.getDocumentTypeConfigs()) {
            Element documenttypeElement = documenttypesElement.addElement(N_DOCUMENTTYPE);
            documenttypeElement.addElement("name").addText(currSearchDocType.getName());
            documenttypeElement.addElement(N_CLASS).addText(currSearchDocType.getClassName());
            Element mimetypesElement = documenttypeElement.addElement(N_MIMETYPES);
            Iterator<String> mimeTypesIterator = currSearchDocType.getMimeTypes().iterator();
            while (mimeTypesIterator.hasNext()) {
                mimetypesElement.addElement(N_MIMETYPE).addText(mimeTypesIterator.next());
            }
            Element element = documenttypeElement.addElement(N_RESOURCETYPES);
            Iterator<String> resTypesIterator = currSearchDocType.getResourceTypes().iterator();
            while (resTypesIterator.hasNext()) {
                element.addElement(N_RESOURCETYPE).addText(resTypesIterator.next());
            }
        }
        Element analyzersElement = searchElement.addElement(N_ANALYZERS);
        ArrayList<Locale> analyzerLocaleList = new ArrayList<Locale>(this.m_searchManager.getAnalyzers().keySet());
        Collections.sort(analyzerLocaleList, CmsLocaleComparator.getComparator());
        Iterator<Locale> analyzersLocaleInterator = analyzerLocaleList.iterator();
        while (analyzersLocaleInterator.hasNext()) {
            CmsSearchAnalyzer searchAnalyzer = this.m_searchManager.getCmsSearchAnalyzer(analyzersLocaleInterator.next());
            Element analyzerElement = analyzersElement.addElement("analyzer");
            analyzerElement.addElement(N_CLASS).addText(searchAnalyzer.getClassName());
            analyzerElement.addElement(N_LOCALE).addText(searchAnalyzer.getLocale().toString());
        }
        Element indexesElement = searchElement.addElement(N_INDEXES);
        for (I_CmsSearchIndex i_CmsSearchIndex : this.m_searchManager.getSearchIndexesAll()) {
            Element indexElement = indexesElement.addElement("index");
            if (!i_CmsSearchIndex.getClass().equals(CmsSearchIndex.class)) {
                indexElement.addAttribute(N_CLASS, i_CmsSearchIndex.getClass().getName());
            }
            indexElement.addElement("name").addText(i_CmsSearchIndex.getName());
            indexElement.addElement(N_REBUILD).addText(i_CmsSearchIndex.getRebuildMode());
            indexElement.addElement(N_PROJECT).addText(i_CmsSearchIndex.getProject());
            indexElement.addElement(N_LOCALE).addText(i_CmsSearchIndex.getLocale().toString());
            String fieldConfigurationName = i_CmsSearchIndex.getFieldConfigurationName();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(fieldConfigurationName)) {
                indexElement.addElement(N_CONFIGURATION).addText(fieldConfigurationName);
            }
            Element sourcesElement = indexElement.addElement(N_SOURCES);
            Iterator<Object> sourcesIterator = i_CmsSearchIndex.getSourceNames().iterator();
            while (sourcesIterator.hasNext()) {
                sourcesElement.addElement(N_SOURCE).addText((String)sourcesIterator.next());
            }
            CmsParameterConfiguration indexConfiguration = i_CmsSearchIndex.getConfiguration();
            if (indexConfiguration == null) continue;
            indexConfiguration.appendToXml(indexElement);
        }
        Element indexsourcesElement = searchElement.addElement(N_INDEXSOURCES);
        for (CmsSearchIndexSource searchIndexSource : this.m_searchManager.getSearchIndexSources().values()) {
            Element indexsourceElement = indexsourcesElement.addElement(N_INDEXSOURCE);
            indexsourceElement.addElement("name").addText(searchIndexSource.getName());
            Element indexerElement = indexsourceElement.addElement(N_INDEXER).addAttribute(N_CLASS, searchIndexSource.getIndexerClassName());
            for (Map.Entry<String, String> entry : searchIndexSource.getParams().entrySet()) {
                indexerElement.addElement("param").addAttribute("name", entry.getKey()).addText(entry.getValue());
            }
            Element resourcesElement = indexsourceElement.addElement(N_RESOURCES);
            Iterator<String> resourceIterator = searchIndexSource.getResourcesNames().iterator();
            while (resourceIterator.hasNext()) {
                resourcesElement.addElement("resource").addText(resourceIterator.next());
            }
            Element doctypes_indexedElement = indexsourceElement.addElement(N_DOCUMENTTYPES_INDEXED);
            Iterator<String> doctypesIterator = searchIndexSource.getDocumentTypes().iterator();
            while (doctypesIterator.hasNext()) {
                doctypes_indexedElement.addElement("name").addText(doctypesIterator.next());
            }
        }
        Element element = searchElement.addElement(N_FIELDCONFIGURATIONS);
        for (I_CmsSearchFieldConfiguration fieldConfiguration : this.m_searchManager.getFieldConfigurations()) {
            Element fieldConfigurationElement = element.addElement(N_FIELDCONFIGURATION);
            if (!fieldConfiguration.getClass().equals(CmsLuceneFieldConfiguration.class)) {
                fieldConfigurationElement.addAttribute(N_CLASS, fieldConfiguration.getClass().getName());
            }
            fieldConfigurationElement.addElement("name").setText(fieldConfiguration.getName());
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(fieldConfiguration.getDescription())) {
                fieldConfigurationElement.addElement(N_DESCRIPTION).setText(fieldConfiguration.getDescription());
            }
            Element fieldsElement = fieldConfigurationElement.addElement(N_FIELDS);
            for (CmsSearchField sfield : fieldConfiguration.getFields()) {
                if (!(sfield instanceof CmsLuceneField)) continue;
                CmsLuceneField field = (CmsLuceneField)sfield;
                Element fieldElement = fieldsElement.addElement(N_FIELD);
                fieldElement.addAttribute("name", field.getName());
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(field.getDisplayNameForConfiguration())) {
                    fieldElement.addAttribute(A_DISPLAY, field.getDisplayNameForConfiguration());
                }
                if (field.isCompressed()) {
                    fieldElement.addAttribute(A_STORE, "compress");
                } else {
                    fieldElement.addAttribute(A_STORE, String.valueOf(field.isStored()));
                }
                String index = field.isIndexed() ? (field.isTokenizedAndIndexed() ? CmsStringUtil.TRUE : "untokenized") : CmsStringUtil.FALSE;
                fieldElement.addAttribute("index", index);
                if (field.isInExcerptAndStored()) {
                    fieldElement.addAttribute("excerpt", String.valueOf(true));
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(field.getDefaultValue())) {
                    fieldElement.addAttribute("default", field.getDefaultValue());
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(field.getType())) {
                    fieldElement.addAttribute("type", field.getType());
                }
                if (field.getAnalyzer() != null) {
                    String className = field.getAnalyzer().getClass().getName();
                    if (className.startsWith("org.apache.lucene.analysis.core.")) {
                        className = className.substring("org.apache.lucene.analysis.core.".length());
                    }
                    fieldElement.addAttribute("analyzer", className);
                }
                for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
                    Element mappingElement = fieldElement.addElement(N_MAPPING);
                    mappingElement.addAttribute("type", mapping.getType().toString());
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(mapping.getDefaultValue())) {
                        mappingElement.addAttribute("default", mapping.getDefaultValue());
                    }
                    if (!mapping.getClass().equals(CmsSearchFieldMapping.class) || mapping.getType() == CmsSearchFieldMappingType.DYNAMIC) {
                        mappingElement.addAttribute(N_CLASS, mapping.getClass().getName());
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(mapping.getParam())) continue;
                    mappingElement.setText(mapping.getParam());
                }
            }
        }
        return searchElement;
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsSearchManager getSearchManager() {
        return this.m_searchManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_CONFIG_FINISHED_0"));
        }
    }

    public void setSearchManager(CmsSearchManager manager) {
        this.m_searchManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_MANAGER_FINISHED_0"));
        }
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_CONFIG_INIT_0"));
        }
    }
}

