/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.ui.apps.I_CmsWorkplaceAppConfiguration;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsStartViewPreference
extends CmsBuiltinPreference {
    private static final Log LOG = CmsLog.getLog(CmsStartViewPreference.class);
    private static final String NICE_NAME = "%(key.GUI_PREF_STARTUP_VIEW_0)";

    public CmsStartViewPreference(String name) {
        super(name);
    }

    public static CmsBuiltinPreference.SelectOptions getViewSelectOptions(CmsObject cms, String value) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        List<I_CmsWorkplaceAppConfiguration> apps = OpenCms.getWorkplaceAppManager().getDefaultQuickLaunchConfigurations();
        for (I_CmsWorkplaceAppConfiguration app : apps) {
            if (!OpenCms.getRoleManager().hasRole(cms, cms.getRequestContext().getCurrentUser().getName(), app.getRequiredRole())) continue;
            values.add(app.getId());
            options.add(app.getName(locale));
        }
        CmsBuiltinPreference.SelectOptions optionBean = new CmsBuiltinPreference.SelectOptions(options, values, selectedIndex);
        return optionBean;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        String options = CmsStartViewPreference.getViewSelectOptions(cms, null).toClientSelectWidgetConfiguration();
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", options, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public boolean isDisabled(CmsObject cms) {
        return !OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_USER);
    }
}

