/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsLoginMessage;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsUserDisabledException;
import org.opencms.security.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsLoginManager {
    public static final long DEFAULT_TOKEN_LIFETIME = 86400000L;
    public static final int DISABLE_MINUTES_DEFAULT = 15;
    public static final boolean ENABLE_SECURITY_DEFAULT = false;
    public static final String KEY_SEPARATOR = "_";
    public static final int MAX_BAD_ATTEMPTS_DEFAULT = 3;
    private static final Log LOG = CmsLog.getLog(CmsLoginManager.class);
    protected static Map<String, Set<CmsUserData>> TEMP_DISABLED_USER;
    protected int m_disableMillis;
    protected int m_disableMinutes;
    protected boolean m_enableSecurity;
    protected int m_maxBadAttempts;
    protected Map<String, CmsUserData> m_storage;
    protected String m_tokenLifetimeStr;
    private CmsLoginMessage m_loginMessage;
    private CmsLoginMessage m_beforeLoginMessage;
    private String m_maxInactive;
    private String m_passwordChangeInterval;
    private String m_userDateCheckInterval;

    public CmsLoginManager(int disableMinutes, int maxBadAttempts, boolean enableSecurity, String tokenLifetime, String maxInactive, String passwordChangeInterval, String userDataCheckInterval) {
        this.m_maxBadAttempts = maxBadAttempts;
        if (TEMP_DISABLED_USER == null) {
            TEMP_DISABLED_USER = new Hashtable<String, Set<CmsUserData>>();
        }
        if (this.m_maxBadAttempts >= 0) {
            this.m_disableMinutes = disableMinutes;
            this.m_disableMillis = disableMinutes * 60 * 1000;
            this.m_storage = new Hashtable<String, CmsUserData>();
        }
        this.m_enableSecurity = enableSecurity;
        this.m_tokenLifetimeStr = tokenLifetime;
        this.m_maxInactive = maxInactive;
        this.m_passwordChangeInterval = passwordChangeInterval;
        this.m_userDateCheckInterval = userDataCheckInterval;
    }

    private static String createStorageKey(String userName, String remoteAddress) {
        StringBuffer result = new StringBuffer();
        result.append(userName);
        result.append(KEY_SEPARATOR);
        result.append(remoteAddress);
        return result.toString();
    }

    public boolean canLockBecauseOfInactivity(CmsObject cms, CmsUser user) {
        return !user.isManaged() && !user.isWebuser() && !OpenCms.getDefaultUsers().isDefaultUser(user.getName()) && !OpenCms.getRoleManager().hasRole(cms, user.getName(), CmsRole.ROOT_ADMIN);
    }

    public boolean checkInactive(CmsUser user) {
        if (this.m_maxInactive == null) {
            return false;
        }
        try {
            long maxInactive = CmsStringUtil.parseDuration(this.m_maxInactive, Long.MAX_VALUE);
            return System.currentTimeMillis() - user.getLastlogin() > maxInactive;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void checkInvalidLogins(String userName, String remoteAddress) throws CmsAuthentificationException {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        CmsUserData userData = this.m_storage.get(key);
        if (userData != null && userData.isDisabled()) {
            Set<CmsUserData> data = TEMP_DISABLED_USER.get(userName);
            if (data == null) {
                data = new HashSet<CmsUserData>();
            }
            data.add(userData);
            TEMP_DISABLED_USER.put(userName, data);
            throw new CmsUserDisabledException(Messages.get().container("ERR_LOGIN_FAILED_TEMP_DISABLED_4", new Object[]{userName, remoteAddress, userData.getReleaseDate(), userData.getInvalidLoginCount()}));
        }
        if (TEMP_DISABLED_USER.containsKey(userName) & userData != null && TEMP_DISABLED_USER.get(userName).contains(userData)) {
            TEMP_DISABLED_USER.get(userName).remove(userData);
            if (TEMP_DISABLED_USER.get(userName).isEmpty()) {
                TEMP_DISABLED_USER.remove(userName);
            }
        }
    }

    public void checkLoginAllowed() throws CmsAuthentificationException {
        if (this.m_loginMessage != null && this.m_loginMessage.isLoginCurrentlyForbidden()) {
            throw new CmsAuthentificationException(Messages.get().container("ERR_LOGIN_FAILED_WITH_MESSAGE_1", this.m_loginMessage.getMessage()));
        }
    }

    public CmsLoginMessage getBeforeLoginMessage() {
        return this.m_beforeLoginMessage;
    }

    public int getDisableMinutes() {
        return this.m_disableMinutes;
    }

    public CmsLoginMessage getLoginMessage() {
        return this.m_loginMessage;
    }

    public int getMaxBadAttempts() {
        return this.m_maxBadAttempts;
    }

    public String getMaxInactive() {
        return this.m_maxInactive;
    }

    public long getPasswordChangeInterval() {
        if (this.m_passwordChangeInterval == null) {
            return Long.MAX_VALUE;
        }
        return CmsStringUtil.parseDuration(this.m_passwordChangeInterval, Long.MAX_VALUE);
    }

    public String getPasswordChangeIntervalStr() {
        return this.m_passwordChangeInterval;
    }

    public long getTokenLifetime() {
        if (this.m_tokenLifetimeStr == null) {
            return 86400000L;
        }
        return CmsStringUtil.parseDuration(this.m_tokenLifetimeStr, 86400000L);
    }

    public String getTokenLifetimeStr() {
        return this.m_tokenLifetimeStr;
    }

    public long getUserDataCheckInterval() {
        if (this.m_userDateCheckInterval == null) {
            return Long.MAX_VALUE;
        }
        return CmsStringUtil.parseDuration(this.m_userDateCheckInterval, Long.MAX_VALUE);
    }

    public String getUserDataCheckIntervalStr() {
        return this.m_userDateCheckInterval;
    }

    public boolean isEnableSecurity() {
        return this.m_enableSecurity;
    }

    public boolean isPasswordReset(CmsObject cms, CmsUser user) {
        if (user.isManaged() || user.isWebuser() || OpenCms.getDefaultUsers().isDefaultUser(user.getName())) {
            return false;
        }
        return user.getAdditionalInfo().get("RESET_PASSWORD") != null;
    }

    public boolean isUserLocked(CmsUser user) {
        Set<String> keysForUser = this.getKeysForUser(user);
        for (String key : keysForUser) {
            CmsUserData data = this.m_storage.get(key);
            if (data == null || !data.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isUserTempDisabled(String username) {
        Set<CmsUserData> data = TEMP_DISABLED_USER.get(username);
        if (data == null) {
            return false;
        }
        for (CmsUserData userData : data) {
            if (userData.isDisabled()) continue;
            data.remove(userData);
        }
        if (data.size() > 0) {
            TEMP_DISABLED_USER.put(username, data);
            return true;
        }
        TEMP_DISABLED_USER.remove(username);
        return false;
    }

    public void removeLoginMessage(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        this.m_loginMessage = null;
    }

    public boolean requiresPasswordChange(CmsObject cms, CmsUser user) {
        if (user.isManaged() || user.isWebuser() || OpenCms.getDefaultUsers().isDefaultUser(user.getName()) || OpenCms.getRoleManager().hasRole(cms, user.getName(), CmsRole.ROOT_ADMIN)) {
            return false;
        }
        String lastPasswordChangeStr = (String)user.getAdditionalInfo().get("LAST_PASSWORD_CHANGE");
        if (lastPasswordChangeStr == null) {
            return false;
        }
        long lastPasswordChange = Long.parseLong(lastPasswordChangeStr);
        return System.currentTimeMillis() - lastPasswordChange > this.getPasswordChangeInterval();
    }

    public boolean requiresUserDataCheck(CmsObject cms, CmsUser user) {
        if (user.isManaged() || user.isWebuser() || OpenCms.getDefaultUsers().isDefaultUser(user.getName()) || OpenCms.getRoleManager().hasRole(cms, user.getName(), CmsRole.ROOT_ADMIN)) {
            return false;
        }
        String lastCheckStr = (String)user.getAdditionalInfo().get("ADDITIONAL_INFO_LAST_USER_DATA_CHECK");
        if (lastCheckStr == null) {
            return !CmsStringUtil.isEmptyOrWhitespaceOnly(this.getUserDataCheckIntervalStr());
        }
        long lastCheck = Long.parseLong(lastCheckStr);
        return System.currentTimeMillis() - lastCheck > this.getUserDataCheckInterval();
    }

    public void resetUserTempDisable(String username) {
        Set<CmsUserData> data = TEMP_DISABLED_USER.get(username);
        if (data == null) {
            return;
        }
        for (CmsUserData userData : data) {
            userData.reset();
        }
        TEMP_DISABLED_USER.remove(username);
    }

    public void setBeforeLoginMessage(CmsObject cms, CmsLoginMessage message) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() >= 3) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        this.m_beforeLoginMessage = message;
        if (this.m_beforeLoginMessage != null) {
            this.m_beforeLoginMessage.setFrozen();
        }
    }

    public void setLoginMessage(CmsObject cms, CmsLoginMessage message) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() >= 3) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        this.m_loginMessage = message;
        if (this.m_loginMessage != null) {
            this.m_loginMessage.setFrozen();
        }
    }

    public void unlockUser(CmsObject cms, CmsUser user) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(cms.getRequestContext().getOuFqn()));
        Set<String> keysToRemove = this.getKeysForUser(user);
        for (String keyToRemove : keysToRemove) {
            this.m_storage.remove(keyToRemove);
        }
    }

    protected void addInvalidLogin(String userName, String remoteAddress) {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        CmsUserData userData = this.m_storage.get(key);
        if (userData != null) {
            userData.increaseInvalidLoginCount();
        } else {
            userData = new CmsUserData();
            this.m_storage.put(key, userData);
        }
    }

    protected void removeInvalidLogins(String userName, String remoteAddress) {
        if (this.m_maxBadAttempts < 0) {
            return;
        }
        String key = CmsLoginManager.createStorageKey(userName, remoteAddress);
        this.m_storage.remove(key);
    }

    private Set<String> getKeysForUser(CmsUser user) {
        HashSet<String> keysToRemove = new HashSet<String>();
        for (Map.Entry<String, CmsUserData> entry : this.m_storage.entrySet()) {
            String key = entry.getKey();
            int separatorPos = key.lastIndexOf(KEY_SEPARATOR);
            String prefix = key.substring(0, separatorPos);
            if (!user.getName().equals(prefix)) continue;
            keysToRemove.add(key);
        }
        return keysToRemove;
    }

    private class CmsUserData {
        private long m_disableTimeStart;
        private int m_invalidLoginCount = 1;

        protected CmsUserData() {
        }

        protected Integer getInvalidLoginCount() {
            return new Integer(this.m_invalidLoginCount);
        }

        protected Date getReleaseDate() {
            return new Date(this.m_disableTimeStart + (long)CmsLoginManager.this.m_disableMillis + 1L);
        }

        protected void increaseInvalidLoginCount() {
            ++this.m_invalidLoginCount;
            if (this.m_invalidLoginCount >= CmsLoginManager.this.m_maxBadAttempts && this.m_disableTimeStart == 0L) {
                this.m_disableTimeStart = System.currentTimeMillis();
            }
        }

        protected boolean isDisabled() {
            long currentTime;
            if (this.m_disableTimeStart > 0L && (currentTime = System.currentTimeMillis()) - this.m_disableTimeStart > (long)CmsLoginManager.this.m_disableMillis) {
                this.m_disableTimeStart = 0L;
            }
            return this.m_disableTimeStart > 0L;
        }

        protected void reset() {
            this.m_disableTimeStart = 0L;
            this.m_invalidLoginCount = 0;
        }
    }
}

