/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.Serializable;
import org.opencms.file.CmsResource;

public class CmsResourceState
implements Serializable {
    public static final CmsResourceState STATE_CHANGED = new CmsResourceState(1, 'C');
    public static final CmsResourceState STATE_DELETED = new CmsResourceState(3, 'D');
    public static final CmsResourceState STATE_KEEP = new CmsResourceState(99, '_');
    public static final CmsResourceState STATE_NEW = new CmsResourceState(2, 'N');
    public static final CmsResourceState STATE_UNCHANGED = new CmsResourceState(0, 'U');
    private static final long serialVersionUID = -2704354453252295414L;
    private char m_abbrev;
    private int m_state;

    @Deprecated
    protected CmsResourceState() {
    }

    protected CmsResourceState(int state, char abbrev) {
        this.m_state = state;
        this.m_abbrev = abbrev;
    }

    public static CmsResourceState valueOf(int state) {
        switch (state) {
            case 0: {
                return CmsResource.STATE_UNCHANGED;
            }
            case 1: {
                return CmsResource.STATE_CHANGED;
            }
            case 2: {
                return CmsResource.STATE_NEW;
            }
            case 3: {
                return CmsResource.STATE_DELETED;
            }
        }
        return CmsResource.STATE_KEEP;
    }

    public boolean equals(Object obj) {
        return obj instanceof CmsResourceState && ((CmsResourceState)obj).m_state == this.m_state;
    }

    public char getAbbreviation() {
        return this.m_abbrev;
    }

    public int getState() {
        return this.m_state;
    }

    public int hashCode() {
        return new Integer(this.m_state).hashCode();
    }

    public boolean isChanged() {
        return this.equals(CmsResource.STATE_CHANGED);
    }

    public boolean isDeleted() {
        return this.equals(CmsResource.STATE_DELETED);
    }

    public boolean isKeep() {
        return this.equals(CmsResource.STATE_KEEP);
    }

    public boolean isNew() {
        return this.equals(CmsResource.STATE_NEW);
    }

    public boolean isUnchanged() {
        return this.equals(CmsResource.STATE_UNCHANGED);
    }

    public String toString() {
        return String.valueOf(this.getState());
    }
}

