/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.log;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.opencms.db.log.CmsLogEntryType;
import org.opencms.util.CmsUUID;

public final class CmsLogFilter
implements Cloneable {
    public static final CmsLogFilter ALL = new CmsLogFilter();
    private long m_dateFrom;
    private long m_dateTo = Long.MAX_VALUE;
    private Set<CmsLogEntryType> m_excludeTypes = new HashSet<CmsLogEntryType>();
    private Set<CmsLogEntryType> m_includeTypes = new HashSet<CmsLogEntryType>();
    private CmsUUID m_structureId;
    private CmsUUID m_userId;

    private CmsLogFilter() {
    }

    public Object clone() {
        CmsLogFilter filter = new CmsLogFilter();
        filter.m_structureId = this.m_structureId;
        filter.m_includeTypes = new HashSet<CmsLogEntryType>(this.m_includeTypes);
        filter.m_excludeTypes = new HashSet<CmsLogEntryType>(this.m_excludeTypes);
        filter.m_userId = this.m_userId;
        filter.m_dateFrom = this.m_dateFrom;
        filter.m_dateTo = this.m_dateTo;
        return filter;
    }

    public CmsLogFilter excludeType(CmsLogEntryType type) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_excludeTypes.add(type);
        return filter;
    }

    public CmsLogFilter filterFrom(long from) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_dateFrom = from;
        return filter;
    }

    public CmsLogFilter filterResource(CmsUUID structureId) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_structureId = structureId;
        return filter;
    }

    public CmsLogFilter filterTo(long to) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_dateTo = to;
        return filter;
    }

    public CmsLogFilter filterUser(CmsUUID userId) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_userId = userId;
        return filter;
    }

    public long getDateFrom() {
        return this.m_dateFrom;
    }

    public long getDateTo() {
        return this.m_dateTo;
    }

    public Set<CmsLogEntryType> getExcludeTypes() {
        return Collections.unmodifiableSet(this.m_excludeTypes);
    }

    public Set<CmsLogEntryType> getIncludeTypes() {
        return Collections.unmodifiableSet(this.m_includeTypes);
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public CmsLogFilter includeType(CmsLogEntryType type) {
        CmsLogFilter filter = (CmsLogFilter)this.clone();
        filter.m_includeTypes.add(type);
        return filter;
    }

    public boolean matchType(CmsLogEntryType type) {
        if (this.m_excludeTypes.contains((Object)type)) {
            return false;
        }
        if (this.m_includeTypes.isEmpty()) {
            return true;
        }
        return this.m_includeTypes.contains((Object)type);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append("[");
        str.append("resource").append("=").append(this.m_structureId).append(", ");
        str.append("user").append("=").append(this.m_userId).append(", ");
        str.append("from").append("=").append(new Date(this.m_dateFrom)).append(", ");
        str.append("to").append("=").append(new Date(this.m_dateTo)).append(", ");
        str.append("includeTypes").append("=").append(this.m_includeTypes);
        str.append("excludeTypes").append("=").append(this.m_excludeTypes);
        str.append("]");
        return str.toString();
    }
}

