/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.timing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.opencms.db.timing.I_CmsProfilingHandler;

public class CmsProfilingInvocationHandler
implements InvocationHandler {
    private I_CmsProfilingHandler m_profilingHandler;
    private Object m_target;

    public CmsProfilingInvocationHandler(Object target, I_CmsProfilingHandler timingConsumer) {
        this.m_target = target;
        this.m_profilingHandler = timingConsumer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long start = 0L;
        long end = 0L;
        try {
            start = System.nanoTime();
            Object object = method.invoke(this.m_target, args);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw cause;
            }
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            end = System.nanoTime();
            long nanos = end - start;
            String key = method.toString();
            this.m_profilingHandler.putTime(key, nanos);
        }
    }
}

