/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.history;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.Messages;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.util.CmsRequestUtil;

public class CmsHistoryResourceHandler
implements I_CmsResourceInit {
    public static final String ATTRIBUTE_NAME = "org.opencms.file.history.CmsHistoryResourceHandler";
    public static final String HISTORY_HANDLER = "/system/config/showversion";
    public static final String PARAM_VERSION = "version";
    public static final int PROJECT_OFFLINE_VERSION = Integer.MAX_VALUE;
    private static final Log LOG = CmsLog.getLog(CmsHistoryResourceHandler.class);

    public static I_CmsHistoryResource getHistoryResource(ServletRequest req) {
        return (I_CmsHistoryResource)req.getAttribute(ATTRIBUTE_NAME);
    }

    public static String getHistoryResourceURI(String uri, ServletRequest req) {
        String histUri = uri;
        if (CmsHistoryResourceHandler.isHistoryRequest(req)) {
            String version = req.getParameter(PARAM_VERSION);
            histUri = CmsRequestUtil.appendParameter(uri, PARAM_VERSION, version);
        }
        return histUri;
    }

    public static CmsResource getResourceWithHistory(CmsObject cms, String resourceUri) throws CmsException {
        int pos;
        Map<String, String[]> params;
        CmsResource resource = null;
        if (resourceUri.contains("?") && (params = CmsRequestUtil.createParameterMap(resourceUri.substring(pos = resourceUri.indexOf("?")))).containsKey(PARAM_VERSION)) {
            int version = Integer.parseInt(params.get(PARAM_VERSION)[0]);
            String sitemapPath = resourceUri.substring(0, pos);
            resource = cms.readResource(sitemapPath);
            resource = (CmsResource)((Object)cms.readResource(resource.getStructureId(), version));
        }
        if (resource == null) {
            resource = cms.readResource(resourceUri);
        }
        return resource;
    }

    public static boolean isHistoryRequest(ServletRequest req) {
        return null != req.getAttribute(ATTRIBUTE_NAME);
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        String uri;
        if (req != null && (uri = cms.getRequestContext().getUri()).startsWith(HISTORY_HANDLER)) {
            String version = req.getParameter(PARAM_VERSION);
            if (resource == null && version != null && cms.existsResource(HISTORY_HANDLER)) {
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot("/");
                    uri = uri.substring(HISTORY_HANDLER.length(), uri.length());
                    int id = new Integer(version);
                    if (id == Integer.MAX_VALUE) {
                        resource = new CmsHistoryFile(cms.readFile(uri, CmsResourceFilter.IGNORE_EXPIRATION));
                    } else {
                        CmsResource currRes = cms.readResource(uri, CmsResourceFilter.IGNORE_EXPIRATION);
                        CmsHistoryFile hisRes = (CmsHistoryFile)cms.readResource(cms.readResource(uri, CmsResourceFilter.IGNORE_EXPIRATION).getStructureId(), id);
                        resource = !currRes.getRootPath().equals(hisRes.getRootPath()) ? new CmsHistoryFile(hisRes.getPublishTag(), hisRes.getStructureId(), hisRes.getResourceId(), currRes.getRootPath(), hisRes.getTypeId(), hisRes.getFlags(), hisRes.getProjectLastModified(), hisRes.getState(), hisRes.getDateCreated(), hisRes.getUserCreated(), hisRes.getDateLastModified(), hisRes.getUserLastModified(), hisRes.getDateReleased(), hisRes.getDateExpired(), hisRes.getLength(), hisRes.getDateContent(), hisRes.getVersion(), hisRes.getParentId(), null, hisRes.getResourceVersion(), hisRes.getStructureVersion()) : hisRes;
                        if (resource instanceof CmsHistoryFile) {
                            try {
                                resource = cms.readFile(resource);
                            }
                            catch (Exception e) {
                                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (res != null) {
                        req.setAttribute(ATTRIBUTE_NAME, (Object)resource);
                    }
                }
                catch (CmsException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_HISTORYRESOURCE_2", uri, version));
                    }
                    throw new CmsResourceInitException(Messages.get().container("ERR_SHOWVERSION_2", uri, version), (Throwable)e);
                }
                finally {
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    if (resource != null) {
                        cms.getRequestContext().setUri(cms.getSitePath(resource));
                    }
                }
            }
        }
        return resource;
    }
}

