/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.types.A_CmsResourceType;
import org.opencms.file.types.Messages;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;

public class CmsResourceTypeImage
extends A_CmsResourceType {
    public static final Log LOG = CmsLog.getLog(CmsResourceTypeImage.class);
    public static final String PROPERTY_VALUE_UNLIMITED = "unlimited";
    private static final String GALLERY_PREVIEW_PROVIDER = "org.opencms.ade.galleries.preview.CmsImagePreviewProvider";
    private static CmsImageScaler m_downScaler;
    private static boolean m_staticFrozen;
    private static int m_staticLoaderId;
    private static int m_staticTypeId;
    private static final int RESOURCE_TYPE_ID = 3;
    private static final String RESOURCE_TYPE_NAME = "image";
    private static final long serialVersionUID = -8708850913653288684L;

    public CmsResourceTypeImage() {
        this.m_typeId = 3;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static CmsImageScaler getDownScaler(CmsObject cms, String rootPath) {
        if (m_downScaler == null) {
            return null;
        }
        String parentFolder = CmsResource.getParentFolder(rootPath);
        parentFolder = cms.getRequestContext().removeSiteRoot(parentFolder);
        try {
            String value;
            CmsProperty fileSizeProperty = cms.readPropertyObject(parentFolder, "image.size", true);
            if (!fileSizeProperty.isNullProperty() && CmsStringUtil.isNotEmpty(value = fileSizeProperty.getValue().trim())) {
                if (PROPERTY_VALUE_UNLIMITED.equals(value)) {
                    return null;
                }
                CmsImageScaler scaler = new CmsImageScaler(value);
                if (scaler.isValid()) {
                    return scaler;
                }
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return (CmsImageScaler)m_downScaler.clone();
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        if (resourcename.toLowerCase().endsWith(".svg")) {
            List<CmsProperty> prop2 = this.tryAddImageSizeFromSvg(content, properties);
            properties = prop2;
        } else if (CmsImageLoader.isEnabled()) {
            String rootPath = cms.getRequestContext().addSiteRoot(resourcename);
            CmsImageScaler downScaler = CmsResourceTypeImage.getDownScaler(cms, rootPath);
            CmsImageAdjuster adjuster = new CmsImageAdjuster(content, rootPath, properties, downScaler);
            adjuster.adjust();
            content = adjuster.getContent();
            properties = adjuster.getProperties();
        }
        return super.createResource(cms, securityManager, resourcename, content, properties);
    }

    @Override
    public String getGalleryPreviewProvider() {
        if (this.m_galleryPreviewProvider == null) {
            this.m_galleryPreviewProvider = this.getConfiguration().getString("gallery.preview.provider", GALLERY_PREVIEW_PROVIDER);
        }
        return this.m_galleryPreviewProvider;
    }

    @Override
    public int getLoaderId() {
        return m_staticLoaderId;
    }

    @Override
    public CmsResource importResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, CmsResource resource, byte[] content, List<CmsProperty> properties) throws CmsException {
        if (resourcename.toLowerCase().endsWith(".svg")) {
            properties = this.tryAddImageSizeFromSvg(content, properties);
        } else if (CmsImageLoader.isEnabled() && content != null) {
            CmsImageScaler downScaler = CmsResourceTypeImage.getDownScaler(cms, resource.getRootPath());
            CmsImageAdjuster adjuster = new CmsImageAdjuster(content, resource.getRootPath(), properties, downScaler);
            adjuster.adjust();
            content = adjuster.getContent();
            properties = adjuster.getProperties();
        }
        return super.importResource(cms, securityManager, resourcename, resource, content, properties);
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (OpenCms.getRunLevel() > 2 && m_staticFrozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), CmsResourceTypeImage.getStaticTypeName(), new Integer(CmsResourceTypeImage.getStaticTypeId())));
        }
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        m_staticFrozen = true;
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
        m_staticTypeId = this.m_typeId;
        if (CmsImageLoader.isEnabled()) {
            m_staticLoaderId = 2;
            String downScaleParams = CmsImageLoader.getDownScaleParams();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(downScaleParams) && !(m_downScaler = new CmsImageScaler(downScaleParams)).isValid()) {
                m_downScaler = null;
            }
        } else {
            m_staticLoaderId = 1;
            m_downScaler = null;
        }
    }

    @Override
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        if (resource.getRootPath().toLowerCase().endsWith(".svg")) {
            List<CmsProperty> newProperties = this.tryAddImageSizeFromSvg(content, properties);
            if (properties != newProperties) {
                this.writePropertyObjects(cms, securityManager, resource, newProperties);
            }
        } else if (CmsImageLoader.isEnabled()) {
            securityManager.checkPermissions(cms.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            CmsImageScaler downScaler = CmsResourceTypeImage.getDownScaler(cms, resource.getRootPath());
            CmsImageAdjuster adjuster = new CmsImageAdjuster(content, resource.getRootPath(), properties, downScaler);
            adjuster.adjust();
            content = adjuster.getContent();
            if (adjuster.getProperties() != null) {
                this.writePropertyObjects(cms, securityManager, resource, adjuster.getProperties());
            }
        }
        super.replaceResource(cms, securityManager, resource, type, content, properties);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException, CmsVfsException, CmsSecurityException {
        if (CmsImageLoader.isEnabled()) {
            securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
            CmsImageScaler downScaler = CmsResourceTypeImage.getDownScaler(cms, resource.getRootPath());
            CmsImageAdjuster adjuster = new CmsImageAdjuster(resource.getContents(), resource.getRootPath(), null, downScaler);
            adjuster.adjust();
            resource.setContents(adjuster.getContent());
            if (adjuster.getProperties() != null) {
                this.writePropertyObjects(cms, securityManager, resource, adjuster.getProperties());
            }
        }
        return super.writeFile(cms, securityManager, resource);
    }

    protected List<CmsProperty> tryAddImageSizeFromSvg(byte[] content, List<CmsProperty> properties) {
        if (content == null || content.length == 0) {
            return properties;
        }
        List<CmsProperty> newProps = properties;
        try {
            double w = -1.0;
            double h = -1.0;
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)new ByteArrayInputStream(content));
            Element node = (Element)doc.selectSingleNode("/svg");
            if (node != null) {
                String widthStr = node.attributeValue("width");
                String heightStr = node.attributeValue("height");
                SvgSize width = SvgSize.parse(widthStr);
                SvgSize height = SvgSize.parse(heightStr);
                if (width != null && height != null && Objects.equals(width.getUnit(), height.getUnit())) {
                    w = width.getSize();
                    h = height.getSize();
                } else {
                    String[] viewboxParts;
                    String viewboxStr = node.attributeValue("viewBox");
                    if (viewboxStr != null && (viewboxParts = (viewboxStr = viewboxStr.replace(",", " ")).trim().split(" +")).length == 4) {
                        w = Double.parseDouble(viewboxParts[2]);
                        h = Double.parseDouble(viewboxParts[3]);
                    }
                }
                if (w > 0.0 && h > 0.0) {
                    String propValue = "w:" + (int)Math.round(w) + ",h:" + (int)Math.round(h);
                    Map<Object, Object> propsMap = properties == null ? new HashMap() : CmsProperty.toObjectMap(properties);
                    propsMap.put("image.size", new CmsProperty("image.size", null, propValue));
                    newProps = new ArrayList<Object>(propsMap.values());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while trying to determine size of SVG: " + e.getLocalizedMessage()), (Throwable)e);
        }
        return newProps;
    }

    private static class SvgSize {
        private double m_size;
        private String m_unit;

        private SvgSize() {
        }

        public static SvgSize parse(String s) {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(s)) {
                return null;
            }
            s = s.trim();
            double length = -1.0;
            String unit = "";
            for (int unitPos = s.length(); unitPos >= 0; --unitPos) {
                String prefix = s.substring(0, unitPos);
                unit = s.substring(unitPos);
                try {
                    length = Double.parseDouble(prefix);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            if (length < 0.0) {
                LOG.warn((Object)("Invalid string for SVG size: " + s));
                return null;
            }
            SvgSize result = new SvgSize();
            result.m_size = length;
            result.m_unit = unit;
            return result;
        }

        public double getSize() {
            return this.m_size;
        }

        public String getUnit() {
            return this.m_unit;
        }

        public String toString() {
            return this.m_size + this.m_unit;
        }
    }

    protected static class CmsImageAdjuster {
        private byte[] m_content;
        private CmsImageScaler m_imageDownScaler;
        private List<CmsProperty> m_properties;
        private String m_rootPath;

        public CmsImageAdjuster(byte[] content, String rootPath, List<CmsProperty> properties, CmsImageScaler downScaler) {
            this.m_content = content;
            this.m_rootPath = rootPath;
            this.m_properties = properties;
            this.m_imageDownScaler = downScaler;
        }

        public void adjust() {
            CmsImageScaler scaler = new CmsImageScaler(this.getContent(), this.getRootPath());
            if (!scaler.isValid()) {
                return;
            }
            if (scaler.isDownScaleRequired(this.m_imageDownScaler)) {
                CmsImageScaler downScaler = scaler.getDownScaler(this.m_imageDownScaler);
                this.m_content = downScaler.scaleImage(this.m_content, this.m_rootPath);
                scaler.setHeight(downScaler.getHeight());
                scaler.setWidth(downScaler.getWidth());
            }
            CmsProperty p = new CmsProperty("image.size", null, scaler.toString());
            ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
            if (this.m_properties != null && this.m_properties.size() > 0) {
                result.addAll(this.m_properties);
                result.remove(p);
            }
            result.add(p);
            this.m_properties = result;
        }

        public byte[] getContent() {
            return this.m_content;
        }

        public List<CmsProperty> getProperties() {
            return this.m_properties;
        }

        public String getRootPath() {
            return this.m_rootPath;
        }
    }
}

