/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.file.wrapper.CmsWrappedResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public final class CmsResourceWrapperUtils {
    public static final String EXTENSION_PROPERTIES = "properties";
    public static final String PROPERTY_RESOURCE_TYPE = "resourceType";
    public static final String SUFFIX_PROP_INDIVIDUAL = ".i";
    public static final String SUFFIX_PROP_SHARED = ".s";
    public static final byte[] UTF8_MARKER = new byte[]{-17, -69, -65};
    private static final Pattern PATTERN_UNESCAPE = Pattern.compile("\\\\([^ntru\n\r])");

    private CmsResourceWrapperUtils() {
    }

    public static String addFileExtension(CmsObject cms, String resourcename, String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        if (!resourcename.endsWith(extension)) {
            String name = resourcename + extension;
            int count = 0;
            while (cms.existsResource(name)) {
                name = resourcename + "." + ++count + extension;
            }
            return name;
        }
        return resourcename;
    }

    public static byte[] addUtf8Marker(byte[] content) {
        if (content != null && content.length >= 3 && content[0] == UTF8_MARKER[0] && content[1] == UTF8_MARKER[1] && content[2] == UTF8_MARKER[2]) {
            return content;
        }
        if (content == null) {
            content = new byte[]{};
        }
        byte[] ret = new byte[UTF8_MARKER.length + content.length];
        System.arraycopy(UTF8_MARKER, 0, ret, 0, UTF8_MARKER.length);
        System.arraycopy(content, 0, ret, UTF8_MARKER.length, content.length);
        return ret;
    }

    public static CmsFile createPropertyFile(CmsObject cms, CmsResource res, String path) throws CmsException {
        StringBuffer content = new StringBuffer();
        content.append("# Properties for resource ");
        content.append(res.getRootPath());
        content.append("\n");
        content.append("#\n");
        content.append("# ${property_name}.i : individual property\n");
        content.append("# ${property_name}.s :     shared property\n\n");
        List<CmsPropertyDefinition> propertyDef = cms.readAllPropertyDefinitions();
        Map<String, CmsProperty> activeProperties = CmsProperty.getPropertyMap(cms.readPropertyObjects(res, false));
        String resourceType = OpenCms.getResourceManager().getResourceType(res).getTypeName();
        content.append("resourceType=");
        content.append(resourceType);
        content.append("\n\n");
        for (CmsPropertyDefinition currentPropertyDef : propertyDef) {
            String propName = currentPropertyDef.getName();
            CmsProperty currentProperty = activeProperties.get(propName);
            if (currentProperty == null) {
                currentProperty = new CmsProperty();
            }
            String individualValue = currentProperty.getStructureValue();
            String sharedValue = currentProperty.getResourceValue();
            if (individualValue == null) {
                individualValue = "";
            }
            if (sharedValue == null) {
                sharedValue = "";
            }
            individualValue = CmsResourceWrapperUtils.escapeString(individualValue);
            sharedValue = CmsResourceWrapperUtils.escapeString(sharedValue);
            content.append(propName);
            content.append(SUFFIX_PROP_INDIVIDUAL);
            content.append("=");
            content.append(individualValue);
            content.append("\n");
            content.append(propName);
            content.append(SUFFIX_PROP_SHARED);
            content.append("=");
            content.append(sharedValue);
            content.append("\n\n");
        }
        CmsWrappedResource wrap = new CmsWrappedResource(res);
        wrap.setRootPath(CmsResourceWrapperUtils.addFileExtension(cms, path, EXTENSION_PROPERTIES));
        int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        wrap.setTypeId(plainId);
        wrap.setFolder(false);
        CmsFile ret = wrap.getFile();
        try {
            ret.setContents(content.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ret.setContents(content.toString().getBytes());
        }
        return ret;
    }

    public static String removeFileExtension(CmsObject cms, String resourcename, String extension) {
        if (resourcename.equals("")) {
            resourcename = "/";
        }
        String name = CmsResource.getName(resourcename);
        String[] tokens = name.split("\\.");
        String suffix = null;
        if (tokens.length > 2) {
            if (extension.equalsIgnoreCase(tokens[tokens.length - 1])) {
                suffix = "." + extension;
                if (tokens.length > 3) {
                    try {
                        int index = Integer.valueOf(tokens[tokens.length - 2]);
                        suffix = "." + index + suffix;
                    }
                    catch (NumberFormatException index) {}
                }
            }
        } else if (tokens.length == 2 && cms.existsResource(CmsResource.getFolderPath(resourcename) + tokens[0]) && extension.equals(tokens[1])) {
            suffix = "." + tokens[1];
        }
        if (suffix != null) {
            String path = resourcename.substring(0, resourcename.length() - suffix.length());
            return path;
        }
        return resourcename;
    }

    public static byte[] removeUtf8Marker(byte[] content) {
        if (content != null && content.length >= 3 && content[0] == UTF8_MARKER[0] && content[1] == UTF8_MARKER[1] && content[2] == UTF8_MARKER[2]) {
            byte[] ret = new byte[content.length - UTF8_MARKER.length];
            System.arraycopy(content, 3, ret, 0, content.length - UTF8_MARKER.length);
            return ret;
        }
        return content;
    }

    public static void writePropertyFile(CmsObject cms, String resourcename, byte[] content) throws CmsException {
        Properties properties = new Properties();
        try {
            String props = CmsEncoder.createString(content, "UTF-8");
            props = CmsResourceWrapperUtils.unescapeString(props);
            props = CmsEncoder.encodeJavaEntities(props, "ISO-8859-1");
            byte[] modContent = props.getBytes("ISO-8859-1");
            properties.load(new ByteArrayInputStream(modContent));
            ArrayList<CmsProperty> propList = new ArrayList<CmsProperty>();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (key.endsWith(SUFFIX_PROP_SHARED)) {
                    propList.add(new CmsProperty(key.substring(0, key.length() - SUFFIX_PROP_SHARED.length()), null, value));
                    continue;
                }
                if (!key.endsWith(SUFFIX_PROP_INDIVIDUAL)) continue;
                propList.add(new CmsProperty(key.substring(0, key.length() - SUFFIX_PROP_INDIVIDUAL.length()), value, null));
            }
            cms.writePropertyObjects(resourcename, propList);
            String newType = properties.getProperty(PROPERTY_RESOURCE_TYPE);
            if (newType != null) {
                newType = newType.trim();
                if (OpenCms.getResourceManager().hasResourceType(newType)) {
                    I_CmsResourceType newTypeObj = OpenCms.getResourceManager().getResourceType(newType);
                    cms.chtype(resourcename, newTypeObj.getTypeId());
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String escapeString(String value) {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("\n", "\\n");
        substitutions.put("\t", "\\t");
        substitutions.put("\r", "\\r");
        return CmsStringUtil.substitute(value, substitutions);
    }

    private static String unescapeString(String value) {
        Matcher matcher = PATTERN_UNESCAPE.matcher(value);
        return matcher.replaceAll("\\\\\\\\$1");
    }
}

