/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsFlexBucketConfiguration {
    public static final String BUCKET_OTHER = "OTHER";
    public static final String KEY_CLEAR_ALL = "clearAll";
    public static final String KEY_PREFIX_BUCKET = "bucket.";
    private static final Log LOG = CmsLog.getLog(CmsFlexBucketConfiguration.class);
    private List<String> m_bucketNames = Lists.newArrayList();
    private List<List<String>> m_bucketPathLists = Lists.newArrayList();
    private List<String> m_clearAll = Lists.newArrayList((Object[])new String[]{"/system/modules"});
    private boolean m_frozen;

    public static CmsFlexBucketConfiguration loadFromProperties(Properties properties) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        List<Object> clearAll = Lists.newArrayList();
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            key = key.trim();
            String value = (String)properties.get(key);
            value = value.trim();
            if (key.startsWith(KEY_PREFIX_BUCKET)) {
                String bucketName = key.substring(KEY_PREFIX_BUCKET.length());
                multimap.putAll((Object)bucketName, Arrays.asList(value.trim().split(" *, *")));
                continue;
            }
            if (!KEY_CLEAR_ALL.equals(key)) continue;
            clearAll = Arrays.asList(value.trim().split(" *, *"));
        }
        CmsFlexBucketConfiguration result = new CmsFlexBucketConfiguration();
        if (!clearAll.isEmpty()) {
            result.setClearAll(clearAll);
        }
        for (String key : multimap.keySet()) {
            result.add(key, multimap.get((Object)key));
        }
        result.freeze();
        return result;
    }

    public static CmsFlexBucketConfiguration loadFromVfsFile(CmsObject cms, String path) throws CmsException {
        if (!cms.existsResource(path)) {
            return null;
        }
        CmsResource configRes = cms.readResource(path);
        if (configRes.isFolder()) {
            return null;
        }
        CmsFile configFile = cms.readFile(configRes);
        String encoding = CmsFileUtil.getEncoding(cms, configRes);
        Properties props = new Properties();
        try {
            props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(configFile.getContents()), encoding));
            return CmsFlexBucketConfiguration.loadFromProperties(props);
        }
        catch (IOException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public void add(String key, List<String> values) {
        if (this.m_frozen) {
            throw new IllegalStateException("Can not modify frozen CmsFlexBucketConfiguration");
        }
        this.m_bucketNames.add(key);
        this.m_bucketPathLists.add(values);
    }

    public void freeze() {
        this.m_frozen = true;
    }

    public String getBucketName(int bitIndex) {
        if (bitIndex == 0) {
            return BUCKET_OTHER;
        }
        String result = null;
        if (bitIndex - 1 < this.m_bucketNames.size()) {
            result = this.m_bucketNames.get(bitIndex - 1);
        }
        if (result == null) {
            return "??? " + bitIndex;
        }
        return result;
    }

    public BucketSet getBucketSet(Iterable<String> paths) {
        HashSet bucketNames = Sets.newHashSet();
        for (String path : paths) {
            bucketNames.addAll(this.getBucketsForPath(path));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Determined bucket set " + ((Object)bucketNames).toString() + " for path set " + paths));
        }
        return new BucketSet(bucketNames);
    }

    public void setClearAll(List<String> clearAll) {
        if (this.m_frozen) {
            throw new IllegalStateException("Can not modify frozen CmsFlexBucketConfiguration");
        }
        this.m_clearAll = Collections.unmodifiableList(clearAll);
    }

    public boolean shouldClearAll(List<CmsPublishedResource> publishedResources) {
        for (CmsPublishedResource pubRes : publishedResources) {
            for (String clearPath : this.m_clearAll) {
                if (!CmsStringUtil.isPrefixPath(clearPath, pubRes.getRootPath())) continue;
                return true;
            }
        }
        return false;
    }

    int getBucketIndex(String bucketName) {
        if (bucketName.equals(BUCKET_OTHER)) {
            return 0;
        }
        for (int i = 0; i < this.m_bucketNames.size(); ++i) {
            if (!this.m_bucketNames.get(i).equals(bucketName)) continue;
            return 1 + i;
        }
        return -1;
    }

    private Set<String> getBucketsForPath(String path) {
        HashSet result = Sets.newHashSet();
        boolean foundBucket = false;
        for (int i = 0; i < this.m_bucketNames.size(); ++i) {
            for (String bucketPath : this.m_bucketPathLists.get(i)) {
                if (!CmsStringUtil.isPrefixPath(bucketPath, path)) continue;
                String bucketName = this.m_bucketNames.get(i);
                result.add(bucketName);
                if (BUCKET_OTHER.equals(bucketName)) continue;
                foundBucket = true;
            }
        }
        if (!foundBucket) {
            result.add(BUCKET_OTHER);
        }
        return result;
    }

    public class BucketSet {
        private BitSet m_bits = new BitSet();

        protected BucketSet(Set<String> buckets) {
            for (String bucket : buckets) {
                int index = CmsFlexBucketConfiguration.this.getBucketIndex(bucket);
                if (index < 0) continue;
                this.m_bits.set(index);
            }
        }

        public List<String> getBucketNames() {
            ArrayList result = Lists.newArrayList();
            int i = this.m_bits.nextSetBit(0);
            while (i >= 0) {
                result.add(CmsFlexBucketConfiguration.this.getBucketName(i));
                i = this.m_bits.nextSetBit(i + 1);
            }
            return result;
        }

        public boolean matchForDeletion(BucketSet flexEntryBucketSet) {
            if (flexEntryBucketSet == null) {
                return true;
            }
            BitSet otherBits = flexEntryBucketSet.m_bits;
            BitSet commonBits = (BitSet)this.m_bits.clone();
            commonBits.and(otherBits);
            return !commonBits.isEmpty();
        }

        public String toString() {
            return "[BucketSet:" + this.getBucketNames().toString() + "]";
        }
    }
}

