/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.Messages;
import org.opencms.jsp.CmsJspResourceWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;

public class CmsFlexRequestKey {
    private static final Log LOG = CmsLog.getLog(CmsFlexRequestKey.class);
    private String m_containerElement;
    private CmsRequestContext m_context;
    private CmsUUID m_detailViewId;
    private String m_device;
    private PathsBean m_paths = new PathsBean();
    private HttpServletRequest m_request;
    private String m_resource;

    public CmsFlexRequestKey(HttpServletRequest req, String target, boolean online) {
        CmsResource containerElementResource;
        this.m_request = req;
        CmsObject cms = CmsFlexController.getCmsObject((ServletRequest)req);
        this.m_context = cms.getRequestContext();
        this.m_resource = CmsFlexCacheKey.getKeyName(this.m_context.addSiteRoot(target), online);
        this.m_device = OpenCms.getSystemInfo().getDeviceSelector().getDeviceType(req);
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        String templateContextKey = "";
        CmsJspStandardContextBean.TemplateBean templateBean = (CmsJspStandardContextBean.TemplateBean)req.getAttribute("ATTR_TEMPLATE_BEAN");
        if (templateBean != null) {
            templateContextKey = templateBean.getName();
        }
        this.m_containerElement = standardContext.elementCachingHash() + "_tc_" + templateContextKey;
        this.m_detailViewId = standardContext.getDetailContentId();
        CmsJspResourceWrapper detailContent = standardContext.getDetailContent();
        if (detailContent != null) {
            this.m_paths.setDetailElement(detailContent.getRootPath());
        }
        this.m_paths.setSite(this.m_context.getSiteRoot());
        CmsJspStandardContextBean.CmsContainerElementWrapper wrapper = standardContext.getElement();
        if (wrapper != null && (containerElementResource = wrapper.getResource()) != null) {
            this.m_paths.setContainerElement(containerElementResource.getRootPath());
        }
        this.m_paths.setUri(this.m_context.addSiteRoot(this.m_context.getUri()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUESTKEY_CREATED_NEW_KEY_1", this.m_resource));
        }
    }

    public Map<String, Object> getAttributes() {
        Map<String, Object> attrs = CmsRequestUtil.getAtrributeMap((ServletRequest)this.m_request);
        if (attrs.size() == 0) {
            return null;
        }
        return attrs;
    }

    public String getContainerElement() {
        return this.m_containerElement;
    }

    public String getDevice() {
        return this.m_device;
    }

    public String getElement() {
        return this.m_request.getParameter("__element");
    }

    public String getEncoding() {
        return this.m_context.getEncoding();
    }

    public String getIp() {
        return this.m_context.getRemoteAddress();
    }

    public String getLocale() {
        return this.m_context.getLocale().toString();
    }

    public Map<String, String[]> getParams() {
        Map<String, String[]> params = CmsCollectionsGenericWrapper.map(this.m_request.getParameterMap());
        if (params.size() == 0) {
            return null;
        }
        return params;
    }

    public PathsBean getPaths() {
        return this.m_paths;
    }

    public Integer getPort() {
        return new Integer(this.m_request.getServerPort());
    }

    public String getResource() {
        return this.m_resource;
    }

    public String getScheme() {
        return this.m_request.getScheme().toLowerCase();
    }

    public HttpSession getSession() {
        return this.m_request.getSession(false);
    }

    public String getSite() {
        return this.m_context.getSiteRoot();
    }

    public String getUri() {
        String uri = this.m_context.addSiteRoot(this.m_context.getUri());
        if (this.m_detailViewId != null) {
            uri = uri + this.m_detailViewId.toString() + "/";
        }
        return uri;
    }

    public String getUser() {
        return this.m_context.getCurrentUser().getName();
    }

    public static class PathsBean {
        private String m_containerElement;
        private String m_detailElement;
        private String m_site;
        private String m_uri;

        public String getContainerElement() {
            return this.m_containerElement;
        }

        public String getDetailElement() {
            return this.m_detailElement;
        }

        public String getSite() {
            return this.m_site;
        }

        public String getUri() {
            return this.m_uri;
        }

        public void setContainerElement(String containerElement) {
            this.m_containerElement = containerElement;
        }

        public void setDetailElement(String detailElement) {
            this.m_detailElement = detailElement;
        }

        public void setSite(String site) {
            this.m_site = site;
        }

        public void setUri(String uri) {
            this.m_uri = uri;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this);
        }
    }
}

