/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.I_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.gwt.shared.CmsUserSettingsBean;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.Messages;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsClientUserSettingConverter {
    private static final Log LOG = CmsLog.getLog(CmsClientUserSettingConverter.class);
    private CmsObject m_cms;
    private CmsDefaultUserSettings m_currentPreferences;
    private CmsMacroResolver m_macroResolver = new CmsMacroResolver();
    private HttpServletRequest m_request;

    public CmsClientUserSettingConverter(CmsObject cms, HttpServletRequest request, HttpServletResponse response) {
        this.m_cms = cms;
        this.m_request = request;
        this.m_currentPreferences = new CmsDefaultUserSettings();
        this.m_currentPreferences.init(cms.getRequestContext().getCurrentUser());
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsMultiMessages messages = new CmsMultiMessages(locale);
        messages.addMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        messages.addMessages(Messages.get().getBundle(locale));
        this.m_macroResolver.setMessages(messages);
    }

    public CmsUserSettingsBean loadSettings() {
        CmsUserSettingsBean result = new CmsUserSettingsBean();
        CmsDefaultUserSettings currentSettings = new CmsDefaultUserSettings();
        currentSettings.init(this.m_currentPreferences.getUser());
        for (I_CmsPreference pref : OpenCms.getWorkplaceManager().getDefaultUserSettings().getPreferences().values()) {
            String tab = pref.getTab();
            if ("hidden".equals(tab) || pref.isDisabled(this.m_cms)) continue;
            CmsXmlContentProperty prop2 = pref.getPropertyDefinition(this.m_cms);
            String value = pref.getValue(currentSettings);
            CmsXmlContentProperty resolvedProp = CmsXmlContentPropertyHelper.resolveMacrosInProperty(prop2.withDefaultWidget("string"), this.m_macroResolver);
            result.addSetting(value, resolvedProp, "basic".equals(tab));
        }
        return result;
    }

    public void saveSettings(Map<String, String> settings) throws Exception {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.saveSetting(key, value);
        }
        this.m_currentPreferences.save(this.m_cms);
        CmsWorkplace.updateUserPreferences(this.m_cms, this.m_request);
    }

    private void saveSetting(String key, String value) throws Exception {
        Map<String, I_CmsPreference> prefs = OpenCms.getWorkplaceManager().getDefaultUserSettings().getPreferences();
        if (prefs.containsKey(key)) {
            prefs.get(key).setValue(this.m_currentPreferences, value);
        } else {
            LOG.error((Object)("Can't save user setting '" + key + "'"));
        }
    }

    class NoJspActionElement
    extends CmsJspActionElement {
        private CmsObject m_setCms;

        public NoJspActionElement(CmsObject cms, HttpServletRequest req, HttpServletResponse res) {
            super(null, req, res);
            this.m_setCms = cms;
        }

        @Override
        public CmsObject getCmsObject() {
            return this.m_setCms;
        }

        @Override
        protected void handleMissingFlexController() {
        }
    }
}

