/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.gwt.I_CmsValidationService;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsValidationResult;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsUrlNameValidationService
implements I_CmsValidationService {
    @Override
    public CmsValidationResult validate(CmsObject cms, String value, String config) {
        String name = cms.getRequestContext().getFileTranslator().translateResource(value);
        name = name.replace('/', '_');
        Map<String, String> configMap = CmsStringUtil.splitAsMap(config, "|", ":");
        String parentPath = configMap.get("parent");
        String id = configMap.get("id");
        try {
            CmsResource res = cms.readResource(CmsStringUtil.joinPaths(parentPath, name));
            if (!CmsUUID.isValidUUID(id) || res.getStructureId().toString().equals(id)) {
                return new CmsValidationResult(null, name);
            }
            return new CmsValidationResult(Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("ERR_URL_NAME_ALREADY_EXISTS_1", name));
        }
        catch (CmsVfsResourceNotFoundException e) {
            return new CmsValidationResult(null, name);
        }
        catch (CmsException e) {
            throw new CmsRuntimeException(e.getMessageContainer());
        }
    }
}

