/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared.alias;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.util.CmsUUID;

public class CmsAliasTableRow
implements IsSerializable {
    private String m_aliasError;
    private String m_aliasPath;
    private boolean m_isChanged;
    private boolean m_isEdited;
    private String m_key;
    private CmsAliasMode m_mode;
    private CmsUUID m_originalStructureId;
    private String m_pathError;
    private String m_resourcePath;
    private CmsUUID m_structureId;

    public void clearErrors() {
        if (this.getAliasError() != null || this.getPathError() != null) {
            this.m_isChanged = true;
        }
        this.m_pathError = null;
        this.m_aliasError = null;
    }

    public CmsAliasTableRow copy() {
        CmsAliasTableRow result = new CmsAliasTableRow();
        result.setKey(this.m_key);
        result.setResourcePath(this.m_resourcePath);
        result.setStructureId(this.m_structureId);
        result.setChanged(this.m_isChanged);
        result.setMode(this.m_mode);
        result.setPathError(this.m_pathError);
        result.setAliasError(this.m_aliasError);
        result.setAliasPath(this.m_aliasPath);
        result.setEdited(this.m_isEdited);
        result.setOriginalStructureId(this.m_originalStructureId);
        return result;
    }

    public void editAliasPath(String newPath) {
        this.m_aliasPath = newPath;
        this.m_isChanged = true;
    }

    public void editResourcePath(String newPath) {
        this.m_resourcePath = newPath;
        this.m_structureId = null;
        this.m_isChanged = true;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof CmsAliasTableRow && ((CmsAliasTableRow)other).getKey().equals(this.getKey());
    }

    public String getAliasError() {
        return this.m_aliasError;
    }

    public String getAliasPath() {
        return this.m_aliasPath;
    }

    public String getKey() {
        return this.m_key;
    }

    public CmsAliasMode getMode() {
        return this.m_mode;
    }

    public CmsUUID getOriginalStructureId() {
        return this.m_originalStructureId;
    }

    public String getPathError() {
        return this.m_pathError;
    }

    public String getResourcePath() {
        return this.m_resourcePath;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public boolean hasErrors() {
        return this.m_pathError != null || this.m_aliasError != null;
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    public boolean isChanged() {
        return this.m_isChanged;
    }

    public boolean isEdited() {
        return this.m_isEdited;
    }

    public void setAliasError(String aliasError) {
        this.m_isChanged = true;
        this.m_aliasError = aliasError;
    }

    public void setAliasPath(String aliasPath) {
        this.m_aliasPath = aliasPath;
    }

    public void setChanged(boolean isChanged) {
        this.m_isChanged = isChanged;
    }

    public void setEdited(boolean isEdited) {
        this.m_isEdited = isEdited;
    }

    public void setKey(String key) {
        this.m_key = key;
    }

    public void setMode(CmsAliasMode mode) {
        this.m_mode = mode;
    }

    public void setOriginalStructureId(CmsUUID originalStructureId) {
        this.m_originalStructureId = originalStructureId;
    }

    public void setPathError(String pathError) {
        this.m_isChanged = true;
        this.m_pathError = pathError;
    }

    public void setResourcePath(String resourcePath) {
        this.m_resourcePath = resourcePath;
    }

    public void setStructureId(CmsUUID structureId) {
        this.m_structureId = structureId;
    }

    public void update(CmsAliasTableRow updateRow) {
        this.m_aliasError = updateRow.m_aliasError;
        this.m_aliasPath = updateRow.m_aliasPath;
        this.m_mode = updateRow.m_mode;
        this.m_pathError = updateRow.m_pathError;
        this.m_resourcePath = updateRow.m_resourcePath;
        this.m_structureId = updateRow.m_structureId;
        this.m_isEdited = updateRow.m_isEdited;
        this.m_originalStructureId = updateRow.m_originalStructureId;
    }
}

