/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared.property;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Map;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.util.CmsUUID;

public class CmsPropertyModification
implements IsSerializable {
    public static final String FILE_NAME_PROPERTY = "~~~file_name_property~~~";
    private CmsUUID m_id;
    private boolean m_isStructureValue;
    private String m_name;
    private String m_value;

    public CmsPropertyModification(CmsPropertyModification propMod) {
        this.m_id = propMod.m_id;
        this.m_name = propMod.m_name;
        this.m_value = propMod.m_value;
        this.m_isStructureValue = propMod.m_isStructureValue;
    }

    public CmsPropertyModification(CmsUUID resourceId, String propertyName, String value, boolean isStructureValue) {
        this.m_id = resourceId;
        this.m_name = propertyName;
        this.m_value = value;
        this.m_isStructureValue = isStructureValue;
    }

    public CmsPropertyModification(String path, String value) {
        CmsUUID id;
        String[] pathComponents = path.split("/");
        String idStr = pathComponents[0];
        String propName = pathComponents[1];
        String mode = pathComponents[2];
        this.m_id = id = new CmsUUID(idStr);
        this.m_name = propName;
        this.m_value = value;
        this.m_isStructureValue = mode.equals("S");
    }

    protected CmsPropertyModification() {
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isFileNameProperty() {
        return FILE_NAME_PROPERTY.equals(this.m_name);
    }

    public boolean isStructureValue() {
        return this.m_isStructureValue;
    }

    public void updatePropertyInMap(Map<String, CmsClientProperty> props) {
        CmsClientProperty prop = props.get(this.getName());
        if (prop == null) {
            prop = new CmsClientProperty(this.getName(), "", "");
            props.put(this.getName(), prop);
        }
        if (this.isStructureValue()) {
            prop.setStructureValue(this.getValue());
        } else {
            prop.setResourceValue(this.getValue());
        }
    }
}

