/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleGroup;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsLocaleGroupService {
    private static final Log LOG = CmsLog.getLog(CmsLocaleGroupService.class);
    private CmsObject m_cms;

    public CmsLocaleGroupService(CmsObject cms) {
        this.m_cms = cms;
    }

    public static List<Locale> getPossibleLocales(CmsObject cms, CmsResource currentResource) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(currentResource.getRootPath());
        ArrayList secondaryLocales = Lists.newArrayList();
        Locale mainLocale = null;
        if (site != null) {
            List<Locale> siteLocales = site.getSecondaryTranslationLocales();
            mainLocale = site.getMainTranslationLocale(null);
            if (siteLocales == null || siteLocales.isEmpty()) {
                siteLocales = OpenCms.getLocaleManager().getAvailableLocales();
                if (mainLocale == null) {
                    mainLocale = siteLocales.get(0);
                }
            }
            secondaryLocales.addAll(siteLocales);
        }
        try {
            CmsProperty secondaryLocaleProp = cms.readPropertyObject(currentResource, "locale.secondary", true);
            String propValue = secondaryLocaleProp.getValue();
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(propValue)) {
                String[] tokens;
                ArrayList restrictionLocales = Lists.newArrayList();
                for (String token : tokens = propValue.trim().split(" *, *")) {
                    OpenCms.getLocaleManager();
                    Locale localeForToken = CmsLocaleManager.getLocale(token);
                    restrictionLocales.add(localeForToken);
                }
                if (!restrictionLocales.isEmpty()) {
                    secondaryLocales.retainAll(restrictionLocales);
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        result.add(mainLocale);
        for (Locale secondaryLocale : secondaryLocales) {
            if (result.contains(secondaryLocale)) continue;
            result.add(secondaryLocale);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachLocaleGroup(CmsResource secondaryPage, CmsResource primaryPage) throws CmsException {
        if (secondaryPage.getStructureId().equals(primaryPage.getStructureId())) {
            throw new IllegalArgumentException("A page can not be linked with itself as a locale variant: " + secondaryPage.getRootPath());
        }
        CmsLocaleGroup group = this.readLocaleGroup(secondaryPage);
        if (group.isRealGroup()) {
            throw new IllegalArgumentException("The page " + secondaryPage.getRootPath() + " is already part of a group. ");
        }
        CmsLocaleGroup targetGroup = this.readLocaleGroup(primaryPage);
        CmsLockActionRecord record = CmsLockUtil.ensureLock(this.m_cms, secondaryPage);
        try {
            this.m_cms.deleteRelationsFromResource(secondaryPage, CmsRelationFilter.ALL.filterType(CmsRelationType.LOCALE_VARIANT));
            this.m_cms.addRelationToResource(secondaryPage, targetGroup.getPrimaryResource(), CmsRelationType.LOCALE_VARIANT.getName());
        }
        finally {
            if (record.getChange() == CmsLockActionRecord.LockChange.locked) {
                this.m_cms.unlockResource(secondaryPage);
            }
        }
    }

    public void attachLocaleGroupIndirect(CmsResource first, CmsResource second) throws CmsException {
        CmsResource firstResourceCorrected = this.getDefaultFileOrSelf(first);
        CmsResource secondResourceCorrected = this.getDefaultFileOrSelf(second);
        if (firstResourceCorrected == null || secondResourceCorrected == null) {
            throw new IllegalArgumentException("no default file");
        }
        CmsLocaleGroup group1 = this.readLocaleGroup(firstResourceCorrected);
        CmsLocaleGroup group2 = this.readLocaleGroup(secondResourceCorrected);
        int numberOfRealGroups = (group1.isRealGroupOrPotentialGroupHead() ? 1 : 0) + (group2.isRealGroupOrPotentialGroupHead() ? 1 : 0);
        if (numberOfRealGroups != 1) {
            throw new IllegalArgumentException("more than one real groups");
        }
        CmsResource main = null;
        CmsResource secondary = null;
        if (group1.isRealGroupOrPotentialGroupHead()) {
            main = group1.getPrimaryResource();
            secondary = group2.getPrimaryResource();
        } else if (group2.isRealGroupOrPotentialGroupHead()) {
            main = group2.getPrimaryResource();
            secondary = group1.getPrimaryResource();
        }
        this.attachLocaleGroup(secondary, main);
    }

    public Status checkLinkable(CmsResource firstResource, CmsResource secondResource) {
        String debugPrefix = "checkLinkable [" + Thread.currentThread().getName() + "]: ";
        LOG.debug((Object)(debugPrefix + (firstResource != null ? firstResource.getRootPath() : null) + " -- " + (secondResource != null ? secondResource.getRootPath() : null)));
        try {
            CmsLocaleGroup group2;
            Set<Locale> locales2;
            Locale locale2;
            CmsResource firstResourceCorrected = this.getDefaultFileOrSelf(firstResource);
            CmsResource secondResourceCorrected = this.getDefaultFileOrSelf(secondResource);
            if (firstResourceCorrected == null || secondResourceCorrected == null) {
                LOG.debug((Object)(debugPrefix + " rejected - no resource"));
                return Status.other;
            }
            Locale locale1 = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, firstResourceCorrected);
            if (locale1.equals(locale2 = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, secondResourceCorrected))) {
                LOG.debug((Object)(debugPrefix + "  rejected - same locale " + locale1));
                return Status.other;
            }
            Locale mainLocale1 = this.getMainLocale(firstResourceCorrected.getRootPath());
            Locale mainLocale2 = this.getMainLocale(secondResourceCorrected.getRootPath());
            if (mainLocale1 == null || !mainLocale1.equals(mainLocale2)) {
                LOG.debug((Object)(debugPrefix + " rejected - incompatible main locale " + mainLocale1 + "/" + mainLocale2));
                return Status.other;
            }
            CmsLocaleGroup group1 = this.readLocaleGroup(firstResourceCorrected);
            Set<Locale> locales1 = group1.getLocales();
            if (!Sets.intersection(locales1, locales2 = (group2 = this.readLocaleGroup(secondResourceCorrected)).getLocales()).isEmpty()) {
                LOG.debug((Object)(debugPrefix + "  rejected - already linked (case 1)"));
                return Status.alreadyLinked;
            }
            if (group1.isMarkedNoTranslation(group2.getLocales()) || group2.isMarkedNoTranslation(group1.getLocales())) {
                LOG.debug((Object)(debugPrefix + "  rejected - marked 'no translation'"));
                return Status.notranslation;
            }
            if (group1.isRealGroupOrPotentialGroupHead() == group2.isRealGroupOrPotentialGroupHead()) {
                LOG.debug((Object)(debugPrefix + "  rejected - incompatible locale group states"));
                return Status.other;
            }
            CmsResource permCheckResource = null;
            permCheckResource = group1.isRealGroupOrPotentialGroupHead() ? group2.getPrimaryResource() : group1.getPrimaryResource();
            if (!this.m_cms.hasPermissions(permCheckResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION)) {
                LOG.debug((Object)(debugPrefix + " no write permissions: " + permCheckResource.getRootPath()));
                return Status.other;
            }
            if (!this.checkLock(permCheckResource)) {
                LOG.debug((Object)(debugPrefix + " lock state: " + permCheckResource.getRootPath()));
                return Status.other;
            }
            if (group2.getPrimaryResource().getStructureId().equals(group1.getPrimaryResource().getStructureId())) {
                LOG.debug((Object)(debugPrefix + "  rejected - already linked (case 2)"));
                return Status.alreadyLinked;
            }
        }
        catch (Exception e) {
            LOG.error((Object)(debugPrefix + e.getLocalizedMessage()), (Throwable)e);
            LOG.debug((Object)(debugPrefix + "  rejected - exception (see previous)"));
            return Status.other;
        }
        LOG.debug((Object)(debugPrefix + " OK"));
        return Status.linkable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachLocaleGroup(CmsResource firstPage, CmsResource secondPage) throws CmsException {
        CmsRelationFilter typeFilter = CmsRelationFilter.ALL.filterType(CmsRelationType.LOCALE_VARIANT);
        firstPage = this.getDefaultFileOrSelf(firstPage);
        secondPage = this.getDefaultFileOrSelf(secondPage);
        if (firstPage == null || secondPage == null) {
            return;
        }
        List<CmsRelation> relations = this.m_cms.readRelations(typeFilter.filterStructureId(secondPage.getStructureId()));
        CmsUUID firstId = firstPage.getStructureId();
        CmsUUID secondId = secondPage.getStructureId();
        for (CmsRelation relation : relations) {
            CmsUUID sourceId = relation.getSourceId();
            CmsUUID targetId = relation.getTargetId();
            CmsResource resourceToModify = null;
            if (sourceId.equals(firstId) && targetId.equals(secondId)) {
                resourceToModify = firstPage;
            } else if (sourceId.equals(secondId) && targetId.equals(firstId)) {
                resourceToModify = secondPage;
            }
            if (resourceToModify == null) continue;
            CmsLockActionRecord record = CmsLockUtil.ensureLock(this.m_cms, resourceToModify);
            try {
                this.m_cms.deleteRelationsFromResource(resourceToModify, typeFilter);
                break;
            }
            finally {
                if (record.getChange() == CmsLockActionRecord.LockChange.locked) {
                    this.m_cms.unlockResource(resourceToModify);
                }
            }
        }
    }

    public CmsResource findLocalizationRoot(CmsResource resource) throws CmsException {
        String rootPath = resource.getRootPath();
        LOG.debug((Object)("Trying to find localization root for " + rootPath));
        if (resource.isFile()) {
            rootPath = CmsResource.getParentFolder(rootPath);
        }
        CmsObject cms = OpenCms.initCmsObject(this.m_cms);
        cms.getRequestContext().setSiteRoot("");
        String currentPath = rootPath;
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(rootPath);
        if (site == null) {
            return null;
        }
        String siteroot = site.getSiteRoot();
        ArrayList ancestors = Lists.newArrayList();
        while (currentPath != null && CmsStringUtil.isPrefixPath(siteroot, currentPath)) {
            ancestors.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        Iterator iter = ancestors.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (CmsFileUtil.removeTrailingSeparator(path).equals(CmsFileUtil.removeTrailingSeparator(siteroot))) {
                LOG.debug((Object)("keeping path because it is the site root: " + (String)path));
                continue;
            }
            if (cms.existsResource(CmsStringUtil.joinPaths(path, "/.content/.config"), CmsResourceFilter.IGNORE_EXPIRATION)) {
                LOG.debug((Object)("keeping path because it is a sub-sitemap: " + (String)path));
                continue;
            }
            LOG.debug((Object)("removing path " + (String)path));
            iter.remove();
        }
        for (String ancestor : ancestors) {
            try {
                CmsResource ancestorRes = cms.readResource(ancestor, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsLocaleGroup group = this.readLocaleGroup(ancestorRes);
                if (!group.isRealGroup()) continue;
                return ancestorRes;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String result = (String)ancestors.get(0);
        LOG.debug((Object)("result = " + result));
        return cms.readResource(result, CmsResourceFilter.IGNORE_EXPIRATION);
    }

    public Locale getMainLocale(String rootPath) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(rootPath);
        if (site == null) {
            return null;
        }
        return site.getMainTranslationLocale(null);
    }

    public CmsLocaleGroup readDefaultFileLocaleGroup(CmsResource resource) throws CmsException {
        if (resource.isFolder()) {
            CmsResource defaultFile = this.m_cms.readDefaultFile(resource, CmsResourceFilter.IGNORE_EXPIRATION);
            if (defaultFile != null) {
                return this.readLocaleGroup(defaultFile);
            }
            LOG.warn((Object)"default file not found, reading locale group of folder.");
        }
        return this.readLocaleGroup(resource);
    }

    public CmsLocaleGroup readLocaleGroup(CmsResource resource) throws CmsException {
        CmsResource defaultFile;
        if (resource.isFolder() && (defaultFile = this.m_cms.readDefaultFile(resource, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
            resource = defaultFile;
        }
        List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.ALL.filterType(CmsRelationType.LOCALE_VARIANT).filterStructureId(resource.getStructureId()));
        ArrayList out = Lists.newArrayList();
        ArrayList in = Lists.newArrayList();
        for (CmsRelation rel : relations) {
            if (rel.getSourceId().equals(resource.getStructureId())) {
                out.add(rel);
                continue;
            }
            in.add(rel);
        }
        CmsResource primaryResource = null;
        ArrayList secondaryResources = Lists.newArrayList();
        if (out.size() == 0 && in.size() == 0) {
            primaryResource = resource;
        } else if (out.size() == 0 && in.size() > 0) {
            primaryResource = resource;
            for (CmsRelation relation : in) {
                CmsResource source = relation.getSource(this.m_cms, CmsResourceFilter.ALL);
                secondaryResources.add(source);
            }
        } else if (out.size() == 1 && in.size() == 0) {
            CmsResource target;
            primaryResource = target = ((CmsRelation)out.get(0)).getTarget(this.m_cms, CmsResourceFilter.ALL);
            CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterType(CmsRelationType.LOCALE_VARIANT).filterStructureId(target.getStructureId());
            List<CmsRelation> relationsToTarget = this.m_cms.readRelations(filter);
            for (CmsRelation targetRelation : relationsToTarget) {
                CmsResource secondaryResource = targetRelation.getSource(this.m_cms, CmsResourceFilter.ALL);
                secondaryResources.add(secondaryResource);
            }
        } else {
            throw new IllegalStateException("illegal locale variant relations for resource with id=" + resource.getStructureId() + ", path=" + resource.getRootPath());
        }
        return new CmsLocaleGroup(this.m_cms, primaryResource, secondaryResources);
    }

    protected CmsResource getDefaultFileOrSelf(CmsResource res) {
        CmsResource defaultfile = null;
        if (res.isFolder()) {
            try {
                defaultfile = this.m_cms.readDefaultFile("" + res.getStructureId());
            }
            catch (CmsSecurityException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return null;
            }
            return defaultfile;
        }
        return res;
    }

    private boolean checkLock(CmsResource resource) throws CmsException {
        CmsLock lock = this.m_cms.getLock(resource);
        return lock.isUnlocked() || lock.getUserId().equals(this.m_cms.getRequestContext().getCurrentUser().getId());
    }

    public static enum Status {
        alreadyLinked,
        linkable,
        notranslation,
        other;

    }
}

