/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsRegexSubstitution;

public class CmsRemoveInnerNameFallback
implements CmsMultiMessages.I_KeyFallbackHandler,
I_CmsRegexSubstitution {
    private static final Log LOG = CmsLog.getLog(CmsRemoveInnerNameFallback.class);
    public static final String REGEX_STR = "^label\\.[^.]+\\.(.+)$";
    public static final Pattern PATTERN = Pattern.compile("^label\\.[^.]+\\.(.+)$");

    public CmsRemoveInnerNameFallback(String config) {
    }

    @Override
    public Optional<String> getFallbackKey(String key) {
        String result = CmsStringUtil.substitute(PATTERN, key, this);
        if (result.equals(key)) {
            return Optional.absent();
        }
        LOG.debug((Object)("Replacing message key " + key + " with " + result));
        return Optional.fromNullable((Object)result);
    }

    @Override
    public String substituteMatch(String string, Matcher matcher) {
        return "label." + matcher.group(1);
    }
}

