/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsDefaultLocaleHandler;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsStringUtil;

public class CmsSingleTreeLocaleHandler
extends CmsDefaultLocaleHandler {
    private static final Log LOG = CmsLog.getLog(CmsSingleTreeLocaleHandler.class);
    private CmsObject m_adminCmsObject;

    public static Locale getLocaleFromPath(String sitePath) {
        Locale result = null;
        if (sitePath.indexOf("/") == 0) {
            sitePath = sitePath.substring(1);
        }
        if (sitePath.length() > 1) {
            String localePrefix;
            if (!sitePath.contains("/")) {
                int separator = -1;
                int param = sitePath.indexOf("?");
                int hash = sitePath.indexOf("#");
                separator = param >= 0 ? (hash != 0 ? (param < hash ? param : hash) : param) : hash;
                localePrefix = separator >= 0 ? sitePath.substring(0, separator) : sitePath;
            } else {
                localePrefix = sitePath.substring(0, sitePath.indexOf("/"));
            }
            Locale locale = CmsLocaleManager.getLocale(localePrefix);
            if (localePrefix.equals(locale.toString()) && OpenCms.getLocaleManager().getAvailableLocales().contains(locale)) {
                result = locale;
            }
        }
        return result;
    }

    @Override
    public CmsI18nInfo getI18nInfo(HttpServletRequest req, CmsUser user, CmsProject project, String resourceName) {
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(resourceName);
        if (site != null && CmsSite.LocalizationMode.singleTree.equals((Object)site.getLocalizationMode())) {
            Locale locale;
            String sitePath = resourceName.substring(site.getSiteRoot().length());
            if (sitePath.startsWith("/")) {
                sitePath = sitePath.substring(1);
            }
            if ((locale = CmsSingleTreeLocaleHandler.getLocaleFromPath(sitePath)) == null) {
                return super.getI18nInfo(req, user, project, resourceName);
            }
            sitePath = sitePath.substring(locale.toString().length());
            String encoding = null;
            resourceName = CmsStringUtil.joinPaths(site.getSiteRoot(), sitePath);
            CmsObject adminCms = null;
            try {
                adminCms = OpenCms.initCmsObject(this.m_adminCmsObject);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            if (adminCms != null) {
                block15: {
                    adminCms.getRequestContext().setCurrentProject(project);
                    adminCms.getRequestContext().setUri(resourceName);
                    CmsResource res = null;
                    try {
                        res = adminCms.readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION);
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                    if (res == null) {
                        try {
                            res = OpenCms.initResource(adminCms, resourceName, req, null);
                        }
                        catch (CmsException cmsException) {
                            // empty catch block
                        }
                    }
                    if (res != null) {
                        try {
                            encoding = adminCms.readPropertyObject(res, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
                        }
                        catch (CmsException e) {
                            if (!LOG.isInfoEnabled()) break block15;
                            LOG.info((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", resourceName), (Throwable)e);
                        }
                    }
                }
                if (encoding == null) {
                    encoding = OpenCms.getSystemInfo().getDefaultEncoding();
                }
                return new CmsI18nInfo(locale, encoding);
            }
        }
        return super.getI18nInfo(req, user, project, resourceName);
    }

    @Override
    public void initHandler(CmsObject cms) {
        this.m_adminCmsObject = cms;
        super.initHandler(cms);
    }
}

