/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.ui.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsContainerPageCopier {
    private static final Log LOG = CmsLog.getLog(CmsContainerPageCopier.class);
    private CmsObject m_cms;
    private CmsObject m_rootCms;
    private CmsResource m_copiedFolderOrPage;
    private CopyMode m_copyMode = CopyMode.smartCopyAndChangeLocale;
    private Map<CmsUUID, CmsUUID> m_customReplacements;
    private Map<CmsUUID, CmsUUID> m_elementReplacements = Maps.newHashMap();
    private CmsResource m_originalPage;
    private CmsResource m_targetFolder;
    private Set<String> m_typesWithRequiredReplacements;

    public CmsContainerPageCopier(CmsObject cms) {
        this.m_cms = cms;
    }

    public void adjustLocalesForElement(CmsResource elementResource) throws CmsException {
        if (this.m_copyMode != CopyMode.smartCopyAndChangeLocale) {
            return;
        }
        CmsFile file = this.m_cms.readFile(elementResource);
        Locale oldLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, this.m_originalPage);
        Locale newLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, this.m_targetFolder);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, file);
        try {
            content.moveLocale(oldLocale, newLocale);
            LOG.info((Object)("Replacing locale " + oldLocale + " -> " + newLocale + " for " + elementResource.getRootPath()));
            file.setContents(content.marshal());
            this.m_cms.writeFile(file);
        }
        catch (CmsXmlException e) {
            LOG.info((Object)("NOT replacing locale for " + elementResource.getRootPath() + ": old=" + oldLocale + ", new=" + newLocale + ", contentLocales=" + content.getLocales()));
        }
    }

    public void copyPageOnly(CmsResource originalPage, String targetPageRootPath) throws CmsException, NoCustomReplacementException {
        if (null == originalPage || !OpenCms.getResourceManager().getResourceType(originalPage).getTypeName().equals(CmsResourceTypeXmlContainerPage.getStaticTypeName())) {
            throw new CmsException(new CmsMessageContainer(Messages.get(), "ERR_PAGECOPY_INVALID_PAGE_0"));
        }
        this.m_originalPage = originalPage;
        CmsObject rootCms = this.getRootCms();
        rootCms.copyResource(originalPage.getRootPath(), targetPageRootPath);
        CmsResource copiedPage = rootCms.readResource(targetPageRootPath, CmsResourceFilter.IGNORE_EXPIRATION);
        this.m_targetFolder = rootCms.readResource(CmsResource.getFolderPath(copiedPage.getRootPath()));
        this.replaceElements(copiedPage);
        this.attachLocaleGroups(copiedPage);
        this.tryUnlock(copiedPage);
    }

    public CmsResource getCopiedFolderOrPage() {
        return this.m_copiedFolderOrPage;
    }

    public CmsResource getTargetFolder() {
        return this.m_targetFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsContainerElementBean replaceContainerElement(CmsResource targetPage, CmsContainerElementBean originalElement) throws CmsException, NoCustomReplacementException {
        CmsObject targetCms = OpenCms.initCmsObject(this.m_cms);
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(this.m_targetFolder.getRootPath());
        if (site != null) {
            targetCms.getRequestContext().setSiteRoot(site.getSiteRoot());
        }
        if (originalElement.getFormatterId() == null || originalElement.getId() == null) {
            String rootPath = this.m_originalPage != null ? this.m_originalPage.getRootPath() : "???";
            LOG.warn((Object)("Skipping container element because of missing id in page: " + rootPath));
            return null;
        }
        if (this.m_elementReplacements.containsKey(originalElement.getId())) {
            return new CmsContainerElementBean(this.m_elementReplacements.get(originalElement.getId()), this.maybeReplaceFormatter(originalElement.getFormatterId()), this.maybeReplaceFormatterInSettings(originalElement.getIndividualSettings()), originalElement.isCreateNew());
        }
        CmsResource originalResource = this.m_cms.readResource(originalElement.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(originalResource);
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, targetPage.getRootPath());
        CmsResourceTypeConfig typeConfig = config.getResourceType(type.getTypeName());
        if (this.m_copyMode != CopyMode.reuse && typeConfig != null && (originalElement.isCreateNew() || typeConfig.isCopyInModels()) && !type.getTypeName().equals("modelgroup")) {
            CmsResource resourceCopy = typeConfig.createNewElement(targetCms, originalResource, targetPage.getRootPath());
            CmsContainerElementBean copy = new CmsContainerElementBean(resourceCopy.getStructureId(), this.maybeReplaceFormatter(originalElement.getFormatterId()), this.maybeReplaceFormatterInSettings(originalElement.getIndividualSettings()), originalElement.isCreateNew());
            this.m_elementReplacements.put(originalElement.getId(), resourceCopy.getStructureId());
            LOG.info((Object)("Copied container element " + originalResource.getRootPath() + " -> " + resourceCopy.getRootPath()));
            CmsLockActionRecord record = null;
            try {
                record = CmsLockUtil.ensureLock(this.m_cms, resourceCopy);
                this.adjustLocalesForElement(resourceCopy);
            }
            finally {
                if (record != null && record.getChange() == CmsLockActionRecord.LockChange.locked) {
                    this.m_cms.unlockResource(resourceCopy);
                }
            }
            return copy;
        }
        if (this.m_customReplacements != null) {
            CmsUUID replacementId = this.m_customReplacements.get(originalElement.getId());
            if (replacementId != null) {
                return new CmsContainerElementBean(replacementId, this.maybeReplaceFormatter(originalElement.getFormatterId()), this.maybeReplaceFormatterInSettings(originalElement.getIndividualSettings()), originalElement.isCreateNew());
            }
            if (this.m_typesWithRequiredReplacements != null && this.m_typesWithRequiredReplacements.contains(type.getTypeName())) {
                throw new NoCustomReplacementException(originalResource);
            }
            return originalElement;
        }
        LOG.info((Object)("Reusing container element: " + originalResource.getRootPath()));
        return originalElement;
    }

    public void replaceElements(CmsResource containerPage) throws CmsException, NoCustomReplacementException {
        CmsObject rootCms = this.getRootCms();
        CmsObject targetCms = OpenCms.initCmsObject(this.m_cms);
        targetCms.getRequestContext().setSiteRoot("");
        CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(this.m_targetFolder.getRootPath());
        if (site != null) {
            targetCms.getRequestContext().setSiteRoot(site.getSiteRoot());
        } else if (OpenCms.getSiteManager().startsWithShared(this.m_targetFolder.getRootPath())) {
            targetCms.getRequestContext().setSiteRoot(OpenCms.getSiteManager().getSharedFolder());
        }
        CmsProperty elementReplacementProp = rootCms.readPropertyObject(this.m_targetFolder, "element.replacements", true);
        if (elementReplacementProp != null && elementReplacementProp.getValue() != null) {
            try {
                CmsResource elementReplacementMap = targetCms.readResource(elementReplacementProp.getValue(), CmsResourceFilter.IGNORE_EXPIRATION);
                OpenCms.getLocaleManager();
                String encoding = CmsLocaleManager.getResourceEncoding(targetCms, elementReplacementMap);
                CmsFile elementReplacementFile = targetCms.readFile(elementReplacementMap);
                Properties props = new Properties();
                props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(elementReplacementFile.getContents()), encoding));
                CmsMacroResolver resolver = new CmsMacroResolver();
                resolver.addMacro("sourcesite", this.m_cms.getRequestContext().getSiteRoot().replaceAll("/+$", ""));
                resolver.addMacro("targetsite", targetCms.getRequestContext().getSiteRoot().replaceAll("/+$", ""));
                HashMap customReplacements = Maps.newHashMap();
                for (Map.Entry entry : props.entrySet()) {
                    if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    try {
                        String key = (String)entry.getKey();
                        if ("required".equals(key)) {
                            this.m_typesWithRequiredReplacements = Sets.newHashSet((Object[])((String)entry.getValue()).split(" *, *"));
                            continue;
                        }
                        key = resolver.resolveMacros(key);
                        String value = (String)entry.getValue();
                        value = resolver.resolveMacros(value);
                        CmsResource keyRes = rootCms.readResource(key, CmsResourceFilter.IGNORE_EXPIRATION);
                        CmsResource valRes = rootCms.readResource(value, CmsResourceFilter.IGNORE_EXPIRATION);
                        customReplacements.put(keyRes.getStructureId(), valRes.getStructureId());
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    this.m_customReplacements = customReplacements;
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        CmsXmlContainerPage pageXml = CmsXmlContainerPageFactory.unmarshal(this.m_cms, containerPage);
        CmsContainerPageBean page = pageXml.getContainerPage(this.m_cms);
        ArrayList newContainers = Lists.newArrayList();
        for (CmsContainerBean container : page.getContainers().values()) {
            ArrayList newElements = Lists.newArrayList();
            for (CmsContainerElementBean cmsContainerElementBean : container.getElements()) {
                CmsContainerElementBean newBean = this.replaceContainerElement(containerPage, cmsContainerElementBean);
                if (newBean == null) continue;
                newElements.add(newBean);
            }
            CmsContainerBean newContainer = new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.isRootContainer(), newElements);
            newContainers.add(newContainer);
        }
        CmsContainerPageBean newPageBean = new CmsContainerPageBean(newContainers);
        pageXml.save(rootCms, newPageBean);
    }

    public void run(CmsResource source, CmsResource target) throws CmsException, NoCustomReplacementException {
        this.run(source, target, null);
    }

    public void run(CmsResource source, CmsResource target, String targetName) throws CmsException, NoCustomReplacementException {
        CmsResource page;
        LOG.info((Object)("Starting page copy process: page='" + source.getRootPath() + "', targetFolder='" + target.getRootPath() + "'"));
        CmsObject rootCms = this.getRootCms();
        if (this.m_copyMode == CopyMode.automatic) {
            Locale sourceLocale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, source);
            Locale targetLocale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, target);
            LOG.debug((Object)("copy mode automatic: source=" + sourceLocale + " target=" + targetLocale + " reuseConfig=" + OpenCms.getLocaleManager().shouldReuseElements() + ""));
            this.m_copyMode = sourceLocale.equals(targetLocale) ? CopyMode.smartCopyAndChangeLocale : (OpenCms.getLocaleManager().shouldReuseElements() ? CopyMode.reuse : CopyMode.smartCopyAndChangeLocale);
        }
        if (source.isFolder()) {
            Double maxNavPosObj;
            String copyPath;
            if (source.equals(target)) {
                throw new CmsException(Messages.get().container("ERR_PAGECOPY_SOURCE_IS_TARGET_0"));
            }
            page = this.m_cms.readDefaultFile(source, CmsResourceFilter.IGNORE_EXPIRATION);
            if (page == null || !CmsResourceTypeXmlContainerPage.isContainerPage(page)) {
                throw new CmsException(Messages.get().container("ERR_PAGECOPY_INVALID_PAGE_0"));
            }
            ArrayList properties = Lists.newArrayList(this.m_cms.readPropertyObjects(source, false));
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                CmsProperty prop = (CmsProperty)iterator.next();
                if (!prop.getName().equals("locale") && !prop.getName().equals("element.replacements")) continue;
                iterator.remove();
            }
            I_CmsFileNameGenerator nameGen = OpenCms.getResourceManager().getNameGenerator();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(targetName)) {
                CmsResource existingResource;
                copyPath = CmsStringUtil.joinPaths(target.getRootPath(), targetName);
                if (rootCms.existsResource(copyPath) && !(existingResource = rootCms.readResource(copyPath)).isFolder()) {
                    copyPath = nameGen.getNewFileName(rootCms, copyPath + "%(number)", 4, true);
                }
            } else {
                copyPath = CmsFileUtil.removeTrailingSeparator(CmsStringUtil.joinPaths(target.getRootPath(), source.getName()));
                copyPath = nameGen.getNewFileName(rootCms, copyPath + "%(number)", 4, true);
            }
            double maxNavpos = (maxNavPosObj = this.readMaxNavPos(target)) == null ? 0.0 : maxNavPosObj;
            boolean hasNavpos = maxNavPosObj != null;
            CmsResource copiedFolder = null;
            CmsLockActionRecord lockRecord = null;
            if (rootCms.existsResource(copyPath)) {
                copiedFolder = rootCms.readResource(copyPath);
                lockRecord = CmsLockUtil.ensureLock(rootCms, copiedFolder);
                rootCms.writePropertyObjects(copyPath, (List<CmsProperty>)properties);
            } else {
                copiedFolder = rootCms.createResource(copyPath, OpenCms.getResourceManager().getResourceType("folder"), null, (List<CmsProperty>)properties);
            }
            if (hasNavpos) {
                String newNavPosStr = "" + (maxNavpos + 10.0);
                rootCms.writePropertyObject(copiedFolder.getRootPath(), new CmsProperty("NavPos", newNavPosStr, null));
            }
            String pageCopyPath = CmsStringUtil.joinPaths(copiedFolder.getRootPath(), page.getName());
            this.m_originalPage = page;
            this.m_targetFolder = target;
            this.m_copiedFolderOrPage = copiedFolder;
            if (rootCms.existsResource(pageCopyPath, CmsResourceFilter.IGNORE_EXPIRATION)) {
                rootCms.deleteResource(pageCopyPath, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            rootCms.copyResource(page.getRootPath(), pageCopyPath);
            CmsResource copiedPage = rootCms.readResource(pageCopyPath, CmsResourceFilter.IGNORE_EXPIRATION);
            this.replaceElements(copiedPage);
            this.attachLocaleGroups(copiedPage);
            if (lockRecord == null || lockRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                this.tryUnlock(copiedFolder);
            }
        } else {
            int lastSlash;
            page = source;
            if (!CmsResourceTypeXmlContainerPage.isContainerPage(page)) {
                throw new CmsException(Messages.get().container("ERR_PAGECOPY_INVALID_PAGE_0"));
            }
            I_CmsFileNameGenerator nameGen = OpenCms.getResourceManager().getNameGenerator();
            String copyPath = CmsFileUtil.removeTrailingSeparator(CmsStringUtil.joinPaths(target.getRootPath(), source.getName()));
            int lastDot = copyPath.lastIndexOf(".");
            if (lastDot > (lastSlash = copyPath.lastIndexOf("/"))) {
                String macroPath = copyPath.substring(0, lastDot) + "%(number)" + copyPath.substring(lastDot);
                copyPath = nameGen.getNewFileName(rootCms, macroPath, 4, true);
            } else {
                copyPath = nameGen.getNewFileName(rootCms, copyPath + "%(number)", 4, true);
            }
            Double maxNavPosObj = this.readMaxNavPos(target);
            double maxNavpos = maxNavPosObj == null ? 0.0 : maxNavPosObj;
            boolean hasNavpos = maxNavPosObj != null;
            rootCms.copyResource(page.getRootPath(), copyPath);
            if (hasNavpos) {
                String newNavPosStr = "" + (maxNavpos + 10.0);
                rootCms.writePropertyObject(copyPath, new CmsProperty("NavPos", newNavPosStr, null));
            }
            CmsResource copiedPage = rootCms.readResource(copyPath);
            this.m_originalPage = page;
            this.m_targetFolder = target;
            this.m_copiedFolderOrPage = copiedPage;
            this.replaceElements(copiedPage);
            this.attachLocaleGroups(copiedPage);
            this.tryUnlock(copiedPage);
        }
    }

    public void setCopyMode(CopyMode copyMode) {
        this.m_copyMode = copyMode;
    }

    Double readMaxNavPos(CmsResource target) throws CmsException {
        List<CmsResource> existingResourcesInFolder = this.m_cms.readResources(target, CmsResourceFilter.IGNORE_EXPIRATION, false);
        double maxNavpos = 0.0;
        boolean hasNavpos = false;
        for (CmsResource existingResource : existingResourcesInFolder) {
            CmsProperty navpos = this.m_cms.readPropertyObject(existingResource, "NavPos", false);
            if (navpos.getValue() == null) continue;
            try {
                double navposNum = Double.parseDouble(navpos.getValue());
                hasNavpos = true;
                maxNavpos = Math.max(navposNum, maxNavpos);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (hasNavpos) {
            return maxNavpos;
        }
        return null;
    }

    private void attachLocaleGroups(CmsResource copiedPage) throws CmsException {
        CmsLocaleGroupService localeGroupService = this.getRootCms().getLocaleGroupService();
        if (CmsLocaleGroupService.Status.linkable == localeGroupService.checkLinkable(this.m_originalPage, copiedPage)) {
            try {
                localeGroupService.attachLocaleGroupIndirect(this.m_originalPage, copiedPage);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private CmsObject getRootCms() throws CmsException {
        if (null == this.m_rootCms) {
            this.m_rootCms = OpenCms.initCmsObject(this.m_cms);
            this.m_rootCms.getRequestContext().setSiteRoot("");
        }
        return this.m_rootCms;
    }

    private CmsUUID maybeReplaceFormatter(CmsUUID formatterId) {
        CmsUUID replacement;
        if (this.m_customReplacements != null && (replacement = this.m_customReplacements.get(formatterId)) != null) {
            return replacement;
        }
        return formatterId;
    }

    private Map<String, String> maybeReplaceFormatterInSettings(Map<String, String> individualSettings) {
        if (individualSettings == null) {
            return null;
        }
        if (this.m_customReplacements == null) {
            return individualSettings;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : individualSettings.entrySet()) {
            CmsUUID valueId;
            String value = entry.getValue();
            if (CmsUUID.isValidUUID(value) && this.m_customReplacements.containsKey(valueId = new CmsUUID(value))) {
                value = "" + this.m_customReplacements.get(valueId);
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    private void tryUnlock(CmsResource resource) {
        try {
            this.m_cms.unlockResource(resource);
        }
        catch (CmsException e) {
            LOG.debug((Object)("failed to unlock " + resource.getRootPath()), (Throwable)e);
        }
    }

    public static class NoCustomReplacementException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private CmsResource m_resource;

        public NoCustomReplacementException(CmsResource resource) {
            this.m_resource = resource;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }
    }

    public static enum CopyMode {
        automatic,
        reuse,
        smartCopy,
        smartCopyAndChangeLocale;

    }
}

