/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import java.util.ArrayList;
import java.util.Arrays;
import org.opencms.util.CmsStringUtil;

public class CmsByteBuffer {
    private byte[] m_buffer;
    private int m_size;

    public CmsByteBuffer() {
        this(5);
    }

    public CmsByteBuffer(int capacity) {
        this.m_buffer = new byte[Math.max(capacity, 5)];
        this.m_size = 0;
    }

    public int getCapacity() {
        return this.m_buffer.length;
    }

    public void readBytes(byte[] dest, int srcStart, int destStart, int len) {
        System.arraycopy(this.m_buffer, srcStart, dest, destStart, len);
    }

    public int size() {
        return this.m_size;
    }

    public String toString() {
        ArrayList<String> fragments = new ArrayList<String>();
        fragments.add("[");
        int i = 0;
        for (byte b : this.m_buffer) {
            if (i == this.m_size) {
                fragments.add("|");
            }
            fragments.add("" + b);
            ++i;
        }
        fragments.add("]");
        return CmsStringUtil.listAsString(fragments, " ");
    }

    public void truncate(int size) {
        this.ensureCapacity(size);
        int minSize = Math.min(size, this.m_size);
        int maxSize = Math.max(size, this.m_size);
        Arrays.fill(this.m_buffer, minSize, maxSize, (byte)0);
        this.m_size = size;
    }

    public void writeBytes(byte[] src, int srcStart, int destStart, int len) {
        int newEnd = destStart + len;
        this.ensureCapacity(newEnd);
        if (newEnd > this.m_size) {
            this.m_size = newEnd;
        }
        System.arraycopy(src, srcStart, this.m_buffer, destStart, len);
    }

    private void ensureCapacity(int requestedCapacity) {
        if (requestedCapacity > this.getCapacity()) {
            int newCapacity = this.getCapacity();
            while (requestedCapacity > newCapacity) {
                newCapacity = newCapacity * 3 / 2;
            }
            this.reallocateBuffer(newCapacity);
        }
    }

    private void reallocateBuffer(int newCapacity) {
        byte[] newBuffer = new byte[newCapacity];
        System.arraycopy(this.m_buffer, 0, newBuffer, 0, Math.min(this.m_size, newCapacity));
        this.m_buffer = newBuffer;
    }
}

