/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.file.wrapper.CmsSilentWrapperException;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.jlan.CmsJlanDeviceContext;
import org.opencms.jlan.CmsJlanDiskInterface;
import org.opencms.jlan.CmsJlanUsers;
import org.opencms.jlan.CmsRepositoryAccessControl;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsShell;
import org.opencms.main.OpenCms;
import org.opencms.repository.CmsRepositoryFilter;
import org.opencms.repository.CmsRepositoryManager;
import org.opencms.repository.I_CmsRepository;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;

public class CmsJlanRepository
implements I_CmsRepository {
    public static final String PARAM_ADD_BOM = "addBOM";
    public static final String PARAM_PROJECT = "project";
    public static final String PARAM_ROOT = "root";
    public static final String PARAM_WRAPPER = "wrapper";
    private static final Log LOG = CmsLog.getLog(CmsJlanRepository.class);
    private boolean m_addByteOrderMark;
    private CmsObject m_cms;
    private CmsParameterConfiguration m_configuration = new CmsParameterConfiguration();
    private DiskSharedDevice m_device;
    private DiskDeviceContext m_deviceContext;
    private DiskInterface m_diskInterface;
    private String m_name;
    private CmsJlanDiskInterface m_originalDiskInterface;
    private CmsProject m_project;
    private String m_projectName;
    private String m_root;
    private List<I_CmsResourceWrapper> m_wrappers = Lists.newArrayList();

    public CmsJlanRepository() {
        this.m_deviceContext = new CmsJlanDeviceContext(this);
        this.m_deviceContext.enableChangeHandler(true);
        this.m_deviceContext.setFileServerNotifications(true);
        this.m_originalDiskInterface = new CmsJlanDiskInterface();
        this.m_diskInterface = CmsJlanRepository.createLoggingProxy(this.m_originalDiskInterface);
    }

    public static DiskInterface createLoggingProxy(final DiskInterface impl) {
        return (DiskInterface)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DiskInterface.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] params) throws Throwable {
                if (LOG.isInfoEnabled()) {
                    ArrayList<String> paramStrings = new ArrayList<String>();
                    for (Object param : params) {
                        paramStrings.add("" + param);
                    }
                    String paramsAsString = CmsStringUtil.listAsString(paramStrings, ", ");
                    LOG.info((Object)("Call: " + method.getName() + " " + paramsAsString));
                }
                try {
                    Object result = method.invoke((Object)impl, params);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Returned from " + method.getName() + ": " + result));
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof CmsSilentWrapperException) {
                        LOG.info((Object)cause.getCause().getLocalizedMessage(), cause.getCause());
                    } else {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    throw e.getCause();
                }
            }
        });
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.add(paramName, paramValue);
    }

    public boolean allowAccess(String user) {
        try {
            return this.m_cms.getPermissions(this.m_root, user).requiresViewPermission();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return true;
        }
    }

    public CmsObjectWrapper getCms(SrvSession session, TreeConnection connection) throws CmsException {
        String userName = session.getClientInformation().getUserName();
        userName = CmsJlanUsers.translateUser(userName);
        CmsContextInfo contextInfo = new CmsContextInfo(this.m_cms.getRequestContext());
        contextInfo.setUserName(userName);
        CmsObject newCms = OpenCms.initCmsObject(this.m_cms, contextInfo);
        newCms.getRequestContext().setSiteRoot(this.getRoot());
        newCms.getRequestContext().setCurrentProject(this.getProject());
        CmsObjectWrapper result = new CmsObjectWrapper(newCms, this.getWrappers());
        result.setAddByteOrderMark(this.m_addByteOrderMark);
        result.getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
        return result;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public DiskDeviceContext getDeviceContext() {
        return this.m_deviceContext;
    }

    public DiskInterface getDiskInterface() {
        return this.m_diskInterface;
    }

    @Override
    public CmsRepositoryFilter getFilter() {
        return null;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public CmsProject getProject() {
        return this.m_project;
    }

    public String getRoot() {
        return this.m_root;
    }

    public List<I_CmsResourceWrapper> getWrappers() {
        return this.m_wrappers;
    }

    @Override
    public void initConfiguration() throws CmsConfigurationException {
        List<I_CmsResourceWrapper> wrapperObjects = CmsRepositoryManager.createResourceWrappersFromConfiguration(this.getConfiguration(), PARAM_WRAPPER, LOG);
        this.m_wrappers = Collections.unmodifiableList(wrapperObjects);
        this.m_root = this.getConfiguration().getString(PARAM_ROOT, "").trim();
        this.m_projectName = this.getConfiguration().getString(PARAM_PROJECT, "Offline").trim();
        String addByteOrderMarkStr = this.getConfiguration().getString(PARAM_ADD_BOM, "true").trim();
        this.m_addByteOrderMark = Boolean.parseBoolean(addByteOrderMarkStr);
    }

    @Override
    public void initializeCms(CmsObject cms) throws CmsException {
        this.m_cms = cms;
        if (CmsShell.isJlanDisabled()) {
            return;
        }
        this.m_project = this.m_cms.readProject(this.m_projectName);
        this.m_device = new DiskSharedDevice(this.getName(), (DeviceInterface)this.getDiskInterface(), this.getDeviceContext(), 0);
        this.m_device.addAccessControl((AccessControl)new CmsRepositoryAccessControl(this));
    }

    @Override
    public void setFilter(CmsRepositoryFilter filter) {
    }

    @Override
    public void setName(String name) {
        this.m_name = name.toUpperCase();
    }

    DiskSharedDevice getSharedDevice() {
        return this.m_device;
    }
}

