/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import java.io.File;
import org.alfresco.jlan.app.JLANServer;
import org.apache.commons.logging.Log;
import org.opencms.jlan.CmsJlanServer;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsJlanThreadManager {
    private static final Log LOG = CmsLog.getLog(CmsJlanThreadManager.class);
    private static final int MAX_SHUTDOWN_WAIT_MILLIS = 30000;
    private Thread m_thread;

    public synchronized void start() {
        String path = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf("config/jlanConfig.xml");
        File configFile = new File(path);
        if (configFile.exists()) {
            if (this.m_thread == null) {
                this.m_thread = new JlanThread(path);
                this.m_thread.start();
            }
        } else {
            String message = "Not starting JLAN server because no config file was found at " + path;
            System.out.println(message);
            LOG.warn((Object)message);
        }
    }

    public synchronized void stop() {
        if (this.m_thread != null) {
            long timeBeforeShutdownWasCalled = System.currentTimeMillis();
            JLANServer.shutdownServer((String[])new String[0]);
            while (this.m_thread.isAlive() && System.currentTimeMillis() - timeBeforeShutdownWasCalled < 30000L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected class JlanThread
    extends Thread {
        private String m_configPath;

        public JlanThread(String configPath) {
            this.m_configPath = configPath;
        }

        @Override
        public void run() {
            CmsJlanServer server = new CmsJlanServer();
            JLANServer.setAllowConsoleShutdown((boolean)false);
            server.start(new String[]{this.m_configPath});
        }
    }
}

