/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.json;

import java.io.IOException;
import java.io.Writer;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;

public class JSONWriter {
    private static final int MAXDEPTH = 20;
    protected char m_mode = (char)105;
    protected Writer m_writer;
    private boolean m_comma = false;
    private char[] m_stack = new char[20];
    private int m_top = 0;

    public JSONWriter(Writer w) {
        this.m_writer = w;
    }

    public JSONWriter array() throws JSONException {
        if (this.m_mode == 'i' || this.m_mode == 'o' || this.m_mode == 'a') {
            this.push('a');
            this.append("[");
            this.m_comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    public JSONWriter endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONWriter endObject() throws JSONException {
        return this.end('k', '}');
    }

    public JSONWriter key(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.m_mode == 'k') {
            try {
                if (this.m_comma) {
                    this.m_writer.write(44);
                }
                this.m_writer.write(JSONObject.quote(s));
                this.m_writer.write(58);
                this.m_comma = false;
                this.m_mode = (char)111;
                return this;
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONWriter object() throws JSONException {
        if (this.m_mode == 'i') {
            this.m_mode = (char)111;
        }
        if (this.m_mode == 'o' || this.m_mode == 'a') {
            this.append("{");
            this.push('k');
            this.m_comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    public JSONWriter value(boolean b) throws JSONException {
        return this.append(b ? "true" : "false");
    }

    public JSONWriter value(double d) throws JSONException {
        return this.value(new Double(d));
    }

    public JSONWriter value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    public JSONWriter value(Object o) throws JSONException {
        return this.append(JSONObject.valueToString(o));
    }

    private JSONWriter append(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.m_mode == 'o' || this.m_mode == 'a') {
            try {
                if (this.m_comma && this.m_mode == 'a') {
                    this.m_writer.write(44);
                }
                this.m_writer.write(s);
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
            if (this.m_mode == 'o') {
                this.m_mode = (char)107;
            }
            this.m_comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    private JSONWriter end(char m, char c) throws JSONException {
        if (this.m_mode != m) {
            throw new JSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        try {
            this.m_writer.write(c);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.m_comma = true;
        return this;
    }

    private void pop(char c) throws JSONException {
        if (this.m_top <= 0 || this.m_stack[this.m_top - 1] != c) {
            throw new JSONException("Nesting error.");
        }
        --this.m_top;
        this.m_mode = (char)(this.m_top == 0 ? 100 : this.m_stack[this.m_top - 1]);
    }

    private void push(char c) throws JSONException {
        if (this.m_top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        this.m_stack[this.m_top] = c;
        this.m_mode = c;
        ++this.m_top;
    }
}

