/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsJspNavElement
implements Comparable<CmsJspNavElement> {
    private static final Log LOG = CmsLog.getLog(CmsJspNavElement.class);
    protected Locale m_locale;
    protected CmsJspNavBuilder.NavContext m_navContext;
    private boolean m_changedNavPos;
    private String m_fileName;
    private Boolean m_hasNav;
    private Boolean m_isHiddenNavigationEntry;
    private Map<String, String> m_localeProperties;
    private int m_navTreeLevel = Integer.MIN_VALUE;
    private float m_position;
    private Map<String, String> m_properties;
    private CmsResource m_resource;
    private String m_sitePath;
    private String m_text;
    private List<CmsJspNavElement> m_subNavigation;

    public CmsJspNavElement() {
    }

    public CmsJspNavElement(String sitePath, CmsResource resource, Map<String, String> properties) {
        this.setResource(resource);
        this.init(sitePath, properties);
    }

    public CmsJspNavElement(String sitePath, CmsResource resource, Map<String, String> properties, int navTreeLevel) {
        this(sitePath, resource, properties, navTreeLevel, null);
    }

    public CmsJspNavElement(String sitePath, CmsResource resource, Map<String, String> properties, int navTreeLevel, Locale locale) {
        this.setResource(resource);
        this.init(sitePath, properties, navTreeLevel, locale);
    }

    @Deprecated
    public CmsJspNavElement(String sitePath, Map<String, String> properties) {
        this.init(sitePath, properties, -1, null);
    }

    @Deprecated
    public CmsJspNavElement(String sitePath, Map<String, String> properties, int navTreeLevel) {
        this.init(sitePath, properties, navTreeLevel, null);
    }

    @Override
    public int compareTo(CmsJspNavElement obj) {
        if (obj == this) {
            return 0;
        }
        float pos = obj.getNavPosition();
        if (this.m_position == pos) {
            return 0;
        }
        return this.m_position < pos ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsJspNavElement) {
            return ((CmsJspNavElement)obj).m_sitePath.equals(this.m_sitePath);
        }
        return false;
    }

    public String getDescription() {
        return this.getProperties().get("Description");
    }

    public String getFileName() {
        if (this.m_fileName == null) {
            this.m_fileName = !this.m_sitePath.endsWith("/") ? this.m_sitePath.substring(this.m_sitePath.lastIndexOf("/") + 1, this.m_sitePath.length()) : this.m_sitePath.substring(this.m_sitePath.substring(0, this.m_sitePath.length() - 1).lastIndexOf("/") + 1, this.m_sitePath.length());
        }
        return this.m_fileName;
    }

    public String getInfo() {
        return this.getProperties().get("NavInfo");
    }

    public String getLocale() {
        return this.getProperties().get("locale");
    }

    public CmsJspNavBuilder.NavContext getNavContext() {
        return this.m_navContext;
    }

    public String getNavImage() {
        return this.getProperties().get("NavImage");
    }

    public float getNavPosition() {
        return this.m_position;
    }

    public String getNavText() {
        if (this.m_text == null) {
            this.m_text = this.getProperties().get("NavText");
            if (this.m_text == null) {
                this.m_text = CmsMessages.formatUnknownKey("NavText");
            }
        }
        return this.m_text;
    }

    public int getNavTreeLevel() {
        if (this.m_navTreeLevel == Integer.MIN_VALUE) {
            this.m_navTreeLevel = CmsResource.getPathLevel(this.m_sitePath);
        }
        return this.m_navTreeLevel;
    }

    public String getParentFolderName() {
        return CmsResource.getParentFolder(this.m_sitePath);
    }

    public Map<String, String> getProperties() {
        if (null == this.m_locale) {
            return this.m_properties;
        }
        return this.getLocaleProperties();
    }

    public String getProperty(String key) {
        return this.getProperties().get(key);
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public String getResourceName() {
        return this.m_sitePath;
    }

    public List<CmsJspNavElement> getSubNavigation() {
        if (this.m_subNavigation == null) {
            if (this.m_resource.isFile()) {
                this.m_subNavigation = Collections.emptyList();
            } else if (this.m_navContext == null) {
                try {
                    throw new Exception("Can not get subnavigation because navigation context is not set.");
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    this.m_subNavigation = Collections.emptyList();
                }
            } else {
                CmsJspNavBuilder navBuilder = this.m_navContext.getNavBuilder();
                this.m_subNavigation = navBuilder.getNavigationForFolder(navBuilder.getCmsObject().getSitePath(this.m_resource), this.m_navContext.getVisibility(), this.m_navContext.getFilter());
            }
        }
        return this.m_subNavigation;
    }

    public String getTitle() {
        return this.getProperties().get("Title");
    }

    public boolean hasChangedNavPosition() {
        return this.m_changedNavPos;
    }

    public int hashCode() {
        return this.m_sitePath.hashCode();
    }

    public void init(String resource, Map<String, String> properties) {
        this.init(resource, properties, -1, null);
    }

    public void init(String resource, Map<String, String> properties, int navTreeLevel) {
        this.init(resource, properties, navTreeLevel, null);
    }

    public void init(String resource, Map<String, String> properties, int navTreeLevel, Locale locale) {
        this.m_sitePath = resource;
        this.m_properties = properties;
        this.m_navTreeLevel = navTreeLevel;
        this.m_locale = locale;
        this.m_position = Float.MAX_VALUE;
        try {
            this.m_position = Float.parseFloat(this.getProperties().get("NavPos"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isFolderLink() {
        return this.m_sitePath.endsWith("/");
    }

    public boolean isHiddenNavigationEntry() {
        if (this.m_isHiddenNavigationEntry == null) {
            String navInfo = this.getProperties().get("NavInfo");
            this.m_isHiddenNavigationEntry = "ignoreInDefaultNav".equals(navInfo);
        }
        return this.m_isHiddenNavigationEntry;
    }

    public boolean isInNavigation() {
        if (this.m_hasNav == null) {
            String o1 = this.getProperties().get("NavText");
            String o2 = this.getProperties().get("NavPos");
            this.m_hasNav = (o1 != null || o2 != null) && !CmsResource.isTemporaryFileName(this.m_sitePath);
        }
        return this.m_hasNav;
    }

    public boolean isNavigationLevel() {
        return "##navigation_level_folder##".equals(this.getProperties().get("default-file"));
    }

    public void setNavContext(CmsJspNavBuilder.NavContext navContext) {
        this.m_navContext = navContext;
    }

    public void setNavPosition(float value) {
        this.m_position = value;
        this.m_changedNavPos = true;
    }

    public void setNavText(String text) {
        this.m_text = text;
    }

    public void setNavTreeLevel(int navTreeLevel) {
        this.m_navTreeLevel = navTreeLevel;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", sitePath: ");
        result.append(this.m_sitePath);
        result.append(", navPosition: ");
        result.append(this.getNavPosition());
        result.append(", navText ");
        result.append(this.getNavText());
        result.append(", navTreeLevel: ");
        result.append(this.getNavTreeLevel());
        result.append("]");
        return result.toString();
    }

    protected String getSitePath() {
        return this.m_sitePath;
    }

    protected void setResource(CmsResource resource) {
        this.m_resource = resource;
    }

    private Map<String, String> getLocaleProperties() {
        if (this.m_localeProperties == null) {
            this.m_localeProperties = CmsCollectionsGenericWrapper.createLazyMap(new CmsProperty.CmsPropertyLocaleTransformer(this.m_properties, this.m_locale));
        }
        return this.m_localeProperties;
    }
}

