/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsContentInfoBean;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.CmsJspTagContentLoad;
import org.opencms.jsp.CmsJspTagResourceLoad;
import org.opencms.jsp.I_CmsResourceContainer;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsMacroResolver;

public class CmsJspTagContentInfo
extends CmsJspScopedVarBodyTagSuport
implements I_CmsMacroResolver {
    private static final String[] KEYS = new String[]{"resultSize", "resultIndex", "pageCount", "pageIndex", "pageSize", "pageNavStartIndex", "pageNavEndIndex", "pageNavLength"};
    private static final List<String> KEYS_LIST = Collections.unmodifiableList(Arrays.asList(KEYS));
    private static final Log LOG = CmsLog.getLog(CmsJspTagContentInfo.class);
    private static final long serialVersionUID = -1955531050687258685L;
    private String m_value;

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        Tag ancestor = CmsJspTagContentInfo.findAncestorWithClass((Tag)this, I_CmsResourceContainer.class);
        if (ancestor == null) {
            CmsMessageContainer container = Messages.get().container("ERR_PARENTLESS_TAG_1", "contentinfo");
            String msg = Messages.getLocalizedMessage(container, this.pageContext);
            throw new JspTagException(msg);
        }
        I_CmsResourceContainer contentContainer = (I_CmsResourceContainer)ancestor;
        String tagContent = "";
        if (this.isScopeVarSet()) {
            if (contentContainer instanceof CmsJspTagContentLoad) {
                this.storeContentInfoBean((CmsJspTagContentLoad)contentContainer);
            } else if (contentContainer instanceof CmsJspTagResourceLoad) {
                this.storeContentInfoBean((CmsJspTagResourceLoad)contentContainer);
            }
        }
        if (CmsStringUtil.isNotEmpty(this.m_value)) {
            tagContent = this.resolveMacros(this.m_value);
        }
        try {
            this.pageContext.getOut().print(tagContent);
        }
        catch (IOException e) {
            CmsMessageContainer message = Messages.get().container("ERR_PROCESS_TAG_1", "contentinfo");
            LOG.error((Object)message.key(), (Throwable)e);
            throw new JspException(message.key(this.pageContext.getRequest().getLocale()));
        }
        return 0;
    }

    @Override
    public String getMacroValue(String macro) {
        CmsContentInfoBean bean;
        int dotIndex = macro.indexOf(46);
        String beanName = null;
        if (dotIndex <= 1 || dotIndex >= macro.length() - 1) {
            return null;
        }
        beanName = macro.substring(0, dotIndex);
        String variableName = macro.substring(dotIndex + 1, macro.length());
        if (CmsStringUtil.isEmpty(beanName) || CmsStringUtil.isEmpty(variableName)) {
            return null;
        }
        int scope = this.pageContext.getAttributesScope(beanName);
        try {
            bean = (CmsContentInfoBean)this.pageContext.getAttribute(beanName, scope);
        }
        catch (ClassCastException e) {
            return null;
        }
        if (bean == null) {
            return null;
        }
        switch (KEYS_LIST.indexOf(variableName)) {
            case 0: {
                return Integer.toString(bean.getResultSize());
            }
            case 1: {
                return Integer.toString(bean.getResultIndex());
            }
            case 2: {
                return Integer.toString(bean.getPageCount());
            }
            case 3: {
                return Integer.toString(bean.getPageIndex());
            }
            case 4: {
                return Integer.toString(bean.getPageSize());
            }
            case 5: {
                return Integer.toString(bean.getPageNavStartIndex());
            }
            case 6: {
                return Integer.toString(bean.getPageNavEndIndex());
            }
            case 7: {
                return Integer.toString(bean.getPageNavLength());
            }
        }
        return null;
    }

    public String getValue() {
        return this.m_value;
    }

    @Override
    public boolean isKeepEmptyMacros() {
        return true;
    }

    @Override
    public void release() {
        this.m_value = null;
        super.release();
    }

    @Override
    public String resolveMacros(String input) {
        return CmsMacroResolver.resolveMacros(input, this);
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    protected void storeContentInfoBean(CmsJspTagResourceLoad container) {
        CmsContentInfoBean contentInfoBean = container.getContentInfoBean();
        contentInfoBean.setPageSize(container.getContentInfoBean().getPageSize());
        contentInfoBean.setPageIndex(container.getContentInfoBean().getPageIndex());
        contentInfoBean.setResultSize(container.getContentInfoBean().getResultSize());
        this.storeAttribute(contentInfoBean);
    }
}

