/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspTagResourceLoad;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;

public class CmsJspTagContentShow
extends TagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagContentShow.class);
    private static final long serialVersionUID = -6776067180965738432L;
    private String m_element;
    private boolean m_escapeHtml;
    private Locale m_locale;

    public static String contentShowTagAction(I_CmsXmlContentContainer container, PageContext context, String element, Locale locale, boolean escape) {
        String content;
        CmsObject cms = CmsFlexController.getCmsObject(context.getRequest());
        I_CmsXmlDocument xmlContent = container.getXmlDocument();
        if (CmsMacroResolver.isMacro(element = CmsStringUtil.isEmpty(element) ? container.getXmlDocumentElement() : CmsXmlUtils.concatXpath(container.getXmlDocumentElement(), element))) {
            String resourcename = CmsJspTagResourceLoad.getResourceName(cms, container);
            CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setJspPageContext(context).setResourceName(resourcename).setKeepEmptyMacros(true);
            content = resolver.resolveMacros(element);
        } else if (xmlContent == null) {
            content = null;
        } else {
            if (locale == null) {
                locale = container.getXmlDocumentLocale();
            }
            if (xmlContent.hasValue(element, locale)) {
                try {
                    content = xmlContent.getStringValue(cms, element, locale);
                }
                catch (Exception e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_CONTENT_SHOW_1", element), (Throwable)e);
                    content = null;
                }
            } else {
                content = null;
            }
            if (content == null) {
                content = CmsMessages.formatUnknownKey(element);
            }
            if (escape) {
                content = CmsEncoder.escapeHtml(content);
            }
        }
        return content;
    }

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        Tag ancestor = CmsJspTagContentShow.findAncestorWithClass((Tag)this, I_CmsXmlContentContainer.class);
        if (ancestor == null) {
            CmsMessageContainer errMsgContainer = Messages.get().container("ERR_PARENTLESS_TAG_1", "contentshow");
            String msg = Messages.getLocalizedMessage(errMsgContainer, this.pageContext);
            throw new JspTagException(msg);
        }
        I_CmsXmlContentContainer contentContainer = (I_CmsXmlContentContainer)ancestor;
        String content = CmsJspTagContentShow.contentShowTagAction(contentContainer, this.pageContext, this.getElement(), this.m_locale, this.m_escapeHtml);
        try {
            if (content != null) {
                this.pageContext.getOut().print(content);
            }
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_JSP_BEAN_0"), (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public String getElement() {
        return this.m_element != null ? this.m_element : "";
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    public void release() {
        this.m_element = null;
        this.m_locale = null;
        super.release();
    }

    public void setElement(String element) {
        this.m_element = element;
    }

    public void setEscapeHtml(String value) {
        this.m_escapeHtml = value != null ? Boolean.valueOf(value.trim()) : false;
    }

    public void setLocale(String locale) {
        this.m_locale = CmsStringUtil.isEmpty(locale) ? null : CmsLocaleManager.getLocale(locale);
    }
}

