/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagEdit;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.util.CmsJspContentAccessValueWrapper;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.types.CmsXmlDisplayFormatterValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsJspTagDisplay
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    private static final Log LOG = CmsLog.getLog(CmsJspTagDisplay.class);
    private static final long serialVersionUID = 2285680951218629093L;
    private boolean m_canCreate;
    private boolean m_canDelete;
    private String m_creationSiteMap;
    private Map<String, CmsUUID> m_displayFormatterIds;
    private Map<String, String> m_displayFormatterPaths;
    private boolean m_editable;
    private Map<String, String> m_parameterMap = new LinkedHashMap<String, String>();
    private boolean m_passSettings;
    private String m_postCreateHandler;
    private Map<String, String> m_settings;
    private String m_value;

    public CmsJspTagDisplay() {
        this.m_displayFormatterPaths = new HashMap<String, String>();
        this.m_displayFormatterIds = new HashMap<String, CmsUUID>();
    }

    public static void displayAction(CmsContainerElementBean element, I_CmsFormatterBean formatter, boolean editable, boolean canCreate, boolean canDelete, String creationSiteMap, String postCreateHandler, PageContext context, ServletRequest request, ServletResponse response) {
        if (CmsFlexController.isCmsRequest(request)) {
            CmsJspStandardContextBean.CmsContainerElementWrapper parentElement;
            CmsJspStandardContextBean contextBean;
            block8: {
                CmsObject cms = CmsFlexController.getCmsObject(request);
                Locale locale = cms.getRequestContext().getLocale();
                boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                contextBean = CmsJspStandardContextBean.getInstance(request);
                parentElement = contextBean.getElement();
                try {
                    if (formatter == null) break block8;
                    element.initResource(cms);
                    element.initSettings(cms, formatter, locale, request, null);
                    boolean openedEditable = false;
                    contextBean.setElement(element);
                    if (editable && contextBean.getIsEditMode()) {
                        if (CmsJspTagEditable.getDirectEditProvider(context) == null) {
                            CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
                            eb.init(cms, CmsDirectEditMode.TRUE, element.getSitePath());
                            request.setAttribute("org.opencms.workplace.editors.directedit.__directEditProvider", (Object)eb);
                        }
                        openedEditable = CmsJspTagEdit.insertDirectEditStart(cms, context, element.getResource(), canCreate, canDelete, null, creationSiteMap, postCreateHandler);
                        CmsADESessionCache.getCache((HttpServletRequest)context.getRequest(), cms).setCacheContainerElement(element.editorHash(), element);
                    }
                    try {
                        CmsJspTagInclude.includeTagAction(context, cms.getRequestContext().removeSiteRoot(formatter.getJspRootPath()), null, locale, false, isOnline, CmsRequestUtil.createParameterMap(element.getSettings()), CmsRequestUtil.getAtrributeMap(request), request, response);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (openedEditable) {
                        CmsJspTagEdit.insertDirectEditEnd(context);
                    }
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            contextBean.setElement(parentElement);
        }
    }

    public static void displayAction(CmsContainerElementBean element, I_CmsFormatterBean formatter, PageContext context, ServletRequest request, ServletResponse response) {
        CmsJspTagDisplay.displayAction(element, formatter, false, false, false, null, null, context, request, response);
    }

    public static void displayAction(CmsResource elementResource, I_CmsFormatterBean formatter, Map<String, String> settings, boolean editable, boolean canCreate, boolean canDelete, String creationSiteMap, String postCreateHandler, PageContext context, ServletRequest request, ServletResponse response) {
        CmsContainerElementBean element = new CmsContainerElementBean(elementResource.getStructureId(), formatter.getJspStructureId(), settings, false);
        CmsJspTagDisplay.displayAction(element, formatter, editable, canCreate, canDelete, creationSiteMap, postCreateHandler, context, request, response);
    }

    public void addDisplayFormatter(String type, String path) {
        this.m_displayFormatterPaths.put(type, path);
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.m_parameterMap.put(name, value);
    }

    public int doEndTag() {
        ServletRequest request = this.pageContext.getRequest();
        ServletResponse response = this.pageContext.getResponse();
        if (CmsFlexController.isCmsRequest(request)) {
            CmsObject cms = CmsFlexController.getCmsObject(request);
            try {
                boolean isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
                CmsResource res = null;
                if (CmsUUID.isValidUUID(this.m_value)) {
                    CmsUUID structureId = new CmsUUID(this.m_value);
                    res = isOnline ? cms.readResource(structureId) : cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                } else {
                    res = isOnline ? cms.readResource(this.m_value) : cms.readResource(this.m_value, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                I_CmsFormatterBean formatter = this.getFormatterForType(cms, res, isOnline);
                HashMap<String, String> settings = new HashMap<String, String>();
                String formatterId = formatter.getId();
                int prefixLength = formatterId.length() + 1;
                for (Map.Entry<String, String> entry : this.m_parameterMap.entrySet()) {
                    if ("element_instance_id".equals(entry.getKey())) continue;
                    if (entry.getKey().startsWith("formatterSettings#")) {
                        settings.put(entry.getKey(), formatter.getId());
                        continue;
                    }
                    if (entry.getKey().startsWith(formatterId)) {
                        settings.put(entry.getKey().substring(prefixLength), entry.getValue());
                        continue;
                    }
                    if (settings.containsKey(entry.getKey())) continue;
                    settings.put(entry.getKey(), entry.getValue());
                }
                CmsJspTagDisplay.displayAction(res, formatter, settings, this.m_editable, this.m_canCreate, this.m_canDelete, this.m_creationSiteMap, this.m_postCreateHandler, this.pageContext, request, response);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.release();
        return 6;
    }

    public int doStartTag() {
        CmsJspStandardContextBean.CmsContainerElementWrapper element;
        if (Boolean.valueOf(this.m_passSettings).booleanValue() && (element = CmsJspStandardContextBean.getInstance(this.pageContext.getRequest()).getElement()) != null) {
            this.m_parameterMap.putAll(((CmsContainerElementBean)element).getSettings());
        }
        if (this.m_settings != null) {
            this.m_parameterMap.putAll(this.m_settings);
        }
        return 2;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public boolean getPassSettings() {
        return this.m_passSettings;
    }

    public Map<String, String> getSettings() {
        return this.m_settings;
    }

    public String getValue() {
        return this.m_value;
    }

    public void release() {
        super.release();
        this.m_parameterMap.clear();
        this.m_displayFormatterPaths.clear();
        this.m_displayFormatterIds.clear();
        this.m_settings = null;
        this.m_passSettings = false;
        this.m_editable = false;
        this.m_value = null;
    }

    public void setCreate(boolean canCreate) {
        this.m_canCreate = canCreate;
    }

    public void setCreate(String canCreate) {
        this.m_canCreate = Boolean.valueOf(canCreate);
    }

    public void setCreationSiteMap(String sitePath) {
        this.m_creationSiteMap = sitePath;
    }

    public void setDelete(boolean canDelete) {
        this.m_canDelete = canDelete;
    }

    public void setDelete(String canDelete) {
        this.m_canDelete = Boolean.valueOf(canDelete);
    }

    public void setDisplayFormatters(Object displayFormatters) {
        String[] temp;
        if (displayFormatters instanceof List) {
            for (Object formatterItem : (List)displayFormatters) {
                if (!(formatterItem instanceof CmsJspContentAccessValueWrapper)) continue;
                this.addFormatter((CmsJspContentAccessValueWrapper)formatterItem);
            }
        } else if (displayFormatters instanceof CmsJspContentAccessValueWrapper) {
            this.addFormatter((CmsJspContentAccessValueWrapper)displayFormatters);
        } else if (displayFormatters instanceof String && (temp = ((String)displayFormatters).split(":")).length == 2) {
            this.addDisplayFormatter(temp[0], temp[1]);
        }
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public void setEditable(String editable) {
        this.m_editable = Boolean.valueOf(editable);
    }

    public void setPassSettings(Boolean passSettings) {
        this.m_passSettings = passSettings;
    }

    public void setPostCreateHandler(String postCreateHandler) {
        this.m_postCreateHandler = postCreateHandler;
    }

    public void setSettings(Map<String, String> settings) {
        this.m_settings = settings;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    private void addFormatter(CmsJspContentAccessValueWrapper formatterItem) {
        I_CmsXmlContentValue val = formatterItem.getContentValue();
        if (val instanceof CmsXmlDisplayFormatterValue) {
            CmsXmlDisplayFormatterValue value = (CmsXmlDisplayFormatterValue)val;
            String type = value.getDisplayType();
            CmsUUID formatterId = value.getFormatterId();
            if (formatterId != null) {
                this.m_displayFormatterIds.put(type, formatterId);
            }
        }
    }

    private I_CmsFormatterBean getFormatterForType(CmsObject cms, CmsResource resource, boolean isOnline) {
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        I_CmsFormatterBean result = null;
        if (this.m_displayFormatterPaths.containsKey(typeName)) {
            try {
                CmsResource res = cms.readResource(this.m_displayFormatterPaths.get(typeName));
                result = OpenCms.getADEManager().getCachedFormatters(isOnline).getFormatters().get(res.getStructureId());
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (this.m_displayFormatterIds.containsKey(typeName)) {
            result = OpenCms.getADEManager().getCachedFormatters(isOnline).getFormatters().get(this.m_displayFormatterIds.get(typeName));
        } else {
            CmsFormatterConfiguration formatters;
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.addSiteRoot(cms.getRequestContext().getFolderUri()));
            if (config != null && (formatters = config.getFormatters(cms, resource)) != null) {
                result = formatters.getDisplayFormatter();
            }
        }
        return result;
    }
}

