/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.I_CmsCollectorPostCreateHandler;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.directedit.CmsDirectEditButtonSelection;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;

public class CmsJspTagEdit
extends CmsJspScopedVarBodyTagSuport {
    public static final String NEW_LINK_IDENTIFIER = "__edit__";
    private static final Log LOG = CmsLog.getLog(CmsJspTagEdit.class);
    private static final long serialVersionUID = -3781368910893187306L;
    private boolean m_canCreate;
    private boolean m_canDelete;
    private String m_createType;
    private String m_creationSiteMap;
    private boolean m_isEditOpen;
    private String m_postCreateHandler;
    private String m_uuid;

    public static String createResource(CmsObject cmsObject, String newLink, Locale locale, String sitePath, String modelFileName, String mode, String postCreateHandler) {
        String[] newLinkParts = newLink.split("\\|");
        String rootPath = newLinkParts[1];
        String typeName = newLinkParts[2];
        CmsFile modelFile = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)mode, (CharSequence)"copy")) {
            try {
                modelFile = cmsObject.readFile(sitePath);
            }
            catch (CmsException e) {
                LOG.warn((Object)("The resource at path" + sitePath + "could not be read. Thus it can not be used as model file."), (Throwable)e);
            }
        }
        CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cmsObject, rootPath);
        CmsResourceTypeConfig typeConfig = adeConfig.getResourceType(typeName);
        CmsResource newElement = null;
        try {
            CmsObject cmsClone = cmsObject;
            if (locale != null && !cmsObject.getRequestContext().getLocale().equals(locale)) {
                cmsClone = OpenCms.initCmsObject(cmsObject);
                cmsClone.getRequestContext().setLocale(locale);
            }
            newElement = typeConfig.createNewElement(cmsClone, modelFile, rootPath);
            CmsPair<String, String> handlerParameter = I_CmsCollectorPostCreateHandler.splitClassAndConfig(postCreateHandler);
            I_CmsCollectorPostCreateHandler handler = A_CmsResourceCollector.getPostCreateHandler(handlerParameter.getFirst());
            handler.onCreate(cmsClone, cmsClone.readFile(newElement), modelFile != null, handlerParameter.getSecond());
        }
        catch (CmsException e) {
            LOG.error((Object)"Could not create resource.", (Throwable)e);
        }
        return newElement == null ? null : cmsObject.getSitePath(newElement);
    }

    public static String getNewLink(CmsObject cms, I_CmsResourceType resType, String creationSitemap) {
        String contextPath = CmsJspTagEdit.getContextRootPath(cms, creationSitemap);
        StringBuffer newLink = new StringBuffer(NEW_LINK_IDENTIFIER);
        newLink.append('|');
        newLink.append(contextPath);
        newLink.append('|');
        newLink.append(resType.getTypeName());
        return newLink.toString();
    }

    public static String getRootPathFromNewLink(String newLink) {
        String result = null;
        if (newLink.startsWith(NEW_LINK_IDENTIFIER) && newLink.contains("|")) {
            result = newLink.substring(newLink.indexOf("|") + 1, newLink.lastIndexOf("|"));
        }
        return result;
    }

    public static String getTypeFromNewLink(String newLink) {
        String result = null;
        if (newLink.startsWith(NEW_LINK_IDENTIFIER) && newLink.contains("|")) {
            result = newLink.substring(newLink.lastIndexOf("|") + 1);
        }
        return result;
    }

    public static void insertDirectEditEnd(PageContext pageContext) {
        try {
            CmsJspTagEditable.endDirectEdit(pageContext);
        }
        catch (JspException e) {
            LOG.error((Object)"Could not print closing direct edit tag.", (Throwable)e);
        }
    }

    public static boolean insertDirectEditStart(CmsObject cms, PageContext pageContext, CmsResource resource, boolean canCreate, boolean canDelete, String createType, String creationSitemap, String postCreateHandler) {
        I_CmsResourceType resType;
        boolean result = false;
        CmsDirectEditParams editParams = null;
        if (resource != null) {
            I_CmsResourceType resType2;
            String newLink = null;
            if (canCreate && (resType2 = CmsJspTagEdit.getResourceType(resource, createType)) != null) {
                newLink = CmsJspTagEdit.getNewLink(cms, resType2, creationSitemap);
            }
            CmsDirectEditButtonSelection buttons = null;
            buttons = canDelete ? (newLink != null ? CmsDirectEditButtonSelection.EDIT_DELETE_NEW : CmsDirectEditButtonSelection.EDIT_DELETE) : (newLink != null ? CmsDirectEditButtonSelection.EDIT_NEW : CmsDirectEditButtonSelection.EDIT);
            editParams = new CmsDirectEditParams(cms.getSitePath(resource), buttons, null, newLink);
        } else if (canCreate && (resType = CmsJspTagEdit.getResourceType(null, createType)) != null) {
            editParams = new CmsDirectEditParams(cms.getRequestContext().getFolderUri(), CmsDirectEditButtonSelection.NEW, null, CmsJspTagEdit.getNewLink(cms, resType, creationSitemap));
        }
        if (editParams != null) {
            editParams.setPostCreateHandler(postCreateHandler);
            try {
                CmsJspTagEditable.startDirectEdit(pageContext, editParams);
                result = true;
            }
            catch (JspException e) {
                LOG.error((Object)"Could not create direct edit start.", (Throwable)e);
            }
        }
        return result;
    }

    private static String getContextRootPath(CmsObject cms, String creationSitemap) {
        String path = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(creationSitemap)) {
            try {
                path = cms.readFolder(creationSitemap).getRootPath();
            }
            catch (CmsException e) {
                LOG.warn((Object)("The provided creation sitemap " + creationSitemap + " is not a VFS folder."), (Throwable)e);
            }
        }
        if (path == null) {
            path = cms.addSiteRoot(cms.getRequestContext().getFolderUri());
        }
        return path;
    }

    private static I_CmsResourceType getResourceType(CmsResource resource, String createType) {
        I_CmsResourceType resType = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(createType)) {
            try {
                resType = OpenCms.getResourceManager().getResourceType(createType);
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)("Could not read resource type '" + createType + "' for resource creation."), (Throwable)e);
            }
        } else if (resource != null) {
            resType = OpenCms.getResourceManager().getResourceType(resource);
        }
        return resType;
    }

    public int doEndTag() throws JspException {
        if (this.m_isEditOpen) {
            CmsJspTagEditable.endDirectEdit(this.pageContext);
        }
        this.release();
        return 6;
    }

    public int doStartTag() throws CmsIllegalArgumentException {
        CmsObject cms = this.getCmsObject();
        this.m_isEditOpen = CmsJspTagEdit.insertDirectEditStart(cms, this.pageContext, this.getResourceToEdit(cms), this.m_canCreate || null != this.m_createType, this.m_canDelete, this.m_createType, this.m_creationSiteMap, this.m_postCreateHandler);
        return 1;
    }

    @Override
    public void release() {
        this.m_canCreate = false;
        this.m_canDelete = false;
        this.m_creationSiteMap = null;
        this.m_createType = null;
        this.m_isEditOpen = false;
        this.m_uuid = null;
        super.release();
    }

    public void setCreate(Boolean canCreate) {
        this.m_canCreate = canCreate == null ? false : canCreate;
    }

    public void setCreateType(String typeName) {
        this.m_createType = typeName;
    }

    public void setCreationSiteMap(String sitePath) {
        this.m_creationSiteMap = sitePath;
    }

    public void setDelete(Boolean canDelete) {
        this.m_canDelete = canDelete == null ? false : canDelete;
    }

    public void setPostCreateHandler(String postCreateHandler) {
        this.m_postCreateHandler = postCreateHandler;
    }

    public void setUuid(String uuid) {
        this.m_uuid = uuid;
    }

    private CmsObject getCmsObject() {
        CmsFlexController controller = CmsFlexController.getController(this.pageContext.getRequest());
        return controller.getCmsObject();
    }

    private CmsResource getResourceToEdit(CmsObject cms) {
        CmsResource resource = null;
        if (this.m_uuid != null) {
            try {
                CmsUUID uuid = new CmsUUID(this.m_uuid);
                resource = cms.readResource(uuid, CmsResourceFilter.ignoreExpirationOffline(cms));
            }
            catch (NumberFormatException | CmsException e) {
                LOG.warn((Object)"UUID was not valid or there is no resource with the given UUID.", (Throwable)e);
            }
        }
        return resource;
    }
}

