/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsJspTagElementSetting
extends TagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagElementSetting.class);
    private static final long serialVersionUID = -7847101480288189549L;
    private String m_defaultValue;
    private String m_elementSetting;
    private boolean m_escapeHtml;

    public static Map<String, String> elementSettingTagAction(ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        try {
            CmsContainerElementBean currentElement = OpenCms.getADEManager().getCurrentElement(req);
            currentElement.initResource(cms);
            return currentElement.getSettings();
        }
        catch (CmsException e) {
            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static String elementSettingTagAction(String setting, String defaultValue, boolean escape, ServletRequest req) {
        String value = CmsJspTagElementSetting.elementSettingTagAction(req).get(setting);
        if (value == null) {
            value = defaultValue;
        }
        if (escape) {
            value = CmsEncoder.escapeHtml(value);
        }
        return value;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String setting = CmsJspTagElementSetting.elementSettingTagAction(this.getName(), this.m_defaultValue, this.m_escapeHtml, req);
                if (setting == null) {
                    setting = "";
                }
                this.pageContext.getOut().print(setting);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "elementSetting"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getDefault() {
        return this.m_defaultValue != null ? this.m_defaultValue : "";
    }

    public String getEscapeHtml() {
        return String.valueOf(this.m_escapeHtml);
    }

    public String getName() {
        return this.m_elementSetting != null ? this.m_elementSetting : "";
    }

    public void release() {
        super.release();
        this.m_elementSetting = null;
        this.m_defaultValue = null;
        this.m_escapeHtml = false;
    }

    public void setDefault(String def) {
        if (def != null) {
            this.m_defaultValue = def;
        }
    }

    public void setEscapeHtml(String value) {
        this.m_escapeHtml = value != null ? Boolean.valueOf(value.trim()) : false;
    }

    public void setName(String name) {
        if (name != null) {
            this.m_elementSetting = name;
        }
    }
}

