/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.CmsDetailOnlyContainerUtil;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.CmsJspTagLink;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJspTagHeadIncludes
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    public static final String TYPE_CSS = "css";
    public static final String TYPE_JAVASCRIPT = "javascript";
    private static final Log LOG = CmsLog.getLog(CmsJspTagHeadIncludes.class);
    private static final long serialVersionUID = 5496349529835666345L;
    private String m_closeTags;
    private String m_defaults;
    private String m_detailType;
    private String m_detailWidth;
    private Map<String, String[]> m_parameterMap;
    private String m_type;

    public static void addParameter(Map<String, String[]> parameters, String name, String value, boolean overwrite) {
        if (parameters == null || name == null || value == null) {
            return;
        }
        if (parameters.containsKey(name) && !overwrite) {
            String[] values = parameters.get(name);
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            parameters.put(name, newValues);
        } else {
            String[] values = new String[]{value};
            parameters.put(name, values);
        }
    }

    protected static List<String> getHeadIncludes(I_CmsFormatterBean formatter, String type) {
        if (TYPE_CSS.equals(type)) {
            return Lists.newArrayList(formatter.getCssHeadIncludes());
        }
        if (TYPE_JAVASCRIPT.equals(type)) {
            return formatter.getJavascriptHeadIncludes();
        }
        return null;
    }

    protected static String getInlineData(I_CmsFormatterBean formatter, String type) {
        if (TYPE_CSS.equals(type)) {
            return formatter.getInlineCss();
        }
        if (TYPE_JAVASCRIPT.equals(type)) {
            return formatter.getInlineJavascript();
        }
        return null;
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.m_parameterMap == null) {
            this.m_parameterMap = new HashMap<String, String[]>();
        }
        CmsJspTagHeadIncludes.addParameter(this.m_parameterMap, name, value, false);
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        try {
            if (TYPE_CSS.equals(this.m_type)) {
                this.tagCssAction(cms, (HttpServletRequest)req);
            }
            if (TYPE_JAVASCRIPT.equals(this.m_type)) {
                this.tagJSAction(cms, (HttpServletRequest)req);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.m_parameterMap = null;
        }
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getDefaults() {
        return this.m_defaults;
    }

    public String getDetailtype() {
        return this.m_detailType;
    }

    public String getDetailwidth() {
        return this.m_detailWidth;
    }

    public String getType() {
        return this.m_type;
    }

    public void setClosetags(String closeTags) {
        this.m_closeTags = closeTags;
    }

    public void setDefaults(String defaults) {
        this.m_defaults = defaults;
    }

    public void setDetailtype(String detailType) {
        this.m_detailType = detailType;
    }

    public void setDetailwidth(String detailWidth) {
        this.m_detailWidth = detailWidth;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public boolean shouldCloseTags() {
        if (this.m_closeTags == null) {
            return true;
        }
        return Boolean.parseBoolean(this.m_closeTags);
    }

    public void tagCssAction(CmsObject cms, HttpServletRequest req) throws CmsException, IOException {
        StringBuffer inline;
        String includeType = TYPE_CSS;
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        LinkedHashSet<String> cssIncludes = new LinkedHashSet<String>();
        LinkedHashMap<String, String> inlineCss = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                cssIncludes.add(defaults[i].trim());
            }
        }
        this.collectHeadIncludesForContainerElement(cms, (ServletRequest)req, standardContext, containerPage, includeType, cssIncludes, inlineCss);
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId(), CmsResourceFilter.ignoreExpirationOffline(cms));
                CmsFormatterConfiguration config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()).getFormatters(cms, detailContent);
                boolean requiresAllIncludes = true;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailtype()) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailwidth())) {
                    try {
                        int width = Integer.parseInt(this.getDetailwidth());
                        I_CmsFormatterBean formatter = config.getDetailFormatter(this.getDetailtype(), width);
                        cssIncludes.addAll(formatter.getCssHeadIncludes());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineCss())) {
                            inlineCss.put(formatter.getId(), formatter.getInlineCss());
                        }
                        requiresAllIncludes = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (requiresAllIncludes) {
                    for (I_CmsFormatterBean formatter : config.getDetailFormatters()) {
                        cssIncludes.addAll(CmsJspTagHeadIncludes.getHeadIncludes(formatter, includeType));
                        String inlineIncludeData = CmsJspTagHeadIncludes.getInlineData(formatter, includeType);
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(inlineIncludeData)) continue;
                        inlineCss.put(formatter.getId(), inlineIncludeData);
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String cssUri : cssIncludes) {
            this.pageContext.getOut().print("\n<link rel=\"stylesheet\" href=\"" + CmsJspTagLink.linkTagAction(cssUri.trim(), (ServletRequest)req) + this.generateReqParams() + "\" type=\"text/css\" ");
            if (this.shouldCloseTags()) {
                this.pageContext.getOut().print("/>");
                continue;
            }
            this.pageContext.getOut().print(">");
        }
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            if (!inlineCss.isEmpty()) {
                inline = new StringBuffer("\n<style type=\"text/css\">\n");
                for (Map.Entry cssEntry : inlineCss.entrySet()) {
                    inline.append((String)cssEntry.getValue()).append("\n\n");
                }
                inline.append("\n</style>\n");
                this.pageContext.getOut().print(inline.toString());
            }
        } else {
            inline = new StringBuffer();
            for (Map.Entry cssEntry : inlineCss.entrySet()) {
                inline.append("\n<style type=\"text/css\" rel=\"" + (String)cssEntry.getKey() + "\">\n");
                inline.append((String)cssEntry.getValue()).append("\n\n");
                inline.append("\n</style>\n");
            }
            this.pageContext.getOut().print(inline.toString());
        }
    }

    public void tagJSAction(CmsObject cms, HttpServletRequest req) throws CmsException, IOException {
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        String includeType = TYPE_JAVASCRIPT;
        LinkedHashSet<String> jsIncludes = new LinkedHashSet<String>();
        LinkedHashMap<String, String> inlineJS = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                jsIncludes.add(defaults[i].trim());
            }
        }
        this.collectHeadIncludesForContainerElement(cms, (ServletRequest)req, standardContext, containerPage, includeType, jsIncludes, inlineJS);
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId(), CmsResourceFilter.ignoreExpirationOffline(cms));
                CmsFormatterConfiguration config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()).getFormatters(cms, detailContent);
                boolean requiresAllIncludes = true;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailtype()) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailwidth())) {
                    try {
                        int width = Integer.parseInt(this.getDetailwidth());
                        I_CmsFormatterBean formatter = config.getDetailFormatter(this.getDetailtype(), width);
                        jsIncludes.addAll(formatter.getJavascriptHeadIncludes());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineJavascript())) {
                            inlineJS.put(formatter.getId(), formatter.getInlineJavascript());
                        }
                        requiresAllIncludes = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (requiresAllIncludes) {
                    for (I_CmsFormatterBean formatter : config.getDetailFormatters()) {
                        jsIncludes.addAll(CmsJspTagHeadIncludes.getHeadIncludes(formatter, includeType));
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineJavascript())) continue;
                        inlineJS.put(formatter.getId(), formatter.getInlineJavascript());
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String jsUri : jsIncludes) {
            this.pageContext.getOut().print("\n<script type=\"text/javascript\" src=\"" + CmsJspTagLink.linkTagAction(jsUri.trim(), (ServletRequest)req) + this.generateReqParams() + "\"></script>");
        }
        if (!inlineJS.isEmpty()) {
            StringBuffer inline = new StringBuffer();
            for (Map.Entry jsEntry : inlineJS.entrySet()) {
                inline.append("\n<script type=\"text/javascript\">\n");
                inline.append((String)jsEntry.getValue()).append("\n\n");
                inline.append("\n</script>\n");
            }
            this.pageContext.getOut().print(inline.toString());
        }
    }

    protected void collectHeadIncludesForContainerElement(CmsObject cms, ServletRequest req, CmsJspStandardContextBean standardContext, CmsContainerPageBean containerPage, String includeType, Set<String> headincludes, Map<String, String> inline) {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        if (containerPage != null && containerPage.getElements() != null) {
            CmsContainerPageBean detailOnly;
            Map<CmsUUID, I_CmsFormatterBean> formatters = OpenCms.getADEManager().getCachedFormatters(standardContext.getIsOnlineProject()).getFormatters();
            ArrayList<CmsContainerBean> containers = new ArrayList<CmsContainerBean>(containerPage.getContainers().values());
            if (standardContext.isDetailRequest() && (detailOnly = CmsDetailOnlyContainerUtil.getDetailOnlyPage(cms, req, cms.getRequestContext().getRootUri())) != null) {
                containers.addAll(detailOnly.getContainers().values());
            }
            for (CmsContainerBean container : containers) {
                for (CmsContainerElementBean element : container.getElements()) {
                    try {
                        element.initResource(cms);
                        if (standardContext.getIsOnlineProject() && !element.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                        if (element.isGroupContainer(cms) || element.isInheritedContainer(cms)) {
                            List<CmsContainerElementBean> subElements = element.isGroupContainer(cms) ? CmsJspTagContainer.getGroupContainerElements(cms, element, req, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(cms, element);
                            for (CmsContainerElementBean subElement : subElements) {
                                subElement.initResource(cms);
                                if (standardContext.getIsOnlineProject() && !subElement.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                                I_CmsFormatterBean formatter = this.getFormatterBeanForElement(cms, config, subElement, container, formatters);
                                if (formatter != null) {
                                    headincludes.addAll(CmsJspTagHeadIncludes.getHeadIncludes(formatter, includeType));
                                    String inlineIncludeData = CmsJspTagHeadIncludes.getInlineData(formatter, includeType);
                                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(inlineIncludeData)) continue;
                                    inline.put(formatter.getId(), inlineIncludeData);
                                    continue;
                                }
                                headincludes.addAll(this.getSchemaHeadIncludes(cms, subElement.getResource(), includeType));
                            }
                            continue;
                        }
                        I_CmsFormatterBean formatter = this.getFormatterBeanForElement(cms, config, element, container, formatters);
                        if (formatter != null) {
                            headincludes.addAll(CmsJspTagHeadIncludes.getHeadIncludes(formatter, includeType));
                            String inlineIncludeData = CmsJspTagHeadIncludes.getInlineData(formatter, includeType);
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(inlineIncludeData)) continue;
                            inline.put(formatter.getId(), inlineIncludeData);
                            continue;
                        }
                        headincludes.addAll(this.getSchemaHeadIncludes(cms, element.getResource(), includeType));
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                    }
                }
            }
        }
    }

    private String generateReqParams() throws UnsupportedEncodingException {
        String params = "";
        if (this.m_parameterMap != null && !this.m_parameterMap.isEmpty()) {
            for (Map.Entry<String, String[]> paramEntry : this.m_parameterMap.entrySet()) {
                if (paramEntry.getValue() == null) continue;
                for (int i = 0; i < paramEntry.getValue().length; ++i) {
                    params = params + "&" + paramEntry.getKey() + "=" + URLEncoder.encode(paramEntry.getValue()[i], "UTF-8");
                }
            }
            params = "?" + params.substring(1);
        }
        return params;
    }

    private Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getCSSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private I_CmsFormatterBean getFormatterBeanForElement(CmsObject cms, CmsADEConfigData config, CmsContainerElementBean element, CmsContainerBean container, Map<CmsUUID, I_CmsFormatterBean> formatters) {
        int containerWidth = -1;
        if (container.getWidth() == null) {
            containerWidth = -2;
        } else {
            try {
                containerWidth = Integer.parseInt(container.getWidth());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        I_CmsFormatterBean result = CmsJspTagContainer.getFormatterConfigurationForElement(cms, element, config, container.getName(), container.getType(), containerWidth);
        return result;
    }

    private Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsLoaderException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        if (resType instanceof CmsResourceTypeXmlContent) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getJSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private Set<String> getSchemaHeadIncludes(CmsObject cms, CmsResource res, String type) throws CmsLoaderException {
        if (type.equals(TYPE_CSS)) {
            return this.getCSSHeadIncludes(cms, res);
        }
        if (type.equals(TYPE_JAVASCRIPT)) {
            return this.getJSHeadIncludes(cms, res);
        }
        return null;
    }

    private CmsJspStandardContextBean getStandardContext(CmsObject cms, HttpServletRequest req) throws CmsException {
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        standardContext.initPage();
        return standardContext;
    }
}

